/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEventsDetectionJobsRequest extends ComprehendRequest implements
        ToCopyableBuilder<ListEventsDetectionJobsRequest.Builder, ListEventsDetectionJobsRequest> {
    private static final SdkField<EventsDetectionJobFilter> FILTER_FIELD = SdkField
            .<EventsDetectionJobFilter> builder(MarshallingType.SDK_POJO).memberName("Filter")
            .getter(getter(ListEventsDetectionJobsRequest::filter)).setter(setter(Builder::filter))
            .constructor(EventsDetectionJobFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListEventsDetectionJobsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListEventsDetectionJobsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final EventsDetectionJobFilter filter;

    private final String nextToken;

    private final Integer maxResults;

    private ListEventsDetectionJobsRequest(BuilderImpl builder) {
        super(builder);
        this.filter = builder.filter;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * Filters the jobs that are returned. You can filter jobs on their name, status, or the date and time that they
     * were submitted. You can only set one filter at a time.
     * </p>
     * 
     * @return Filters the jobs that are returned. You can filter jobs on their name, status, or the date and time that
     *         they were submitted. You can only set one filter at a time.
     */
    public final EventsDetectionJobFilter filter() {
        return filter;
    }

    /**
     * <p>
     * Identifies the next page of results to return.
     * </p>
     * 
     * @return Identifies the next page of results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return in each page.
     * </p>
     * 
     * @return The maximum number of results to return in each page.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEventsDetectionJobsRequest)) {
            return false;
        }
        ListEventsDetectionJobsRequest other = (ListEventsDetectionJobsRequest) obj;
        return Objects.equals(filter(), other.filter()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEventsDetectionJobsRequest").add("Filter", filter()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEventsDetectionJobsRequest, T> g) {
        return obj -> g.apply((ListEventsDetectionJobsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListEventsDetectionJobsRequest> {
        /**
         * <p>
         * Filters the jobs that are returned. You can filter jobs on their name, status, or the date and time that they
         * were submitted. You can only set one filter at a time.
         * </p>
         * 
         * @param filter
         *        Filters the jobs that are returned. You can filter jobs on their name, status, or the date and time
         *        that they were submitted. You can only set one filter at a time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(EventsDetectionJobFilter filter);

        /**
         * <p>
         * Filters the jobs that are returned. You can filter jobs on their name, status, or the date and time that they
         * were submitted. You can only set one filter at a time.
         * </p>
         * This is a convenience method that creates an instance of the {@link EventsDetectionJobFilter.Builder}
         * avoiding the need to create one manually via {@link EventsDetectionJobFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link EventsDetectionJobFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #filter(EventsDetectionJobFilter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link EventsDetectionJobFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(EventsDetectionJobFilter)
         */
        default Builder filter(Consumer<EventsDetectionJobFilter.Builder> filter) {
            return filter(EventsDetectionJobFilter.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * Identifies the next page of results to return.
         * </p>
         * 
         * @param nextToken
         *        Identifies the next page of results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return in each page.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in each page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ComprehendRequest.BuilderImpl implements Builder {
        private EventsDetectionJobFilter filter;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEventsDetectionJobsRequest model) {
            super(model);
            filter(model.filter);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final EventsDetectionJobFilter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(EventsDetectionJobFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(EventsDetectionJobFilter filter) {
            this.filter = filter;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEventsDetectionJobsRequest build() {
            return new ListEventsDetectionJobsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
