/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClassifyDocumentResponse extends ComprehendResponse implements
        ToCopyableBuilder<ClassifyDocumentResponse.Builder, ClassifyDocumentResponse> {
    private static final SdkField<List<DocumentClass>> CLASSES_FIELD = SdkField
            .<List<DocumentClass>> builder(MarshallingType.LIST)
            .memberName("Classes")
            .getter(getter(ClassifyDocumentResponse::classes))
            .setter(setter(Builder::classes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Classes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentClass> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentClass::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DocumentLabel>> LABELS_FIELD = SdkField
            .<List<DocumentLabel>> builder(MarshallingType.LIST)
            .memberName("Labels")
            .getter(getter(ClassifyDocumentResponse::labels))
            .setter(setter(Builder::labels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Labels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentLabel> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentLabel::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLASSES_FIELD, LABELS_FIELD));

    private final List<DocumentClass> classes;

    private final List<DocumentLabel> labels;

    private ClassifyDocumentResponse(BuilderImpl builder) {
        super(builder);
        this.classes = builder.classes;
        this.labels = builder.labels;
    }

    /**
     * For responses, this returns true if the service returned a value for the Classes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasClasses() {
        return classes != null && !(classes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The classes used by the document being analyzed. These are used for multi-class trained models. Individual
     * classes are mutually exclusive and each document is expected to have only a single class assigned to it. For
     * example, an animal can be a dog or a cat, but not both at the same time.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClasses} method.
     * </p>
     * 
     * @return The classes used by the document being analyzed. These are used for multi-class trained models.
     *         Individual classes are mutually exclusive and each document is expected to have only a single class
     *         assigned to it. For example, an animal can be a dog or a cat, but not both at the same time.
     */
    public final List<DocumentClass> classes() {
        return classes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Labels property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLabels() {
        return labels != null && !(labels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The labels used the document being analyzed. These are used for multi-label trained models. Individual labels
     * represent different categories that are related in some manner and are not mutually exclusive. For example, a
     * movie can be just an action movie, or it can be an action movie, a science fiction movie, and a comedy, all at
     * the same time.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLabels} method.
     * </p>
     * 
     * @return The labels used the document being analyzed. These are used for multi-label trained models. Individual
     *         labels represent different categories that are related in some manner and are not mutually exclusive. For
     *         example, a movie can be just an action movie, or it can be an action movie, a science fiction movie, and
     *         a comedy, all at the same time.
     */
    public final List<DocumentLabel> labels() {
        return labels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasClasses() ? classes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLabels() ? labels() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClassifyDocumentResponse)) {
            return false;
        }
        ClassifyDocumentResponse other = (ClassifyDocumentResponse) obj;
        return hasClasses() == other.hasClasses() && Objects.equals(classes(), other.classes())
                && hasLabels() == other.hasLabels() && Objects.equals(labels(), other.labels());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClassifyDocumentResponse").add("Classes", hasClasses() ? classes() : null)
                .add("Labels", hasLabels() ? labels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Classes":
            return Optional.ofNullable(clazz.cast(classes()));
        case "Labels":
            return Optional.ofNullable(clazz.cast(labels()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClassifyDocumentResponse, T> g) {
        return obj -> g.apply((ClassifyDocumentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendResponse.Builder, SdkPojo, CopyableBuilder<Builder, ClassifyDocumentResponse> {
        /**
         * <p>
         * The classes used by the document being analyzed. These are used for multi-class trained models. Individual
         * classes are mutually exclusive and each document is expected to have only a single class assigned to it. For
         * example, an animal can be a dog or a cat, but not both at the same time.
         * </p>
         * 
         * @param classes
         *        The classes used by the document being analyzed. These are used for multi-class trained models.
         *        Individual classes are mutually exclusive and each document is expected to have only a single class
         *        assigned to it. For example, an animal can be a dog or a cat, but not both at the same time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classes(Collection<DocumentClass> classes);

        /**
         * <p>
         * The classes used by the document being analyzed. These are used for multi-class trained models. Individual
         * classes are mutually exclusive and each document is expected to have only a single class assigned to it. For
         * example, an animal can be a dog or a cat, but not both at the same time.
         * </p>
         * 
         * @param classes
         *        The classes used by the document being analyzed. These are used for multi-class trained models.
         *        Individual classes are mutually exclusive and each document is expected to have only a single class
         *        assigned to it. For example, an animal can be a dog or a cat, but not both at the same time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classes(DocumentClass... classes);

        /**
         * <p>
         * The classes used by the document being analyzed. These are used for multi-class trained models. Individual
         * classes are mutually exclusive and each document is expected to have only a single class assigned to it. For
         * example, an animal can be a dog or a cat, but not both at the same time.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.comprehend.model.DocumentClass.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.comprehend.model.DocumentClass#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.comprehend.model.DocumentClass.Builder#build()} is called immediately
         * and its result is passed to {@link #classes(List<DocumentClass>)}.
         * 
         * @param classes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.comprehend.model.DocumentClass.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #classes(java.util.Collection<DocumentClass>)
         */
        Builder classes(Consumer<DocumentClass.Builder>... classes);

        /**
         * <p>
         * The labels used the document being analyzed. These are used for multi-label trained models. Individual labels
         * represent different categories that are related in some manner and are not mutually exclusive. For example, a
         * movie can be just an action movie, or it can be an action movie, a science fiction movie, and a comedy, all
         * at the same time.
         * </p>
         * 
         * @param labels
         *        The labels used the document being analyzed. These are used for multi-label trained models. Individual
         *        labels represent different categories that are related in some manner and are not mutually exclusive.
         *        For example, a movie can be just an action movie, or it can be an action movie, a science fiction
         *        movie, and a comedy, all at the same time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(Collection<DocumentLabel> labels);

        /**
         * <p>
         * The labels used the document being analyzed. These are used for multi-label trained models. Individual labels
         * represent different categories that are related in some manner and are not mutually exclusive. For example, a
         * movie can be just an action movie, or it can be an action movie, a science fiction movie, and a comedy, all
         * at the same time.
         * </p>
         * 
         * @param labels
         *        The labels used the document being analyzed. These are used for multi-label trained models. Individual
         *        labels represent different categories that are related in some manner and are not mutually exclusive.
         *        For example, a movie can be just an action movie, or it can be an action movie, a science fiction
         *        movie, and a comedy, all at the same time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(DocumentLabel... labels);

        /**
         * <p>
         * The labels used the document being analyzed. These are used for multi-label trained models. Individual labels
         * represent different categories that are related in some manner and are not mutually exclusive. For example, a
         * movie can be just an action movie, or it can be an action movie, a science fiction movie, and a comedy, all
         * at the same time.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.comprehend.model.DocumentLabel.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.comprehend.model.DocumentLabel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.comprehend.model.DocumentLabel.Builder#build()} is called immediately
         * and its result is passed to {@link #labels(List<DocumentLabel>)}.
         * 
         * @param labels
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.comprehend.model.DocumentLabel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #labels(java.util.Collection<DocumentLabel>)
         */
        Builder labels(Consumer<DocumentLabel.Builder>... labels);
    }

    static final class BuilderImpl extends ComprehendResponse.BuilderImpl implements Builder {
        private List<DocumentClass> classes = DefaultSdkAutoConstructList.getInstance();

        private List<DocumentLabel> labels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ClassifyDocumentResponse model) {
            super(model);
            classes(model.classes);
            labels(model.labels);
        }

        public final List<DocumentClass.Builder> getClasses() {
            List<DocumentClass.Builder> result = ListOfClassesCopier.copyToBuilder(this.classes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClasses(Collection<DocumentClass.BuilderImpl> classes) {
            this.classes = ListOfClassesCopier.copyFromBuilder(classes);
        }

        @Override
        public final Builder classes(Collection<DocumentClass> classes) {
            this.classes = ListOfClassesCopier.copy(classes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classes(DocumentClass... classes) {
            classes(Arrays.asList(classes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classes(Consumer<DocumentClass.Builder>... classes) {
            classes(Stream.of(classes).map(c -> DocumentClass.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DocumentLabel.Builder> getLabels() {
            List<DocumentLabel.Builder> result = ListOfLabelsCopier.copyToBuilder(this.labels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLabels(Collection<DocumentLabel.BuilderImpl> labels) {
            this.labels = ListOfLabelsCopier.copyFromBuilder(labels);
        }

        @Override
        public final Builder labels(Collection<DocumentLabel> labels) {
            this.labels = ListOfLabelsCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(DocumentLabel... labels) {
            labels(Arrays.asList(labels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(Consumer<DocumentLabel.Builder>... labels) {
            labels(Stream.of(labels).map(c -> DocumentLabel.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ClassifyDocumentResponse build() {
            return new ClassifyDocumentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
