/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDocumentClassifierSummariesResponse extends ComprehendResponse implements
        ToCopyableBuilder<ListDocumentClassifierSummariesResponse.Builder, ListDocumentClassifierSummariesResponse> {
    private static final SdkField<List<DocumentClassifierSummary>> DOCUMENT_CLASSIFIER_SUMMARIES_LIST_FIELD = SdkField
            .<List<DocumentClassifierSummary>> builder(MarshallingType.LIST)
            .memberName("DocumentClassifierSummariesList")
            .getter(getter(ListDocumentClassifierSummariesResponse::documentClassifierSummariesList))
            .setter(setter(Builder::documentClassifierSummariesList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentClassifierSummariesList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentClassifierSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentClassifierSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListDocumentClassifierSummariesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DOCUMENT_CLASSIFIER_SUMMARIES_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final List<DocumentClassifierSummary> documentClassifierSummariesList;

    private final String nextToken;

    private ListDocumentClassifierSummariesResponse(BuilderImpl builder) {
        super(builder);
        this.documentClassifierSummariesList = builder.documentClassifierSummariesList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the DocumentClassifierSummariesList
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasDocumentClassifierSummariesList() {
        return documentClassifierSummariesList != null && !(documentClassifierSummariesList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of summaries of document classifiers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDocumentClassifierSummariesList}
     * method.
     * </p>
     * 
     * @return The list of summaries of document classifiers.
     */
    public final List<DocumentClassifierSummary> documentClassifierSummariesList() {
        return documentClassifierSummariesList;
    }

    /**
     * <p>
     * Identifies the next page of results to return.
     * </p>
     * 
     * @return Identifies the next page of results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasDocumentClassifierSummariesList() ? documentClassifierSummariesList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDocumentClassifierSummariesResponse)) {
            return false;
        }
        ListDocumentClassifierSummariesResponse other = (ListDocumentClassifierSummariesResponse) obj;
        return hasDocumentClassifierSummariesList() == other.hasDocumentClassifierSummariesList()
                && Objects.equals(documentClassifierSummariesList(), other.documentClassifierSummariesList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListDocumentClassifierSummariesResponse")
                .add("DocumentClassifierSummariesList",
                        hasDocumentClassifierSummariesList() ? documentClassifierSummariesList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DocumentClassifierSummariesList":
            return Optional.ofNullable(clazz.cast(documentClassifierSummariesList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDocumentClassifierSummariesResponse, T> g) {
        return obj -> g.apply((ListDocumentClassifierSummariesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDocumentClassifierSummariesResponse> {
        /**
         * <p>
         * The list of summaries of document classifiers.
         * </p>
         * 
         * @param documentClassifierSummariesList
         *        The list of summaries of document classifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentClassifierSummariesList(Collection<DocumentClassifierSummary> documentClassifierSummariesList);

        /**
         * <p>
         * The list of summaries of document classifiers.
         * </p>
         * 
         * @param documentClassifierSummariesList
         *        The list of summaries of document classifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentClassifierSummariesList(DocumentClassifierSummary... documentClassifierSummariesList);

        /**
         * <p>
         * The list of summaries of document classifiers.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.comprehend.model.DocumentClassifierSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.comprehend.model.DocumentClassifierSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.comprehend.model.DocumentClassifierSummary.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #documentClassifierSummariesList(List<DocumentClassifierSummary>)}.
         * 
         * @param documentClassifierSummariesList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.comprehend.model.DocumentClassifierSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentClassifierSummariesList(java.util.Collection<DocumentClassifierSummary>)
         */
        Builder documentClassifierSummariesList(Consumer<DocumentClassifierSummary.Builder>... documentClassifierSummariesList);

        /**
         * <p>
         * Identifies the next page of results to return.
         * </p>
         * 
         * @param nextToken
         *        Identifies the next page of results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ComprehendResponse.BuilderImpl implements Builder {
        private List<DocumentClassifierSummary> documentClassifierSummariesList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDocumentClassifierSummariesResponse model) {
            super(model);
            documentClassifierSummariesList(model.documentClassifierSummariesList);
            nextToken(model.nextToken);
        }

        public final List<DocumentClassifierSummary.Builder> getDocumentClassifierSummariesList() {
            List<DocumentClassifierSummary.Builder> result = DocumentClassifierSummariesListCopier
                    .copyToBuilder(this.documentClassifierSummariesList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocumentClassifierSummariesList(
                Collection<DocumentClassifierSummary.BuilderImpl> documentClassifierSummariesList) {
            this.documentClassifierSummariesList = DocumentClassifierSummariesListCopier
                    .copyFromBuilder(documentClassifierSummariesList);
        }

        @Override
        public final Builder documentClassifierSummariesList(Collection<DocumentClassifierSummary> documentClassifierSummariesList) {
            this.documentClassifierSummariesList = DocumentClassifierSummariesListCopier.copy(documentClassifierSummariesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentClassifierSummariesList(DocumentClassifierSummary... documentClassifierSummariesList) {
            documentClassifierSummariesList(Arrays.asList(documentClassifierSummariesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentClassifierSummariesList(
                Consumer<DocumentClassifierSummary.Builder>... documentClassifierSummariesList) {
            documentClassifierSummariesList(Stream.of(documentClassifierSummariesList)
                    .map(c -> DocumentClassifierSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDocumentClassifierSummariesResponse build() {
            return new ListDocumentClassifierSummariesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
