/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDetectSyntaxResponse extends ComprehendResponse implements
        ToCopyableBuilder<BatchDetectSyntaxResponse.Builder, BatchDetectSyntaxResponse> {
    private static final SdkField<List<BatchDetectSyntaxItemResult>> RESULT_LIST_FIELD = SdkField
            .<List<BatchDetectSyntaxItemResult>> builder(MarshallingType.LIST)
            .memberName("ResultList")
            .getter(getter(BatchDetectSyntaxResponse::resultList))
            .setter(setter(Builder::resultList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchDetectSyntaxItemResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchDetectSyntaxItemResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BatchItemError>> ERROR_LIST_FIELD = SdkField
            .<List<BatchItemError>> builder(MarshallingType.LIST)
            .memberName("ErrorList")
            .getter(getter(BatchDetectSyntaxResponse::errorList))
            .setter(setter(Builder::errorList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchItemError> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchItemError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_LIST_FIELD,
            ERROR_LIST_FIELD));

    private final List<BatchDetectSyntaxItemResult> resultList;

    private final List<BatchItemError> errorList;

    private BatchDetectSyntaxResponse(BuilderImpl builder) {
        super(builder);
        this.resultList = builder.resultList;
        this.errorList = builder.errorList;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResultList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResultList() {
        return resultList != null && !(resultList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects containing the results of the operation. The results are sorted in ascending order by the
     * <code>Index</code> field and match the order of the documents in the input list. If all of the documents contain
     * an error, the <code>ResultList</code> is empty.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResultList} method.
     * </p>
     * 
     * @return A list of objects containing the results of the operation. The results are sorted in ascending order by
     *         the <code>Index</code> field and match the order of the documents in the input list. If all of the
     *         documents contain an error, the <code>ResultList</code> is empty.
     */
    public final List<BatchDetectSyntaxItemResult> resultList() {
        return resultList;
    }

    /**
     * For responses, this returns true if the service returned a value for the ErrorList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrorList() {
        return errorList != null && !(errorList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list containing one object for each document that contained an error. The results are sorted in ascending order
     * by the <code>Index</code> field and match the order of the documents in the input list. If there are no errors in
     * the batch, the <code>ErrorList</code> is empty.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrorList} method.
     * </p>
     * 
     * @return A list containing one object for each document that contained an error. The results are sorted in
     *         ascending order by the <code>Index</code> field and match the order of the documents in the input list.
     *         If there are no errors in the batch, the <code>ErrorList</code> is empty.
     */
    public final List<BatchItemError> errorList() {
        return errorList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResultList() ? resultList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrorList() ? errorList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDetectSyntaxResponse)) {
            return false;
        }
        BatchDetectSyntaxResponse other = (BatchDetectSyntaxResponse) obj;
        return hasResultList() == other.hasResultList() && Objects.equals(resultList(), other.resultList())
                && hasErrorList() == other.hasErrorList() && Objects.equals(errorList(), other.errorList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDetectSyntaxResponse").add("ResultList", hasResultList() ? resultList() : null)
                .add("ErrorList", hasErrorList() ? errorList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResultList":
            return Optional.ofNullable(clazz.cast(resultList()));
        case "ErrorList":
            return Optional.ofNullable(clazz.cast(errorList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDetectSyntaxResponse, T> g) {
        return obj -> g.apply((BatchDetectSyntaxResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchDetectSyntaxResponse> {
        /**
         * <p>
         * A list of objects containing the results of the operation. The results are sorted in ascending order by the
         * <code>Index</code> field and match the order of the documents in the input list. If all of the documents
         * contain an error, the <code>ResultList</code> is empty.
         * </p>
         * 
         * @param resultList
         *        A list of objects containing the results of the operation. The results are sorted in ascending order
         *        by the <code>Index</code> field and match the order of the documents in the input list. If all of the
         *        documents contain an error, the <code>ResultList</code> is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultList(Collection<BatchDetectSyntaxItemResult> resultList);

        /**
         * <p>
         * A list of objects containing the results of the operation. The results are sorted in ascending order by the
         * <code>Index</code> field and match the order of the documents in the input list. If all of the documents
         * contain an error, the <code>ResultList</code> is empty.
         * </p>
         * 
         * @param resultList
         *        A list of objects containing the results of the operation. The results are sorted in ascending order
         *        by the <code>Index</code> field and match the order of the documents in the input list. If all of the
         *        documents contain an error, the <code>ResultList</code> is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultList(BatchDetectSyntaxItemResult... resultList);

        /**
         * <p>
         * A list of objects containing the results of the operation. The results are sorted in ascending order by the
         * <code>Index</code> field and match the order of the documents in the input list. If all of the documents
         * contain an error, the <code>ResultList</code> is empty.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BatchDetectSyntaxItemResult>.Builder}
         * avoiding the need to create one manually via {@link List<BatchDetectSyntaxItemResult>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BatchDetectSyntaxItemResult>.Builder#build()} is called
         * immediately and its result is passed to {@link #resultList(List<BatchDetectSyntaxItemResult>)}.
         * 
         * @param resultList
         *        a consumer that will call methods on {@link List<BatchDetectSyntaxItemResult>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resultList(List<BatchDetectSyntaxItemResult>)
         */
        Builder resultList(Consumer<BatchDetectSyntaxItemResult.Builder>... resultList);

        /**
         * <p>
         * A list containing one object for each document that contained an error. The results are sorted in ascending
         * order by the <code>Index</code> field and match the order of the documents in the input list. If there are no
         * errors in the batch, the <code>ErrorList</code> is empty.
         * </p>
         * 
         * @param errorList
         *        A list containing one object for each document that contained an error. The results are sorted in
         *        ascending order by the <code>Index</code> field and match the order of the documents in the input
         *        list. If there are no errors in the batch, the <code>ErrorList</code> is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorList(Collection<BatchItemError> errorList);

        /**
         * <p>
         * A list containing one object for each document that contained an error. The results are sorted in ascending
         * order by the <code>Index</code> field and match the order of the documents in the input list. If there are no
         * errors in the batch, the <code>ErrorList</code> is empty.
         * </p>
         * 
         * @param errorList
         *        A list containing one object for each document that contained an error. The results are sorted in
         *        ascending order by the <code>Index</code> field and match the order of the documents in the input
         *        list. If there are no errors in the batch, the <code>ErrorList</code> is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorList(BatchItemError... errorList);

        /**
         * <p>
         * A list containing one object for each document that contained an error. The results are sorted in ascending
         * order by the <code>Index</code> field and match the order of the documents in the input list. If there are no
         * errors in the batch, the <code>ErrorList</code> is empty.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BatchItemError>.Builder} avoiding the need
         * to create one manually via {@link List<BatchItemError>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BatchItemError>.Builder#build()} is called immediately and
         * its result is passed to {@link #errorList(List<BatchItemError>)}.
         * 
         * @param errorList
         *        a consumer that will call methods on {@link List<BatchItemError>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorList(List<BatchItemError>)
         */
        Builder errorList(Consumer<BatchItemError.Builder>... errorList);
    }

    static final class BuilderImpl extends ComprehendResponse.BuilderImpl implements Builder {
        private List<BatchDetectSyntaxItemResult> resultList = DefaultSdkAutoConstructList.getInstance();

        private List<BatchItemError> errorList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDetectSyntaxResponse model) {
            super(model);
            resultList(model.resultList);
            errorList(model.errorList);
        }

        public final List<BatchDetectSyntaxItemResult.Builder> getResultList() {
            List<BatchDetectSyntaxItemResult.Builder> result = ListOfDetectSyntaxResultCopier.copyToBuilder(this.resultList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResultList(Collection<BatchDetectSyntaxItemResult.BuilderImpl> resultList) {
            this.resultList = ListOfDetectSyntaxResultCopier.copyFromBuilder(resultList);
        }

        @Override
        @Transient
        public final Builder resultList(Collection<BatchDetectSyntaxItemResult> resultList) {
            this.resultList = ListOfDetectSyntaxResultCopier.copy(resultList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resultList(BatchDetectSyntaxItemResult... resultList) {
            resultList(Arrays.asList(resultList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resultList(Consumer<BatchDetectSyntaxItemResult.Builder>... resultList) {
            resultList(Stream.of(resultList).map(c -> BatchDetectSyntaxItemResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<BatchItemError.Builder> getErrorList() {
            List<BatchItemError.Builder> result = BatchItemErrorListCopier.copyToBuilder(this.errorList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrorList(Collection<BatchItemError.BuilderImpl> errorList) {
            this.errorList = BatchItemErrorListCopier.copyFromBuilder(errorList);
        }

        @Override
        @Transient
        public final Builder errorList(Collection<BatchItemError> errorList) {
            this.errorList = BatchItemErrorListCopier.copy(errorList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder errorList(BatchItemError... errorList) {
            errorList(Arrays.asList(errorList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder errorList(Consumer<BatchItemError.Builder>... errorList) {
            errorList(Stream.of(errorList).map(c -> BatchItemError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchDetectSyntaxResponse build() {
            return new BatchDetectSyntaxResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
