/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDominantLanguageDetectionJobResponse extends ComprehendResponse implements
        ToCopyableBuilder<DescribeDominantLanguageDetectionJobResponse.Builder, DescribeDominantLanguageDetectionJobResponse> {
    private static final SdkField<DominantLanguageDetectionJobProperties> DOMINANT_LANGUAGE_DETECTION_JOB_PROPERTIES_FIELD = SdkField
            .<DominantLanguageDetectionJobProperties> builder(MarshallingType.SDK_POJO)
            .memberName("DominantLanguageDetectionJobProperties")
            .getter(getter(DescribeDominantLanguageDetectionJobResponse::dominantLanguageDetectionJobProperties))
            .setter(setter(Builder::dominantLanguageDetectionJobProperties))
            .constructor(DominantLanguageDetectionJobProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("DominantLanguageDetectionJobProperties").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DOMINANT_LANGUAGE_DETECTION_JOB_PROPERTIES_FIELD));

    private final DominantLanguageDetectionJobProperties dominantLanguageDetectionJobProperties;

    private DescribeDominantLanguageDetectionJobResponse(BuilderImpl builder) {
        super(builder);
        this.dominantLanguageDetectionJobProperties = builder.dominantLanguageDetectionJobProperties;
    }

    /**
     * <p>
     * An object that contains the properties associated with a dominant language detection job.
     * </p>
     * 
     * @return An object that contains the properties associated with a dominant language detection job.
     */
    public final DominantLanguageDetectionJobProperties dominantLanguageDetectionJobProperties() {
        return dominantLanguageDetectionJobProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dominantLanguageDetectionJobProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDominantLanguageDetectionJobResponse)) {
            return false;
        }
        DescribeDominantLanguageDetectionJobResponse other = (DescribeDominantLanguageDetectionJobResponse) obj;
        return Objects.equals(dominantLanguageDetectionJobProperties(), other.dominantLanguageDetectionJobProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDominantLanguageDetectionJobResponse")
                .add("DominantLanguageDetectionJobProperties", dominantLanguageDetectionJobProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DominantLanguageDetectionJobProperties":
            return Optional.ofNullable(clazz.cast(dominantLanguageDetectionJobProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDominantLanguageDetectionJobResponse, T> g) {
        return obj -> g.apply((DescribeDominantLanguageDetectionJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDominantLanguageDetectionJobResponse> {
        /**
         * <p>
         * An object that contains the properties associated with a dominant language detection job.
         * </p>
         * 
         * @param dominantLanguageDetectionJobProperties
         *        An object that contains the properties associated with a dominant language detection job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dominantLanguageDetectionJobProperties(
                DominantLanguageDetectionJobProperties dominantLanguageDetectionJobProperties);

        /**
         * <p>
         * An object that contains the properties associated with a dominant language detection job.
         * </p>
         * This is a convenience that creates an instance of the {@link DominantLanguageDetectionJobProperties.Builder}
         * avoiding the need to create one manually via {@link DominantLanguageDetectionJobProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link DominantLanguageDetectionJobProperties.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #dominantLanguageDetectionJobProperties(DominantLanguageDetectionJobProperties)}.
         * 
         * @param dominantLanguageDetectionJobProperties
         *        a consumer that will call methods on {@link DominantLanguageDetectionJobProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dominantLanguageDetectionJobProperties(DominantLanguageDetectionJobProperties)
         */
        default Builder dominantLanguageDetectionJobProperties(
                Consumer<DominantLanguageDetectionJobProperties.Builder> dominantLanguageDetectionJobProperties) {
            return dominantLanguageDetectionJobProperties(DominantLanguageDetectionJobProperties.builder()
                    .applyMutation(dominantLanguageDetectionJobProperties).build());
        }
    }

    static final class BuilderImpl extends ComprehendResponse.BuilderImpl implements Builder {
        private DominantLanguageDetectionJobProperties dominantLanguageDetectionJobProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDominantLanguageDetectionJobResponse model) {
            super(model);
            dominantLanguageDetectionJobProperties(model.dominantLanguageDetectionJobProperties);
        }

        public final DominantLanguageDetectionJobProperties.Builder getDominantLanguageDetectionJobProperties() {
            return dominantLanguageDetectionJobProperties != null ? dominantLanguageDetectionJobProperties.toBuilder() : null;
        }

        public final void setDominantLanguageDetectionJobProperties(
                DominantLanguageDetectionJobProperties.BuilderImpl dominantLanguageDetectionJobProperties) {
            this.dominantLanguageDetectionJobProperties = dominantLanguageDetectionJobProperties != null ? dominantLanguageDetectionJobProperties
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder dominantLanguageDetectionJobProperties(
                DominantLanguageDetectionJobProperties dominantLanguageDetectionJobProperties) {
            this.dominantLanguageDetectionJobProperties = dominantLanguageDetectionJobProperties;
            return this;
        }

        @Override
        public DescribeDominantLanguageDetectionJobResponse build() {
            return new DescribeDominantLanguageDetectionJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
