/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information for filtering a list of document classification jobs. For more information, see the operation.
 * You can provide only one filter parameter in each request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentClassificationJobFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentClassificationJobFilter.Builder, DocumentClassificationJobFilter> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobName").getter(getter(DocumentClassificationJobFilter::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()).build();

    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobStatus").getter(getter(DocumentClassificationJobFilter::jobStatusAsString))
            .setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()).build();

    private static final SdkField<Instant> SUBMIT_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("SubmitTimeBefore").getter(getter(DocumentClassificationJobFilter::submitTimeBefore))
            .setter(setter(Builder::submitTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmitTimeBefore").build()).build();

    private static final SdkField<Instant> SUBMIT_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("SubmitTimeAfter").getter(getter(DocumentClassificationJobFilter::submitTimeAfter))
            .setter(setter(Builder::submitTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmitTimeAfter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD,
            JOB_STATUS_FIELD, SUBMIT_TIME_BEFORE_FIELD, SUBMIT_TIME_AFTER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String jobName;

    private final String jobStatus;

    private final Instant submitTimeBefore;

    private final Instant submitTimeAfter;

    private DocumentClassificationJobFilter(BuilderImpl builder) {
        this.jobName = builder.jobName;
        this.jobStatus = builder.jobStatus;
        this.submitTimeBefore = builder.submitTimeBefore;
        this.submitTimeAfter = builder.submitTimeAfter;
    }

    /**
     * <p>
     * Filters on the name of the job.
     * </p>
     * 
     * @return Filters on the name of the job.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * Filters the list based on job status. Returns only jobs with the specified status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return Filters the list based on job status. Returns only jobs with the specified status.
     * @see JobStatus
     */
    public final JobStatus jobStatus() {
        return JobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * Filters the list based on job status. Returns only jobs with the specified status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return Filters the list based on job status. Returns only jobs with the specified status.
     * @see JobStatus
     */
    public final String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * Filters the list of jobs based on the time that the job was submitted for processing. Returns only jobs submitted
     * before the specified time. Jobs are returned in ascending order, oldest to newest.
     * </p>
     * 
     * @return Filters the list of jobs based on the time that the job was submitted for processing. Returns only jobs
     *         submitted before the specified time. Jobs are returned in ascending order, oldest to newest.
     */
    public final Instant submitTimeBefore() {
        return submitTimeBefore;
    }

    /**
     * <p>
     * Filters the list of jobs based on the time that the job was submitted for processing. Returns only jobs submitted
     * after the specified time. Jobs are returned in descending order, newest to oldest.
     * </p>
     * 
     * @return Filters the list of jobs based on the time that the job was submitted for processing. Returns only jobs
     *         submitted after the specified time. Jobs are returned in descending order, newest to oldest.
     */
    public final Instant submitTimeAfter() {
        return submitTimeAfter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(submitTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(submitTimeAfter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentClassificationJobFilter)) {
            return false;
        }
        DocumentClassificationJobFilter other = (DocumentClassificationJobFilter) obj;
        return Objects.equals(jobName(), other.jobName()) && Objects.equals(jobStatusAsString(), other.jobStatusAsString())
                && Objects.equals(submitTimeBefore(), other.submitTimeBefore())
                && Objects.equals(submitTimeAfter(), other.submitTimeAfter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentClassificationJobFilter").add("JobName", jobName())
                .add("JobStatus", jobStatusAsString()).add("SubmitTimeBefore", submitTimeBefore())
                .add("SubmitTimeAfter", submitTimeAfter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "JobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "SubmitTimeBefore":
            return Optional.ofNullable(clazz.cast(submitTimeBefore()));
        case "SubmitTimeAfter":
            return Optional.ofNullable(clazz.cast(submitTimeAfter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentClassificationJobFilter, T> g) {
        return obj -> g.apply((DocumentClassificationJobFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentClassificationJobFilter> {
        /**
         * <p>
         * Filters on the name of the job.
         * </p>
         * 
         * @param jobName
         *        Filters on the name of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * Filters the list based on job status. Returns only jobs with the specified status.
         * </p>
         * 
         * @param jobStatus
         *        Filters the list based on job status. Returns only jobs with the specified status.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * Filters the list based on job status. Returns only jobs with the specified status.
         * </p>
         * 
         * @param jobStatus
         *        Filters the list based on job status. Returns only jobs with the specified status.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(JobStatus jobStatus);

        /**
         * <p>
         * Filters the list of jobs based on the time that the job was submitted for processing. Returns only jobs
         * submitted before the specified time. Jobs are returned in ascending order, oldest to newest.
         * </p>
         * 
         * @param submitTimeBefore
         *        Filters the list of jobs based on the time that the job was submitted for processing. Returns only
         *        jobs submitted before the specified time. Jobs are returned in ascending order, oldest to newest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submitTimeBefore(Instant submitTimeBefore);

        /**
         * <p>
         * Filters the list of jobs based on the time that the job was submitted for processing. Returns only jobs
         * submitted after the specified time. Jobs are returned in descending order, newest to oldest.
         * </p>
         * 
         * @param submitTimeAfter
         *        Filters the list of jobs based on the time that the job was submitted for processing. Returns only
         *        jobs submitted after the specified time. Jobs are returned in descending order, newest to oldest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submitTimeAfter(Instant submitTimeAfter);
    }

    static final class BuilderImpl implements Builder {
        private String jobName;

        private String jobStatus;

        private Instant submitTimeBefore;

        private Instant submitTimeAfter;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentClassificationJobFilter model) {
            jobName(model.jobName);
            jobStatus(model.jobStatus);
            submitTimeBefore(model.submitTimeBefore);
            submitTimeAfter(model.submitTimeAfter);
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        @Transient
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        @Transient
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final Instant getSubmitTimeBefore() {
            return submitTimeBefore;
        }

        public final void setSubmitTimeBefore(Instant submitTimeBefore) {
            this.submitTimeBefore = submitTimeBefore;
        }

        @Override
        @Transient
        public final Builder submitTimeBefore(Instant submitTimeBefore) {
            this.submitTimeBefore = submitTimeBefore;
            return this;
        }

        public final Instant getSubmitTimeAfter() {
            return submitTimeAfter;
        }

        public final void setSubmitTimeAfter(Instant submitTimeAfter) {
            this.submitTimeAfter = submitTimeAfter;
        }

        @Override
        @Transient
        public final Builder submitTimeAfter(Instant submitTimeAfter) {
            this.submitTimeAfter = submitTimeAfter;
            return this;
        }

        @Override
        public DocumentClassificationJobFilter build() {
            return new DocumentClassificationJobFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
