/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class DocumentClassifierAugmentedManifestsListCopier {
    static List<AugmentedManifestsListItem> copy(
            Collection<? extends AugmentedManifestsListItem> documentClassifierAugmentedManifestsListParam) {
        List<AugmentedManifestsListItem> list;
        if (documentClassifierAugmentedManifestsListParam == null
                || documentClassifierAugmentedManifestsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AugmentedManifestsListItem> modifiableList = new ArrayList<>();
            documentClassifierAugmentedManifestsListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AugmentedManifestsListItem> copyFromBuilder(
            Collection<? extends AugmentedManifestsListItem.Builder> documentClassifierAugmentedManifestsListParam) {
        List<AugmentedManifestsListItem> list;
        if (documentClassifierAugmentedManifestsListParam == null
                || documentClassifierAugmentedManifestsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AugmentedManifestsListItem> modifiableList = new ArrayList<>();
            documentClassifierAugmentedManifestsListParam.forEach(entry -> {
                AugmentedManifestsListItem member = entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AugmentedManifestsListItem.Builder> copyToBuilder(
            Collection<? extends AugmentedManifestsListItem> documentClassifierAugmentedManifestsListParam) {
        List<AugmentedManifestsListItem.Builder> list;
        if (documentClassifierAugmentedManifestsListParam == null
                || documentClassifierAugmentedManifestsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AugmentedManifestsListItem.Builder> modifiableList = new ArrayList<>();
            documentClassifierAugmentedManifestsListParam.forEach(entry -> {
                AugmentedManifestsListItem.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
