/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input properties for a topic detection job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentReaderConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentReaderConfig.Builder, DocumentReaderConfig> {
    private static final SdkField<String> DOCUMENT_READ_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentReadAction").getter(getter(DocumentReaderConfig::documentReadActionAsString))
            .setter(setter(Builder::documentReadAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentReadAction").build())
            .build();

    private static final SdkField<String> DOCUMENT_READ_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentReadMode").getter(getter(DocumentReaderConfig::documentReadModeAsString))
            .setter(setter(Builder::documentReadMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentReadMode").build()).build();

    private static final SdkField<List<String>> FEATURE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FeatureTypes")
            .getter(getter(DocumentReaderConfig::featureTypesAsStrings))
            .setter(setter(Builder::featureTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_READ_ACTION_FIELD,
            DOCUMENT_READ_MODE_FIELD, FEATURE_TYPES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String documentReadAction;

    private final String documentReadMode;

    private final List<String> featureTypes;

    private DocumentReaderConfig(BuilderImpl builder) {
        this.documentReadAction = builder.documentReadAction;
        this.documentReadMode = builder.documentReadMode;
        this.featureTypes = builder.featureTypes;
    }

    /**
     * <p>
     * This enum field will start with two values which will apply to PDFs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TEXTRACT_DETECT_DOCUMENT_TEXT</code> - The service calls DetectDocumentText for PDF documents per page.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TEXTRACT_ANALYZE_DOCUMENT</code> - The service calls AnalyzeDocument for PDF documents per page.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #documentReadAction} will return {@link DocumentReadAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #documentReadActionAsString}.
     * </p>
     * 
     * @return This enum field will start with two values which will apply to PDFs:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TEXTRACT_DETECT_DOCUMENT_TEXT</code> - The service calls DetectDocumentText for PDF documents per
     *         page.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TEXTRACT_ANALYZE_DOCUMENT</code> - The service calls AnalyzeDocument for PDF documents per page.
     *         </p>
     *         </li>
     * @see DocumentReadAction
     */
    public final DocumentReadAction documentReadAction() {
        return DocumentReadAction.fromValue(documentReadAction);
    }

    /**
     * <p>
     * This enum field will start with two values which will apply to PDFs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TEXTRACT_DETECT_DOCUMENT_TEXT</code> - The service calls DetectDocumentText for PDF documents per page.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TEXTRACT_ANALYZE_DOCUMENT</code> - The service calls AnalyzeDocument for PDF documents per page.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #documentReadAction} will return {@link DocumentReadAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #documentReadActionAsString}.
     * </p>
     * 
     * @return This enum field will start with two values which will apply to PDFs:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TEXTRACT_DETECT_DOCUMENT_TEXT</code> - The service calls DetectDocumentText for PDF documents per
     *         page.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TEXTRACT_ANALYZE_DOCUMENT</code> - The service calls AnalyzeDocument for PDF documents per page.
     *         </p>
     *         </li>
     * @see DocumentReadAction
     */
    public final String documentReadActionAsString() {
        return documentReadAction;
    }

    /**
     * <p>
     * This enum field provides two values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SERVICE_DEFAULT</code> - use service defaults for Document reading. For Digital PDF it would mean using an
     * internal parser instead of Textract APIs
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FORCE_DOCUMENT_READ_ACTION</code> - Always use specified action for DocumentReadAction, including Digital
     * PDF.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #documentReadMode}
     * will return {@link DocumentReadMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #documentReadModeAsString}.
     * </p>
     * 
     * @return This enum field provides two values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SERVICE_DEFAULT</code> - use service defaults for Document reading. For Digital PDF it would mean
     *         using an internal parser instead of Textract APIs
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FORCE_DOCUMENT_READ_ACTION</code> - Always use specified action for DocumentReadAction, including
     *         Digital PDF.
     *         </p>
     *         </li>
     * @see DocumentReadMode
     */
    public final DocumentReadMode documentReadMode() {
        return DocumentReadMode.fromValue(documentReadMode);
    }

    /**
     * <p>
     * This enum field provides two values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SERVICE_DEFAULT</code> - use service defaults for Document reading. For Digital PDF it would mean using an
     * internal parser instead of Textract APIs
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FORCE_DOCUMENT_READ_ACTION</code> - Always use specified action for DocumentReadAction, including Digital
     * PDF.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #documentReadMode}
     * will return {@link DocumentReadMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #documentReadModeAsString}.
     * </p>
     * 
     * @return This enum field provides two values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SERVICE_DEFAULT</code> - use service defaults for Document reading. For Digital PDF it would mean
     *         using an internal parser instead of Textract APIs
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FORCE_DOCUMENT_READ_ACTION</code> - Always use specified action for DocumentReadAction, including
     *         Digital PDF.
     *         </p>
     *         </li>
     * @see DocumentReadMode
     */
    public final String documentReadModeAsString() {
        return documentReadMode;
    }

    /**
     * <p>
     * Specifies how the text in an input file should be processed:
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFeatureTypes} method.
     * </p>
     * 
     * @return Specifies how the text in an input file should be processed:
     */
    public final List<DocumentReadFeatureTypes> featureTypes() {
        return ListOfDocumentReadFeatureTypesCopier.copyStringToEnum(featureTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the FeatureTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFeatureTypes() {
        return featureTypes != null && !(featureTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies how the text in an input file should be processed:
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFeatureTypes} method.
     * </p>
     * 
     * @return Specifies how the text in an input file should be processed:
     */
    public final List<String> featureTypesAsStrings() {
        return featureTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(documentReadActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(documentReadModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasFeatureTypes() ? featureTypesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentReaderConfig)) {
            return false;
        }
        DocumentReaderConfig other = (DocumentReaderConfig) obj;
        return Objects.equals(documentReadActionAsString(), other.documentReadActionAsString())
                && Objects.equals(documentReadModeAsString(), other.documentReadModeAsString())
                && hasFeatureTypes() == other.hasFeatureTypes()
                && Objects.equals(featureTypesAsStrings(), other.featureTypesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentReaderConfig").add("DocumentReadAction", documentReadActionAsString())
                .add("DocumentReadMode", documentReadModeAsString())
                .add("FeatureTypes", hasFeatureTypes() ? featureTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DocumentReadAction":
            return Optional.ofNullable(clazz.cast(documentReadActionAsString()));
        case "DocumentReadMode":
            return Optional.ofNullable(clazz.cast(documentReadModeAsString()));
        case "FeatureTypes":
            return Optional.ofNullable(clazz.cast(featureTypesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentReaderConfig, T> g) {
        return obj -> g.apply((DocumentReaderConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentReaderConfig> {
        /**
         * <p>
         * This enum field will start with two values which will apply to PDFs:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TEXTRACT_DETECT_DOCUMENT_TEXT</code> - The service calls DetectDocumentText for PDF documents per page.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TEXTRACT_ANALYZE_DOCUMENT</code> - The service calls AnalyzeDocument for PDF documents per page.
         * </p>
         * </li>
         * </ul>
         * 
         * @param documentReadAction
         *        This enum field will start with two values which will apply to PDFs:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TEXTRACT_DETECT_DOCUMENT_TEXT</code> - The service calls DetectDocumentText for PDF documents
         *        per page.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TEXTRACT_ANALYZE_DOCUMENT</code> - The service calls AnalyzeDocument for PDF documents per page.
         *        </p>
         *        </li>
         * @see DocumentReadAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentReadAction
         */
        Builder documentReadAction(String documentReadAction);

        /**
         * <p>
         * This enum field will start with two values which will apply to PDFs:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TEXTRACT_DETECT_DOCUMENT_TEXT</code> - The service calls DetectDocumentText for PDF documents per page.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TEXTRACT_ANALYZE_DOCUMENT</code> - The service calls AnalyzeDocument for PDF documents per page.
         * </p>
         * </li>
         * </ul>
         * 
         * @param documentReadAction
         *        This enum field will start with two values which will apply to PDFs:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TEXTRACT_DETECT_DOCUMENT_TEXT</code> - The service calls DetectDocumentText for PDF documents
         *        per page.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TEXTRACT_ANALYZE_DOCUMENT</code> - The service calls AnalyzeDocument for PDF documents per page.
         *        </p>
         *        </li>
         * @see DocumentReadAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentReadAction
         */
        Builder documentReadAction(DocumentReadAction documentReadAction);

        /**
         * <p>
         * This enum field provides two values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SERVICE_DEFAULT</code> - use service defaults for Document reading. For Digital PDF it would mean using
         * an internal parser instead of Textract APIs
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FORCE_DOCUMENT_READ_ACTION</code> - Always use specified action for DocumentReadAction, including
         * Digital PDF.
         * </p>
         * </li>
         * </ul>
         * 
         * @param documentReadMode
         *        This enum field provides two values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SERVICE_DEFAULT</code> - use service defaults for Document reading. For Digital PDF it would
         *        mean using an internal parser instead of Textract APIs
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FORCE_DOCUMENT_READ_ACTION</code> - Always use specified action for DocumentReadAction,
         *        including Digital PDF.
         *        </p>
         *        </li>
         * @see DocumentReadMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentReadMode
         */
        Builder documentReadMode(String documentReadMode);

        /**
         * <p>
         * This enum field provides two values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SERVICE_DEFAULT</code> - use service defaults for Document reading. For Digital PDF it would mean using
         * an internal parser instead of Textract APIs
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FORCE_DOCUMENT_READ_ACTION</code> - Always use specified action for DocumentReadAction, including
         * Digital PDF.
         * </p>
         * </li>
         * </ul>
         * 
         * @param documentReadMode
         *        This enum field provides two values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SERVICE_DEFAULT</code> - use service defaults for Document reading. For Digital PDF it would
         *        mean using an internal parser instead of Textract APIs
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FORCE_DOCUMENT_READ_ACTION</code> - Always use specified action for DocumentReadAction,
         *        including Digital PDF.
         *        </p>
         *        </li>
         * @see DocumentReadMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentReadMode
         */
        Builder documentReadMode(DocumentReadMode documentReadMode);

        /**
         * <p>
         * Specifies how the text in an input file should be processed:
         * </p>
         * 
         * @param featureTypes
         *        Specifies how the text in an input file should be processed:
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureTypesWithStrings(Collection<String> featureTypes);

        /**
         * <p>
         * Specifies how the text in an input file should be processed:
         * </p>
         * 
         * @param featureTypes
         *        Specifies how the text in an input file should be processed:
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureTypesWithStrings(String... featureTypes);

        /**
         * <p>
         * Specifies how the text in an input file should be processed:
         * </p>
         * 
         * @param featureTypes
         *        Specifies how the text in an input file should be processed:
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureTypes(Collection<DocumentReadFeatureTypes> featureTypes);

        /**
         * <p>
         * Specifies how the text in an input file should be processed:
         * </p>
         * 
         * @param featureTypes
         *        Specifies how the text in an input file should be processed:
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureTypes(DocumentReadFeatureTypes... featureTypes);
    }

    static final class BuilderImpl implements Builder {
        private String documentReadAction;

        private String documentReadMode;

        private List<String> featureTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentReaderConfig model) {
            documentReadAction(model.documentReadAction);
            documentReadMode(model.documentReadMode);
            featureTypesWithStrings(model.featureTypes);
        }

        public final String getDocumentReadAction() {
            return documentReadAction;
        }

        public final void setDocumentReadAction(String documentReadAction) {
            this.documentReadAction = documentReadAction;
        }

        @Override
        @Transient
        public final Builder documentReadAction(String documentReadAction) {
            this.documentReadAction = documentReadAction;
            return this;
        }

        @Override
        @Transient
        public final Builder documentReadAction(DocumentReadAction documentReadAction) {
            this.documentReadAction(documentReadAction == null ? null : documentReadAction.toString());
            return this;
        }

        public final String getDocumentReadMode() {
            return documentReadMode;
        }

        public final void setDocumentReadMode(String documentReadMode) {
            this.documentReadMode = documentReadMode;
        }

        @Override
        @Transient
        public final Builder documentReadMode(String documentReadMode) {
            this.documentReadMode = documentReadMode;
            return this;
        }

        @Override
        @Transient
        public final Builder documentReadMode(DocumentReadMode documentReadMode) {
            this.documentReadMode(documentReadMode == null ? null : documentReadMode.toString());
            return this;
        }

        public final Collection<String> getFeatureTypes() {
            if (featureTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return featureTypes;
        }

        public final void setFeatureTypes(Collection<String> featureTypes) {
            this.featureTypes = ListOfDocumentReadFeatureTypesCopier.copy(featureTypes);
        }

        @Override
        @Transient
        public final Builder featureTypesWithStrings(Collection<String> featureTypes) {
            this.featureTypes = ListOfDocumentReadFeatureTypesCopier.copy(featureTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder featureTypesWithStrings(String... featureTypes) {
            featureTypesWithStrings(Arrays.asList(featureTypes));
            return this;
        }

        @Override
        @Transient
        public final Builder featureTypes(Collection<DocumentReadFeatureTypes> featureTypes) {
            this.featureTypes = ListOfDocumentReadFeatureTypesCopier.copyEnumToString(featureTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder featureTypes(DocumentReadFeatureTypes... featureTypes) {
            featureTypes(Arrays.asList(featureTypes));
            return this;
        }

        @Override
        public DocumentReaderConfig build() {
            return new DocumentReaderConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
