/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed information about the accuracy of an entity recognizer for a specific entity type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EntityTypesEvaluationMetrics implements SdkPojo, Serializable,
        ToCopyableBuilder<EntityTypesEvaluationMetrics.Builder, EntityTypesEvaluationMetrics> {
    private static final SdkField<Double> PRECISION_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Precision").getter(getter(EntityTypesEvaluationMetrics::precision)).setter(setter(Builder::precision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Precision").build()).build();

    private static final SdkField<Double> RECALL_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Recall")
            .getter(getter(EntityTypesEvaluationMetrics::recall)).setter(setter(Builder::recall))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recall").build()).build();

    private static final SdkField<Double> F1_SCORE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("F1Score").getter(getter(EntityTypesEvaluationMetrics::f1Score)).setter(setter(Builder::f1Score))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("F1Score").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRECISION_FIELD, RECALL_FIELD,
            F1_SCORE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double precision;

    private final Double recall;

    private final Double f1Score;

    private EntityTypesEvaluationMetrics(BuilderImpl builder) {
        this.precision = builder.precision;
        this.recall = builder.recall;
        this.f1Score = builder.f1Score;
    }

    /**
     * <p>
     * A measure of the usefulness of the recognizer results for a specific entity type in the test data. High precision
     * means that the recognizer returned substantially more relevant results than irrelevant ones.
     * </p>
     * 
     * @return A measure of the usefulness of the recognizer results for a specific entity type in the test data. High
     *         precision means that the recognizer returned substantially more relevant results than irrelevant ones.
     */
    public final Double precision() {
        return precision;
    }

    /**
     * <p>
     * A measure of how complete the recognizer results are for a specific entity type in the test data. High recall
     * means that the recognizer returned most of the relevant results.
     * </p>
     * 
     * @return A measure of how complete the recognizer results are for a specific entity type in the test data. High
     *         recall means that the recognizer returned most of the relevant results.
     */
    public final Double recall() {
        return recall;
    }

    /**
     * <p>
     * A measure of how accurate the recognizer results are for a specific entity type in the test data. It is derived
     * from the <code>Precision</code> and <code>Recall</code> values. The <code>F1Score</code> is the harmonic average
     * of the two scores. The highest score is 1, and the worst score is 0.
     * </p>
     * 
     * @return A measure of how accurate the recognizer results are for a specific entity type in the test data. It is
     *         derived from the <code>Precision</code> and <code>Recall</code> values. The <code>F1Score</code> is the
     *         harmonic average of the two scores. The highest score is 1, and the worst score is 0.
     */
    public final Double f1Score() {
        return f1Score;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(precision());
        hashCode = 31 * hashCode + Objects.hashCode(recall());
        hashCode = 31 * hashCode + Objects.hashCode(f1Score());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityTypesEvaluationMetrics)) {
            return false;
        }
        EntityTypesEvaluationMetrics other = (EntityTypesEvaluationMetrics) obj;
        return Objects.equals(precision(), other.precision()) && Objects.equals(recall(), other.recall())
                && Objects.equals(f1Score(), other.f1Score());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EntityTypesEvaluationMetrics").add("Precision", precision()).add("Recall", recall())
                .add("F1Score", f1Score()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Precision":
            return Optional.ofNullable(clazz.cast(precision()));
        case "Recall":
            return Optional.ofNullable(clazz.cast(recall()));
        case "F1Score":
            return Optional.ofNullable(clazz.cast(f1Score()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntityTypesEvaluationMetrics, T> g) {
        return obj -> g.apply((EntityTypesEvaluationMetrics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EntityTypesEvaluationMetrics> {
        /**
         * <p>
         * A measure of the usefulness of the recognizer results for a specific entity type in the test data. High
         * precision means that the recognizer returned substantially more relevant results than irrelevant ones.
         * </p>
         * 
         * @param precision
         *        A measure of the usefulness of the recognizer results for a specific entity type in the test data.
         *        High precision means that the recognizer returned substantially more relevant results than irrelevant
         *        ones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder precision(Double precision);

        /**
         * <p>
         * A measure of how complete the recognizer results are for a specific entity type in the test data. High recall
         * means that the recognizer returned most of the relevant results.
         * </p>
         * 
         * @param recall
         *        A measure of how complete the recognizer results are for a specific entity type in the test data. High
         *        recall means that the recognizer returned most of the relevant results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recall(Double recall);

        /**
         * <p>
         * A measure of how accurate the recognizer results are for a specific entity type in the test data. It is
         * derived from the <code>Precision</code> and <code>Recall</code> values. The <code>F1Score</code> is the
         * harmonic average of the two scores. The highest score is 1, and the worst score is 0.
         * </p>
         * 
         * @param f1Score
         *        A measure of how accurate the recognizer results are for a specific entity type in the test data. It
         *        is derived from the <code>Precision</code> and <code>Recall</code> values. The <code>F1Score</code> is
         *        the harmonic average of the two scores. The highest score is 1, and the worst score is 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder f1Score(Double f1Score);
    }

    static final class BuilderImpl implements Builder {
        private Double precision;

        private Double recall;

        private Double f1Score;

        private BuilderImpl() {
        }

        private BuilderImpl(EntityTypesEvaluationMetrics model) {
            precision(model.precision);
            recall(model.recall);
            f1Score(model.f1Score);
        }

        public final Double getPrecision() {
            return precision;
        }

        public final void setPrecision(Double precision) {
            this.precision = precision;
        }

        @Override
        @Transient
        public final Builder precision(Double precision) {
            this.precision = precision;
            return this;
        }

        public final Double getRecall() {
            return recall;
        }

        public final void setRecall(Double recall) {
            this.recall = recall;
        }

        @Override
        @Transient
        public final Builder recall(Double recall) {
            this.recall = recall;
            return this;
        }

        public final Double getF1Score() {
            return f1Score;
        }

        public final void setF1Score(Double f1Score) {
            this.f1Score = f1Score;
        }

        @Override
        @Transient
        public final Builder f1Score(Double f1Score) {
            this.f1Score = f1Score;
            return this;
        }

        @Override
        public EntityTypesEvaluationMetrics build() {
            return new EntityTypesEvaluationMetrics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
