/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEntityRecognizersResponse extends ComprehendResponse implements
        ToCopyableBuilder<ListEntityRecognizersResponse.Builder, ListEntityRecognizersResponse> {
    private static final SdkField<List<EntityRecognizerProperties>> ENTITY_RECOGNIZER_PROPERTIES_LIST_FIELD = SdkField
            .<List<EntityRecognizerProperties>> builder(MarshallingType.LIST)
            .memberName("EntityRecognizerPropertiesList")
            .getter(getter(ListEntityRecognizersResponse::entityRecognizerPropertiesList))
            .setter(setter(Builder::entityRecognizerPropertiesList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityRecognizerPropertiesList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EntityRecognizerProperties> builder(MarshallingType.SDK_POJO)
                                            .constructor(EntityRecognizerProperties::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListEntityRecognizersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ENTITY_RECOGNIZER_PROPERTIES_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final List<EntityRecognizerProperties> entityRecognizerPropertiesList;

    private final String nextToken;

    private ListEntityRecognizersResponse(BuilderImpl builder) {
        super(builder);
        this.entityRecognizerPropertiesList = builder.entityRecognizerPropertiesList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the EntityRecognizerPropertiesList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEntityRecognizerPropertiesList() {
        return entityRecognizerPropertiesList != null && !(entityRecognizerPropertiesList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of properties of an entity recognizer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntityRecognizerPropertiesList} method.
     * </p>
     * 
     * @return The list of properties of an entity recognizer.
     */
    public final List<EntityRecognizerProperties> entityRecognizerPropertiesList() {
        return entityRecognizerPropertiesList;
    }

    /**
     * <p>
     * Identifies the next page of results to return.
     * </p>
     * 
     * @return Identifies the next page of results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasEntityRecognizerPropertiesList() ? entityRecognizerPropertiesList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEntityRecognizersResponse)) {
            return false;
        }
        ListEntityRecognizersResponse other = (ListEntityRecognizersResponse) obj;
        return hasEntityRecognizerPropertiesList() == other.hasEntityRecognizerPropertiesList()
                && Objects.equals(entityRecognizerPropertiesList(), other.entityRecognizerPropertiesList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListEntityRecognizersResponse")
                .add("EntityRecognizerPropertiesList",
                        hasEntityRecognizerPropertiesList() ? entityRecognizerPropertiesList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EntityRecognizerPropertiesList":
            return Optional.ofNullable(clazz.cast(entityRecognizerPropertiesList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEntityRecognizersResponse, T> g) {
        return obj -> g.apply((ListEntityRecognizersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListEntityRecognizersResponse> {
        /**
         * <p>
         * The list of properties of an entity recognizer.
         * </p>
         * 
         * @param entityRecognizerPropertiesList
         *        The list of properties of an entity recognizer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityRecognizerPropertiesList(Collection<EntityRecognizerProperties> entityRecognizerPropertiesList);

        /**
         * <p>
         * The list of properties of an entity recognizer.
         * </p>
         * 
         * @param entityRecognizerPropertiesList
         *        The list of properties of an entity recognizer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityRecognizerPropertiesList(EntityRecognizerProperties... entityRecognizerPropertiesList);

        /**
         * <p>
         * The list of properties of an entity recognizer.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EntityRecognizerProperties>.Builder}
         * avoiding the need to create one manually via {@link List<EntityRecognizerProperties>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EntityRecognizerProperties>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #entityRecognizerPropertiesList(List<EntityRecognizerProperties>)}.
         * 
         * @param entityRecognizerPropertiesList
         *        a consumer that will call methods on {@link List<EntityRecognizerProperties>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entityRecognizerPropertiesList(List<EntityRecognizerProperties>)
         */
        Builder entityRecognizerPropertiesList(Consumer<EntityRecognizerProperties.Builder>... entityRecognizerPropertiesList);

        /**
         * <p>
         * Identifies the next page of results to return.
         * </p>
         * 
         * @param nextToken
         *        Identifies the next page of results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ComprehendResponse.BuilderImpl implements Builder {
        private List<EntityRecognizerProperties> entityRecognizerPropertiesList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEntityRecognizersResponse model) {
            super(model);
            entityRecognizerPropertiesList(model.entityRecognizerPropertiesList);
            nextToken(model.nextToken);
        }

        public final List<EntityRecognizerProperties.Builder> getEntityRecognizerPropertiesList() {
            List<EntityRecognizerProperties.Builder> result = EntityRecognizerPropertiesListCopier
                    .copyToBuilder(this.entityRecognizerPropertiesList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntityRecognizerPropertiesList(
                Collection<EntityRecognizerProperties.BuilderImpl> entityRecognizerPropertiesList) {
            this.entityRecognizerPropertiesList = EntityRecognizerPropertiesListCopier
                    .copyFromBuilder(entityRecognizerPropertiesList);
        }

        @Override
        @Transient
        public final Builder entityRecognizerPropertiesList(Collection<EntityRecognizerProperties> entityRecognizerPropertiesList) {
            this.entityRecognizerPropertiesList = EntityRecognizerPropertiesListCopier.copy(entityRecognizerPropertiesList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder entityRecognizerPropertiesList(EntityRecognizerProperties... entityRecognizerPropertiesList) {
            entityRecognizerPropertiesList(Arrays.asList(entityRecognizerPropertiesList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder entityRecognizerPropertiesList(
                Consumer<EntityRecognizerProperties.Builder>... entityRecognizerPropertiesList) {
            entityRecognizerPropertiesList(Stream.of(entityRecognizerPropertiesList)
                    .map(c -> EntityRecognizerProperties.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEntityRecognizersResponse build() {
            return new ListEntityRecognizersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
