/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the document, discovered during text extraction.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentMetadata.Builder, DocumentMetadata> {
    private static final SdkField<Integer> PAGES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Pages")
            .getter(getter(DocumentMetadata::pages)).setter(setter(Builder::pages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pages").build()).build();

    private static final SdkField<List<ExtractedCharactersListItem>> EXTRACTED_CHARACTERS_FIELD = SdkField
            .<List<ExtractedCharactersListItem>> builder(MarshallingType.LIST)
            .memberName("ExtractedCharacters")
            .getter(getter(DocumentMetadata::extractedCharacters))
            .setter(setter(Builder::extractedCharacters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtractedCharacters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExtractedCharactersListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExtractedCharactersListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAGES_FIELD,
            EXTRACTED_CHARACTERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer pages;

    private final List<ExtractedCharactersListItem> extractedCharacters;

    private DocumentMetadata(BuilderImpl builder) {
        this.pages = builder.pages;
        this.extractedCharacters = builder.extractedCharacters;
    }

    /**
     * <p>
     * Number of pages in the document.
     * </p>
     * 
     * @return Number of pages in the document.
     */
    public final Integer pages() {
        return pages;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExtractedCharacters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExtractedCharacters() {
        return extractedCharacters != null && !(extractedCharacters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of pages in the document, with the number of characters extracted from each page.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExtractedCharacters} method.
     * </p>
     * 
     * @return List of pages in the document, with the number of characters extracted from each page.
     */
    public final List<ExtractedCharactersListItem> extractedCharacters() {
        return extractedCharacters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pages());
        hashCode = 31 * hashCode + Objects.hashCode(hasExtractedCharacters() ? extractedCharacters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentMetadata)) {
            return false;
        }
        DocumentMetadata other = (DocumentMetadata) obj;
        return Objects.equals(pages(), other.pages()) && hasExtractedCharacters() == other.hasExtractedCharacters()
                && Objects.equals(extractedCharacters(), other.extractedCharacters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentMetadata").add("Pages", pages())
                .add("ExtractedCharacters", hasExtractedCharacters() ? extractedCharacters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Pages":
            return Optional.ofNullable(clazz.cast(pages()));
        case "ExtractedCharacters":
            return Optional.ofNullable(clazz.cast(extractedCharacters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentMetadata, T> g) {
        return obj -> g.apply((DocumentMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentMetadata> {
        /**
         * <p>
         * Number of pages in the document.
         * </p>
         * 
         * @param pages
         *        Number of pages in the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pages(Integer pages);

        /**
         * <p>
         * List of pages in the document, with the number of characters extracted from each page.
         * </p>
         * 
         * @param extractedCharacters
         *        List of pages in the document, with the number of characters extracted from each page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extractedCharacters(Collection<ExtractedCharactersListItem> extractedCharacters);

        /**
         * <p>
         * List of pages in the document, with the number of characters extracted from each page.
         * </p>
         * 
         * @param extractedCharacters
         *        List of pages in the document, with the number of characters extracted from each page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extractedCharacters(ExtractedCharactersListItem... extractedCharacters);

        /**
         * <p>
         * List of pages in the document, with the number of characters extracted from each page.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.comprehend.model.ExtractedCharactersListItem.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.comprehend.model.ExtractedCharactersListItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.comprehend.model.ExtractedCharactersListItem.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #extractedCharacters(List<ExtractedCharactersListItem>)}.
         * 
         * @param extractedCharacters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.comprehend.model.ExtractedCharactersListItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #extractedCharacters(java.util.Collection<ExtractedCharactersListItem>)
         */
        Builder extractedCharacters(Consumer<ExtractedCharactersListItem.Builder>... extractedCharacters);
    }

    static final class BuilderImpl implements Builder {
        private Integer pages;

        private List<ExtractedCharactersListItem> extractedCharacters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentMetadata model) {
            pages(model.pages);
            extractedCharacters(model.extractedCharacters);
        }

        public final Integer getPages() {
            return pages;
        }

        public final void setPages(Integer pages) {
            this.pages = pages;
        }

        @Override
        public final Builder pages(Integer pages) {
            this.pages = pages;
            return this;
        }

        public final List<ExtractedCharactersListItem.Builder> getExtractedCharacters() {
            List<ExtractedCharactersListItem.Builder> result = ListOfExtractedCharactersCopier
                    .copyToBuilder(this.extractedCharacters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExtractedCharacters(Collection<ExtractedCharactersListItem.BuilderImpl> extractedCharacters) {
            this.extractedCharacters = ListOfExtractedCharactersCopier.copyFromBuilder(extractedCharacters);
        }

        @Override
        public final Builder extractedCharacters(Collection<ExtractedCharactersListItem> extractedCharacters) {
            this.extractedCharacters = ListOfExtractedCharactersCopier.copy(extractedCharacters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extractedCharacters(ExtractedCharactersListItem... extractedCharacters) {
            extractedCharacters(Arrays.asList(extractedCharacters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extractedCharacters(Consumer<ExtractedCharactersListItem.Builder>... extractedCharacters) {
            extractedCharacters(Stream.of(extractedCharacters)
                    .map(c -> ExtractedCharactersListItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DocumentMetadata build() {
            return new DocumentMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
