/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportModelRequest extends ComprehendRequest implements
        ToCopyableBuilder<ImportModelRequest.Builder, ImportModelRequest> {
    private static final SdkField<String> SOURCE_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceModelArn").getter(getter(ImportModelRequest::sourceModelArn))
            .setter(setter(Builder::sourceModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceModelArn").build()).build();

    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelName").getter(getter(ImportModelRequest::modelName)).setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()).build();

    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionName").getter(getter(ImportModelRequest::versionName)).setter(setter(Builder::versionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionName").build()).build();

    private static final SdkField<String> MODEL_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelKmsKeyId").getter(getter(ImportModelRequest::modelKmsKeyId)).setter(setter(Builder::modelKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelKmsKeyId").build()).build();

    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataAccessRoleArn").getter(getter(ImportModelRequest::dataAccessRoleArn))
            .setter(setter(Builder::dataAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(ImportModelRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_MODEL_ARN_FIELD,
            MODEL_NAME_FIELD, VERSION_NAME_FIELD, MODEL_KMS_KEY_ID_FIELD, DATA_ACCESS_ROLE_ARN_FIELD, TAGS_FIELD));

    private final String sourceModelArn;

    private final String modelName;

    private final String versionName;

    private final String modelKmsKeyId;

    private final String dataAccessRoleArn;

    private final List<Tag> tags;

    private ImportModelRequest(BuilderImpl builder) {
        super(builder);
        this.sourceModelArn = builder.sourceModelArn;
        this.modelName = builder.modelName;
        this.versionName = builder.versionName;
        this.modelKmsKeyId = builder.modelKmsKeyId;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the custom model to import.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the custom model to import.
     */
    public final String sourceModelArn() {
        return sourceModelArn;
    }

    /**
     * <p>
     * The name to assign to the custom model that is created in Amazon Comprehend by this import.
     * </p>
     * 
     * @return The name to assign to the custom model that is created in Amazon Comprehend by this import.
     */
    public final String modelName() {
        return modelName;
    }

    /**
     * <p>
     * The version name given to the custom model that is created by this import. Version names can have a maximum of
     * 256 characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed. The version name must be
     * unique among all models with the same classifier name in the account/AWS Region.
     * </p>
     * 
     * @return The version name given to the custom model that is created by this import. Version names can have a
     *         maximum of 256 characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed. The
     *         version name must be unique among all models with the same classifier name in the account/AWS Region.
     */
    public final String versionName() {
        return versionName;
    }

    /**
     * <p>
     * ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt trained custom models. The
     * ModelKmsKeyId can be either of the following formats:
     * </p>
     * <ul>
     * <li>
     * <p>
     * KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Resource Name (ARN) of a KMS Key:
     * <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt trained custom
     *         models. The ModelKmsKeyId can be either of the following formats:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Resource Name (ARN) of a KMS Key:
     *         <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
     *         </p>
     *         </li>
     */
    public final String modelKmsKeyId() {
        return modelKmsKeyId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that allows Amazon Comprehend to use
     * Amazon Key Management Service (KMS) to encrypt or decrypt the custom model.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that allows Amazon
     *         Comprehend to use Amazon Key Management Service (KMS) to encrypt or decrypt the custom model.
     */
    public final String dataAccessRoleArn() {
        return dataAccessRoleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tags to be associated with the custom model that is created by this import. A tag is a key-value pair that adds
     * as a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added
     * to a resource to indicate its use by the sales department.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags to be associated with the custom model that is created by this import. A tag is a key-value pair
     *         that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the
     *         key might be added to a resource to indicate its use by the sales department.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        hashCode = 31 * hashCode + Objects.hashCode(versionName());
        hashCode = 31 * hashCode + Objects.hashCode(modelKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportModelRequest)) {
            return false;
        }
        ImportModelRequest other = (ImportModelRequest) obj;
        return Objects.equals(sourceModelArn(), other.sourceModelArn()) && Objects.equals(modelName(), other.modelName())
                && Objects.equals(versionName(), other.versionName()) && Objects.equals(modelKmsKeyId(), other.modelKmsKeyId())
                && Objects.equals(dataAccessRoleArn(), other.dataAccessRoleArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportModelRequest").add("SourceModelArn", sourceModelArn()).add("ModelName", modelName())
                .add("VersionName", versionName()).add("ModelKmsKeyId", modelKmsKeyId())
                .add("DataAccessRoleArn", dataAccessRoleArn()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceModelArn":
            return Optional.ofNullable(clazz.cast(sourceModelArn()));
        case "ModelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        case "VersionName":
            return Optional.ofNullable(clazz.cast(versionName()));
        case "ModelKmsKeyId":
            return Optional.ofNullable(clazz.cast(modelKmsKeyId()));
        case "DataAccessRoleArn":
            return Optional.ofNullable(clazz.cast(dataAccessRoleArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportModelRequest, T> g) {
        return obj -> g.apply((ImportModelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendRequest.Builder, SdkPojo, CopyableBuilder<Builder, ImportModelRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the custom model to import.
         * </p>
         * 
         * @param sourceModelArn
         *        The Amazon Resource Name (ARN) of the custom model to import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceModelArn(String sourceModelArn);

        /**
         * <p>
         * The name to assign to the custom model that is created in Amazon Comprehend by this import.
         * </p>
         * 
         * @param modelName
         *        The name to assign to the custom model that is created in Amazon Comprehend by this import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        /**
         * <p>
         * The version name given to the custom model that is created by this import. Version names can have a maximum
         * of 256 characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed. The version name
         * must be unique among all models with the same classifier name in the account/AWS Region.
         * </p>
         * 
         * @param versionName
         *        The version name given to the custom model that is created by this import. Version names can have a
         *        maximum of 256 characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed. The
         *        version name must be unique among all models with the same classifier name in the account/AWS Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionName(String versionName);

        /**
         * <p>
         * ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt trained custom models.
         * The ModelKmsKeyId can be either of the following formats:
         * </p>
         * <ul>
         * <li>
         * <p>
         * KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Resource Name (ARN) of a KMS Key:
         * <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param modelKmsKeyId
         *        ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt trained custom
         *        models. The ModelKmsKeyId can be either of the following formats:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Resource Name (ARN) of a KMS Key:
         *        <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelKmsKeyId(String modelKmsKeyId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that allows Amazon Comprehend to
         * use Amazon Key Management Service (KMS) to encrypt or decrypt the custom model.
         * </p>
         * 
         * @param dataAccessRoleArn
         *        The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that allows Amazon
         *        Comprehend to use Amazon Key Management Service (KMS) to encrypt or decrypt the custom model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAccessRoleArn(String dataAccessRoleArn);

        /**
         * <p>
         * Tags to be associated with the custom model that is created by this import. A tag is a key-value pair that
         * adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might
         * be added to a resource to indicate its use by the sales department.
         * </p>
         * 
         * @param tags
         *        Tags to be associated with the custom model that is created by this import. A tag is a key-value pair
         *        that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as
         *        the key might be added to a resource to indicate its use by the sales department.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Tags to be associated with the custom model that is created by this import. A tag is a key-value pair that
         * adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might
         * be added to a resource to indicate its use by the sales department.
         * </p>
         * 
         * @param tags
         *        Tags to be associated with the custom model that is created by this import. A tag is a key-value pair
         *        that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as
         *        the key might be added to a resource to indicate its use by the sales department.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Tags to be associated with the custom model that is created by this import. A tag is a key-value pair that
         * adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might
         * be added to a resource to indicate its use by the sales department.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.comprehend.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.comprehend.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.comprehend.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.comprehend.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ComprehendRequest.BuilderImpl implements Builder {
        private String sourceModelArn;

        private String modelName;

        private String versionName;

        private String modelKmsKeyId;

        private String dataAccessRoleArn;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImportModelRequest model) {
            super(model);
            sourceModelArn(model.sourceModelArn);
            modelName(model.modelName);
            versionName(model.versionName);
            modelKmsKeyId(model.modelKmsKeyId);
            dataAccessRoleArn(model.dataAccessRoleArn);
            tags(model.tags);
        }

        public final String getSourceModelArn() {
            return sourceModelArn;
        }

        public final void setSourceModelArn(String sourceModelArn) {
            this.sourceModelArn = sourceModelArn;
        }

        @Override
        public final Builder sourceModelArn(String sourceModelArn) {
            this.sourceModelArn = sourceModelArn;
            return this;
        }

        public final String getModelName() {
            return modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getVersionName() {
            return versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final String getModelKmsKeyId() {
            return modelKmsKeyId;
        }

        public final void setModelKmsKeyId(String modelKmsKeyId) {
            this.modelKmsKeyId = modelKmsKeyId;
        }

        @Override
        public final Builder modelKmsKeyId(String modelKmsKeyId) {
            this.modelKmsKeyId = modelKmsKeyId;
            return this;
        }

        public final String getDataAccessRoleArn() {
            return dataAccessRoleArn;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportModelRequest build() {
            return new ImportModelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
