/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFlywheelRequest extends ComprehendRequest implements
        ToCopyableBuilder<CreateFlywheelRequest.Builder, CreateFlywheelRequest> {
    private static final SdkField<String> FLYWHEEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlywheelName").getter(getter(CreateFlywheelRequest::flywheelName)).setter(setter(Builder::flywheelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlywheelName").build()).build();

    private static final SdkField<String> ACTIVE_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActiveModelArn").getter(getter(CreateFlywheelRequest::activeModelArn))
            .setter(setter(Builder::activeModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveModelArn").build()).build();

    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataAccessRoleArn").getter(getter(CreateFlywheelRequest::dataAccessRoleArn))
            .setter(setter(Builder::dataAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()).build();

    private static final SdkField<TaskConfig> TASK_CONFIG_FIELD = SdkField.<TaskConfig> builder(MarshallingType.SDK_POJO)
            .memberName("TaskConfig").getter(getter(CreateFlywheelRequest::taskConfig)).setter(setter(Builder::taskConfig))
            .constructor(TaskConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskConfig").build()).build();

    private static final SdkField<String> MODEL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelType").getter(getter(CreateFlywheelRequest::modelTypeAsString)).setter(setter(Builder::modelType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelType").build()).build();

    private static final SdkField<String> DATA_LAKE_S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataLakeS3Uri").getter(getter(CreateFlywheelRequest::dataLakeS3Uri))
            .setter(setter(Builder::dataLakeS3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLakeS3Uri").build()).build();

    private static final SdkField<DataSecurityConfig> DATA_SECURITY_CONFIG_FIELD = SdkField
            .<DataSecurityConfig> builder(MarshallingType.SDK_POJO).memberName("DataSecurityConfig")
            .getter(getter(CreateFlywheelRequest::dataSecurityConfig)).setter(setter(Builder::dataSecurityConfig))
            .constructor(DataSecurityConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSecurityConfig").build())
            .build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(CreateFlywheelRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateFlywheelRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLYWHEEL_NAME_FIELD,
            ACTIVE_MODEL_ARN_FIELD, DATA_ACCESS_ROLE_ARN_FIELD, TASK_CONFIG_FIELD, MODEL_TYPE_FIELD, DATA_LAKE_S3_URI_FIELD,
            DATA_SECURITY_CONFIG_FIELD, CLIENT_REQUEST_TOKEN_FIELD, TAGS_FIELD));

    private final String flywheelName;

    private final String activeModelArn;

    private final String dataAccessRoleArn;

    private final TaskConfig taskConfig;

    private final String modelType;

    private final String dataLakeS3Uri;

    private final DataSecurityConfig dataSecurityConfig;

    private final String clientRequestToken;

    private final List<Tag> tags;

    private CreateFlywheelRequest(BuilderImpl builder) {
        super(builder);
        this.flywheelName = builder.flywheelName;
        this.activeModelArn = builder.activeModelArn;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.taskConfig = builder.taskConfig;
        this.modelType = builder.modelType;
        this.dataLakeS3Uri = builder.dataLakeS3Uri;
        this.dataSecurityConfig = builder.dataSecurityConfig;
        this.clientRequestToken = builder.clientRequestToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Name for the flywheel.
     * </p>
     * 
     * @return Name for the flywheel.
     */
    public final String flywheelName() {
        return flywheelName;
    }

    /**
     * <p>
     * To associate an existing model with the flywheel, specify the Amazon Resource Number (ARN) of the model version.
     * </p>
     * 
     * @return To associate an existing model with the flywheel, specify the Amazon Resource Number (ARN) of the model
     *         version.
     */
    public final String activeModelArn() {
        return activeModelArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend the permissions required to access
     * the flywheel data in the data lake.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend the permissions required to
     *         access the flywheel data in the data lake.
     */
    public final String dataAccessRoleArn() {
        return dataAccessRoleArn;
    }

    /**
     * <p>
     * Configuration about the custom classifier associated with the flywheel.
     * </p>
     * 
     * @return Configuration about the custom classifier associated with the flywheel.
     */
    public final TaskConfig taskConfig() {
        return taskConfig;
    }

    /**
     * <p>
     * The model type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelType} will
     * return {@link ModelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modelTypeAsString}.
     * </p>
     * 
     * @return The model type.
     * @see ModelType
     */
    public final ModelType modelType() {
        return ModelType.fromValue(modelType);
    }

    /**
     * <p>
     * The model type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelType} will
     * return {@link ModelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modelTypeAsString}.
     * </p>
     * 
     * @return The model type.
     * @see ModelType
     */
    public final String modelTypeAsString() {
        return modelType;
    }

    /**
     * <p>
     * Enter the S3 location for the data lake. You can specify a new S3 bucket or a new folder of an existing S3
     * bucket. The flywheel creates the data lake at this location.
     * </p>
     * 
     * @return Enter the S3 location for the data lake. You can specify a new S3 bucket or a new folder of an existing
     *         S3 bucket. The flywheel creates the data lake at this location.
     */
    public final String dataLakeS3Uri() {
        return dataLakeS3Uri;
    }

    /**
     * <p>
     * Data security configurations.
     * </p>
     * 
     * @return Data security configurations.
     */
    public final DataSecurityConfig dataSecurityConfig() {
        return dataSecurityConfig;
    }

    /**
     * <p>
     * A unique identifier for the request. If you don't set the client request token, Amazon Comprehend generates one.
     * </p>
     * 
     * @return A unique identifier for the request. If you don't set the client request token, Amazon Comprehend
     *         generates one.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to associate with this flywheel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to associate with this flywheel.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(flywheelName());
        hashCode = 31 * hashCode + Objects.hashCode(activeModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(taskConfig());
        hashCode = 31 * hashCode + Objects.hashCode(modelTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dataLakeS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(dataSecurityConfig());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFlywheelRequest)) {
            return false;
        }
        CreateFlywheelRequest other = (CreateFlywheelRequest) obj;
        return Objects.equals(flywheelName(), other.flywheelName()) && Objects.equals(activeModelArn(), other.activeModelArn())
                && Objects.equals(dataAccessRoleArn(), other.dataAccessRoleArn())
                && Objects.equals(taskConfig(), other.taskConfig())
                && Objects.equals(modelTypeAsString(), other.modelTypeAsString())
                && Objects.equals(dataLakeS3Uri(), other.dataLakeS3Uri())
                && Objects.equals(dataSecurityConfig(), other.dataSecurityConfig())
                && Objects.equals(clientRequestToken(), other.clientRequestToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFlywheelRequest").add("FlywheelName", flywheelName())
                .add("ActiveModelArn", activeModelArn()).add("DataAccessRoleArn", dataAccessRoleArn())
                .add("TaskConfig", taskConfig()).add("ModelType", modelTypeAsString()).add("DataLakeS3Uri", dataLakeS3Uri())
                .add("DataSecurityConfig", dataSecurityConfig()).add("ClientRequestToken", clientRequestToken())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlywheelName":
            return Optional.ofNullable(clazz.cast(flywheelName()));
        case "ActiveModelArn":
            return Optional.ofNullable(clazz.cast(activeModelArn()));
        case "DataAccessRoleArn":
            return Optional.ofNullable(clazz.cast(dataAccessRoleArn()));
        case "TaskConfig":
            return Optional.ofNullable(clazz.cast(taskConfig()));
        case "ModelType":
            return Optional.ofNullable(clazz.cast(modelTypeAsString()));
        case "DataLakeS3Uri":
            return Optional.ofNullable(clazz.cast(dataLakeS3Uri()));
        case "DataSecurityConfig":
            return Optional.ofNullable(clazz.cast(dataSecurityConfig()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFlywheelRequest, T> g) {
        return obj -> g.apply((CreateFlywheelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateFlywheelRequest> {
        /**
         * <p>
         * Name for the flywheel.
         * </p>
         * 
         * @param flywheelName
         *        Name for the flywheel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flywheelName(String flywheelName);

        /**
         * <p>
         * To associate an existing model with the flywheel, specify the Amazon Resource Number (ARN) of the model
         * version.
         * </p>
         * 
         * @param activeModelArn
         *        To associate an existing model with the flywheel, specify the Amazon Resource Number (ARN) of the
         *        model version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeModelArn(String activeModelArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend the permissions required to
         * access the flywheel data in the data lake.
         * </p>
         * 
         * @param dataAccessRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend the permissions required
         *        to access the flywheel data in the data lake.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAccessRoleArn(String dataAccessRoleArn);

        /**
         * <p>
         * Configuration about the custom classifier associated with the flywheel.
         * </p>
         * 
         * @param taskConfig
         *        Configuration about the custom classifier associated with the flywheel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskConfig(TaskConfig taskConfig);

        /**
         * <p>
         * Configuration about the custom classifier associated with the flywheel.
         * </p>
         * This is a convenience method that creates an instance of the {@link TaskConfig.Builder} avoiding the need to
         * create one manually via {@link TaskConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TaskConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #taskConfig(TaskConfig)}.
         * 
         * @param taskConfig
         *        a consumer that will call methods on {@link TaskConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskConfig(TaskConfig)
         */
        default Builder taskConfig(Consumer<TaskConfig.Builder> taskConfig) {
            return taskConfig(TaskConfig.builder().applyMutation(taskConfig).build());
        }

        /**
         * <p>
         * The model type.
         * </p>
         * 
         * @param modelType
         *        The model type.
         * @see ModelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelType
         */
        Builder modelType(String modelType);

        /**
         * <p>
         * The model type.
         * </p>
         * 
         * @param modelType
         *        The model type.
         * @see ModelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelType
         */
        Builder modelType(ModelType modelType);

        /**
         * <p>
         * Enter the S3 location for the data lake. You can specify a new S3 bucket or a new folder of an existing S3
         * bucket. The flywheel creates the data lake at this location.
         * </p>
         * 
         * @param dataLakeS3Uri
         *        Enter the S3 location for the data lake. You can specify a new S3 bucket or a new folder of an
         *        existing S3 bucket. The flywheel creates the data lake at this location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataLakeS3Uri(String dataLakeS3Uri);

        /**
         * <p>
         * Data security configurations.
         * </p>
         * 
         * @param dataSecurityConfig
         *        Data security configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSecurityConfig(DataSecurityConfig dataSecurityConfig);

        /**
         * <p>
         * Data security configurations.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSecurityConfig.Builder} avoiding the
         * need to create one manually via {@link DataSecurityConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSecurityConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #dataSecurityConfig(DataSecurityConfig)}.
         * 
         * @param dataSecurityConfig
         *        a consumer that will call methods on {@link DataSecurityConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSecurityConfig(DataSecurityConfig)
         */
        default Builder dataSecurityConfig(Consumer<DataSecurityConfig.Builder> dataSecurityConfig) {
            return dataSecurityConfig(DataSecurityConfig.builder().applyMutation(dataSecurityConfig).build());
        }

        /**
         * <p>
         * A unique identifier for the request. If you don't set the client request token, Amazon Comprehend generates
         * one.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique identifier for the request. If you don't set the client request token, Amazon Comprehend
         *        generates one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The tags to associate with this flywheel.
         * </p>
         * 
         * @param tags
         *        The tags to associate with this flywheel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags to associate with this flywheel.
         * </p>
         * 
         * @param tags
         *        The tags to associate with this flywheel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags to associate with this flywheel.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.comprehend.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.comprehend.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.comprehend.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.comprehend.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ComprehendRequest.BuilderImpl implements Builder {
        private String flywheelName;

        private String activeModelArn;

        private String dataAccessRoleArn;

        private TaskConfig taskConfig;

        private String modelType;

        private String dataLakeS3Uri;

        private DataSecurityConfig dataSecurityConfig;

        private String clientRequestToken;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFlywheelRequest model) {
            super(model);
            flywheelName(model.flywheelName);
            activeModelArn(model.activeModelArn);
            dataAccessRoleArn(model.dataAccessRoleArn);
            taskConfig(model.taskConfig);
            modelType(model.modelType);
            dataLakeS3Uri(model.dataLakeS3Uri);
            dataSecurityConfig(model.dataSecurityConfig);
            clientRequestToken(model.clientRequestToken);
            tags(model.tags);
        }

        public final String getFlywheelName() {
            return flywheelName;
        }

        public final void setFlywheelName(String flywheelName) {
            this.flywheelName = flywheelName;
        }

        @Override
        public final Builder flywheelName(String flywheelName) {
            this.flywheelName = flywheelName;
            return this;
        }

        public final String getActiveModelArn() {
            return activeModelArn;
        }

        public final void setActiveModelArn(String activeModelArn) {
            this.activeModelArn = activeModelArn;
        }

        @Override
        public final Builder activeModelArn(String activeModelArn) {
            this.activeModelArn = activeModelArn;
            return this;
        }

        public final String getDataAccessRoleArn() {
            return dataAccessRoleArn;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final TaskConfig.Builder getTaskConfig() {
            return taskConfig != null ? taskConfig.toBuilder() : null;
        }

        public final void setTaskConfig(TaskConfig.BuilderImpl taskConfig) {
            this.taskConfig = taskConfig != null ? taskConfig.build() : null;
        }

        @Override
        public final Builder taskConfig(TaskConfig taskConfig) {
            this.taskConfig = taskConfig;
            return this;
        }

        public final String getModelType() {
            return modelType;
        }

        public final void setModelType(String modelType) {
            this.modelType = modelType;
        }

        @Override
        public final Builder modelType(String modelType) {
            this.modelType = modelType;
            return this;
        }

        @Override
        public final Builder modelType(ModelType modelType) {
            this.modelType(modelType == null ? null : modelType.toString());
            return this;
        }

        public final String getDataLakeS3Uri() {
            return dataLakeS3Uri;
        }

        public final void setDataLakeS3Uri(String dataLakeS3Uri) {
            this.dataLakeS3Uri = dataLakeS3Uri;
        }

        @Override
        public final Builder dataLakeS3Uri(String dataLakeS3Uri) {
            this.dataLakeS3Uri = dataLakeS3Uri;
            return this;
        }

        public final DataSecurityConfig.Builder getDataSecurityConfig() {
            return dataSecurityConfig != null ? dataSecurityConfig.toBuilder() : null;
        }

        public final void setDataSecurityConfig(DataSecurityConfig.BuilderImpl dataSecurityConfig) {
            this.dataSecurityConfig = dataSecurityConfig != null ? dataSecurityConfig.build() : null;
        }

        @Override
        public final Builder dataSecurityConfig(DataSecurityConfig dataSecurityConfig) {
            this.dataSecurityConfig = dataSecurityConfig;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFlywheelRequest build() {
            return new CreateFlywheelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
