/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration about the model associated with a flywheel.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaskConfig implements SdkPojo, Serializable, ToCopyableBuilder<TaskConfig.Builder, TaskConfig> {
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(TaskConfig::languageCodeAsString)).setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<DocumentClassificationConfig> DOCUMENT_CLASSIFICATION_CONFIG_FIELD = SdkField
            .<DocumentClassificationConfig> builder(MarshallingType.SDK_POJO)
            .memberName("DocumentClassificationConfig")
            .getter(getter(TaskConfig::documentClassificationConfig))
            .setter(setter(Builder::documentClassificationConfig))
            .constructor(DocumentClassificationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentClassificationConfig")
                    .build()).build();

    private static final SdkField<EntityRecognitionConfig> ENTITY_RECOGNITION_CONFIG_FIELD = SdkField
            .<EntityRecognitionConfig> builder(MarshallingType.SDK_POJO).memberName("EntityRecognitionConfig")
            .getter(getter(TaskConfig::entityRecognitionConfig)).setter(setter(Builder::entityRecognitionConfig))
            .constructor(EntityRecognitionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityRecognitionConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANGUAGE_CODE_FIELD,
            DOCUMENT_CLASSIFICATION_CONFIG_FIELD, ENTITY_RECOGNITION_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String languageCode;

    private final DocumentClassificationConfig documentClassificationConfig;

    private final EntityRecognitionConfig entityRecognitionConfig;

    private TaskConfig(BuilderImpl builder) {
        this.languageCode = builder.languageCode;
        this.documentClassificationConfig = builder.documentClassificationConfig;
        this.entityRecognitionConfig = builder.entityRecognitionConfig;
    }

    /**
     * <p>
     * Language code for the language that the model supports.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return Language code for the language that the model supports.
     * @see LanguageCode
     */
    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * Language code for the language that the model supports.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return Language code for the language that the model supports.
     * @see LanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * Configuration required for a document classification model.
     * </p>
     * 
     * @return Configuration required for a document classification model.
     */
    public final DocumentClassificationConfig documentClassificationConfig() {
        return documentClassificationConfig;
    }

    /**
     * <p>
     * Configuration required for an entity recognition model.
     * </p>
     * 
     * @return Configuration required for an entity recognition model.
     */
    public final EntityRecognitionConfig entityRecognitionConfig() {
        return entityRecognitionConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(documentClassificationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(entityRecognitionConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskConfig)) {
            return false;
        }
        TaskConfig other = (TaskConfig) obj;
        return Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(documentClassificationConfig(), other.documentClassificationConfig())
                && Objects.equals(entityRecognitionConfig(), other.entityRecognitionConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TaskConfig").add("LanguageCode", languageCodeAsString())
                .add("DocumentClassificationConfig", documentClassificationConfig())
                .add("EntityRecognitionConfig", entityRecognitionConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "DocumentClassificationConfig":
            return Optional.ofNullable(clazz.cast(documentClassificationConfig()));
        case "EntityRecognitionConfig":
            return Optional.ofNullable(clazz.cast(entityRecognitionConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TaskConfig, T> g) {
        return obj -> g.apply((TaskConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaskConfig> {
        /**
         * <p>
         * Language code for the language that the model supports.
         * </p>
         * 
         * @param languageCode
         *        Language code for the language that the model supports.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * Language code for the language that the model supports.
         * </p>
         * 
         * @param languageCode
         *        Language code for the language that the model supports.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * <p>
         * Configuration required for a document classification model.
         * </p>
         * 
         * @param documentClassificationConfig
         *        Configuration required for a document classification model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentClassificationConfig(DocumentClassificationConfig documentClassificationConfig);

        /**
         * <p>
         * Configuration required for a document classification model.
         * </p>
         * This is a convenience method that creates an instance of the {@link DocumentClassificationConfig.Builder}
         * avoiding the need to create one manually via {@link DocumentClassificationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentClassificationConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #documentClassificationConfig(DocumentClassificationConfig)}.
         * 
         * @param documentClassificationConfig
         *        a consumer that will call methods on {@link DocumentClassificationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentClassificationConfig(DocumentClassificationConfig)
         */
        default Builder documentClassificationConfig(Consumer<DocumentClassificationConfig.Builder> documentClassificationConfig) {
            return documentClassificationConfig(DocumentClassificationConfig.builder()
                    .applyMutation(documentClassificationConfig).build());
        }

        /**
         * <p>
         * Configuration required for an entity recognition model.
         * </p>
         * 
         * @param entityRecognitionConfig
         *        Configuration required for an entity recognition model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityRecognitionConfig(EntityRecognitionConfig entityRecognitionConfig);

        /**
         * <p>
         * Configuration required for an entity recognition model.
         * </p>
         * This is a convenience method that creates an instance of the {@link EntityRecognitionConfig.Builder} avoiding
         * the need to create one manually via {@link EntityRecognitionConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EntityRecognitionConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #entityRecognitionConfig(EntityRecognitionConfig)}.
         * 
         * @param entityRecognitionConfig
         *        a consumer that will call methods on {@link EntityRecognitionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entityRecognitionConfig(EntityRecognitionConfig)
         */
        default Builder entityRecognitionConfig(Consumer<EntityRecognitionConfig.Builder> entityRecognitionConfig) {
            return entityRecognitionConfig(EntityRecognitionConfig.builder().applyMutation(entityRecognitionConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String languageCode;

        private DocumentClassificationConfig documentClassificationConfig;

        private EntityRecognitionConfig entityRecognitionConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskConfig model) {
            languageCode(model.languageCode);
            documentClassificationConfig(model.documentClassificationConfig);
            entityRecognitionConfig(model.entityRecognitionConfig);
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final DocumentClassificationConfig.Builder getDocumentClassificationConfig() {
            return documentClassificationConfig != null ? documentClassificationConfig.toBuilder() : null;
        }

        public final void setDocumentClassificationConfig(DocumentClassificationConfig.BuilderImpl documentClassificationConfig) {
            this.documentClassificationConfig = documentClassificationConfig != null ? documentClassificationConfig.build()
                    : null;
        }

        @Override
        public final Builder documentClassificationConfig(DocumentClassificationConfig documentClassificationConfig) {
            this.documentClassificationConfig = documentClassificationConfig;
            return this;
        }

        public final EntityRecognitionConfig.Builder getEntityRecognitionConfig() {
            return entityRecognitionConfig != null ? entityRecognitionConfig.toBuilder() : null;
        }

        public final void setEntityRecognitionConfig(EntityRecognitionConfig.BuilderImpl entityRecognitionConfig) {
            this.entityRecognitionConfig = entityRecognitionConfig != null ? entityRecognitionConfig.build() : null;
        }

        @Override
        public final Builder entityRecognitionConfig(EntityRecognitionConfig entityRecognitionConfig) {
            this.entityRecognitionConfig = entityRecognitionConfig;
            return this;
        }

        @Override
        public TaskConfig build() {
            return new TaskConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
