/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about an entity.
 * </p>
 * <p>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Entity implements SdkPojo, Serializable, ToCopyableBuilder<Entity.Builder, Entity> {
    private static final SdkField<Float> SCORE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("Score")
            .getter(getter(Entity::score)).setter(setter(Builder::score))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Score").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Entity::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Text")
            .getter(getter(Entity::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()).build();

    private static final SdkField<Integer> BEGIN_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BeginOffset").getter(getter(Entity::beginOffset)).setter(setter(Builder::beginOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeginOffset").build()).build();

    private static final SdkField<Integer> END_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EndOffset").getter(getter(Entity::endOffset)).setter(setter(Builder::endOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndOffset").build()).build();

    private static final SdkField<List<BlockReference>> BLOCK_REFERENCES_FIELD = SdkField
            .<List<BlockReference>> builder(MarshallingType.LIST)
            .memberName("BlockReferences")
            .getter(getter(Entity::blockReferences))
            .setter(setter(Builder::blockReferences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockReferences").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BlockReference> builder(MarshallingType.SDK_POJO)
                                            .constructor(BlockReference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCORE_FIELD, TYPE_FIELD,
            TEXT_FIELD, BEGIN_OFFSET_FIELD, END_OFFSET_FIELD, BLOCK_REFERENCES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Float score;

    private final String type;

    private final String text;

    private final Integer beginOffset;

    private final Integer endOffset;

    private final List<BlockReference> blockReferences;

    private Entity(BuilderImpl builder) {
        this.score = builder.score;
        this.type = builder.type;
        this.text = builder.text;
        this.beginOffset = builder.beginOffset;
        this.endOffset = builder.endOffset;
        this.blockReferences = builder.blockReferences;
    }

    /**
     * <p>
     * The level of confidence that Amazon Comprehend has in the accuracy of the detection.
     * </p>
     * 
     * @return The level of confidence that Amazon Comprehend has in the accuracy of the detection.
     */
    public final Float score() {
        return score;
    }

    /**
     * <p>
     * The entity type. For entity detection using the built-in model, this field contains one of the standard entity
     * types listed below.
     * </p>
     * <p>
     * For custom entity detection, this field contains one of the entity types that you specified when you trained your
     * custom model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The entity type. For entity detection using the built-in model, this field contains one of the standard
     *         entity types listed below.</p>
     *         <p>
     *         For custom entity detection, this field contains one of the entity types that you specified when you
     *         trained your custom model.
     * @see EntityType
     */
    public final EntityType type() {
        return EntityType.fromValue(type);
    }

    /**
     * <p>
     * The entity type. For entity detection using the built-in model, this field contains one of the standard entity
     * types listed below.
     * </p>
     * <p>
     * For custom entity detection, this field contains one of the entity types that you specified when you trained your
     * custom model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The entity type. For entity detection using the built-in model, this field contains one of the standard
     *         entity types listed below.</p>
     *         <p>
     *         For custom entity detection, this field contains one of the entity types that you specified when you
     *         trained your custom model.
     * @see EntityType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The text of the entity.
     * </p>
     * 
     * @return The text of the entity.
     */
    public final String text() {
        return text;
    }

    /**
     * <p>
     * The zero-based offset from the beginning of the source text to the first character in the entity.
     * </p>
     * <p>
     * This field is empty for non-text input.
     * </p>
     * 
     * @return The zero-based offset from the beginning of the source text to the first character in the entity.</p>
     *         <p>
     *         This field is empty for non-text input.
     */
    public final Integer beginOffset() {
        return beginOffset;
    }

    /**
     * <p>
     * The zero-based offset from the beginning of the source text to the last character in the entity.
     * </p>
     * <p>
     * This field is empty for non-text input.
     * </p>
     * 
     * @return The zero-based offset from the beginning of the source text to the last character in the entity.</p>
     *         <p>
     *         This field is empty for non-text input.
     */
    public final Integer endOffset() {
        return endOffset;
    }

    /**
     * For responses, this returns true if the service returned a value for the BlockReferences property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBlockReferences() {
        return blockReferences != null && !(blockReferences instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A reference to each block for this entity. This field is empty for plain-text input.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlockReferences} method.
     * </p>
     * 
     * @return A reference to each block for this entity. This field is empty for plain-text input.
     */
    public final List<BlockReference> blockReferences() {
        return blockReferences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(score());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(beginOffset());
        hashCode = 31 * hashCode + Objects.hashCode(endOffset());
        hashCode = 31 * hashCode + Objects.hashCode(hasBlockReferences() ? blockReferences() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Entity)) {
            return false;
        }
        Entity other = (Entity) obj;
        return Objects.equals(score(), other.score()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(text(), other.text()) && Objects.equals(beginOffset(), other.beginOffset())
                && Objects.equals(endOffset(), other.endOffset()) && hasBlockReferences() == other.hasBlockReferences()
                && Objects.equals(blockReferences(), other.blockReferences());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Entity").add("Score", score()).add("Type", typeAsString()).add("Text", text())
                .add("BeginOffset", beginOffset()).add("EndOffset", endOffset())
                .add("BlockReferences", hasBlockReferences() ? blockReferences() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Score":
            return Optional.ofNullable(clazz.cast(score()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Text":
            return Optional.ofNullable(clazz.cast(text()));
        case "BeginOffset":
            return Optional.ofNullable(clazz.cast(beginOffset()));
        case "EndOffset":
            return Optional.ofNullable(clazz.cast(endOffset()));
        case "BlockReferences":
            return Optional.ofNullable(clazz.cast(blockReferences()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Entity, T> g) {
        return obj -> g.apply((Entity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Entity> {
        /**
         * <p>
         * The level of confidence that Amazon Comprehend has in the accuracy of the detection.
         * </p>
         * 
         * @param score
         *        The level of confidence that Amazon Comprehend has in the accuracy of the detection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder score(Float score);

        /**
         * <p>
         * The entity type. For entity detection using the built-in model, this field contains one of the standard
         * entity types listed below.
         * </p>
         * <p>
         * For custom entity detection, this field contains one of the entity types that you specified when you trained
         * your custom model.
         * </p>
         * 
         * @param type
         *        The entity type. For entity detection using the built-in model, this field contains one of the
         *        standard entity types listed below.</p>
         *        <p>
         *        For custom entity detection, this field contains one of the entity types that you specified when you
         *        trained your custom model.
         * @see EntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityType
         */
        Builder type(String type);

        /**
         * <p>
         * The entity type. For entity detection using the built-in model, this field contains one of the standard
         * entity types listed below.
         * </p>
         * <p>
         * For custom entity detection, this field contains one of the entity types that you specified when you trained
         * your custom model.
         * </p>
         * 
         * @param type
         *        The entity type. For entity detection using the built-in model, this field contains one of the
         *        standard entity types listed below.</p>
         *        <p>
         *        For custom entity detection, this field contains one of the entity types that you specified when you
         *        trained your custom model.
         * @see EntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityType
         */
        Builder type(EntityType type);

        /**
         * <p>
         * The text of the entity.
         * </p>
         * 
         * @param text
         *        The text of the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * The zero-based offset from the beginning of the source text to the first character in the entity.
         * </p>
         * <p>
         * This field is empty for non-text input.
         * </p>
         * 
         * @param beginOffset
         *        The zero-based offset from the beginning of the source text to the first character in the entity.</p>
         *        <p>
         *        This field is empty for non-text input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beginOffset(Integer beginOffset);

        /**
         * <p>
         * The zero-based offset from the beginning of the source text to the last character in the entity.
         * </p>
         * <p>
         * This field is empty for non-text input.
         * </p>
         * 
         * @param endOffset
         *        The zero-based offset from the beginning of the source text to the last character in the entity.</p>
         *        <p>
         *        This field is empty for non-text input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endOffset(Integer endOffset);

        /**
         * <p>
         * A reference to each block for this entity. This field is empty for plain-text input.
         * </p>
         * 
         * @param blockReferences
         *        A reference to each block for this entity. This field is empty for plain-text input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockReferences(Collection<BlockReference> blockReferences);

        /**
         * <p>
         * A reference to each block for this entity. This field is empty for plain-text input.
         * </p>
         * 
         * @param blockReferences
         *        A reference to each block for this entity. This field is empty for plain-text input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockReferences(BlockReference... blockReferences);

        /**
         * <p>
         * A reference to each block for this entity. This field is empty for plain-text input.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.comprehend.model.BlockReference.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.comprehend.model.BlockReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.comprehend.model.BlockReference.Builder#build()} is called immediately
         * and its result is passed to {@link #blockReferences(List<BlockReference>)}.
         * 
         * @param blockReferences
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.comprehend.model.BlockReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockReferences(java.util.Collection<BlockReference>)
         */
        Builder blockReferences(Consumer<BlockReference.Builder>... blockReferences);
    }

    static final class BuilderImpl implements Builder {
        private Float score;

        private String type;

        private String text;

        private Integer beginOffset;

        private Integer endOffset;

        private List<BlockReference> blockReferences = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Entity model) {
            score(model.score);
            type(model.type);
            text(model.text);
            beginOffset(model.beginOffset);
            endOffset(model.endOffset);
            blockReferences(model.blockReferences);
        }

        public final Float getScore() {
            return score;
        }

        public final void setScore(Float score) {
            this.score = score;
        }

        @Override
        public final Builder score(Float score) {
            this.score = score;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EntityType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final Integer getBeginOffset() {
            return beginOffset;
        }

        public final void setBeginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
        }

        @Override
        public final Builder beginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
            return this;
        }

        public final Integer getEndOffset() {
            return endOffset;
        }

        public final void setEndOffset(Integer endOffset) {
            this.endOffset = endOffset;
        }

        @Override
        public final Builder endOffset(Integer endOffset) {
            this.endOffset = endOffset;
            return this;
        }

        public final List<BlockReference.Builder> getBlockReferences() {
            List<BlockReference.Builder> result = ListOfBlockReferencesCopier.copyToBuilder(this.blockReferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlockReferences(Collection<BlockReference.BuilderImpl> blockReferences) {
            this.blockReferences = ListOfBlockReferencesCopier.copyFromBuilder(blockReferences);
        }

        @Override
        public final Builder blockReferences(Collection<BlockReference> blockReferences) {
            this.blockReferences = ListOfBlockReferencesCopier.copy(blockReferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockReferences(BlockReference... blockReferences) {
            blockReferences(Arrays.asList(blockReferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockReferences(Consumer<BlockReference.Builder>... blockReferences) {
            blockReferences(Stream.of(blockReferences).map(c -> BlockReference.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Entity build() {
            return new Entity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
