/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEndpointResponse extends ComprehendResponse implements
        ToCopyableBuilder<UpdateEndpointResponse.Builder, UpdateEndpointResponse> {
    private static final SdkField<String> DESIRED_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DesiredModelArn").getter(getter(UpdateEndpointResponse::desiredModelArn))
            .setter(setter(Builder::desiredModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredModelArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESIRED_MODEL_ARN_FIELD));

    private final String desiredModelArn;

    private UpdateEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.desiredModelArn = builder.desiredModelArn;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the new model.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the new model.
     */
    public final String desiredModelArn() {
        return desiredModelArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(desiredModelArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEndpointResponse)) {
            return false;
        }
        UpdateEndpointResponse other = (UpdateEndpointResponse) obj;
        return Objects.equals(desiredModelArn(), other.desiredModelArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateEndpointResponse").add("DesiredModelArn", desiredModelArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DesiredModelArn":
            return Optional.ofNullable(clazz.cast(desiredModelArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEndpointResponse, T> g) {
        return obj -> g.apply((UpdateEndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateEndpointResponse> {
        /**
         * <p>
         * The Amazon Resource Number (ARN) of the new model.
         * </p>
         * 
         * @param desiredModelArn
         *        The Amazon Resource Number (ARN) of the new model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredModelArn(String desiredModelArn);
    }

    static final class BuilderImpl extends ComprehendResponse.BuilderImpl implements Builder {
        private String desiredModelArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEndpointResponse model) {
            super(model);
            desiredModelArn(model.desiredModelArn);
        }

        public final String getDesiredModelArn() {
            return desiredModelArn;
        }

        public final void setDesiredModelArn(String desiredModelArn) {
            this.desiredModelArn = desiredModelArn;
        }

        @Override
        public final Builder desiredModelArn(String desiredModelArn) {
            this.desiredModelArn = desiredModelArn;
            return this;
        }

        @Override
        public UpdateEndpointResponse build() {
            return new UpdateEndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
