/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.ComprehendResponse;
import software.amazon.awssdk.services.comprehend.model.DatasetProperties;
import software.amazon.awssdk.services.comprehend.model.DatasetPropertiesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDatasetsResponse
extends ComprehendResponse
implements ToCopyableBuilder<Builder, ListDatasetsResponse> {
    private static final SdkField<List<DatasetProperties>> DATASET_PROPERTIES_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DatasetPropertiesList").getter(ListDatasetsResponse.getter(ListDatasetsResponse::datasetPropertiesList)).setter(ListDatasetsResponse.setter(Builder::datasetPropertiesList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetPropertiesList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DatasetProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDatasetsResponse.getter(ListDatasetsResponse::nextToken)).setter(ListDatasetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_PROPERTIES_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DatasetPropertiesList", DATASET_PROPERTIES_LIST_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<DatasetProperties> datasetPropertiesList;
    private final String nextToken;

    private ListDatasetsResponse(BuilderImpl builder) {
        super(builder);
        this.datasetPropertiesList = builder.datasetPropertiesList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDatasetPropertiesList() {
        return this.datasetPropertiesList != null && !(this.datasetPropertiesList instanceof SdkAutoConstructList);
    }

    public final List<DatasetProperties> datasetPropertiesList() {
        return this.datasetPropertiesList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatasetPropertiesList() ? this.datasetPropertiesList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDatasetsResponse)) {
            return false;
        }
        ListDatasetsResponse other = (ListDatasetsResponse)((Object)obj);
        return this.hasDatasetPropertiesList() == other.hasDatasetPropertiesList() && Objects.equals(this.datasetPropertiesList(), other.datasetPropertiesList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDatasetsResponse").add("DatasetPropertiesList", this.hasDatasetPropertiesList() ? this.datasetPropertiesList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatasetPropertiesList": {
                return Optional.ofNullable(clazz.cast(this.datasetPropertiesList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListDatasetsResponse, T> g) {
        return obj -> g.apply((ListDatasetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendResponse.BuilderImpl
    implements Builder {
        private List<DatasetProperties> datasetPropertiesList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDatasetsResponse model) {
            super(model);
            this.datasetPropertiesList(model.datasetPropertiesList);
            this.nextToken(model.nextToken);
        }

        public final List<DatasetProperties.Builder> getDatasetPropertiesList() {
            List<DatasetProperties.Builder> result = DatasetPropertiesListCopier.copyToBuilder(this.datasetPropertiesList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDatasetPropertiesList(Collection<DatasetProperties.BuilderImpl> datasetPropertiesList) {
            this.datasetPropertiesList = DatasetPropertiesListCopier.copyFromBuilder(datasetPropertiesList);
        }

        @Override
        public final Builder datasetPropertiesList(Collection<DatasetProperties> datasetPropertiesList) {
            this.datasetPropertiesList = DatasetPropertiesListCopier.copy(datasetPropertiesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetPropertiesList(DatasetProperties ... datasetPropertiesList) {
            this.datasetPropertiesList(Arrays.asList(datasetPropertiesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetPropertiesList(Consumer<DatasetProperties.Builder> ... datasetPropertiesList) {
            this.datasetPropertiesList(Stream.of(datasetPropertiesList).map(c -> (DatasetProperties)((DatasetProperties.Builder)DatasetProperties.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDatasetsResponse build() {
            return new ListDatasetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ComprehendResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDatasetsResponse> {
        public Builder datasetPropertiesList(Collection<DatasetProperties> var1);

        public Builder datasetPropertiesList(DatasetProperties ... var1);

        public Builder datasetPropertiesList(Consumer<DatasetProperties.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

