/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehend.model.MentionSentiment;
import software.amazon.awssdk.services.comprehend.model.TargetedSentimentEntityType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TargetedSentimentMention
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TargetedSentimentMention> {
    private static final SdkField<Float> SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Score").getter(TargetedSentimentMention.getter(TargetedSentimentMention::score)).setter(TargetedSentimentMention.setter(Builder::score)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Score").build()}).build();
    private static final SdkField<Float> GROUP_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("GroupScore").getter(TargetedSentimentMention.getter(TargetedSentimentMention::groupScore)).setter(TargetedSentimentMention.setter(Builder::groupScore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupScore").build()}).build();
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Text").getter(TargetedSentimentMention.getter(TargetedSentimentMention::text)).setter(TargetedSentimentMention.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(TargetedSentimentMention.getter(TargetedSentimentMention::typeAsString)).setter(TargetedSentimentMention.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<MentionSentiment> MENTION_SENTIMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MentionSentiment").getter(TargetedSentimentMention.getter(TargetedSentimentMention::mentionSentiment)).setter(TargetedSentimentMention.setter(Builder::mentionSentiment)).constructor(MentionSentiment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MentionSentiment").build()}).build();
    private static final SdkField<Integer> BEGIN_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BeginOffset").getter(TargetedSentimentMention.getter(TargetedSentimentMention::beginOffset)).setter(TargetedSentimentMention.setter(Builder::beginOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeginOffset").build()}).build();
    private static final SdkField<Integer> END_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EndOffset").getter(TargetedSentimentMention.getter(TargetedSentimentMention::endOffset)).setter(TargetedSentimentMention.setter(Builder::endOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndOffset").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCORE_FIELD, GROUP_SCORE_FIELD, TEXT_FIELD, TYPE_FIELD, MENTION_SENTIMENT_FIELD, BEGIN_OFFSET_FIELD, END_OFFSET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Score", SCORE_FIELD);
            this.put("GroupScore", GROUP_SCORE_FIELD);
            this.put("Text", TEXT_FIELD);
            this.put("Type", TYPE_FIELD);
            this.put("MentionSentiment", MENTION_SENTIMENT_FIELD);
            this.put("BeginOffset", BEGIN_OFFSET_FIELD);
            this.put("EndOffset", END_OFFSET_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Float score;
    private final Float groupScore;
    private final String text;
    private final String type;
    private final MentionSentiment mentionSentiment;
    private final Integer beginOffset;
    private final Integer endOffset;

    private TargetedSentimentMention(BuilderImpl builder) {
        this.score = builder.score;
        this.groupScore = builder.groupScore;
        this.text = builder.text;
        this.type = builder.type;
        this.mentionSentiment = builder.mentionSentiment;
        this.beginOffset = builder.beginOffset;
        this.endOffset = builder.endOffset;
    }

    public final Float score() {
        return this.score;
    }

    public final Float groupScore() {
        return this.groupScore;
    }

    public final String text() {
        return this.text;
    }

    public final TargetedSentimentEntityType type() {
        return TargetedSentimentEntityType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final MentionSentiment mentionSentiment() {
        return this.mentionSentiment;
    }

    public final Integer beginOffset() {
        return this.beginOffset;
    }

    public final Integer endOffset() {
        return this.endOffset;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.score());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupScore());
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mentionSentiment());
        hashCode = 31 * hashCode + Objects.hashCode(this.beginOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.endOffset());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetedSentimentMention)) {
            return false;
        }
        TargetedSentimentMention other = (TargetedSentimentMention)obj;
        return Objects.equals(this.score(), other.score()) && Objects.equals(this.groupScore(), other.groupScore()) && Objects.equals(this.text(), other.text()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.mentionSentiment(), other.mentionSentiment()) && Objects.equals(this.beginOffset(), other.beginOffset()) && Objects.equals(this.endOffset(), other.endOffset());
    }

    public final String toString() {
        return ToString.builder((String)"TargetedSentimentMention").add("Score", (Object)this.score()).add("GroupScore", (Object)this.groupScore()).add("Text", (Object)this.text()).add("Type", (Object)this.typeAsString()).add("MentionSentiment", (Object)this.mentionSentiment()).add("BeginOffset", (Object)this.beginOffset()).add("EndOffset", (Object)this.endOffset()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Score": {
                return Optional.ofNullable(clazz.cast(this.score()));
            }
            case "GroupScore": {
                return Optional.ofNullable(clazz.cast(this.groupScore()));
            }
            case "Text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "MentionSentiment": {
                return Optional.ofNullable(clazz.cast(this.mentionSentiment()));
            }
            case "BeginOffset": {
                return Optional.ofNullable(clazz.cast(this.beginOffset()));
            }
            case "EndOffset": {
                return Optional.ofNullable(clazz.cast(this.endOffset()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TargetedSentimentMention, T> g) {
        return obj -> g.apply((TargetedSentimentMention)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Float score;
        private Float groupScore;
        private String text;
        private String type;
        private MentionSentiment mentionSentiment;
        private Integer beginOffset;
        private Integer endOffset;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetedSentimentMention model) {
            this.score(model.score);
            this.groupScore(model.groupScore);
            this.text(model.text);
            this.type(model.type);
            this.mentionSentiment(model.mentionSentiment);
            this.beginOffset(model.beginOffset);
            this.endOffset(model.endOffset);
        }

        public final Float getScore() {
            return this.score;
        }

        public final void setScore(Float score) {
            this.score = score;
        }

        @Override
        public final Builder score(Float score) {
            this.score = score;
            return this;
        }

        public final Float getGroupScore() {
            return this.groupScore;
        }

        public final void setGroupScore(Float groupScore) {
            this.groupScore = groupScore;
        }

        @Override
        public final Builder groupScore(Float groupScore) {
            this.groupScore = groupScore;
            return this;
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TargetedSentimentEntityType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final MentionSentiment.Builder getMentionSentiment() {
            return this.mentionSentiment != null ? this.mentionSentiment.toBuilder() : null;
        }

        public final void setMentionSentiment(MentionSentiment.BuilderImpl mentionSentiment) {
            this.mentionSentiment = mentionSentiment != null ? mentionSentiment.build() : null;
        }

        @Override
        public final Builder mentionSentiment(MentionSentiment mentionSentiment) {
            this.mentionSentiment = mentionSentiment;
            return this;
        }

        public final Integer getBeginOffset() {
            return this.beginOffset;
        }

        public final void setBeginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
        }

        @Override
        public final Builder beginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
            return this;
        }

        public final Integer getEndOffset() {
            return this.endOffset;
        }

        public final void setEndOffset(Integer endOffset) {
            this.endOffset = endOffset;
        }

        @Override
        public final Builder endOffset(Integer endOffset) {
            this.endOffset = endOffset;
            return this;
        }

        public TargetedSentimentMention build() {
            return new TargetedSentimentMention(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TargetedSentimentMention> {
        public Builder score(Float var1);

        public Builder groupScore(Float var1);

        public Builder text(String var1);

        public Builder type(String var1);

        public Builder type(TargetedSentimentEntityType var1);

        public Builder mentionSentiment(MentionSentiment var1);

        default public Builder mentionSentiment(Consumer<MentionSentiment.Builder> mentionSentiment) {
            return this.mentionSentiment((MentionSentiment)((MentionSentiment.Builder)MentionSentiment.builder().applyMutation(mentionSentiment)).build());
        }

        public Builder beginOffset(Integer var1);

        public Builder endOffset(Integer var1);
    }
}

