/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.DocumentClassifierMode;
import software.amazon.awssdk.services.comprehend.model.LabelsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentClassificationConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DocumentClassificationConfig> {
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mode").getter(DocumentClassificationConfig.getter(DocumentClassificationConfig::modeAsString)).setter(DocumentClassificationConfig.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()}).build();
    private static final SdkField<List<String>> LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Labels").getter(DocumentClassificationConfig.getter(DocumentClassificationConfig::labels)).setter(DocumentClassificationConfig.setter(Builder::labels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Labels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD, LABELS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Mode", MODE_FIELD);
            this.put("Labels", LABELS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String mode;
    private final List<String> labels;

    private DocumentClassificationConfig(BuilderImpl builder) {
        this.mode = builder.mode;
        this.labels = builder.labels;
    }

    public final DocumentClassifierMode mode() {
        return DocumentClassifierMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final boolean hasLabels() {
        return this.labels != null && !(this.labels instanceof SdkAutoConstructList);
    }

    public final List<String> labels() {
        return this.labels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLabels() ? this.labels() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentClassificationConfig)) {
            return false;
        }
        DocumentClassificationConfig other = (DocumentClassificationConfig)obj;
        return Objects.equals(this.modeAsString(), other.modeAsString()) && this.hasLabels() == other.hasLabels() && Objects.equals(this.labels(), other.labels());
    }

    public final String toString() {
        return ToString.builder((String)"DocumentClassificationConfig").add("Mode", (Object)this.modeAsString()).add("Labels", this.hasLabels() ? this.labels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "Labels": {
                return Optional.ofNullable(clazz.cast(this.labels()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DocumentClassificationConfig, T> g) {
        return obj -> g.apply((DocumentClassificationConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mode;
        private List<String> labels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentClassificationConfig model) {
            this.mode(model.mode);
            this.labels(model.labels);
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(DocumentClassifierMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final Collection<String> getLabels() {
            if (this.labels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.labels;
        }

        public final void setLabels(Collection<String> labels) {
            this.labels = LabelsListCopier.copy(labels);
        }

        @Override
        public final Builder labels(Collection<String> labels) {
            this.labels = LabelsListCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(String ... labels) {
            this.labels(Arrays.asList(labels));
            return this;
        }

        public DocumentClassificationConfig build() {
            return new DocumentClassificationConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DocumentClassificationConfig> {
        public Builder mode(String var1);

        public Builder mode(DocumentClassifierMode var1);

        public Builder labels(Collection<String> var1);

        public Builder labels(String ... var1);
    }
}

