/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFlywheelResponse extends ComprehendResponse implements
        ToCopyableBuilder<CreateFlywheelResponse.Builder, CreateFlywheelResponse> {
    private static final SdkField<String> FLYWHEEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlywheelArn").getter(getter(CreateFlywheelResponse::flywheelArn)).setter(setter(Builder::flywheelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlywheelArn").build()).build();

    private static final SdkField<String> ACTIVE_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActiveModelArn").getter(getter(CreateFlywheelResponse::activeModelArn))
            .setter(setter(Builder::activeModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveModelArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLYWHEEL_ARN_FIELD,
            ACTIVE_MODEL_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String flywheelArn;

    private final String activeModelArn;

    private CreateFlywheelResponse(BuilderImpl builder) {
        super(builder);
        this.flywheelArn = builder.flywheelArn;
        this.activeModelArn = builder.activeModelArn;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the flywheel.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the flywheel.
     */
    public final String flywheelArn() {
        return flywheelArn;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the active model version.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the active model version.
     */
    public final String activeModelArn() {
        return activeModelArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(flywheelArn());
        hashCode = 31 * hashCode + Objects.hashCode(activeModelArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFlywheelResponse)) {
            return false;
        }
        CreateFlywheelResponse other = (CreateFlywheelResponse) obj;
        return Objects.equals(flywheelArn(), other.flywheelArn()) && Objects.equals(activeModelArn(), other.activeModelArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFlywheelResponse").add("FlywheelArn", flywheelArn())
                .add("ActiveModelArn", activeModelArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlywheelArn":
            return Optional.ofNullable(clazz.cast(flywheelArn()));
        case "ActiveModelArn":
            return Optional.ofNullable(clazz.cast(activeModelArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FlywheelArn", FLYWHEEL_ARN_FIELD);
        map.put("ActiveModelArn", ACTIVE_MODEL_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateFlywheelResponse, T> g) {
        return obj -> g.apply((CreateFlywheelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateFlywheelResponse> {
        /**
         * <p>
         * The Amazon Resource Number (ARN) of the flywheel.
         * </p>
         * 
         * @param flywheelArn
         *        The Amazon Resource Number (ARN) of the flywheel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flywheelArn(String flywheelArn);

        /**
         * <p>
         * The Amazon Resource Number (ARN) of the active model version.
         * </p>
         * 
         * @param activeModelArn
         *        The Amazon Resource Number (ARN) of the active model version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeModelArn(String activeModelArn);
    }

    static final class BuilderImpl extends ComprehendResponse.BuilderImpl implements Builder {
        private String flywheelArn;

        private String activeModelArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFlywheelResponse model) {
            super(model);
            flywheelArn(model.flywheelArn);
            activeModelArn(model.activeModelArn);
        }

        public final String getFlywheelArn() {
            return flywheelArn;
        }

        public final void setFlywheelArn(String flywheelArn) {
            this.flywheelArn = flywheelArn;
        }

        @Override
        public final Builder flywheelArn(String flywheelArn) {
            this.flywheelArn = flywheelArn;
            return this;
        }

        public final String getActiveModelArn() {
            return activeModelArn;
        }

        public final void setActiveModelArn(String activeModelArn) {
            this.activeModelArn = activeModelArn;
        }

        @Override
        public final Builder activeModelArn(String activeModelArn) {
            this.activeModelArn = activeModelArn;
            return this;
        }

        @Override
        public CreateFlywheelResponse build() {
            return new CreateFlywheelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
