/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Properties associated with the dataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasetProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<DatasetProperties.Builder, DatasetProperties> {
    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetArn").getter(getter(DatasetProperties::datasetArn)).setter(setter(Builder::datasetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArn").build()).build();

    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetName").getter(getter(DatasetProperties::datasetName)).setter(setter(Builder::datasetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetName").build()).build();

    private static final SdkField<String> DATASET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetType").getter(getter(DatasetProperties::datasetTypeAsString))
            .setter(setter(Builder::datasetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetType").build()).build();

    private static final SdkField<String> DATASET_S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetS3Uri").getter(getter(DatasetProperties::datasetS3Uri)).setter(setter(Builder::datasetS3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetS3Uri").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DatasetProperties::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DatasetProperties::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(DatasetProperties::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<Long> NUMBER_OF_DOCUMENTS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("NumberOfDocuments").getter(getter(DatasetProperties::numberOfDocuments))
            .setter(setter(Builder::numberOfDocuments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfDocuments").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DatasetProperties::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(DatasetProperties::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_ARN_FIELD,
            DATASET_NAME_FIELD, DATASET_TYPE_FIELD, DATASET_S3_URI_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, MESSAGE_FIELD,
            NUMBER_OF_DOCUMENTS_FIELD, CREATION_TIME_FIELD, END_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String datasetArn;

    private final String datasetName;

    private final String datasetType;

    private final String datasetS3Uri;

    private final String description;

    private final String status;

    private final String message;

    private final Long numberOfDocuments;

    private final Instant creationTime;

    private final Instant endTime;

    private DatasetProperties(BuilderImpl builder) {
        this.datasetArn = builder.datasetArn;
        this.datasetName = builder.datasetName;
        this.datasetType = builder.datasetType;
        this.datasetS3Uri = builder.datasetS3Uri;
        this.description = builder.description;
        this.status = builder.status;
        this.message = builder.message;
        this.numberOfDocuments = builder.numberOfDocuments;
        this.creationTime = builder.creationTime;
        this.endTime = builder.endTime;
    }

    /**
     * <p>
     * The ARN of the dataset.
     * </p>
     * 
     * @return The ARN of the dataset.
     */
    public final String datasetArn() {
        return datasetArn;
    }

    /**
     * <p>
     * The name of the dataset.
     * </p>
     * 
     * @return The name of the dataset.
     */
    public final String datasetName() {
        return datasetName;
    }

    /**
     * <p>
     * The dataset type (training data or test data).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #datasetType} will
     * return {@link DatasetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #datasetTypeAsString}.
     * </p>
     * 
     * @return The dataset type (training data or test data).
     * @see DatasetType
     */
    public final DatasetType datasetType() {
        return DatasetType.fromValue(datasetType);
    }

    /**
     * <p>
     * The dataset type (training data or test data).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #datasetType} will
     * return {@link DatasetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #datasetTypeAsString}.
     * </p>
     * 
     * @return The dataset type (training data or test data).
     * @see DatasetType
     */
    public final String datasetTypeAsString() {
        return datasetType;
    }

    /**
     * <p>
     * The S3 URI where the dataset is stored.
     * </p>
     * 
     * @return The S3 URI where the dataset is stored.
     */
    public final String datasetS3Uri() {
        return datasetS3Uri;
    }

    /**
     * <p>
     * Description of the dataset.
     * </p>
     * 
     * @return Description of the dataset.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The dataset status. While the system creates the dataset, the status is <code>CREATING</code>. When the dataset
     * is ready to use, the status changes to <code>COMPLETED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DatasetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The dataset status. While the system creates the dataset, the status is <code>CREATING</code>. When the
     *         dataset is ready to use, the status changes to <code>COMPLETED</code>.
     * @see DatasetStatus
     */
    public final DatasetStatus status() {
        return DatasetStatus.fromValue(status);
    }

    /**
     * <p>
     * The dataset status. While the system creates the dataset, the status is <code>CREATING</code>. When the dataset
     * is ready to use, the status changes to <code>COMPLETED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DatasetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The dataset status. While the system creates the dataset, the status is <code>CREATING</code>. When the
     *         dataset is ready to use, the status changes to <code>COMPLETED</code>.
     * @see DatasetStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A description of the status of the dataset.
     * </p>
     * 
     * @return A description of the status of the dataset.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The number of documents in the dataset.
     * </p>
     * 
     * @return The number of documents in the dataset.
     */
    public final Long numberOfDocuments() {
        return numberOfDocuments;
    }

    /**
     * <p>
     * Creation time of the dataset.
     * </p>
     * 
     * @return Creation time of the dataset.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Time when the data from the dataset becomes available in the data lake.
     * </p>
     * 
     * @return Time when the data from the dataset becomes available in the data lake.
     */
    public final Instant endTime() {
        return endTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(datasetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(datasetS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfDocuments());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetProperties)) {
            return false;
        }
        DatasetProperties other = (DatasetProperties) obj;
        return Objects.equals(datasetArn(), other.datasetArn()) && Objects.equals(datasetName(), other.datasetName())
                && Objects.equals(datasetTypeAsString(), other.datasetTypeAsString())
                && Objects.equals(datasetS3Uri(), other.datasetS3Uri()) && Objects.equals(description(), other.description())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(message(), other.message())
                && Objects.equals(numberOfDocuments(), other.numberOfDocuments())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(endTime(), other.endTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatasetProperties").add("DatasetArn", datasetArn()).add("DatasetName", datasetName())
                .add("DatasetType", datasetTypeAsString()).add("DatasetS3Uri", datasetS3Uri()).add("Description", description())
                .add("Status", statusAsString()).add("Message", message()).add("NumberOfDocuments", numberOfDocuments())
                .add("CreationTime", creationTime()).add("EndTime", endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatasetArn":
            return Optional.ofNullable(clazz.cast(datasetArn()));
        case "DatasetName":
            return Optional.ofNullable(clazz.cast(datasetName()));
        case "DatasetType":
            return Optional.ofNullable(clazz.cast(datasetTypeAsString()));
        case "DatasetS3Uri":
            return Optional.ofNullable(clazz.cast(datasetS3Uri()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "NumberOfDocuments":
            return Optional.ofNullable(clazz.cast(numberOfDocuments()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DatasetArn", DATASET_ARN_FIELD);
        map.put("DatasetName", DATASET_NAME_FIELD);
        map.put("DatasetType", DATASET_TYPE_FIELD);
        map.put("DatasetS3Uri", DATASET_S3_URI_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("NumberOfDocuments", NUMBER_OF_DOCUMENTS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DatasetProperties, T> g) {
        return obj -> g.apply((DatasetProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasetProperties> {
        /**
         * <p>
         * The ARN of the dataset.
         * </p>
         * 
         * @param datasetArn
         *        The ARN of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetArn(String datasetArn);

        /**
         * <p>
         * The name of the dataset.
         * </p>
         * 
         * @param datasetName
         *        The name of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetName(String datasetName);

        /**
         * <p>
         * The dataset type (training data or test data).
         * </p>
         * 
         * @param datasetType
         *        The dataset type (training data or test data).
         * @see DatasetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetType
         */
        Builder datasetType(String datasetType);

        /**
         * <p>
         * The dataset type (training data or test data).
         * </p>
         * 
         * @param datasetType
         *        The dataset type (training data or test data).
         * @see DatasetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetType
         */
        Builder datasetType(DatasetType datasetType);

        /**
         * <p>
         * The S3 URI where the dataset is stored.
         * </p>
         * 
         * @param datasetS3Uri
         *        The S3 URI where the dataset is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetS3Uri(String datasetS3Uri);

        /**
         * <p>
         * Description of the dataset.
         * </p>
         * 
         * @param description
         *        Description of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The dataset status. While the system creates the dataset, the status is <code>CREATING</code>. When the
         * dataset is ready to use, the status changes to <code>COMPLETED</code>.
         * </p>
         * 
         * @param status
         *        The dataset status. While the system creates the dataset, the status is <code>CREATING</code>. When
         *        the dataset is ready to use, the status changes to <code>COMPLETED</code>.
         * @see DatasetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The dataset status. While the system creates the dataset, the status is <code>CREATING</code>. When the
         * dataset is ready to use, the status changes to <code>COMPLETED</code>.
         * </p>
         * 
         * @param status
         *        The dataset status. While the system creates the dataset, the status is <code>CREATING</code>. When
         *        the dataset is ready to use, the status changes to <code>COMPLETED</code>.
         * @see DatasetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetStatus
         */
        Builder status(DatasetStatus status);

        /**
         * <p>
         * A description of the status of the dataset.
         * </p>
         * 
         * @param message
         *        A description of the status of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The number of documents in the dataset.
         * </p>
         * 
         * @param numberOfDocuments
         *        The number of documents in the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfDocuments(Long numberOfDocuments);

        /**
         * <p>
         * Creation time of the dataset.
         * </p>
         * 
         * @param creationTime
         *        Creation time of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Time when the data from the dataset becomes available in the data lake.
         * </p>
         * 
         * @param endTime
         *        Time when the data from the dataset becomes available in the data lake.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);
    }

    static final class BuilderImpl implements Builder {
        private String datasetArn;

        private String datasetName;

        private String datasetType;

        private String datasetS3Uri;

        private String description;

        private String status;

        private String message;

        private Long numberOfDocuments;

        private Instant creationTime;

        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetProperties model) {
            datasetArn(model.datasetArn);
            datasetName(model.datasetName);
            datasetType(model.datasetType);
            datasetS3Uri(model.datasetS3Uri);
            description(model.description);
            status(model.status);
            message(model.message);
            numberOfDocuments(model.numberOfDocuments);
            creationTime(model.creationTime);
            endTime(model.endTime);
        }

        public final String getDatasetArn() {
            return datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final String getDatasetName() {
            return datasetName;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final String getDatasetType() {
            return datasetType;
        }

        public final void setDatasetType(String datasetType) {
            this.datasetType = datasetType;
        }

        @Override
        public final Builder datasetType(String datasetType) {
            this.datasetType = datasetType;
            return this;
        }

        @Override
        public final Builder datasetType(DatasetType datasetType) {
            this.datasetType(datasetType == null ? null : datasetType.toString());
            return this;
        }

        public final String getDatasetS3Uri() {
            return datasetS3Uri;
        }

        public final void setDatasetS3Uri(String datasetS3Uri) {
            this.datasetS3Uri = datasetS3Uri;
        }

        @Override
        public final Builder datasetS3Uri(String datasetS3Uri) {
            this.datasetS3Uri = datasetS3Uri;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DatasetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Long getNumberOfDocuments() {
            return numberOfDocuments;
        }

        public final void setNumberOfDocuments(Long numberOfDocuments) {
            this.numberOfDocuments = numberOfDocuments;
        }

        @Override
        public final Builder numberOfDocuments(Long numberOfDocuments) {
            this.numberOfDocuments = numberOfDocuments;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        @Override
        public DatasetProperties build() {
            return new DatasetProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
