/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes information about a document classifier and its versions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentClassifierSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentClassifierSummary.Builder, DocumentClassifierSummary> {
    private static final SdkField<String> DOCUMENT_CLASSIFIER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentClassifierName").getter(getter(DocumentClassifierSummary::documentClassifierName))
            .setter(setter(Builder::documentClassifierName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentClassifierName").build())
            .build();

    private static final SdkField<Integer> NUMBER_OF_VERSIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfVersions").getter(getter(DocumentClassifierSummary::numberOfVersions))
            .setter(setter(Builder::numberOfVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfVersions").build()).build();

    private static final SdkField<Instant> LATEST_VERSION_CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LatestVersionCreatedAt").getter(getter(DocumentClassifierSummary::latestVersionCreatedAt))
            .setter(setter(Builder::latestVersionCreatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestVersionCreatedAt").build())
            .build();

    private static final SdkField<String> LATEST_VERSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LatestVersionName").getter(getter(DocumentClassifierSummary::latestVersionName))
            .setter(setter(Builder::latestVersionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestVersionName").build()).build();

    private static final SdkField<String> LATEST_VERSION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LatestVersionStatus").getter(getter(DocumentClassifierSummary::latestVersionStatusAsString))
            .setter(setter(Builder::latestVersionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestVersionStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DOCUMENT_CLASSIFIER_NAME_FIELD, NUMBER_OF_VERSIONS_FIELD, LATEST_VERSION_CREATED_AT_FIELD, LATEST_VERSION_NAME_FIELD,
            LATEST_VERSION_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String documentClassifierName;

    private final Integer numberOfVersions;

    private final Instant latestVersionCreatedAt;

    private final String latestVersionName;

    private final String latestVersionStatus;

    private DocumentClassifierSummary(BuilderImpl builder) {
        this.documentClassifierName = builder.documentClassifierName;
        this.numberOfVersions = builder.numberOfVersions;
        this.latestVersionCreatedAt = builder.latestVersionCreatedAt;
        this.latestVersionName = builder.latestVersionName;
        this.latestVersionStatus = builder.latestVersionStatus;
    }

    /**
     * <p>
     * The name that you assigned the document classifier.
     * </p>
     * 
     * @return The name that you assigned the document classifier.
     */
    public final String documentClassifierName() {
        return documentClassifierName;
    }

    /**
     * <p>
     * The number of versions you created.
     * </p>
     * 
     * @return The number of versions you created.
     */
    public final Integer numberOfVersions() {
        return numberOfVersions;
    }

    /**
     * <p>
     * The time that the latest document classifier version was submitted for processing.
     * </p>
     * 
     * @return The time that the latest document classifier version was submitted for processing.
     */
    public final Instant latestVersionCreatedAt() {
        return latestVersionCreatedAt;
    }

    /**
     * <p>
     * The version name you assigned to the latest document classifier version.
     * </p>
     * 
     * @return The version name you assigned to the latest document classifier version.
     */
    public final String latestVersionName() {
        return latestVersionName;
    }

    /**
     * <p>
     * Provides the status of the latest document classifier version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #latestVersionStatus} will return {@link ModelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #latestVersionStatusAsString}.
     * </p>
     * 
     * @return Provides the status of the latest document classifier version.
     * @see ModelStatus
     */
    public final ModelStatus latestVersionStatus() {
        return ModelStatus.fromValue(latestVersionStatus);
    }

    /**
     * <p>
     * Provides the status of the latest document classifier version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #latestVersionStatus} will return {@link ModelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #latestVersionStatusAsString}.
     * </p>
     * 
     * @return Provides the status of the latest document classifier version.
     * @see ModelStatus
     */
    public final String latestVersionStatusAsString() {
        return latestVersionStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(documentClassifierName());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfVersions());
        hashCode = 31 * hashCode + Objects.hashCode(latestVersionCreatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(latestVersionName());
        hashCode = 31 * hashCode + Objects.hashCode(latestVersionStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentClassifierSummary)) {
            return false;
        }
        DocumentClassifierSummary other = (DocumentClassifierSummary) obj;
        return Objects.equals(documentClassifierName(), other.documentClassifierName())
                && Objects.equals(numberOfVersions(), other.numberOfVersions())
                && Objects.equals(latestVersionCreatedAt(), other.latestVersionCreatedAt())
                && Objects.equals(latestVersionName(), other.latestVersionName())
                && Objects.equals(latestVersionStatusAsString(), other.latestVersionStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentClassifierSummary").add("DocumentClassifierName", documentClassifierName())
                .add("NumberOfVersions", numberOfVersions()).add("LatestVersionCreatedAt", latestVersionCreatedAt())
                .add("LatestVersionName", latestVersionName()).add("LatestVersionStatus", latestVersionStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DocumentClassifierName":
            return Optional.ofNullable(clazz.cast(documentClassifierName()));
        case "NumberOfVersions":
            return Optional.ofNullable(clazz.cast(numberOfVersions()));
        case "LatestVersionCreatedAt":
            return Optional.ofNullable(clazz.cast(latestVersionCreatedAt()));
        case "LatestVersionName":
            return Optional.ofNullable(clazz.cast(latestVersionName()));
        case "LatestVersionStatus":
            return Optional.ofNullable(clazz.cast(latestVersionStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DocumentClassifierName", DOCUMENT_CLASSIFIER_NAME_FIELD);
        map.put("NumberOfVersions", NUMBER_OF_VERSIONS_FIELD);
        map.put("LatestVersionCreatedAt", LATEST_VERSION_CREATED_AT_FIELD);
        map.put("LatestVersionName", LATEST_VERSION_NAME_FIELD);
        map.put("LatestVersionStatus", LATEST_VERSION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DocumentClassifierSummary, T> g) {
        return obj -> g.apply((DocumentClassifierSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentClassifierSummary> {
        /**
         * <p>
         * The name that you assigned the document classifier.
         * </p>
         * 
         * @param documentClassifierName
         *        The name that you assigned the document classifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentClassifierName(String documentClassifierName);

        /**
         * <p>
         * The number of versions you created.
         * </p>
         * 
         * @param numberOfVersions
         *        The number of versions you created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfVersions(Integer numberOfVersions);

        /**
         * <p>
         * The time that the latest document classifier version was submitted for processing.
         * </p>
         * 
         * @param latestVersionCreatedAt
         *        The time that the latest document classifier version was submitted for processing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestVersionCreatedAt(Instant latestVersionCreatedAt);

        /**
         * <p>
         * The version name you assigned to the latest document classifier version.
         * </p>
         * 
         * @param latestVersionName
         *        The version name you assigned to the latest document classifier version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestVersionName(String latestVersionName);

        /**
         * <p>
         * Provides the status of the latest document classifier version.
         * </p>
         * 
         * @param latestVersionStatus
         *        Provides the status of the latest document classifier version.
         * @see ModelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelStatus
         */
        Builder latestVersionStatus(String latestVersionStatus);

        /**
         * <p>
         * Provides the status of the latest document classifier version.
         * </p>
         * 
         * @param latestVersionStatus
         *        Provides the status of the latest document classifier version.
         * @see ModelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelStatus
         */
        Builder latestVersionStatus(ModelStatus latestVersionStatus);
    }

    static final class BuilderImpl implements Builder {
        private String documentClassifierName;

        private Integer numberOfVersions;

        private Instant latestVersionCreatedAt;

        private String latestVersionName;

        private String latestVersionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentClassifierSummary model) {
            documentClassifierName(model.documentClassifierName);
            numberOfVersions(model.numberOfVersions);
            latestVersionCreatedAt(model.latestVersionCreatedAt);
            latestVersionName(model.latestVersionName);
            latestVersionStatus(model.latestVersionStatus);
        }

        public final String getDocumentClassifierName() {
            return documentClassifierName;
        }

        public final void setDocumentClassifierName(String documentClassifierName) {
            this.documentClassifierName = documentClassifierName;
        }

        @Override
        public final Builder documentClassifierName(String documentClassifierName) {
            this.documentClassifierName = documentClassifierName;
            return this;
        }

        public final Integer getNumberOfVersions() {
            return numberOfVersions;
        }

        public final void setNumberOfVersions(Integer numberOfVersions) {
            this.numberOfVersions = numberOfVersions;
        }

        @Override
        public final Builder numberOfVersions(Integer numberOfVersions) {
            this.numberOfVersions = numberOfVersions;
            return this;
        }

        public final Instant getLatestVersionCreatedAt() {
            return latestVersionCreatedAt;
        }

        public final void setLatestVersionCreatedAt(Instant latestVersionCreatedAt) {
            this.latestVersionCreatedAt = latestVersionCreatedAt;
        }

        @Override
        public final Builder latestVersionCreatedAt(Instant latestVersionCreatedAt) {
            this.latestVersionCreatedAt = latestVersionCreatedAt;
            return this;
        }

        public final String getLatestVersionName() {
            return latestVersionName;
        }

        public final void setLatestVersionName(String latestVersionName) {
            this.latestVersionName = latestVersionName;
        }

        @Override
        public final Builder latestVersionName(String latestVersionName) {
            this.latestVersionName = latestVersionName;
            return this;
        }

        public final String getLatestVersionStatus() {
            return latestVersionStatus;
        }

        public final void setLatestVersionStatus(String latestVersionStatus) {
            this.latestVersionStatus = latestVersionStatus;
        }

        @Override
        public final Builder latestVersionStatus(String latestVersionStatus) {
            this.latestVersionStatus = latestVersionStatus;
            return this;
        }

        @Override
        public final Builder latestVersionStatus(ModelStatus latestVersionStatus) {
            this.latestVersionStatus(latestVersionStatus == null ? null : latestVersionStatus.toString());
            return this;
        }

        @Override
        public DocumentClassifierSummary build() {
            return new DocumentClassifierSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
