/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListKeyPhrasesDetectionJobsResponse extends ComprehendResponse implements
        ToCopyableBuilder<ListKeyPhrasesDetectionJobsResponse.Builder, ListKeyPhrasesDetectionJobsResponse> {
    private static final SdkField<List<KeyPhrasesDetectionJobProperties>> KEY_PHRASES_DETECTION_JOB_PROPERTIES_LIST_FIELD = SdkField
            .<List<KeyPhrasesDetectionJobProperties>> builder(MarshallingType.LIST)
            .memberName("KeyPhrasesDetectionJobPropertiesList")
            .getter(getter(ListKeyPhrasesDetectionJobsResponse::keyPhrasesDetectionJobPropertiesList))
            .setter(setter(Builder::keyPhrasesDetectionJobPropertiesList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("KeyPhrasesDetectionJobPropertiesList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KeyPhrasesDetectionJobProperties> builder(MarshallingType.SDK_POJO)
                                            .constructor(KeyPhrasesDetectionJobProperties::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListKeyPhrasesDetectionJobsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            KEY_PHRASES_DETECTION_JOB_PROPERTIES_LIST_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<KeyPhrasesDetectionJobProperties> keyPhrasesDetectionJobPropertiesList;

    private final String nextToken;

    private ListKeyPhrasesDetectionJobsResponse(BuilderImpl builder) {
        super(builder);
        this.keyPhrasesDetectionJobPropertiesList = builder.keyPhrasesDetectionJobPropertiesList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the KeyPhrasesDetectionJobPropertiesList
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasKeyPhrasesDetectionJobPropertiesList() {
        return keyPhrasesDetectionJobPropertiesList != null
                && !(keyPhrasesDetectionJobPropertiesList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list containing the properties of each job that is returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKeyPhrasesDetectionJobPropertiesList}
     * method.
     * </p>
     * 
     * @return A list containing the properties of each job that is returned.
     */
    public final List<KeyPhrasesDetectionJobProperties> keyPhrasesDetectionJobPropertiesList() {
        return keyPhrasesDetectionJobPropertiesList;
    }

    /**
     * <p>
     * Identifies the next page of results to return.
     * </p>
     * 
     * @return Identifies the next page of results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasKeyPhrasesDetectionJobPropertiesList() ? keyPhrasesDetectionJobPropertiesList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListKeyPhrasesDetectionJobsResponse)) {
            return false;
        }
        ListKeyPhrasesDetectionJobsResponse other = (ListKeyPhrasesDetectionJobsResponse) obj;
        return hasKeyPhrasesDetectionJobPropertiesList() == other.hasKeyPhrasesDetectionJobPropertiesList()
                && Objects.equals(keyPhrasesDetectionJobPropertiesList(), other.keyPhrasesDetectionJobPropertiesList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListKeyPhrasesDetectionJobsResponse")
                .add("KeyPhrasesDetectionJobPropertiesList",
                        hasKeyPhrasesDetectionJobPropertiesList() ? keyPhrasesDetectionJobPropertiesList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyPhrasesDetectionJobPropertiesList":
            return Optional.ofNullable(clazz.cast(keyPhrasesDetectionJobPropertiesList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("KeyPhrasesDetectionJobPropertiesList", KEY_PHRASES_DETECTION_JOB_PROPERTIES_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListKeyPhrasesDetectionJobsResponse, T> g) {
        return obj -> g.apply((ListKeyPhrasesDetectionJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListKeyPhrasesDetectionJobsResponse> {
        /**
         * <p>
         * A list containing the properties of each job that is returned.
         * </p>
         * 
         * @param keyPhrasesDetectionJobPropertiesList
         *        A list containing the properties of each job that is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPhrasesDetectionJobPropertiesList(
                Collection<KeyPhrasesDetectionJobProperties> keyPhrasesDetectionJobPropertiesList);

        /**
         * <p>
         * A list containing the properties of each job that is returned.
         * </p>
         * 
         * @param keyPhrasesDetectionJobPropertiesList
         *        A list containing the properties of each job that is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPhrasesDetectionJobPropertiesList(KeyPhrasesDetectionJobProperties... keyPhrasesDetectionJobPropertiesList);

        /**
         * <p>
         * A list containing the properties of each job that is returned.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.comprehend.model.KeyPhrasesDetectionJobProperties.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.comprehend.model.KeyPhrasesDetectionJobProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.comprehend.model.KeyPhrasesDetectionJobProperties.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #keyPhrasesDetectionJobPropertiesList(List<KeyPhrasesDetectionJobProperties>)}.
         * 
         * @param keyPhrasesDetectionJobPropertiesList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.comprehend.model.KeyPhrasesDetectionJobProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyPhrasesDetectionJobPropertiesList(java.util.Collection<KeyPhrasesDetectionJobProperties>)
         */
        Builder keyPhrasesDetectionJobPropertiesList(
                Consumer<KeyPhrasesDetectionJobProperties.Builder>... keyPhrasesDetectionJobPropertiesList);

        /**
         * <p>
         * Identifies the next page of results to return.
         * </p>
         * 
         * @param nextToken
         *        Identifies the next page of results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ComprehendResponse.BuilderImpl implements Builder {
        private List<KeyPhrasesDetectionJobProperties> keyPhrasesDetectionJobPropertiesList = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListKeyPhrasesDetectionJobsResponse model) {
            super(model);
            keyPhrasesDetectionJobPropertiesList(model.keyPhrasesDetectionJobPropertiesList);
            nextToken(model.nextToken);
        }

        public final List<KeyPhrasesDetectionJobProperties.Builder> getKeyPhrasesDetectionJobPropertiesList() {
            List<KeyPhrasesDetectionJobProperties.Builder> result = KeyPhrasesDetectionJobPropertiesListCopier
                    .copyToBuilder(this.keyPhrasesDetectionJobPropertiesList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKeyPhrasesDetectionJobPropertiesList(
                Collection<KeyPhrasesDetectionJobProperties.BuilderImpl> keyPhrasesDetectionJobPropertiesList) {
            this.keyPhrasesDetectionJobPropertiesList = KeyPhrasesDetectionJobPropertiesListCopier
                    .copyFromBuilder(keyPhrasesDetectionJobPropertiesList);
        }

        @Override
        public final Builder keyPhrasesDetectionJobPropertiesList(
                Collection<KeyPhrasesDetectionJobProperties> keyPhrasesDetectionJobPropertiesList) {
            this.keyPhrasesDetectionJobPropertiesList = KeyPhrasesDetectionJobPropertiesListCopier
                    .copy(keyPhrasesDetectionJobPropertiesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyPhrasesDetectionJobPropertiesList(
                KeyPhrasesDetectionJobProperties... keyPhrasesDetectionJobPropertiesList) {
            keyPhrasesDetectionJobPropertiesList(Arrays.asList(keyPhrasesDetectionJobPropertiesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyPhrasesDetectionJobPropertiesList(
                Consumer<KeyPhrasesDetectionJobProperties.Builder>... keyPhrasesDetectionJobPropertiesList) {
            keyPhrasesDetectionJobPropertiesList(Stream.of(keyPhrasesDetectionJobPropertiesList)
                    .map(c -> KeyPhrasesDetectionJobProperties.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListKeyPhrasesDetectionJobsResponse build() {
            return new ListKeyPhrasesDetectionJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
