/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTopicsDetectionJobsResponse extends ComprehendResponse implements
        ToCopyableBuilder<ListTopicsDetectionJobsResponse.Builder, ListTopicsDetectionJobsResponse> {
    private static final SdkField<List<TopicsDetectionJobProperties>> TOPICS_DETECTION_JOB_PROPERTIES_LIST_FIELD = SdkField
            .<List<TopicsDetectionJobProperties>> builder(MarshallingType.LIST)
            .memberName("TopicsDetectionJobPropertiesList")
            .getter(getter(ListTopicsDetectionJobsResponse::topicsDetectionJobPropertiesList))
            .setter(setter(Builder::topicsDetectionJobPropertiesList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicsDetectionJobPropertiesList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TopicsDetectionJobProperties> builder(MarshallingType.SDK_POJO)
                                            .constructor(TopicsDetectionJobProperties::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListTopicsDetectionJobsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TOPICS_DETECTION_JOB_PROPERTIES_LIST_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<TopicsDetectionJobProperties> topicsDetectionJobPropertiesList;

    private final String nextToken;

    private ListTopicsDetectionJobsResponse(BuilderImpl builder) {
        super(builder);
        this.topicsDetectionJobPropertiesList = builder.topicsDetectionJobPropertiesList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TopicsDetectionJobPropertiesList
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasTopicsDetectionJobPropertiesList() {
        return topicsDetectionJobPropertiesList != null && !(topicsDetectionJobPropertiesList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list containing the properties of each job that is returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTopicsDetectionJobPropertiesList}
     * method.
     * </p>
     * 
     * @return A list containing the properties of each job that is returned.
     */
    public final List<TopicsDetectionJobProperties> topicsDetectionJobPropertiesList() {
        return topicsDetectionJobPropertiesList;
    }

    /**
     * <p>
     * Identifies the next page of results to return.
     * </p>
     * 
     * @return Identifies the next page of results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasTopicsDetectionJobPropertiesList() ? topicsDetectionJobPropertiesList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTopicsDetectionJobsResponse)) {
            return false;
        }
        ListTopicsDetectionJobsResponse other = (ListTopicsDetectionJobsResponse) obj;
        return hasTopicsDetectionJobPropertiesList() == other.hasTopicsDetectionJobPropertiesList()
                && Objects.equals(topicsDetectionJobPropertiesList(), other.topicsDetectionJobPropertiesList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListTopicsDetectionJobsResponse")
                .add("TopicsDetectionJobPropertiesList",
                        hasTopicsDetectionJobPropertiesList() ? topicsDetectionJobPropertiesList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TopicsDetectionJobPropertiesList":
            return Optional.ofNullable(clazz.cast(topicsDetectionJobPropertiesList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TopicsDetectionJobPropertiesList", TOPICS_DETECTION_JOB_PROPERTIES_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTopicsDetectionJobsResponse, T> g) {
        return obj -> g.apply((ListTopicsDetectionJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListTopicsDetectionJobsResponse> {
        /**
         * <p>
         * A list containing the properties of each job that is returned.
         * </p>
         * 
         * @param topicsDetectionJobPropertiesList
         *        A list containing the properties of each job that is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicsDetectionJobPropertiesList(Collection<TopicsDetectionJobProperties> topicsDetectionJobPropertiesList);

        /**
         * <p>
         * A list containing the properties of each job that is returned.
         * </p>
         * 
         * @param topicsDetectionJobPropertiesList
         *        A list containing the properties of each job that is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicsDetectionJobPropertiesList(TopicsDetectionJobProperties... topicsDetectionJobPropertiesList);

        /**
         * <p>
         * A list containing the properties of each job that is returned.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.comprehend.model.TopicsDetectionJobProperties.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.comprehend.model.TopicsDetectionJobProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.comprehend.model.TopicsDetectionJobProperties.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #topicsDetectionJobPropertiesList(List<TopicsDetectionJobProperties>)}.
         * 
         * @param topicsDetectionJobPropertiesList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.comprehend.model.TopicsDetectionJobProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #topicsDetectionJobPropertiesList(java.util.Collection<TopicsDetectionJobProperties>)
         */
        Builder topicsDetectionJobPropertiesList(
                Consumer<TopicsDetectionJobProperties.Builder>... topicsDetectionJobPropertiesList);

        /**
         * <p>
         * Identifies the next page of results to return.
         * </p>
         * 
         * @param nextToken
         *        Identifies the next page of results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ComprehendResponse.BuilderImpl implements Builder {
        private List<TopicsDetectionJobProperties> topicsDetectionJobPropertiesList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTopicsDetectionJobsResponse model) {
            super(model);
            topicsDetectionJobPropertiesList(model.topicsDetectionJobPropertiesList);
            nextToken(model.nextToken);
        }

        public final List<TopicsDetectionJobProperties.Builder> getTopicsDetectionJobPropertiesList() {
            List<TopicsDetectionJobProperties.Builder> result = TopicsDetectionJobPropertiesListCopier
                    .copyToBuilder(this.topicsDetectionJobPropertiesList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTopicsDetectionJobPropertiesList(
                Collection<TopicsDetectionJobProperties.BuilderImpl> topicsDetectionJobPropertiesList) {
            this.topicsDetectionJobPropertiesList = TopicsDetectionJobPropertiesListCopier
                    .copyFromBuilder(topicsDetectionJobPropertiesList);
        }

        @Override
        public final Builder topicsDetectionJobPropertiesList(
                Collection<TopicsDetectionJobProperties> topicsDetectionJobPropertiesList) {
            this.topicsDetectionJobPropertiesList = TopicsDetectionJobPropertiesListCopier.copy(topicsDetectionJobPropertiesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicsDetectionJobPropertiesList(TopicsDetectionJobProperties... topicsDetectionJobPropertiesList) {
            topicsDetectionJobPropertiesList(Arrays.asList(topicsDetectionJobPropertiesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicsDetectionJobPropertiesList(
                Consumer<TopicsDetectionJobProperties.Builder>... topicsDetectionJobPropertiesList) {
            topicsDetectionJobPropertiesList(Stream.of(topicsDetectionJobPropertiesList)
                    .map(c -> TopicsDetectionJobProperties.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTopicsDetectionJobsResponse build() {
            return new ListTopicsDetectionJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
