/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFlywheelRequest extends ComprehendRequest implements
        ToCopyableBuilder<DescribeFlywheelRequest.Builder, DescribeFlywheelRequest> {
    private static final SdkField<String> FLYWHEEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlywheelArn").getter(getter(DescribeFlywheelRequest::flywheelArn)).setter(setter(Builder::flywheelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlywheelArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLYWHEEL_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String flywheelArn;

    private DescribeFlywheelRequest(BuilderImpl builder) {
        super(builder);
        this.flywheelArn = builder.flywheelArn;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the flywheel.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the flywheel.
     */
    public final String flywheelArn() {
        return flywheelArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(flywheelArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFlywheelRequest)) {
            return false;
        }
        DescribeFlywheelRequest other = (DescribeFlywheelRequest) obj;
        return Objects.equals(flywheelArn(), other.flywheelArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeFlywheelRequest").add("FlywheelArn", flywheelArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlywheelArn":
            return Optional.ofNullable(clazz.cast(flywheelArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FlywheelArn", FLYWHEEL_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeFlywheelRequest, T> g) {
        return obj -> g.apply((DescribeFlywheelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeFlywheelRequest> {
        /**
         * <p>
         * The Amazon Resource Number (ARN) of the flywheel.
         * </p>
         * 
         * @param flywheelArn
         *        The Amazon Resource Number (ARN) of the flywheel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flywheelArn(String flywheelArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ComprehendRequest.BuilderImpl implements Builder {
        private String flywheelArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFlywheelRequest model) {
            super(model);
            flywheelArn(model.flywheelArn);
        }

        public final String getFlywheelArn() {
            return flywheelArn;
        }

        public final void setFlywheelArn(String flywheelArn) {
            this.flywheelArn = flywheelArn;
        }

        @Override
        public final Builder flywheelArn(String flywheelArn) {
            this.flywheelArn = flywheelArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeFlywheelRequest build() {
            return new DescribeFlywheelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
