/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectSentimentResponse extends ComprehendResponse implements
        ToCopyableBuilder<DetectSentimentResponse.Builder, DetectSentimentResponse> {
    private static final SdkField<String> SENTIMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Sentiment").getter(getter(DetectSentimentResponse::sentimentAsString))
            .setter(setter(Builder::sentiment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sentiment").build()).build();

    private static final SdkField<SentimentScore> SENTIMENT_SCORE_FIELD = SdkField
            .<SentimentScore> builder(MarshallingType.SDK_POJO).memberName("SentimentScore")
            .getter(getter(DetectSentimentResponse::sentimentScore)).setter(setter(Builder::sentimentScore))
            .constructor(SentimentScore::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SentimentScore").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SENTIMENT_FIELD,
            SENTIMENT_SCORE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String sentiment;

    private final SentimentScore sentimentScore;

    private DetectSentimentResponse(BuilderImpl builder) {
        super(builder);
        this.sentiment = builder.sentiment;
        this.sentimentScore = builder.sentimentScore;
    }

    /**
     * <p>
     * The inferred sentiment that Amazon Comprehend has the highest level of confidence in.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sentiment} will
     * return {@link SentimentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sentimentAsString}.
     * </p>
     * 
     * @return The inferred sentiment that Amazon Comprehend has the highest level of confidence in.
     * @see SentimentType
     */
    public final SentimentType sentiment() {
        return SentimentType.fromValue(sentiment);
    }

    /**
     * <p>
     * The inferred sentiment that Amazon Comprehend has the highest level of confidence in.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sentiment} will
     * return {@link SentimentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sentimentAsString}.
     * </p>
     * 
     * @return The inferred sentiment that Amazon Comprehend has the highest level of confidence in.
     * @see SentimentType
     */
    public final String sentimentAsString() {
        return sentiment;
    }

    /**
     * <p>
     * An object that lists the sentiments, and their corresponding confidence levels.
     * </p>
     * 
     * @return An object that lists the sentiments, and their corresponding confidence levels.
     */
    public final SentimentScore sentimentScore() {
        return sentimentScore;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sentimentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sentimentScore());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectSentimentResponse)) {
            return false;
        }
        DetectSentimentResponse other = (DetectSentimentResponse) obj;
        return Objects.equals(sentimentAsString(), other.sentimentAsString())
                && Objects.equals(sentimentScore(), other.sentimentScore());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectSentimentResponse").add("Sentiment", sentimentAsString())
                .add("SentimentScore", sentimentScore()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Sentiment":
            return Optional.ofNullable(clazz.cast(sentimentAsString()));
        case "SentimentScore":
            return Optional.ofNullable(clazz.cast(sentimentScore()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Sentiment", SENTIMENT_FIELD);
        map.put("SentimentScore", SENTIMENT_SCORE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DetectSentimentResponse, T> g) {
        return obj -> g.apply((DetectSentimentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendResponse.Builder, SdkPojo, CopyableBuilder<Builder, DetectSentimentResponse> {
        /**
         * <p>
         * The inferred sentiment that Amazon Comprehend has the highest level of confidence in.
         * </p>
         * 
         * @param sentiment
         *        The inferred sentiment that Amazon Comprehend has the highest level of confidence in.
         * @see SentimentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SentimentType
         */
        Builder sentiment(String sentiment);

        /**
         * <p>
         * The inferred sentiment that Amazon Comprehend has the highest level of confidence in.
         * </p>
         * 
         * @param sentiment
         *        The inferred sentiment that Amazon Comprehend has the highest level of confidence in.
         * @see SentimentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SentimentType
         */
        Builder sentiment(SentimentType sentiment);

        /**
         * <p>
         * An object that lists the sentiments, and their corresponding confidence levels.
         * </p>
         * 
         * @param sentimentScore
         *        An object that lists the sentiments, and their corresponding confidence levels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sentimentScore(SentimentScore sentimentScore);

        /**
         * <p>
         * An object that lists the sentiments, and their corresponding confidence levels.
         * </p>
         * This is a convenience method that creates an instance of the {@link SentimentScore.Builder} avoiding the need
         * to create one manually via {@link SentimentScore#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SentimentScore.Builder#build()} is called immediately and its
         * result is passed to {@link #sentimentScore(SentimentScore)}.
         * 
         * @param sentimentScore
         *        a consumer that will call methods on {@link SentimentScore.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sentimentScore(SentimentScore)
         */
        default Builder sentimentScore(Consumer<SentimentScore.Builder> sentimentScore) {
            return sentimentScore(SentimentScore.builder().applyMutation(sentimentScore).build());
        }
    }

    static final class BuilderImpl extends ComprehendResponse.BuilderImpl implements Builder {
        private String sentiment;

        private SentimentScore sentimentScore;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectSentimentResponse model) {
            super(model);
            sentiment(model.sentiment);
            sentimentScore(model.sentimentScore);
        }

        public final String getSentiment() {
            return sentiment;
        }

        public final void setSentiment(String sentiment) {
            this.sentiment = sentiment;
        }

        @Override
        public final Builder sentiment(String sentiment) {
            this.sentiment = sentiment;
            return this;
        }

        @Override
        public final Builder sentiment(SentimentType sentiment) {
            this.sentiment(sentiment == null ? null : sentiment.toString());
            return this;
        }

        public final SentimentScore.Builder getSentimentScore() {
            return sentimentScore != null ? sentimentScore.toBuilder() : null;
        }

        public final void setSentimentScore(SentimentScore.BuilderImpl sentimentScore) {
            this.sentimentScore = sentimentScore != null ? sentimentScore.build() : null;
        }

        @Override
        public final Builder sentimentScore(SentimentScore sentimentScore) {
            this.sentimentScore = sentimentScore;
            return this;
        }

        @Override
        public DetectSentimentResponse build() {
            return new DetectSentimentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
