/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectToxicContentResponse extends ComprehendResponse implements
        ToCopyableBuilder<DetectToxicContentResponse.Builder, DetectToxicContentResponse> {
    private static final SdkField<List<ToxicLabels>> RESULT_LIST_FIELD = SdkField
            .<List<ToxicLabels>> builder(MarshallingType.LIST)
            .memberName("ResultList")
            .getter(getter(DetectToxicContentResponse::resultList))
            .setter(setter(Builder::resultList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ToxicLabels> builder(MarshallingType.SDK_POJO)
                                            .constructor(ToxicLabels::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ToxicLabels> resultList;

    private DetectToxicContentResponse(BuilderImpl builder) {
        super(builder);
        this.resultList = builder.resultList;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResultList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResultList() {
        return resultList != null && !(resultList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Results of the content moderation analysis. Each entry in the results list contains a list of toxic content types
     * identified in the text, along with a confidence score for each content type. The results list also includes a
     * toxicity score for each entry in the results list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResultList} method.
     * </p>
     * 
     * @return Results of the content moderation analysis. Each entry in the results list contains a list of toxic
     *         content types identified in the text, along with a confidence score for each content type. The results
     *         list also includes a toxicity score for each entry in the results list.
     */
    public final List<ToxicLabels> resultList() {
        return resultList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResultList() ? resultList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectToxicContentResponse)) {
            return false;
        }
        DetectToxicContentResponse other = (DetectToxicContentResponse) obj;
        return hasResultList() == other.hasResultList() && Objects.equals(resultList(), other.resultList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectToxicContentResponse").add("ResultList", hasResultList() ? resultList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResultList":
            return Optional.ofNullable(clazz.cast(resultList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResultList", RESULT_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DetectToxicContentResponse, T> g) {
        return obj -> g.apply((DetectToxicContentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendResponse.Builder, SdkPojo, CopyableBuilder<Builder, DetectToxicContentResponse> {
        /**
         * <p>
         * Results of the content moderation analysis. Each entry in the results list contains a list of toxic content
         * types identified in the text, along with a confidence score for each content type. The results list also
         * includes a toxicity score for each entry in the results list.
         * </p>
         * 
         * @param resultList
         *        Results of the content moderation analysis. Each entry in the results list contains a list of toxic
         *        content types identified in the text, along with a confidence score for each content type. The results
         *        list also includes a toxicity score for each entry in the results list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultList(Collection<ToxicLabels> resultList);

        /**
         * <p>
         * Results of the content moderation analysis. Each entry in the results list contains a list of toxic content
         * types identified in the text, along with a confidence score for each content type. The results list also
         * includes a toxicity score for each entry in the results list.
         * </p>
         * 
         * @param resultList
         *        Results of the content moderation analysis. Each entry in the results list contains a list of toxic
         *        content types identified in the text, along with a confidence score for each content type. The results
         *        list also includes a toxicity score for each entry in the results list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultList(ToxicLabels... resultList);

        /**
         * <p>
         * Results of the content moderation analysis. Each entry in the results list contains a list of toxic content
         * types identified in the text, along with a confidence score for each content type. The results list also
         * includes a toxicity score for each entry in the results list.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.comprehend.model.ToxicLabels.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.comprehend.model.ToxicLabels#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.comprehend.model.ToxicLabels.Builder#build()} is called immediately
         * and its result is passed to {@link #resultList(List<ToxicLabels>)}.
         * 
         * @param resultList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.comprehend.model.ToxicLabels.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resultList(java.util.Collection<ToxicLabels>)
         */
        Builder resultList(Consumer<ToxicLabels.Builder>... resultList);
    }

    static final class BuilderImpl extends ComprehendResponse.BuilderImpl implements Builder {
        private List<ToxicLabels> resultList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetectToxicContentResponse model) {
            super(model);
            resultList(model.resultList);
        }

        public final List<ToxicLabels.Builder> getResultList() {
            List<ToxicLabels.Builder> result = ListOfToxicLabelsCopier.copyToBuilder(this.resultList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResultList(Collection<ToxicLabels.BuilderImpl> resultList) {
            this.resultList = ListOfToxicLabelsCopier.copyFromBuilder(resultList);
        }

        @Override
        public final Builder resultList(Collection<ToxicLabels> resultList) {
            this.resultList = ListOfToxicLabelsCopier.copy(resultList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultList(ToxicLabels... resultList) {
            resultList(Arrays.asList(resultList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultList(Consumer<ToxicLabels.Builder>... resultList) {
            resultList(Stream.of(resultList).map(c -> ToxicLabels.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DetectToxicContentResponse build() {
            return new DetectToxicContentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
