/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the class that categorizes the document being analyzed
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentClass implements SdkPojo, Serializable, ToCopyableBuilder<DocumentClass.Builder, DocumentClass> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DocumentClass::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Float> SCORE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("Score")
            .getter(getter(DocumentClass::score)).setter(setter(Builder::score))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Score").build()).build();

    private static final SdkField<Integer> PAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Page")
            .getter(getter(DocumentClass::page)).setter(setter(Builder::page))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Page").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SCORE_FIELD,
            PAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Float score;

    private final Integer page;

    private DocumentClass(BuilderImpl builder) {
        this.name = builder.name;
        this.score = builder.score;
        this.page = builder.page;
    }

    /**
     * <p>
     * The name of the class.
     * </p>
     * 
     * @return The name of the class.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The confidence score that Amazon Comprehend has this class correctly attributed.
     * </p>
     * 
     * @return The confidence score that Amazon Comprehend has this class correctly attributed.
     */
    public final Float score() {
        return score;
    }

    /**
     * <p>
     * Page number in the input document. This field is present in the response only if your request includes the
     * <code>Byte</code> parameter.
     * </p>
     * 
     * @return Page number in the input document. This field is present in the response only if your request includes
     *         the <code>Byte</code> parameter.
     */
    public final Integer page() {
        return page;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(score());
        hashCode = 31 * hashCode + Objects.hashCode(page());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentClass)) {
            return false;
        }
        DocumentClass other = (DocumentClass) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(score(), other.score())
                && Objects.equals(page(), other.page());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentClass").add("Name", name()).add("Score", score()).add("Page", page()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Score":
            return Optional.ofNullable(clazz.cast(score()));
        case "Page":
            return Optional.ofNullable(clazz.cast(page()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Score", SCORE_FIELD);
        map.put("Page", PAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DocumentClass, T> g) {
        return obj -> g.apply((DocumentClass) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentClass> {
        /**
         * <p>
         * The name of the class.
         * </p>
         * 
         * @param name
         *        The name of the class.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The confidence score that Amazon Comprehend has this class correctly attributed.
         * </p>
         * 
         * @param score
         *        The confidence score that Amazon Comprehend has this class correctly attributed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder score(Float score);

        /**
         * <p>
         * Page number in the input document. This field is present in the response only if your request includes the
         * <code>Byte</code> parameter.
         * </p>
         * 
         * @param page
         *        Page number in the input document. This field is present in the response only if your request includes
         *        the <code>Byte</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder page(Integer page);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Float score;

        private Integer page;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentClass model) {
            name(model.name);
            score(model.score);
            page(model.page);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Float getScore() {
            return score;
        }

        public final void setScore(Float score) {
            this.score = score;
        }

        @Override
        public final Builder score(Float score) {
            this.score = score;
            return this;
        }

        public final Integer getPage() {
            return page;
        }

        public final void setPage(Integer page) {
            this.page = page;
        }

        @Override
        public final Builder page(Integer page) {
            this.page = page;
            return this;
        }

        @Override
        public DocumentClass build() {
            return new DocumentClass(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
