/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information for filtering a list of document classifiers. You can only specify one filtering parameter in a
 * request. For more information, see the <code>ListDocumentClassifiers</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentClassifierFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentClassifierFilter.Builder, DocumentClassifierFilter> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DocumentClassifierFilter::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> DOCUMENT_CLASSIFIER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentClassifierName").getter(getter(DocumentClassifierFilter::documentClassifierName))
            .setter(setter(Builder::documentClassifierName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentClassifierName").build())
            .build();

    private static final SdkField<Instant> SUBMIT_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("SubmitTimeBefore").getter(getter(DocumentClassifierFilter::submitTimeBefore))
            .setter(setter(Builder::submitTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmitTimeBefore").build()).build();

    private static final SdkField<Instant> SUBMIT_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("SubmitTimeAfter").getter(getter(DocumentClassifierFilter::submitTimeAfter))
            .setter(setter(Builder::submitTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmitTimeAfter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            DOCUMENT_CLASSIFIER_NAME_FIELD, SUBMIT_TIME_BEFORE_FIELD, SUBMIT_TIME_AFTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String documentClassifierName;

    private final Instant submitTimeBefore;

    private final Instant submitTimeAfter;

    private DocumentClassifierFilter(BuilderImpl builder) {
        this.status = builder.status;
        this.documentClassifierName = builder.documentClassifierName;
        this.submitTimeBefore = builder.submitTimeBefore;
        this.submitTimeAfter = builder.submitTimeAfter;
    }

    /**
     * <p>
     * Filters the list of classifiers based on status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ModelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Filters the list of classifiers based on status.
     * @see ModelStatus
     */
    public final ModelStatus status() {
        return ModelStatus.fromValue(status);
    }

    /**
     * <p>
     * Filters the list of classifiers based on status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ModelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Filters the list of classifiers based on status.
     * @see ModelStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The name that you assigned to the document classifier
     * </p>
     * 
     * @return The name that you assigned to the document classifier
     */
    public final String documentClassifierName() {
        return documentClassifierName;
    }

    /**
     * <p>
     * Filters the list of classifiers based on the time that the classifier was submitted for processing. Returns only
     * classifiers submitted before the specified time. Classifiers are returned in ascending order, oldest to newest.
     * </p>
     * 
     * @return Filters the list of classifiers based on the time that the classifier was submitted for processing.
     *         Returns only classifiers submitted before the specified time. Classifiers are returned in ascending
     *         order, oldest to newest.
     */
    public final Instant submitTimeBefore() {
        return submitTimeBefore;
    }

    /**
     * <p>
     * Filters the list of classifiers based on the time that the classifier was submitted for processing. Returns only
     * classifiers submitted after the specified time. Classifiers are returned in descending order, newest to oldest.
     * </p>
     * 
     * @return Filters the list of classifiers based on the time that the classifier was submitted for processing.
     *         Returns only classifiers submitted after the specified time. Classifiers are returned in descending
     *         order, newest to oldest.
     */
    public final Instant submitTimeAfter() {
        return submitTimeAfter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(documentClassifierName());
        hashCode = 31 * hashCode + Objects.hashCode(submitTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(submitTimeAfter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentClassifierFilter)) {
            return false;
        }
        DocumentClassifierFilter other = (DocumentClassifierFilter) obj;
        return Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(documentClassifierName(), other.documentClassifierName())
                && Objects.equals(submitTimeBefore(), other.submitTimeBefore())
                && Objects.equals(submitTimeAfter(), other.submitTimeAfter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentClassifierFilter").add("Status", statusAsString())
                .add("DocumentClassifierName", documentClassifierName()).add("SubmitTimeBefore", submitTimeBefore())
                .add("SubmitTimeAfter", submitTimeAfter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "DocumentClassifierName":
            return Optional.ofNullable(clazz.cast(documentClassifierName()));
        case "SubmitTimeBefore":
            return Optional.ofNullable(clazz.cast(submitTimeBefore()));
        case "SubmitTimeAfter":
            return Optional.ofNullable(clazz.cast(submitTimeAfter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Status", STATUS_FIELD);
        map.put("DocumentClassifierName", DOCUMENT_CLASSIFIER_NAME_FIELD);
        map.put("SubmitTimeBefore", SUBMIT_TIME_BEFORE_FIELD);
        map.put("SubmitTimeAfter", SUBMIT_TIME_AFTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DocumentClassifierFilter, T> g) {
        return obj -> g.apply((DocumentClassifierFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentClassifierFilter> {
        /**
         * <p>
         * Filters the list of classifiers based on status.
         * </p>
         * 
         * @param status
         *        Filters the list of classifiers based on status.
         * @see ModelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Filters the list of classifiers based on status.
         * </p>
         * 
         * @param status
         *        Filters the list of classifiers based on status.
         * @see ModelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelStatus
         */
        Builder status(ModelStatus status);

        /**
         * <p>
         * The name that you assigned to the document classifier
         * </p>
         * 
         * @param documentClassifierName
         *        The name that you assigned to the document classifier
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentClassifierName(String documentClassifierName);

        /**
         * <p>
         * Filters the list of classifiers based on the time that the classifier was submitted for processing. Returns
         * only classifiers submitted before the specified time. Classifiers are returned in ascending order, oldest to
         * newest.
         * </p>
         * 
         * @param submitTimeBefore
         *        Filters the list of classifiers based on the time that the classifier was submitted for processing.
         *        Returns only classifiers submitted before the specified time. Classifiers are returned in ascending
         *        order, oldest to newest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submitTimeBefore(Instant submitTimeBefore);

        /**
         * <p>
         * Filters the list of classifiers based on the time that the classifier was submitted for processing. Returns
         * only classifiers submitted after the specified time. Classifiers are returned in descending order, newest to
         * oldest.
         * </p>
         * 
         * @param submitTimeAfter
         *        Filters the list of classifiers based on the time that the classifier was submitted for processing.
         *        Returns only classifiers submitted after the specified time. Classifiers are returned in descending
         *        order, newest to oldest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submitTimeAfter(Instant submitTimeAfter);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String documentClassifierName;

        private Instant submitTimeBefore;

        private Instant submitTimeAfter;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentClassifierFilter model) {
            status(model.status);
            documentClassifierName(model.documentClassifierName);
            submitTimeBefore(model.submitTimeBefore);
            submitTimeAfter(model.submitTimeAfter);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ModelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDocumentClassifierName() {
            return documentClassifierName;
        }

        public final void setDocumentClassifierName(String documentClassifierName) {
            this.documentClassifierName = documentClassifierName;
        }

        @Override
        public final Builder documentClassifierName(String documentClassifierName) {
            this.documentClassifierName = documentClassifierName;
            return this;
        }

        public final Instant getSubmitTimeBefore() {
            return submitTimeBefore;
        }

        public final void setSubmitTimeBefore(Instant submitTimeBefore) {
            this.submitTimeBefore = submitTimeBefore;
        }

        @Override
        public final Builder submitTimeBefore(Instant submitTimeBefore) {
            this.submitTimeBefore = submitTimeBefore;
            return this;
        }

        public final Instant getSubmitTimeAfter() {
            return submitTimeAfter;
        }

        public final void setSubmitTimeAfter(Instant submitTimeAfter) {
            this.submitTimeAfter = submitTimeAfter;
        }

        @Override
        public final Builder submitTimeAfter(Instant submitTimeAfter) {
            this.submitTimeAfter = submitTimeAfter;
            return this;
        }

        @Override
        public DocumentClassifierFilter build() {
            return new DocumentClassifierFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
