/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The flywheel properties.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlywheelProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<FlywheelProperties.Builder, FlywheelProperties> {
    private static final SdkField<String> FLYWHEEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlywheelArn").getter(getter(FlywheelProperties::flywheelArn)).setter(setter(Builder::flywheelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlywheelArn").build()).build();

    private static final SdkField<String> ACTIVE_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActiveModelArn").getter(getter(FlywheelProperties::activeModelArn))
            .setter(setter(Builder::activeModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveModelArn").build()).build();

    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataAccessRoleArn").getter(getter(FlywheelProperties::dataAccessRoleArn))
            .setter(setter(Builder::dataAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()).build();

    private static final SdkField<TaskConfig> TASK_CONFIG_FIELD = SdkField.<TaskConfig> builder(MarshallingType.SDK_POJO)
            .memberName("TaskConfig").getter(getter(FlywheelProperties::taskConfig)).setter(setter(Builder::taskConfig))
            .constructor(TaskConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskConfig").build()).build();

    private static final SdkField<String> DATA_LAKE_S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataLakeS3Uri").getter(getter(FlywheelProperties::dataLakeS3Uri)).setter(setter(Builder::dataLakeS3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLakeS3Uri").build()).build();

    private static final SdkField<DataSecurityConfig> DATA_SECURITY_CONFIG_FIELD = SdkField
            .<DataSecurityConfig> builder(MarshallingType.SDK_POJO).memberName("DataSecurityConfig")
            .getter(getter(FlywheelProperties::dataSecurityConfig)).setter(setter(Builder::dataSecurityConfig))
            .constructor(DataSecurityConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSecurityConfig").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(FlywheelProperties::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> MODEL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelType").getter(getter(FlywheelProperties::modelTypeAsString)).setter(setter(Builder::modelType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelType").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(FlywheelProperties::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(FlywheelProperties::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(FlywheelProperties::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> LATEST_FLYWHEEL_ITERATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LatestFlywheelIteration").getter(getter(FlywheelProperties::latestFlywheelIteration))
            .setter(setter(Builder::latestFlywheelIteration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestFlywheelIteration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLYWHEEL_ARN_FIELD,
            ACTIVE_MODEL_ARN_FIELD, DATA_ACCESS_ROLE_ARN_FIELD, TASK_CONFIG_FIELD, DATA_LAKE_S3_URI_FIELD,
            DATA_SECURITY_CONFIG_FIELD, STATUS_FIELD, MODEL_TYPE_FIELD, MESSAGE_FIELD, CREATION_TIME_FIELD,
            LAST_MODIFIED_TIME_FIELD, LATEST_FLYWHEEL_ITERATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String flywheelArn;

    private final String activeModelArn;

    private final String dataAccessRoleArn;

    private final TaskConfig taskConfig;

    private final String dataLakeS3Uri;

    private final DataSecurityConfig dataSecurityConfig;

    private final String status;

    private final String modelType;

    private final String message;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final String latestFlywheelIteration;

    private FlywheelProperties(BuilderImpl builder) {
        this.flywheelArn = builder.flywheelArn;
        this.activeModelArn = builder.activeModelArn;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.taskConfig = builder.taskConfig;
        this.dataLakeS3Uri = builder.dataLakeS3Uri;
        this.dataSecurityConfig = builder.dataSecurityConfig;
        this.status = builder.status;
        this.modelType = builder.modelType;
        this.message = builder.message;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.latestFlywheelIteration = builder.latestFlywheelIteration;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the flywheel.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the flywheel.
     */
    public final String flywheelArn() {
        return flywheelArn;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the active model version.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the active model version.
     */
    public final String activeModelArn() {
        return activeModelArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend permission to access the flywheel
     * data.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend permission to access the
     *         flywheel data.
     */
    public final String dataAccessRoleArn() {
        return dataAccessRoleArn;
    }

    /**
     * <p>
     * Configuration about the model associated with a flywheel.
     * </p>
     * 
     * @return Configuration about the model associated with a flywheel.
     */
    public final TaskConfig taskConfig() {
        return taskConfig;
    }

    /**
     * <p>
     * Amazon S3 URI of the data lake location.
     * </p>
     * 
     * @return Amazon S3 URI of the data lake location.
     */
    public final String dataLakeS3Uri() {
        return dataLakeS3Uri;
    }

    /**
     * <p>
     * Data security configuration.
     * </p>
     * 
     * @return Data security configuration.
     */
    public final DataSecurityConfig dataSecurityConfig() {
        return dataSecurityConfig;
    }

    /**
     * <p>
     * The status of the flywheel.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FlywheelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the flywheel.
     * @see FlywheelStatus
     */
    public final FlywheelStatus status() {
        return FlywheelStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the flywheel.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FlywheelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the flywheel.
     * @see FlywheelStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Model type of the flywheel's model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelType} will
     * return {@link ModelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modelTypeAsString}.
     * </p>
     * 
     * @return Model type of the flywheel's model.
     * @see ModelType
     */
    public final ModelType modelType() {
        return ModelType.fromValue(modelType);
    }

    /**
     * <p>
     * Model type of the flywheel's model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelType} will
     * return {@link ModelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modelTypeAsString}.
     * </p>
     * 
     * @return Model type of the flywheel's model.
     * @see ModelType
     */
    public final String modelTypeAsString() {
        return modelType;
    }

    /**
     * <p>
     * A description of the status of the flywheel.
     * </p>
     * 
     * @return A description of the status of the flywheel.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * Creation time of the flywheel.
     * </p>
     * 
     * @return Creation time of the flywheel.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Last modified time for the flywheel.
     * </p>
     * 
     * @return Last modified time for the flywheel.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The most recent flywheel iteration.
     * </p>
     * 
     * @return The most recent flywheel iteration.
     */
    public final String latestFlywheelIteration() {
        return latestFlywheelIteration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(flywheelArn());
        hashCode = 31 * hashCode + Objects.hashCode(activeModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(taskConfig());
        hashCode = 31 * hashCode + Objects.hashCode(dataLakeS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(dataSecurityConfig());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(modelTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(latestFlywheelIteration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlywheelProperties)) {
            return false;
        }
        FlywheelProperties other = (FlywheelProperties) obj;
        return Objects.equals(flywheelArn(), other.flywheelArn()) && Objects.equals(activeModelArn(), other.activeModelArn())
                && Objects.equals(dataAccessRoleArn(), other.dataAccessRoleArn())
                && Objects.equals(taskConfig(), other.taskConfig()) && Objects.equals(dataLakeS3Uri(), other.dataLakeS3Uri())
                && Objects.equals(dataSecurityConfig(), other.dataSecurityConfig())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(modelTypeAsString(), other.modelTypeAsString()) && Objects.equals(message(), other.message())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(latestFlywheelIteration(), other.latestFlywheelIteration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlywheelProperties").add("FlywheelArn", flywheelArn()).add("ActiveModelArn", activeModelArn())
                .add("DataAccessRoleArn", dataAccessRoleArn()).add("TaskConfig", taskConfig())
                .add("DataLakeS3Uri", dataLakeS3Uri()).add("DataSecurityConfig", dataSecurityConfig())
                .add("Status", statusAsString()).add("ModelType", modelTypeAsString()).add("Message", message())
                .add("CreationTime", creationTime()).add("LastModifiedTime", lastModifiedTime())
                .add("LatestFlywheelIteration", latestFlywheelIteration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlywheelArn":
            return Optional.ofNullable(clazz.cast(flywheelArn()));
        case "ActiveModelArn":
            return Optional.ofNullable(clazz.cast(activeModelArn()));
        case "DataAccessRoleArn":
            return Optional.ofNullable(clazz.cast(dataAccessRoleArn()));
        case "TaskConfig":
            return Optional.ofNullable(clazz.cast(taskConfig()));
        case "DataLakeS3Uri":
            return Optional.ofNullable(clazz.cast(dataLakeS3Uri()));
        case "DataSecurityConfig":
            return Optional.ofNullable(clazz.cast(dataSecurityConfig()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ModelType":
            return Optional.ofNullable(clazz.cast(modelTypeAsString()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "LatestFlywheelIteration":
            return Optional.ofNullable(clazz.cast(latestFlywheelIteration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FlywheelArn", FLYWHEEL_ARN_FIELD);
        map.put("ActiveModelArn", ACTIVE_MODEL_ARN_FIELD);
        map.put("DataAccessRoleArn", DATA_ACCESS_ROLE_ARN_FIELD);
        map.put("TaskConfig", TASK_CONFIG_FIELD);
        map.put("DataLakeS3Uri", DATA_LAKE_S3_URI_FIELD);
        map.put("DataSecurityConfig", DATA_SECURITY_CONFIG_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("ModelType", MODEL_TYPE_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LatestFlywheelIteration", LATEST_FLYWHEEL_ITERATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlywheelProperties, T> g) {
        return obj -> g.apply((FlywheelProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlywheelProperties> {
        /**
         * <p>
         * The Amazon Resource Number (ARN) of the flywheel.
         * </p>
         * 
         * @param flywheelArn
         *        The Amazon Resource Number (ARN) of the flywheel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flywheelArn(String flywheelArn);

        /**
         * <p>
         * The Amazon Resource Number (ARN) of the active model version.
         * </p>
         * 
         * @param activeModelArn
         *        The Amazon Resource Number (ARN) of the active model version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeModelArn(String activeModelArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend permission to access the
         * flywheel data.
         * </p>
         * 
         * @param dataAccessRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend permission to access the
         *        flywheel data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAccessRoleArn(String dataAccessRoleArn);

        /**
         * <p>
         * Configuration about the model associated with a flywheel.
         * </p>
         * 
         * @param taskConfig
         *        Configuration about the model associated with a flywheel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskConfig(TaskConfig taskConfig);

        /**
         * <p>
         * Configuration about the model associated with a flywheel.
         * </p>
         * This is a convenience method that creates an instance of the {@link TaskConfig.Builder} avoiding the need to
         * create one manually via {@link TaskConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TaskConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #taskConfig(TaskConfig)}.
         * 
         * @param taskConfig
         *        a consumer that will call methods on {@link TaskConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskConfig(TaskConfig)
         */
        default Builder taskConfig(Consumer<TaskConfig.Builder> taskConfig) {
            return taskConfig(TaskConfig.builder().applyMutation(taskConfig).build());
        }

        /**
         * <p>
         * Amazon S3 URI of the data lake location.
         * </p>
         * 
         * @param dataLakeS3Uri
         *        Amazon S3 URI of the data lake location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataLakeS3Uri(String dataLakeS3Uri);

        /**
         * <p>
         * Data security configuration.
         * </p>
         * 
         * @param dataSecurityConfig
         *        Data security configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSecurityConfig(DataSecurityConfig dataSecurityConfig);

        /**
         * <p>
         * Data security configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSecurityConfig.Builder} avoiding the
         * need to create one manually via {@link DataSecurityConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSecurityConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #dataSecurityConfig(DataSecurityConfig)}.
         * 
         * @param dataSecurityConfig
         *        a consumer that will call methods on {@link DataSecurityConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSecurityConfig(DataSecurityConfig)
         */
        default Builder dataSecurityConfig(Consumer<DataSecurityConfig.Builder> dataSecurityConfig) {
            return dataSecurityConfig(DataSecurityConfig.builder().applyMutation(dataSecurityConfig).build());
        }

        /**
         * <p>
         * The status of the flywheel.
         * </p>
         * 
         * @param status
         *        The status of the flywheel.
         * @see FlywheelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlywheelStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the flywheel.
         * </p>
         * 
         * @param status
         *        The status of the flywheel.
         * @see FlywheelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlywheelStatus
         */
        Builder status(FlywheelStatus status);

        /**
         * <p>
         * Model type of the flywheel's model.
         * </p>
         * 
         * @param modelType
         *        Model type of the flywheel's model.
         * @see ModelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelType
         */
        Builder modelType(String modelType);

        /**
         * <p>
         * Model type of the flywheel's model.
         * </p>
         * 
         * @param modelType
         *        Model type of the flywheel's model.
         * @see ModelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelType
         */
        Builder modelType(ModelType modelType);

        /**
         * <p>
         * A description of the status of the flywheel.
         * </p>
         * 
         * @param message
         *        A description of the status of the flywheel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * Creation time of the flywheel.
         * </p>
         * 
         * @param creationTime
         *        Creation time of the flywheel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Last modified time for the flywheel.
         * </p>
         * 
         * @param lastModifiedTime
         *        Last modified time for the flywheel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The most recent flywheel iteration.
         * </p>
         * 
         * @param latestFlywheelIteration
         *        The most recent flywheel iteration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestFlywheelIteration(String latestFlywheelIteration);
    }

    static final class BuilderImpl implements Builder {
        private String flywheelArn;

        private String activeModelArn;

        private String dataAccessRoleArn;

        private TaskConfig taskConfig;

        private String dataLakeS3Uri;

        private DataSecurityConfig dataSecurityConfig;

        private String status;

        private String modelType;

        private String message;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private String latestFlywheelIteration;

        private BuilderImpl() {
        }

        private BuilderImpl(FlywheelProperties model) {
            flywheelArn(model.flywheelArn);
            activeModelArn(model.activeModelArn);
            dataAccessRoleArn(model.dataAccessRoleArn);
            taskConfig(model.taskConfig);
            dataLakeS3Uri(model.dataLakeS3Uri);
            dataSecurityConfig(model.dataSecurityConfig);
            status(model.status);
            modelType(model.modelType);
            message(model.message);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            latestFlywheelIteration(model.latestFlywheelIteration);
        }

        public final String getFlywheelArn() {
            return flywheelArn;
        }

        public final void setFlywheelArn(String flywheelArn) {
            this.flywheelArn = flywheelArn;
        }

        @Override
        public final Builder flywheelArn(String flywheelArn) {
            this.flywheelArn = flywheelArn;
            return this;
        }

        public final String getActiveModelArn() {
            return activeModelArn;
        }

        public final void setActiveModelArn(String activeModelArn) {
            this.activeModelArn = activeModelArn;
        }

        @Override
        public final Builder activeModelArn(String activeModelArn) {
            this.activeModelArn = activeModelArn;
            return this;
        }

        public final String getDataAccessRoleArn() {
            return dataAccessRoleArn;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final TaskConfig.Builder getTaskConfig() {
            return taskConfig != null ? taskConfig.toBuilder() : null;
        }

        public final void setTaskConfig(TaskConfig.BuilderImpl taskConfig) {
            this.taskConfig = taskConfig != null ? taskConfig.build() : null;
        }

        @Override
        public final Builder taskConfig(TaskConfig taskConfig) {
            this.taskConfig = taskConfig;
            return this;
        }

        public final String getDataLakeS3Uri() {
            return dataLakeS3Uri;
        }

        public final void setDataLakeS3Uri(String dataLakeS3Uri) {
            this.dataLakeS3Uri = dataLakeS3Uri;
        }

        @Override
        public final Builder dataLakeS3Uri(String dataLakeS3Uri) {
            this.dataLakeS3Uri = dataLakeS3Uri;
            return this;
        }

        public final DataSecurityConfig.Builder getDataSecurityConfig() {
            return dataSecurityConfig != null ? dataSecurityConfig.toBuilder() : null;
        }

        public final void setDataSecurityConfig(DataSecurityConfig.BuilderImpl dataSecurityConfig) {
            this.dataSecurityConfig = dataSecurityConfig != null ? dataSecurityConfig.build() : null;
        }

        @Override
        public final Builder dataSecurityConfig(DataSecurityConfig dataSecurityConfig) {
            this.dataSecurityConfig = dataSecurityConfig;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FlywheelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getModelType() {
            return modelType;
        }

        public final void setModelType(String modelType) {
            this.modelType = modelType;
        }

        @Override
        public final Builder modelType(String modelType) {
            this.modelType = modelType;
            return this;
        }

        @Override
        public final Builder modelType(ModelType modelType) {
            this.modelType(modelType == null ? null : modelType.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLatestFlywheelIteration() {
            return latestFlywheelIteration;
        }

        public final void setLatestFlywheelIteration(String latestFlywheelIteration) {
            this.latestFlywheelIteration = latestFlywheelIteration;
        }

        @Override
        public final Builder latestFlywheelIteration(String latestFlywheelIteration) {
            this.latestFlywheelIteration = latestFlywheelIteration;
            return this;
        }

        @Override
        public FlywheelProperties build() {
            return new FlywheelProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
