/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides configuration parameters for the output of PII entity detection jobs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PiiOutputDataConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<PiiOutputDataConfig.Builder, PiiOutputDataConfig> {
    private static final SdkField<String> S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("S3Uri")
            .getter(getter(PiiOutputDataConfig::s3Uri)).setter(setter(Builder::s3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(PiiOutputDataConfig::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(S3_URI_FIELD, KMS_KEY_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String s3Uri;

    private final String kmsKeyId;

    private PiiOutputDataConfig(BuilderImpl builder) {
        this.s3Uri = builder.s3Uri;
        this.kmsKeyId = builder.kmsKeyId;
    }

    /**
     * <p>
     * When you use the <code>PiiOutputDataConfig</code> object with asynchronous operations, you specify the Amazon S3
     * location where you want to write the output data.
     * </p>
     * <p>
     * For a PII entity detection job, the output file is plain text, not a compressed archive. The output file name is
     * the same as the input file, with <code>.out</code> appended at the end.
     * </p>
     * 
     * @return When you use the <code>PiiOutputDataConfig</code> object with asynchronous operations, you specify the
     *         Amazon S3 location where you want to write the output data. </p>
     *         <p>
     *         For a PII entity detection job, the output file is plain text, not a compressed archive. The output file
     *         name is the same as the input file, with <code>.out</code> appended at the end.
     */
    public final String s3Uri() {
        return s3Uri;
    }

    /**
     * <p>
     * ID for the Amazon Web Services Key Management Service (KMS) key that Amazon Comprehend uses to encrypt the output
     * results from an analysis job.
     * </p>
     * 
     * @return ID for the Amazon Web Services Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
     *         the output results from an analysis job.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PiiOutputDataConfig)) {
            return false;
        }
        PiiOutputDataConfig other = (PiiOutputDataConfig) obj;
        return Objects.equals(s3Uri(), other.s3Uri()) && Objects.equals(kmsKeyId(), other.kmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PiiOutputDataConfig").add("S3Uri", s3Uri()).add("KmsKeyId", kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Uri":
            return Optional.ofNullable(clazz.cast(s3Uri()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("S3Uri", S3_URI_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PiiOutputDataConfig, T> g) {
        return obj -> g.apply((PiiOutputDataConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PiiOutputDataConfig> {
        /**
         * <p>
         * When you use the <code>PiiOutputDataConfig</code> object with asynchronous operations, you specify the Amazon
         * S3 location where you want to write the output data.
         * </p>
         * <p>
         * For a PII entity detection job, the output file is plain text, not a compressed archive. The output file name
         * is the same as the input file, with <code>.out</code> appended at the end.
         * </p>
         * 
         * @param s3Uri
         *        When you use the <code>PiiOutputDataConfig</code> object with asynchronous operations, you specify the
         *        Amazon S3 location where you want to write the output data. </p>
         *        <p>
         *        For a PII entity detection job, the output file is plain text, not a compressed archive. The output
         *        file name is the same as the input file, with <code>.out</code> appended at the end.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Uri(String s3Uri);

        /**
         * <p>
         * ID for the Amazon Web Services Key Management Service (KMS) key that Amazon Comprehend uses to encrypt the
         * output results from an analysis job.
         * </p>
         * 
         * @param kmsKeyId
         *        ID for the Amazon Web Services Key Management Service (KMS) key that Amazon Comprehend uses to encrypt
         *        the output results from an analysis job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);
    }

    static final class BuilderImpl implements Builder {
        private String s3Uri;

        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(PiiOutputDataConfig model) {
            s3Uri(model.s3Uri);
            kmsKeyId(model.kmsKeyId);
        }

        public final String getS3Uri() {
            return s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        @Override
        public PiiOutputDataConfig build() {
            return new PiiOutputDataConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
