/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.comprehend.internal.ComprehendServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectEntitiesRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectEntitiesResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectKeyPhrasesRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectKeyPhrasesResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSyntaxRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSyntaxResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectTargetedSentimentRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectTargetedSentimentResponse;
import software.amazon.awssdk.services.comprehend.model.BatchSizeLimitExceededException;
import software.amazon.awssdk.services.comprehend.model.ClassifyDocumentRequest;
import software.amazon.awssdk.services.comprehend.model.ClassifyDocumentResponse;
import software.amazon.awssdk.services.comprehend.model.ComprehendException;
import software.amazon.awssdk.services.comprehend.model.ConcurrentModificationException;
import software.amazon.awssdk.services.comprehend.model.ContainsPiiEntitiesRequest;
import software.amazon.awssdk.services.comprehend.model.ContainsPiiEntitiesResponse;
import software.amazon.awssdk.services.comprehend.model.CreateDatasetRequest;
import software.amazon.awssdk.services.comprehend.model.CreateDatasetResponse;
import software.amazon.awssdk.services.comprehend.model.CreateDocumentClassifierRequest;
import software.amazon.awssdk.services.comprehend.model.CreateDocumentClassifierResponse;
import software.amazon.awssdk.services.comprehend.model.CreateEndpointRequest;
import software.amazon.awssdk.services.comprehend.model.CreateEndpointResponse;
import software.amazon.awssdk.services.comprehend.model.CreateEntityRecognizerRequest;
import software.amazon.awssdk.services.comprehend.model.CreateEntityRecognizerResponse;
import software.amazon.awssdk.services.comprehend.model.CreateFlywheelRequest;
import software.amazon.awssdk.services.comprehend.model.CreateFlywheelResponse;
import software.amazon.awssdk.services.comprehend.model.DeleteDocumentClassifierRequest;
import software.amazon.awssdk.services.comprehend.model.DeleteDocumentClassifierResponse;
import software.amazon.awssdk.services.comprehend.model.DeleteEndpointRequest;
import software.amazon.awssdk.services.comprehend.model.DeleteEndpointResponse;
import software.amazon.awssdk.services.comprehend.model.DeleteEntityRecognizerRequest;
import software.amazon.awssdk.services.comprehend.model.DeleteEntityRecognizerResponse;
import software.amazon.awssdk.services.comprehend.model.DeleteFlywheelRequest;
import software.amazon.awssdk.services.comprehend.model.DeleteFlywheelResponse;
import software.amazon.awssdk.services.comprehend.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.comprehend.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeDatasetRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeDatasetResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassificationJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassificationJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassifierRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassifierResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeDominantLanguageDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeDominantLanguageDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeEndpointRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeEndpointResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeEntityRecognizerRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeEntityRecognizerResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeEventsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeEventsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeFlywheelIterationRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeFlywheelIterationResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeFlywheelRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeFlywheelResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeKeyPhrasesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeKeyPhrasesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribePiiEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribePiiEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeResourcePolicyRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeResourcePolicyResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeSentimentDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeSentimentDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeTargetedSentimentDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeTargetedSentimentDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeTopicsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeTopicsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DetectDominantLanguageRequest;
import software.amazon.awssdk.services.comprehend.model.DetectDominantLanguageResponse;
import software.amazon.awssdk.services.comprehend.model.DetectEntitiesRequest;
import software.amazon.awssdk.services.comprehend.model.DetectEntitiesResponse;
import software.amazon.awssdk.services.comprehend.model.DetectKeyPhrasesRequest;
import software.amazon.awssdk.services.comprehend.model.DetectKeyPhrasesResponse;
import software.amazon.awssdk.services.comprehend.model.DetectPiiEntitiesRequest;
import software.amazon.awssdk.services.comprehend.model.DetectPiiEntitiesResponse;
import software.amazon.awssdk.services.comprehend.model.DetectSentimentRequest;
import software.amazon.awssdk.services.comprehend.model.DetectSentimentResponse;
import software.amazon.awssdk.services.comprehend.model.DetectSyntaxRequest;
import software.amazon.awssdk.services.comprehend.model.DetectSyntaxResponse;
import software.amazon.awssdk.services.comprehend.model.DetectTargetedSentimentRequest;
import software.amazon.awssdk.services.comprehend.model.DetectTargetedSentimentResponse;
import software.amazon.awssdk.services.comprehend.model.DetectToxicContentRequest;
import software.amazon.awssdk.services.comprehend.model.DetectToxicContentResponse;
import software.amazon.awssdk.services.comprehend.model.ImportModelRequest;
import software.amazon.awssdk.services.comprehend.model.ImportModelResponse;
import software.amazon.awssdk.services.comprehend.model.InternalServerException;
import software.amazon.awssdk.services.comprehend.model.InvalidFilterException;
import software.amazon.awssdk.services.comprehend.model.InvalidRequestException;
import software.amazon.awssdk.services.comprehend.model.JobNotFoundException;
import software.amazon.awssdk.services.comprehend.model.KmsKeyValidationException;
import software.amazon.awssdk.services.comprehend.model.ListDatasetsRequest;
import software.amazon.awssdk.services.comprehend.model.ListDatasetsResponse;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesRequest;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesResponse;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersRequest;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersResponse;
import software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListEndpointsRequest;
import software.amazon.awssdk.services.comprehend.model.ListEndpointsResponse;
import software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesRequest;
import software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesResponse;
import software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersRequest;
import software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersResponse;
import software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListFlywheelIterationHistoryRequest;
import software.amazon.awssdk.services.comprehend.model.ListFlywheelIterationHistoryResponse;
import software.amazon.awssdk.services.comprehend.model.ListFlywheelsRequest;
import software.amazon.awssdk.services.comprehend.model.ListFlywheelsResponse;
import software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.comprehend.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.comprehend.model.ListTargetedSentimentDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListTargetedSentimentDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.comprehend.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.comprehend.model.ResourceInUseException;
import software.amazon.awssdk.services.comprehend.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.comprehend.model.ResourceNotFoundException;
import software.amazon.awssdk.services.comprehend.model.ResourceUnavailableException;
import software.amazon.awssdk.services.comprehend.model.StartDocumentClassificationJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartDocumentClassificationJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartDominantLanguageDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartDominantLanguageDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartEventsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartEventsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartFlywheelIterationRequest;
import software.amazon.awssdk.services.comprehend.model.StartFlywheelIterationResponse;
import software.amazon.awssdk.services.comprehend.model.StartKeyPhrasesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartKeyPhrasesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartPiiEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartPiiEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartSentimentDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartSentimentDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartTargetedSentimentDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartTargetedSentimentDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartTopicsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartTopicsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopDominantLanguageDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopDominantLanguageDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopEventsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopEventsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopKeyPhrasesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopKeyPhrasesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopPiiEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopPiiEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopSentimentDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopSentimentDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopTargetedSentimentDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopTargetedSentimentDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopTrainingDocumentClassifierRequest;
import software.amazon.awssdk.services.comprehend.model.StopTrainingDocumentClassifierResponse;
import software.amazon.awssdk.services.comprehend.model.StopTrainingEntityRecognizerRequest;
import software.amazon.awssdk.services.comprehend.model.StopTrainingEntityRecognizerResponse;
import software.amazon.awssdk.services.comprehend.model.TagResourceRequest;
import software.amazon.awssdk.services.comprehend.model.TagResourceResponse;
import software.amazon.awssdk.services.comprehend.model.TextSizeLimitExceededException;
import software.amazon.awssdk.services.comprehend.model.TooManyRequestsException;
import software.amazon.awssdk.services.comprehend.model.TooManyTagKeysException;
import software.amazon.awssdk.services.comprehend.model.TooManyTagsException;
import software.amazon.awssdk.services.comprehend.model.UnsupportedLanguageException;
import software.amazon.awssdk.services.comprehend.model.UntagResourceRequest;
import software.amazon.awssdk.services.comprehend.model.UntagResourceResponse;
import software.amazon.awssdk.services.comprehend.model.UpdateEndpointRequest;
import software.amazon.awssdk.services.comprehend.model.UpdateEndpointResponse;
import software.amazon.awssdk.services.comprehend.model.UpdateFlywheelRequest;
import software.amazon.awssdk.services.comprehend.model.UpdateFlywheelResponse;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectDominantLanguageRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectEntitiesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectKeyPhrasesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectSentimentRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectSyntaxRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectTargetedSentimentRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ClassifyDocumentRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ContainsPiiEntitiesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.CreateDatasetRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.CreateDocumentClassifierRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.CreateEndpointRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.CreateEntityRecognizerRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.CreateFlywheelRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DeleteDocumentClassifierRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DeleteEndpointRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DeleteEntityRecognizerRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DeleteFlywheelRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DeleteResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeDatasetRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeDocumentClassificationJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeDocumentClassifierRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeDominantLanguageDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeEndpointRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeEntitiesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeEntityRecognizerRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeEventsDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeFlywheelIterationRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeFlywheelRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeKeyPhrasesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribePiiEntitiesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeSentimentDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeTargetedSentimentDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeTopicsDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectDominantLanguageRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectEntitiesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectKeyPhrasesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectPiiEntitiesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectSentimentRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectSyntaxRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectTargetedSentimentRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectToxicContentRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ImportModelRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListDatasetsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListDocumentClassificationJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListDocumentClassifierSummariesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListDocumentClassifiersRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListDominantLanguageDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListEndpointsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListEntitiesDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListEntityRecognizerSummariesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListEntityRecognizersRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListEventsDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListFlywheelIterationHistoryRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListFlywheelsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListKeyPhrasesDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListPiiEntitiesDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListSentimentDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListTargetedSentimentDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListTopicsDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.PutResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartDocumentClassificationJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartDominantLanguageDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartEntitiesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartEventsDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartFlywheelIterationRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartKeyPhrasesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartPiiEntitiesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartSentimentDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartTargetedSentimentDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartTopicsDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopDominantLanguageDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopEntitiesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopEventsDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopKeyPhrasesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopPiiEntitiesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopSentimentDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopTargetedSentimentDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopTrainingDocumentClassifierRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopTrainingEntityRecognizerRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.UpdateEndpointRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.UpdateFlywheelRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link ComprehendAsyncClient}.
 *
 * @see ComprehendAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultComprehendAsyncClient implements ComprehendAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultComprehendAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultComprehendAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Determines the dominant language of the input text for a batch of documents. For a list of languages that Amazon
     * Comprehend can detect, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html">Amazon
     * Comprehend Supported Languages</a>.
     * </p>
     *
     * @param batchDetectDominantLanguageRequest
     * @return A Java Future containing the result of the BatchDetectDominantLanguage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>BatchSizeLimitExceededException The number of documents in the request exceeds the limit of 25. Try
     *         your request again with fewer documents.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.BatchDetectDominantLanguage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectDominantLanguage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchDetectDominantLanguageResponse> batchDetectDominantLanguage(
            BatchDetectDominantLanguageRequest batchDetectDominantLanguageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchDetectDominantLanguageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchDetectDominantLanguageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDetectDominantLanguage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchDetectDominantLanguageResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchDetectDominantLanguageResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<BatchDetectDominantLanguageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchDetectDominantLanguageRequest, BatchDetectDominantLanguageResponse>()
                            .withOperationName("BatchDetectDominantLanguage").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchDetectDominantLanguageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchDetectDominantLanguageRequest));
            CompletableFuture<BatchDetectDominantLanguageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Inspects the text of a batch of documents for named entities and returns information about them. For more
     * information about named entities, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/how-entities.html">Entities</a> in the Comprehend
     * Developer Guide.
     * </p>
     *
     * @param batchDetectEntitiesRequest
     * @return A Java Future containing the result of the BatchDetectEntities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For a
     *         list of supported languages, <a
     *         href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported languages</a>
     *         in the Comprehend Developer Guide.</li>
     *         <li>BatchSizeLimitExceededException The number of documents in the request exceeds the limit of 25. Try
     *         your request again with fewer documents.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.BatchDetectEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectEntities"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchDetectEntitiesResponse> batchDetectEntities(
            BatchDetectEntitiesRequest batchDetectEntitiesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchDetectEntitiesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchDetectEntitiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDetectEntities");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchDetectEntitiesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchDetectEntitiesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<BatchDetectEntitiesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchDetectEntitiesRequest, BatchDetectEntitiesResponse>()
                            .withOperationName("BatchDetectEntities").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchDetectEntitiesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchDetectEntitiesRequest));
            CompletableFuture<BatchDetectEntitiesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Detects the key noun phrases found in a batch of documents.
     * </p>
     *
     * @param batchDetectKeyPhrasesRequest
     * @return A Java Future containing the result of the BatchDetectKeyPhrases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For a
     *         list of supported languages, <a
     *         href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported languages</a>
     *         in the Comprehend Developer Guide.</li>
     *         <li>BatchSizeLimitExceededException The number of documents in the request exceeds the limit of 25. Try
     *         your request again with fewer documents.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.BatchDetectKeyPhrases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectKeyPhrases"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchDetectKeyPhrasesResponse> batchDetectKeyPhrases(
            BatchDetectKeyPhrasesRequest batchDetectKeyPhrasesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchDetectKeyPhrasesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchDetectKeyPhrasesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDetectKeyPhrases");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchDetectKeyPhrasesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchDetectKeyPhrasesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<BatchDetectKeyPhrasesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchDetectKeyPhrasesRequest, BatchDetectKeyPhrasesResponse>()
                            .withOperationName("BatchDetectKeyPhrases").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchDetectKeyPhrasesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchDetectKeyPhrasesRequest));
            CompletableFuture<BatchDetectKeyPhrasesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Inspects a batch of documents and returns an inference of the prevailing sentiment, <code>POSITIVE</code>,
     * <code>NEUTRAL</code>, <code>MIXED</code>, or <code>NEGATIVE</code>, in each one.
     * </p>
     *
     * @param batchDetectSentimentRequest
     * @return A Java Future containing the result of the BatchDetectSentiment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For a
     *         list of supported languages, <a
     *         href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported languages</a>
     *         in the Comprehend Developer Guide.</li>
     *         <li>BatchSizeLimitExceededException The number of documents in the request exceeds the limit of 25. Try
     *         your request again with fewer documents.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.BatchDetectSentiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectSentiment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchDetectSentimentResponse> batchDetectSentiment(
            BatchDetectSentimentRequest batchDetectSentimentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchDetectSentimentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchDetectSentimentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDetectSentiment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchDetectSentimentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchDetectSentimentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<BatchDetectSentimentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchDetectSentimentRequest, BatchDetectSentimentResponse>()
                            .withOperationName("BatchDetectSentiment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchDetectSentimentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchDetectSentimentRequest));
            CompletableFuture<BatchDetectSentimentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Inspects the text of a batch of documents for the syntax and part of speech of the words in the document and
     * returns information about them. For more information, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/how-syntax.html">Syntax</a> in the Comprehend Developer
     * Guide.
     * </p>
     *
     * @param batchDetectSyntaxRequest
     * @return A Java Future containing the result of the BatchDetectSyntax operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For a
     *         list of supported languages, <a
     *         href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported languages</a>
     *         in the Comprehend Developer Guide.</li>
     *         <li>BatchSizeLimitExceededException The number of documents in the request exceeds the limit of 25. Try
     *         your request again with fewer documents.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.BatchDetectSyntax
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectSyntax" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchDetectSyntaxResponse> batchDetectSyntax(BatchDetectSyntaxRequest batchDetectSyntaxRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchDetectSyntaxRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchDetectSyntaxRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDetectSyntax");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchDetectSyntaxResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchDetectSyntaxResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<BatchDetectSyntaxResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchDetectSyntaxRequest, BatchDetectSyntaxResponse>()
                            .withOperationName("BatchDetectSyntax").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchDetectSyntaxRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchDetectSyntaxRequest));
            CompletableFuture<BatchDetectSyntaxResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Inspects a batch of documents and returns a sentiment analysis for each entity identified in the documents.
     * </p>
     * <p>
     * For more information about targeted sentiment, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/how-targeted-sentiment.html">Targeted sentiment</a> in the
     * <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     *
     * @param batchDetectTargetedSentimentRequest
     * @return A Java Future containing the result of the BatchDetectTargetedSentiment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For a
     *         list of supported languages, <a
     *         href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported languages</a>
     *         in the Comprehend Developer Guide.</li>
     *         <li>BatchSizeLimitExceededException The number of documents in the request exceeds the limit of 25. Try
     *         your request again with fewer documents.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.BatchDetectTargetedSentiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectTargetedSentiment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchDetectTargetedSentimentResponse> batchDetectTargetedSentiment(
            BatchDetectTargetedSentimentRequest batchDetectTargetedSentimentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchDetectTargetedSentimentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchDetectTargetedSentimentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDetectTargetedSentiment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchDetectTargetedSentimentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchDetectTargetedSentimentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<BatchDetectTargetedSentimentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchDetectTargetedSentimentRequest, BatchDetectTargetedSentimentResponse>()
                            .withOperationName("BatchDetectTargetedSentiment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchDetectTargetedSentimentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchDetectTargetedSentimentRequest));
            CompletableFuture<BatchDetectTargetedSentimentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a classification request to analyze a single document in real-time. <code>ClassifyDocument</code>
     * supports the following model types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Custom classifier - a custom model that you have created and trained. For input, you can provide plain text, a
     * single-page document (PDF, Word, or image), or Amazon Textract API output. For more information, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/how-document-classification.html">Custom
     * classification</a> in the <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Prompt safety classifier - Amazon Comprehend provides a pre-trained model for classifying input prompts for
     * generative AI applications. For input, you provide English plain text input. For prompt safety classification,
     * the response includes only the <code>Classes</code> field. For more information about prompt safety classifiers,
     * see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/trust-safety.html#prompt-classification">Prompt
     * safety classification</a> in the <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the system detects errors while processing a page in the input document, the API response includes an
     * <code>Errors</code> field that describes the errors.
     * </p>
     * <p>
     * If the system detects a document-level error in your input document, the API returns an
     * <code>InvalidRequestException</code> error response. For details about this exception, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/idp-inputs-sync-err.html"> Errors in semi-structured
     * documents</a> in the Comprehend Developer Guide.
     * </p>
     *
     * @param classifyDocumentRequest
     * @return A Java Future containing the result of the ClassifyDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceUnavailableException The specified resource is not available. Check the resource and try your
     *         request again.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ClassifyDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ClassifyDocument" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ClassifyDocumentResponse> classifyDocument(ClassifyDocumentRequest classifyDocumentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(classifyDocumentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, classifyDocumentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ClassifyDocument");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ClassifyDocumentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ClassifyDocumentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ClassifyDocumentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ClassifyDocumentRequest, ClassifyDocumentResponse>()
                            .withOperationName("ClassifyDocument").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ClassifyDocumentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(classifyDocumentRequest));
            CompletableFuture<ClassifyDocumentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Analyzes input text for the presence of personally identifiable information (PII) and returns the labels of
     * identified PII entity types such as name, address, bank account number, or phone number.
     * </p>
     *
     * @param containsPiiEntitiesRequest
     * @return A Java Future containing the result of the ContainsPiiEntities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For a
     *         list of supported languages, <a
     *         href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported languages</a>
     *         in the Comprehend Developer Guide.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ContainsPiiEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ContainsPiiEntities"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ContainsPiiEntitiesResponse> containsPiiEntities(
            ContainsPiiEntitiesRequest containsPiiEntitiesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(containsPiiEntitiesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, containsPiiEntitiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ContainsPiiEntities");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ContainsPiiEntitiesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ContainsPiiEntitiesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ContainsPiiEntitiesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ContainsPiiEntitiesRequest, ContainsPiiEntitiesResponse>()
                            .withOperationName("ContainsPiiEntities").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ContainsPiiEntitiesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(containsPiiEntitiesRequest));
            CompletableFuture<ContainsPiiEntitiesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a dataset to upload training or test data for a model associated with a flywheel. For more information
     * about datasets, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html"> Flywheel
     * overview</a> in the <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     *
     * @param createDatasetRequest
     * @return A Java Future containing the result of the CreateDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceInUseException The specified resource name is already in use. Use a different name and try
     *         your request again.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceLimitExceededException The maximum number of resources per account has been exceeded. Review
     *         the resources, and then try your request again.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.CreateDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateDataset" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDatasetResponse> createDataset(CreateDatasetRequest createDatasetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDatasetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDatasetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDataset");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDatasetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateDatasetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateDatasetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDatasetRequest, CreateDatasetResponse>()
                            .withOperationName("CreateDataset").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateDatasetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDatasetRequest));
            CompletableFuture<CreateDatasetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new document classifier that you can use to categorize documents. To create a classifier, you provide a
     * set of training documents that are labeled with the categories that you want to use. For more information, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/training-classifier-model.html">Training classifier
     * models</a> in the Comprehend Developer Guide.
     * </p>
     *
     * @param createDocumentClassifierRequest
     * @return A Java Future containing the result of the CreateDocumentClassifier operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceInUseException The specified resource name is already in use. Use a different name and try
     *         your request again.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceLimitExceededException The maximum number of resources per account has been exceeded. Review
     *         the resources, and then try your request again.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For a
     *         list of supported languages, <a
     *         href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported languages</a>
     *         in the Comprehend Developer Guide.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.CreateDocumentClassifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateDocumentClassifier"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDocumentClassifierResponse> createDocumentClassifier(
            CreateDocumentClassifierRequest createDocumentClassifierRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDocumentClassifierRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDocumentClassifierRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDocumentClassifier");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDocumentClassifierResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDocumentClassifierResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateDocumentClassifierResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDocumentClassifierRequest, CreateDocumentClassifierResponse>()
                            .withOperationName("CreateDocumentClassifier").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateDocumentClassifierRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDocumentClassifierRequest));
            CompletableFuture<CreateDocumentClassifierResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a model-specific endpoint for synchronous inference for a previously trained custom model For information
     * about endpoints, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html">Managing
     * endpoints</a>.
     * </p>
     *
     * @param createEndpointRequest
     * @return A Java Future containing the result of the CreateEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceInUseException The specified resource name is already in use. Use a different name and try
     *         your request again.</li>
     *         <li>ResourceLimitExceededException The maximum number of resources per account has been exceeded. Review
     *         the resources, and then try your request again.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>ResourceUnavailableException The specified resource is not available. Check the resource and try your
     *         request again.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.CreateEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateEndpointResponse> createEndpoint(CreateEndpointRequest createEndpointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateEndpointResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateEndpointRequest, CreateEndpointResponse>()
                            .withOperationName("CreateEndpoint").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createEndpointRequest));
            CompletableFuture<CreateEndpointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an entity recognizer using submitted files. After your <code>CreateEntityRecognizer</code> request is
     * submitted, you can check job status using the <code>DescribeEntityRecognizer</code> API.
     * </p>
     *
     * @param createEntityRecognizerRequest
     * @return A Java Future containing the result of the CreateEntityRecognizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceInUseException The specified resource name is already in use. Use a different name and try
     *         your request again.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceLimitExceededException The maximum number of resources per account has been exceeded. Review
     *         the resources, and then try your request again.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For a
     *         list of supported languages, <a
     *         href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported languages</a>
     *         in the Comprehend Developer Guide.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.CreateEntityRecognizer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateEntityRecognizer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateEntityRecognizerResponse> createEntityRecognizer(
            CreateEntityRecognizerRequest createEntityRecognizerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createEntityRecognizerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEntityRecognizerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEntityRecognizer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateEntityRecognizerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateEntityRecognizerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateEntityRecognizerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateEntityRecognizerRequest, CreateEntityRecognizerResponse>()
                            .withOperationName("CreateEntityRecognizer").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateEntityRecognizerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createEntityRecognizerRequest));
            CompletableFuture<CreateEntityRecognizerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * A flywheel is an Amazon Web Services resource that orchestrates the ongoing training of a model for custom
     * classification or custom entity recognition. You can create a flywheel to start with an existing trained model,
     * or Comprehend can create and train a new model.
     * </p>
     * <p>
     * When you create the flywheel, Comprehend creates a data lake in your account. The data lake holds the training
     * data and test data for all versions of the model.
     * </p>
     * <p>
     * To use a flywheel with an existing trained model, you specify the active model version. Comprehend copies the
     * model's training data and test data into the flywheel's data lake.
     * </p>
     * <p>
     * To use the flywheel with a new model, you need to provide a dataset for training data (and optional test data)
     * when you create the flywheel.
     * </p>
     * <p>
     * For more information about flywheels, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html"> Flywheel overview</a> in the
     * <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     *
     * @param createFlywheelRequest
     * @return A Java Future containing the result of the CreateFlywheel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceInUseException The specified resource name is already in use. Use a different name and try
     *         your request again.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceLimitExceededException The maximum number of resources per account has been exceeded. Review
     *         the resources, and then try your request again.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For a
     *         list of supported languages, <a
     *         href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported languages</a>
     *         in the Comprehend Developer Guide.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>ResourceUnavailableException The specified resource is not available. Check the resource and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.CreateFlywheel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateFlywheel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFlywheelResponse> createFlywheel(CreateFlywheelRequest createFlywheelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFlywheelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFlywheelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFlywheel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateFlywheelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateFlywheelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateFlywheelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFlywheelRequest, CreateFlywheelResponse>()
                            .withOperationName("CreateFlywheel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateFlywheelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createFlywheelRequest));
            CompletableFuture<CreateFlywheelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a previously created document classifier
     * </p>
     * <p>
     * Only those classifiers that are in terminated states (IN_ERROR, TRAINED) will be deleted. If an active inference
     * job is using the model, a <code>ResourceInUseException</code> will be returned.
     * </p>
     * <p>
     * This is an asynchronous action that puts the classifier into a DELETING state, and it is then removed by a
     * background job. Once removed, the classifier disappears from your account and is no longer available for use.
     * </p>
     *
     * @param deleteDocumentClassifierRequest
     * @return A Java Future containing the result of the DeleteDocumentClassifier operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>ResourceUnavailableException The specified resource is not available. Check the resource and try your
     *         request again.</li>
     *         <li>ResourceInUseException The specified resource name is already in use. Use a different name and try
     *         your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DeleteDocumentClassifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteDocumentClassifier"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDocumentClassifierResponse> deleteDocumentClassifier(
            DeleteDocumentClassifierRequest deleteDocumentClassifierRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDocumentClassifierRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDocumentClassifierRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDocumentClassifier");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDocumentClassifierResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDocumentClassifierResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteDocumentClassifierResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDocumentClassifierRequest, DeleteDocumentClassifierResponse>()
                            .withOperationName("DeleteDocumentClassifier").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteDocumentClassifierRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteDocumentClassifierRequest));
            CompletableFuture<DeleteDocumentClassifierResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a model-specific endpoint for a previously-trained custom model. All endpoints must be deleted in order
     * for the model to be deleted. For information about endpoints, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html">Managing endpoints</a>.
     * </p>
     *
     * @param deleteEndpointRequest
     * @return A Java Future containing the result of the DeleteEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceInUseException The specified resource name is already in use. Use a different name and try
     *         your request again.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DeleteEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEndpointResponse> deleteEndpoint(DeleteEndpointRequest deleteEndpointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteEndpointResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEndpointRequest, DeleteEndpointResponse>()
                            .withOperationName("DeleteEndpoint").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteEndpointRequest));
            CompletableFuture<DeleteEndpointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an entity recognizer.
     * </p>
     * <p>
     * Only those recognizers that are in terminated states (IN_ERROR, TRAINED) will be deleted. If an active inference
     * job is using the model, a <code>ResourceInUseException</code> will be returned.
     * </p>
     * <p>
     * This is an asynchronous action that puts the recognizer into a DELETING state, and it is then removed by a
     * background job. Once removed, the recognizer disappears from your account and is no longer available for use.
     * </p>
     *
     * @param deleteEntityRecognizerRequest
     * @return A Java Future containing the result of the DeleteEntityRecognizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>ResourceUnavailableException The specified resource is not available. Check the resource and try your
     *         request again.</li>
     *         <li>ResourceInUseException The specified resource name is already in use. Use a different name and try
     *         your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DeleteEntityRecognizer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteEntityRecognizer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEntityRecognizerResponse> deleteEntityRecognizer(
            DeleteEntityRecognizerRequest deleteEntityRecognizerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEntityRecognizerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEntityRecognizerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEntityRecognizer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteEntityRecognizerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteEntityRecognizerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteEntityRecognizerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEntityRecognizerRequest, DeleteEntityRecognizerResponse>()
                            .withOperationName("DeleteEntityRecognizer").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteEntityRecognizerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteEntityRecognizerRequest));
            CompletableFuture<DeleteEntityRecognizerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a flywheel. When you delete the flywheel, Amazon Comprehend does not delete the data lake or the model
     * associated with the flywheel.
     * </p>
     * <p>
     * For more information about flywheels, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html"> Flywheel overview</a> in the
     * <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     *
     * @param deleteFlywheelRequest
     * @return A Java Future containing the result of the DeleteFlywheel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>ResourceUnavailableException The specified resource is not available. Check the resource and try your
     *         request again.</li>
     *         <li>ResourceInUseException The specified resource name is already in use. Use a different name and try
     *         your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DeleteFlywheel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteFlywheel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFlywheelResponse> deleteFlywheel(DeleteFlywheelRequest deleteFlywheelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFlywheelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFlywheelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFlywheel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteFlywheelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteFlywheelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteFlywheelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFlywheelRequest, DeleteFlywheelResponse>()
                            .withOperationName("DeleteFlywheel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteFlywheelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteFlywheelRequest));
            CompletableFuture<DeleteFlywheelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a resource-based policy that is attached to a custom model.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return A Java Future containing the result of the DeleteResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(
            DeleteResourcePolicyRequest deleteResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteResourcePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteResourcePolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteResourcePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteResourcePolicyRequest, DeleteResourcePolicyResponse>()
                            .withOperationName("DeleteResourcePolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteResourcePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteResourcePolicyRequest));
            CompletableFuture<DeleteResourcePolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the dataset that you specify. For more information about datasets, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html"> Flywheel overview</a> in the
     * <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     *
     * @param describeDatasetRequest
     * @return A Java Future containing the result of the DescribeDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDataset" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDatasetResponse> describeDataset(DescribeDatasetRequest describeDatasetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDatasetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDatasetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDataset");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDatasetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDatasetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeDatasetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDatasetRequest, DescribeDatasetResponse>()
                            .withOperationName("DescribeDataset").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeDatasetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDatasetRequest));
            CompletableFuture<DescribeDatasetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the properties associated with a document classification job. Use this operation to get the status of a
     * classification job.
     * </p>
     *
     * @param describeDocumentClassificationJobRequest
     * @return A Java Future containing the result of the DescribeDocumentClassificationJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeDocumentClassificationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDocumentClassificationJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDocumentClassificationJobResponse> describeDocumentClassificationJob(
            DescribeDocumentClassificationJobRequest describeDocumentClassificationJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDocumentClassificationJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDocumentClassificationJobRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDocumentClassificationJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDocumentClassificationJobResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeDocumentClassificationJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeDocumentClassificationJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDocumentClassificationJobRequest, DescribeDocumentClassificationJobResponse>()
                            .withOperationName("DescribeDocumentClassificationJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeDocumentClassificationJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDocumentClassificationJobRequest));
            CompletableFuture<DescribeDocumentClassificationJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the properties associated with a document classifier.
     * </p>
     *
     * @param describeDocumentClassifierRequest
     * @return A Java Future containing the result of the DescribeDocumentClassifier operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeDocumentClassifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDocumentClassifier"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDocumentClassifierResponse> describeDocumentClassifier(
            DescribeDocumentClassifierRequest describeDocumentClassifierRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDocumentClassifierRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDocumentClassifierRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDocumentClassifier");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDocumentClassifierResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDocumentClassifierResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeDocumentClassifierResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDocumentClassifierRequest, DescribeDocumentClassifierResponse>()
                            .withOperationName("DescribeDocumentClassifier").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeDocumentClassifierRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDocumentClassifierRequest));
            CompletableFuture<DescribeDocumentClassifierResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the properties associated with a dominant language detection job. Use this operation to get the status of a
     * detection job.
     * </p>
     *
     * @param describeDominantLanguageDetectionJobRequest
     * @return A Java Future containing the result of the DescribeDominantLanguageDetectionJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeDominantLanguageDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDominantLanguageDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDominantLanguageDetectionJobResponse> describeDominantLanguageDetectionJob(
            DescribeDominantLanguageDetectionJobRequest describeDominantLanguageDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDominantLanguageDetectionJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDominantLanguageDetectionJobRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDominantLanguageDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDominantLanguageDetectionJobResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeDominantLanguageDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeDominantLanguageDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDominantLanguageDetectionJobRequest, DescribeDominantLanguageDetectionJobResponse>()
                            .withOperationName("DescribeDominantLanguageDetectionJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeDominantLanguageDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDominantLanguageDetectionJobRequest));
            CompletableFuture<DescribeDominantLanguageDetectionJobResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the properties associated with a specific endpoint. Use this operation to get the status of an endpoint. For
     * information about endpoints, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html">Managing endpoints</a>.
     * </p>
     *
     * @param describeEndpointRequest
     * @return A Java Future containing the result of the DescribeEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEndpointResponse> describeEndpoint(DescribeEndpointRequest describeEndpointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeEndpointResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEndpointRequest, DescribeEndpointResponse>()
                            .withOperationName("DescribeEndpoint").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeEndpointRequest));
            CompletableFuture<DescribeEndpointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the properties associated with an entities detection job. Use this operation to get the status of a
     * detection job.
     * </p>
     *
     * @param describeEntitiesDetectionJobRequest
     * @return A Java Future containing the result of the DescribeEntitiesDetectionJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeEntitiesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEntitiesDetectionJobResponse> describeEntitiesDetectionJob(
            DescribeEntitiesDetectionJobRequest describeEntitiesDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeEntitiesDetectionJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEntitiesDetectionJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEntitiesDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeEntitiesDetectionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeEntitiesDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeEntitiesDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEntitiesDetectionJobRequest, DescribeEntitiesDetectionJobResponse>()
                            .withOperationName("DescribeEntitiesDetectionJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeEntitiesDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeEntitiesDetectionJobRequest));
            CompletableFuture<DescribeEntitiesDetectionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides details about an entity recognizer including status, S3 buckets containing training data, recognizer
     * metadata, metrics, and so on.
     * </p>
     *
     * @param describeEntityRecognizerRequest
     * @return A Java Future containing the result of the DescribeEntityRecognizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeEntityRecognizer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEntityRecognizer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEntityRecognizerResponse> describeEntityRecognizer(
            DescribeEntityRecognizerRequest describeEntityRecognizerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeEntityRecognizerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEntityRecognizerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEntityRecognizer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeEntityRecognizerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeEntityRecognizerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeEntityRecognizerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEntityRecognizerRequest, DescribeEntityRecognizerResponse>()
                            .withOperationName("DescribeEntityRecognizer").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeEntityRecognizerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeEntityRecognizerRequest));
            CompletableFuture<DescribeEntityRecognizerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the status and details of an events detection job.
     * </p>
     *
     * @param describeEventsDetectionJobRequest
     * @return A Java Future containing the result of the DescribeEventsDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeEventsDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEventsDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEventsDetectionJobResponse> describeEventsDetectionJob(
            DescribeEventsDetectionJobRequest describeEventsDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeEventsDetectionJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEventsDetectionJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEventsDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeEventsDetectionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeEventsDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeEventsDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEventsDetectionJobRequest, DescribeEventsDetectionJobResponse>()
                            .withOperationName("DescribeEventsDetectionJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeEventsDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeEventsDetectionJobRequest));
            CompletableFuture<DescribeEventsDetectionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides configuration information about the flywheel. For more information about flywheels, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html"> Flywheel overview</a> in the
     * <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     *
     * @param describeFlywheelRequest
     * @return A Java Future containing the result of the DescribeFlywheel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeFlywheel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeFlywheel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFlywheelResponse> describeFlywheel(DescribeFlywheelRequest describeFlywheelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeFlywheelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFlywheelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFlywheel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeFlywheelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeFlywheelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeFlywheelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFlywheelRequest, DescribeFlywheelResponse>()
                            .withOperationName("DescribeFlywheel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeFlywheelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeFlywheelRequest));
            CompletableFuture<DescribeFlywheelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieve the configuration properties of a flywheel iteration. For more information about flywheels, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html"> Flywheel overview</a> in the
     * <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     *
     * @param describeFlywheelIterationRequest
     * @return A Java Future containing the result of the DescribeFlywheelIteration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeFlywheelIteration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeFlywheelIteration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFlywheelIterationResponse> describeFlywheelIteration(
            DescribeFlywheelIterationRequest describeFlywheelIterationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeFlywheelIterationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFlywheelIterationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFlywheelIteration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeFlywheelIterationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeFlywheelIterationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeFlywheelIterationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFlywheelIterationRequest, DescribeFlywheelIterationResponse>()
                            .withOperationName("DescribeFlywheelIteration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeFlywheelIterationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeFlywheelIterationRequest));
            CompletableFuture<DescribeFlywheelIterationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the properties associated with a key phrases detection job. Use this operation to get the status of a
     * detection job.
     * </p>
     *
     * @param describeKeyPhrasesDetectionJobRequest
     * @return A Java Future containing the result of the DescribeKeyPhrasesDetectionJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeKeyPhrasesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeKeyPhrasesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeKeyPhrasesDetectionJobResponse> describeKeyPhrasesDetectionJob(
            DescribeKeyPhrasesDetectionJobRequest describeKeyPhrasesDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeKeyPhrasesDetectionJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeKeyPhrasesDetectionJobRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeKeyPhrasesDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeKeyPhrasesDetectionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeKeyPhrasesDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeKeyPhrasesDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeKeyPhrasesDetectionJobRequest, DescribeKeyPhrasesDetectionJobResponse>()
                            .withOperationName("DescribeKeyPhrasesDetectionJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeKeyPhrasesDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeKeyPhrasesDetectionJobRequest));
            CompletableFuture<DescribeKeyPhrasesDetectionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the properties associated with a PII entities detection job. For example, you can use this operation to get
     * the job status.
     * </p>
     *
     * @param describePiiEntitiesDetectionJobRequest
     * @return A Java Future containing the result of the DescribePiiEntitiesDetectionJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribePiiEntitiesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribePiiEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribePiiEntitiesDetectionJobResponse> describePiiEntitiesDetectionJob(
            DescribePiiEntitiesDetectionJobRequest describePiiEntitiesDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describePiiEntitiesDetectionJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describePiiEntitiesDetectionJobRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePiiEntitiesDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribePiiEntitiesDetectionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribePiiEntitiesDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribePiiEntitiesDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribePiiEntitiesDetectionJobRequest, DescribePiiEntitiesDetectionJobResponse>()
                            .withOperationName("DescribePiiEntitiesDetectionJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribePiiEntitiesDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describePiiEntitiesDetectionJobRequest));
            CompletableFuture<DescribePiiEntitiesDetectionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the details of a resource-based policy that is attached to a custom model, including the JSON body of the
     * policy.
     * </p>
     *
     * @param describeResourcePolicyRequest
     * @return A Java Future containing the result of the DescribeResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeResourcePolicyResponse> describeResourcePolicy(
            DescribeResourcePolicyRequest describeResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeResourcePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeResourcePolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeResourcePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeResourcePolicyRequest, DescribeResourcePolicyResponse>()
                            .withOperationName("DescribeResourcePolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeResourcePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeResourcePolicyRequest));
            CompletableFuture<DescribeResourcePolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the properties associated with a sentiment detection job. Use this operation to get the status of a
     * detection job.
     * </p>
     *
     * @param describeSentimentDetectionJobRequest
     * @return A Java Future containing the result of the DescribeSentimentDetectionJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeSentimentDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeSentimentDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSentimentDetectionJobResponse> describeSentimentDetectionJob(
            DescribeSentimentDetectionJobRequest describeSentimentDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeSentimentDetectionJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeSentimentDetectionJobRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSentimentDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeSentimentDetectionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeSentimentDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeSentimentDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeSentimentDetectionJobRequest, DescribeSentimentDetectionJobResponse>()
                            .withOperationName("DescribeSentimentDetectionJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeSentimentDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeSentimentDetectionJobRequest));
            CompletableFuture<DescribeSentimentDetectionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the properties associated with a targeted sentiment detection job. Use this operation to get the status of
     * the job.
     * </p>
     *
     * @param describeTargetedSentimentDetectionJobRequest
     * @return A Java Future containing the result of the DescribeTargetedSentimentDetectionJob operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeTargetedSentimentDetectionJob
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeTargetedSentimentDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTargetedSentimentDetectionJobResponse> describeTargetedSentimentDetectionJob(
            DescribeTargetedSentimentDetectionJobRequest describeTargetedSentimentDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeTargetedSentimentDetectionJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeTargetedSentimentDetectionJobRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTargetedSentimentDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeTargetedSentimentDetectionJobResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeTargetedSentimentDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeTargetedSentimentDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTargetedSentimentDetectionJobRequest, DescribeTargetedSentimentDetectionJobResponse>()
                            .withOperationName("DescribeTargetedSentimentDetectionJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeTargetedSentimentDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeTargetedSentimentDetectionJobRequest));
            CompletableFuture<DescribeTargetedSentimentDetectionJobResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the properties associated with a topic detection job. Use this operation to get the status of a detection
     * job.
     * </p>
     *
     * @param describeTopicsDetectionJobRequest
     * @return A Java Future containing the result of the DescribeTopicsDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeTopicsDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeTopicsDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTopicsDetectionJobResponse> describeTopicsDetectionJob(
            DescribeTopicsDetectionJobRequest describeTopicsDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeTopicsDetectionJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTopicsDetectionJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTopicsDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeTopicsDetectionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeTopicsDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeTopicsDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTopicsDetectionJobRequest, DescribeTopicsDetectionJobResponse>()
                            .withOperationName("DescribeTopicsDetectionJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeTopicsDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeTopicsDetectionJobRequest));
            CompletableFuture<DescribeTopicsDetectionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Determines the dominant language of the input text. For a list of languages that Amazon Comprehend can detect,
     * see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html">Amazon Comprehend Supported
     * Languages</a>.
     * </p>
     *
     * @param detectDominantLanguageRequest
     * @return A Java Future containing the result of the DetectDominantLanguage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DetectDominantLanguage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectDominantLanguage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DetectDominantLanguageResponse> detectDominantLanguage(
            DetectDominantLanguageRequest detectDominantLanguageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(detectDominantLanguageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detectDominantLanguageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetectDominantLanguage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DetectDominantLanguageResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DetectDominantLanguageResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DetectDominantLanguageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetectDominantLanguageRequest, DetectDominantLanguageResponse>()
                            .withOperationName("DetectDominantLanguage").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DetectDominantLanguageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(detectDominantLanguageRequest));
            CompletableFuture<DetectDominantLanguageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Detects named entities in input text when you use the pre-trained model. Detects custom entities if you have a
     * custom entity recognition model.
     * </p>
     * <p>
     * When detecting named entities using the pre-trained model, use plain text as the input. For more information
     * about named entities, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/how-entities.html">Entities</a> in the Comprehend
     * Developer Guide.
     * </p>
     * <p>
     * When you use a custom entity recognition model, you can input plain text or you can upload a single-page input
     * document (text, PDF, Word, or image).
     * </p>
     * <p>
     * If the system detects errors while processing a page in the input document, the API response includes an entry in
     * <code>Errors</code> for each error.
     * </p>
     * <p>
     * If the system detects a document-level error in your input document, the API returns an
     * <code>InvalidRequestException</code> error response. For details about this exception, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/idp-inputs-sync-err.html"> Errors in semi-structured
     * documents</a> in the Comprehend Developer Guide.
     * </p>
     *
     * @param detectEntitiesRequest
     * @return A Java Future containing the result of the DetectEntities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceUnavailableException The specified resource is not available. Check the resource and try your
     *         request again.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For a
     *         list of supported languages, <a
     *         href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported languages</a>
     *         in the Comprehend Developer Guide.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DetectEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectEntities" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DetectEntitiesResponse> detectEntities(DetectEntitiesRequest detectEntitiesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(detectEntitiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detectEntitiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetectEntities");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DetectEntitiesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DetectEntitiesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DetectEntitiesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetectEntitiesRequest, DetectEntitiesResponse>()
                            .withOperationName("DetectEntities").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DetectEntitiesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(detectEntitiesRequest));
            CompletableFuture<DetectEntitiesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Detects the key noun phrases found in the text.
     * </p>
     *
     * @param detectKeyPhrasesRequest
     * @return A Java Future containing the result of the DetectKeyPhrases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For a
     *         list of supported languages, <a
     *         href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported languages</a>
     *         in the Comprehend Developer Guide.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DetectKeyPhrases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectKeyPhrases" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DetectKeyPhrasesResponse> detectKeyPhrases(DetectKeyPhrasesRequest detectKeyPhrasesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(detectKeyPhrasesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detectKeyPhrasesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetectKeyPhrases");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DetectKeyPhrasesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DetectKeyPhrasesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DetectKeyPhrasesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetectKeyPhrasesRequest, DetectKeyPhrasesResponse>()
                            .withOperationName("DetectKeyPhrases").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DetectKeyPhrasesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(detectKeyPhrasesRequest));
            CompletableFuture<DetectKeyPhrasesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Inspects the input text for entities that contain personally identifiable information (PII) and returns
     * information about them.
     * </p>
     *
     * @param detectPiiEntitiesRequest
     * @return A Java Future containing the result of the DetectPiiEntities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For a
     *         list of supported languages, <a
     *         href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported languages</a>
     *         in the Comprehend Developer Guide.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DetectPiiEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectPiiEntities" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DetectPiiEntitiesResponse> detectPiiEntities(DetectPiiEntitiesRequest detectPiiEntitiesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(detectPiiEntitiesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detectPiiEntitiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetectPiiEntities");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DetectPiiEntitiesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DetectPiiEntitiesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DetectPiiEntitiesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetectPiiEntitiesRequest, DetectPiiEntitiesResponse>()
                            .withOperationName("DetectPiiEntities").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DetectPiiEntitiesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(detectPiiEntitiesRequest));
            CompletableFuture<DetectPiiEntitiesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Inspects text and returns an inference of the prevailing sentiment (<code>POSITIVE</code>, <code>NEUTRAL</code>,
     * <code>MIXED</code>, or <code>NEGATIVE</code>).
     * </p>
     *
     * @param detectSentimentRequest
     * @return A Java Future containing the result of the DetectSentiment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For a
     *         list of supported languages, <a
     *         href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported languages</a>
     *         in the Comprehend Developer Guide.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DetectSentiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectSentiment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DetectSentimentResponse> detectSentiment(DetectSentimentRequest detectSentimentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(detectSentimentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detectSentimentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetectSentiment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DetectSentimentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DetectSentimentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DetectSentimentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetectSentimentRequest, DetectSentimentResponse>()
                            .withOperationName("DetectSentiment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DetectSentimentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(detectSentimentRequest));
            CompletableFuture<DetectSentimentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Inspects text for syntax and the part of speech of words in the document. For more information, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/how-syntax.html">Syntax</a> in the Comprehend Developer
     * Guide.
     * </p>
     *
     * @param detectSyntaxRequest
     * @return A Java Future containing the result of the DetectSyntax operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For a
     *         list of supported languages, <a
     *         href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported languages</a>
     *         in the Comprehend Developer Guide.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DetectSyntax
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectSyntax" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DetectSyntaxResponse> detectSyntax(DetectSyntaxRequest detectSyntaxRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(detectSyntaxRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detectSyntaxRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetectSyntax");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DetectSyntaxResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DetectSyntaxResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DetectSyntaxResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetectSyntaxRequest, DetectSyntaxResponse>()
                            .withOperationName("DetectSyntax").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DetectSyntaxRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(detectSyntaxRequest));
            CompletableFuture<DetectSyntaxResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Inspects the input text and returns a sentiment analysis for each entity identified in the text.
     * </p>
     * <p>
     * For more information about targeted sentiment, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/how-targeted-sentiment.html">Targeted sentiment</a> in the
     * <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     *
     * @param detectTargetedSentimentRequest
     * @return A Java Future containing the result of the DetectTargetedSentiment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For a
     *         list of supported languages, <a
     *         href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported languages</a>
     *         in the Comprehend Developer Guide.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DetectTargetedSentiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectTargetedSentiment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DetectTargetedSentimentResponse> detectTargetedSentiment(
            DetectTargetedSentimentRequest detectTargetedSentimentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(detectTargetedSentimentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detectTargetedSentimentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetectTargetedSentiment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DetectTargetedSentimentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DetectTargetedSentimentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DetectTargetedSentimentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetectTargetedSentimentRequest, DetectTargetedSentimentResponse>()
                            .withOperationName("DetectTargetedSentiment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DetectTargetedSentimentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(detectTargetedSentimentRequest));
            CompletableFuture<DetectTargetedSentimentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Performs toxicity analysis on the list of text strings that you provide as input. The API response contains a
     * results list that matches the size of the input list. For more information about toxicity detection, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/toxicity-detection.html">Toxicity detection</a> in the
     * <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     *
     * @param detectToxicContentRequest
     * @return A Java Future containing the result of the DetectToxicContent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For a
     *         list of supported languages, <a
     *         href="https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html">Supported languages</a>
     *         in the Comprehend Developer Guide.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DetectToxicContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectToxicContent" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DetectToxicContentResponse> detectToxicContent(DetectToxicContentRequest detectToxicContentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(detectToxicContentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detectToxicContentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetectToxicContent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DetectToxicContentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DetectToxicContentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DetectToxicContentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetectToxicContentRequest, DetectToxicContentResponse>()
                            .withOperationName("DetectToxicContent").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DetectToxicContentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(detectToxicContentRequest));
            CompletableFuture<DetectToxicContentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new custom model that replicates a source custom model that you import. The source model can be in your
     * Amazon Web Services account or another one.
     * </p>
     * <p>
     * If the source model is in another Amazon Web Services account, then it must have a resource-based policy that
     * authorizes you to import it.
     * </p>
     * <p>
     * The source model must be in the same Amazon Web Services Region that you're using when you import. You can't
     * import a model that's in a different Region.
     * </p>
     *
     * @param importModelRequest
     * @return A Java Future containing the result of the ImportModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>ResourceInUseException The specified resource name is already in use. Use a different name and try
     *         your request again.</li>
     *         <li>ResourceUnavailableException The specified resource is not available. Check the resource and try your
     *         request again.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceLimitExceededException The maximum number of resources per account has been exceeded. Review
     *         the resources, and then try your request again.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ImportModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ImportModel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ImportModelResponse> importModel(ImportModelRequest importModelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(importModelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, importModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ImportModelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ImportModelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ImportModelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ImportModelRequest, ImportModelResponse>()
                            .withOperationName("ImportModel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ImportModelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(importModelRequest));
            CompletableFuture<ImportModelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List the datasets that you have configured in this Region. For more information about datasets, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html"> Flywheel overview</a> in the
     * <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     *
     * @param listDatasetsRequest
     * @return A Java Future containing the result of the ListDatasets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDatasets" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListDatasetsResponse> listDatasets(ListDatasetsRequest listDatasetsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDatasetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDatasetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDatasets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDatasetsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListDatasetsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListDatasetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDatasetsRequest, ListDatasetsResponse>()
                            .withOperationName("ListDatasets").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListDatasetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDatasetsRequest));
            CompletableFuture<ListDatasetsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of the documentation classification jobs that you have submitted.
     * </p>
     *
     * @param listDocumentClassificationJobsRequest
     * @return A Java Future containing the result of the ListDocumentClassificationJobs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListDocumentClassificationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassificationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDocumentClassificationJobsResponse> listDocumentClassificationJobs(
            ListDocumentClassificationJobsRequest listDocumentClassificationJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDocumentClassificationJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listDocumentClassificationJobsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDocumentClassificationJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDocumentClassificationJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDocumentClassificationJobsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListDocumentClassificationJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDocumentClassificationJobsRequest, ListDocumentClassificationJobsResponse>()
                            .withOperationName("ListDocumentClassificationJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListDocumentClassificationJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDocumentClassificationJobsRequest));
            CompletableFuture<ListDocumentClassificationJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of summaries of the document classifiers that you have created
     * </p>
     *
     * @param listDocumentClassifierSummariesRequest
     * @return A Java Future containing the result of the ListDocumentClassifierSummaries operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListDocumentClassifierSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassifierSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDocumentClassifierSummariesResponse> listDocumentClassifierSummaries(
            ListDocumentClassifierSummariesRequest listDocumentClassifierSummariesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDocumentClassifierSummariesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listDocumentClassifierSummariesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDocumentClassifierSummaries");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDocumentClassifierSummariesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDocumentClassifierSummariesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListDocumentClassifierSummariesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDocumentClassifierSummariesRequest, ListDocumentClassifierSummariesResponse>()
                            .withOperationName("ListDocumentClassifierSummaries").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListDocumentClassifierSummariesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDocumentClassifierSummariesRequest));
            CompletableFuture<ListDocumentClassifierSummariesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of the document classifiers that you have created.
     * </p>
     *
     * @param listDocumentClassifiersRequest
     * @return A Java Future containing the result of the ListDocumentClassifiers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListDocumentClassifiers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassifiers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDocumentClassifiersResponse> listDocumentClassifiers(
            ListDocumentClassifiersRequest listDocumentClassifiersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDocumentClassifiersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDocumentClassifiersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDocumentClassifiers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDocumentClassifiersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDocumentClassifiersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListDocumentClassifiersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDocumentClassifiersRequest, ListDocumentClassifiersResponse>()
                            .withOperationName("ListDocumentClassifiers").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListDocumentClassifiersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDocumentClassifiersRequest));
            CompletableFuture<ListDocumentClassifiersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of the dominant language detection jobs that you have submitted.
     * </p>
     *
     * @param listDominantLanguageDetectionJobsRequest
     * @return A Java Future containing the result of the ListDominantLanguageDetectionJobs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListDominantLanguageDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDominantLanguageDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDominantLanguageDetectionJobsResponse> listDominantLanguageDetectionJobs(
            ListDominantLanguageDetectionJobsRequest listDominantLanguageDetectionJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDominantLanguageDetectionJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listDominantLanguageDetectionJobsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDominantLanguageDetectionJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDominantLanguageDetectionJobsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListDominantLanguageDetectionJobsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListDominantLanguageDetectionJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDominantLanguageDetectionJobsRequest, ListDominantLanguageDetectionJobsResponse>()
                            .withOperationName("ListDominantLanguageDetectionJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListDominantLanguageDetectionJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDominantLanguageDetectionJobsRequest));
            CompletableFuture<ListDominantLanguageDetectionJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of all existing endpoints that you've created. For information about endpoints, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html">Managing endpoints</a>.
     * </p>
     *
     * @param listEndpointsRequest
     * @return A Java Future containing the result of the ListEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListEndpointsResponse> listEndpoints(ListEndpointsRequest listEndpointsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listEndpointsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEndpointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEndpoints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListEndpointsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListEndpointsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListEndpointsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListEndpointsRequest, ListEndpointsResponse>()
                            .withOperationName("ListEndpoints").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListEndpointsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listEndpointsRequest));
            CompletableFuture<ListEndpointsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of the entity detection jobs that you have submitted.
     * </p>
     *
     * @param listEntitiesDetectionJobsRequest
     * @return A Java Future containing the result of the ListEntitiesDetectionJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListEntitiesDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntitiesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListEntitiesDetectionJobsResponse> listEntitiesDetectionJobs(
            ListEntitiesDetectionJobsRequest listEntitiesDetectionJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listEntitiesDetectionJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEntitiesDetectionJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEntitiesDetectionJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListEntitiesDetectionJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListEntitiesDetectionJobsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListEntitiesDetectionJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListEntitiesDetectionJobsRequest, ListEntitiesDetectionJobsResponse>()
                            .withOperationName("ListEntitiesDetectionJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListEntitiesDetectionJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listEntitiesDetectionJobsRequest));
            CompletableFuture<ListEntitiesDetectionJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of summaries for the entity recognizers that you have created.
     * </p>
     *
     * @param listEntityRecognizerSummariesRequest
     * @return A Java Future containing the result of the ListEntityRecognizerSummaries operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListEntityRecognizerSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntityRecognizerSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListEntityRecognizerSummariesResponse> listEntityRecognizerSummaries(
            ListEntityRecognizerSummariesRequest listEntityRecognizerSummariesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listEntityRecognizerSummariesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listEntityRecognizerSummariesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEntityRecognizerSummaries");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListEntityRecognizerSummariesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListEntityRecognizerSummariesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListEntityRecognizerSummariesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListEntityRecognizerSummariesRequest, ListEntityRecognizerSummariesResponse>()
                            .withOperationName("ListEntityRecognizerSummaries").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListEntityRecognizerSummariesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listEntityRecognizerSummariesRequest));
            CompletableFuture<ListEntityRecognizerSummariesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of the properties of all entity recognizers that you created, including recognizers currently in
     * training. Allows you to filter the list of recognizers based on criteria such as status and submission time. This
     * call returns up to 500 entity recognizers in the list, with a default number of 100 recognizers in the list.
     * </p>
     * <p>
     * The results of this list are not in any particular order. Please get the list and sort locally if needed.
     * </p>
     *
     * @param listEntityRecognizersRequest
     * @return A Java Future containing the result of the ListEntityRecognizers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListEntityRecognizers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntityRecognizers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListEntityRecognizersResponse> listEntityRecognizers(
            ListEntityRecognizersRequest listEntityRecognizersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listEntityRecognizersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEntityRecognizersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEntityRecognizers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListEntityRecognizersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListEntityRecognizersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListEntityRecognizersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListEntityRecognizersRequest, ListEntityRecognizersResponse>()
                            .withOperationName("ListEntityRecognizers").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListEntityRecognizersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listEntityRecognizersRequest));
            CompletableFuture<ListEntityRecognizersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of the events detection jobs that you have submitted.
     * </p>
     *
     * @param listEventsDetectionJobsRequest
     * @return A Java Future containing the result of the ListEventsDetectionJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListEventsDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEventsDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListEventsDetectionJobsResponse> listEventsDetectionJobs(
            ListEventsDetectionJobsRequest listEventsDetectionJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listEventsDetectionJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEventsDetectionJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEventsDetectionJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListEventsDetectionJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListEventsDetectionJobsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListEventsDetectionJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListEventsDetectionJobsRequest, ListEventsDetectionJobsResponse>()
                            .withOperationName("ListEventsDetectionJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListEventsDetectionJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listEventsDetectionJobsRequest));
            CompletableFuture<ListEventsDetectionJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Information about the history of a flywheel iteration. For more information about flywheels, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html"> Flywheel overview</a> in the
     * <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     *
     * @param listFlywheelIterationHistoryRequest
     * @return A Java Future containing the result of the ListFlywheelIterationHistory operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListFlywheelIterationHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListFlywheelIterationHistory"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListFlywheelIterationHistoryResponse> listFlywheelIterationHistory(
            ListFlywheelIterationHistoryRequest listFlywheelIterationHistoryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFlywheelIterationHistoryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFlywheelIterationHistoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFlywheelIterationHistory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFlywheelIterationHistoryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListFlywheelIterationHistoryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListFlywheelIterationHistoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFlywheelIterationHistoryRequest, ListFlywheelIterationHistoryResponse>()
                            .withOperationName("ListFlywheelIterationHistory").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListFlywheelIterationHistoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listFlywheelIterationHistoryRequest));
            CompletableFuture<ListFlywheelIterationHistoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of the flywheels that you have created.
     * </p>
     *
     * @param listFlywheelsRequest
     * @return A Java Future containing the result of the ListFlywheels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListFlywheels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListFlywheels" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListFlywheelsResponse> listFlywheels(ListFlywheelsRequest listFlywheelsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFlywheelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFlywheelsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFlywheels");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFlywheelsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListFlywheelsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListFlywheelsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFlywheelsRequest, ListFlywheelsResponse>()
                            .withOperationName("ListFlywheels").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListFlywheelsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listFlywheelsRequest));
            CompletableFuture<ListFlywheelsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get a list of key phrase detection jobs that you have submitted.
     * </p>
     *
     * @param listKeyPhrasesDetectionJobsRequest
     * @return A Java Future containing the result of the ListKeyPhrasesDetectionJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListKeyPhrasesDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListKeyPhrasesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListKeyPhrasesDetectionJobsResponse> listKeyPhrasesDetectionJobs(
            ListKeyPhrasesDetectionJobsRequest listKeyPhrasesDetectionJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listKeyPhrasesDetectionJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listKeyPhrasesDetectionJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListKeyPhrasesDetectionJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListKeyPhrasesDetectionJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListKeyPhrasesDetectionJobsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListKeyPhrasesDetectionJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListKeyPhrasesDetectionJobsRequest, ListKeyPhrasesDetectionJobsResponse>()
                            .withOperationName("ListKeyPhrasesDetectionJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListKeyPhrasesDetectionJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listKeyPhrasesDetectionJobsRequest));
            CompletableFuture<ListKeyPhrasesDetectionJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of the PII entity detection jobs that you have submitted.
     * </p>
     *
     * @param listPiiEntitiesDetectionJobsRequest
     * @return A Java Future containing the result of the ListPiiEntitiesDetectionJobs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListPiiEntitiesDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListPiiEntitiesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListPiiEntitiesDetectionJobsResponse> listPiiEntitiesDetectionJobs(
            ListPiiEntitiesDetectionJobsRequest listPiiEntitiesDetectionJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listPiiEntitiesDetectionJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPiiEntitiesDetectionJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPiiEntitiesDetectionJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListPiiEntitiesDetectionJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListPiiEntitiesDetectionJobsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListPiiEntitiesDetectionJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListPiiEntitiesDetectionJobsRequest, ListPiiEntitiesDetectionJobsResponse>()
                            .withOperationName("ListPiiEntitiesDetectionJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListPiiEntitiesDetectionJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listPiiEntitiesDetectionJobsRequest));
            CompletableFuture<ListPiiEntitiesDetectionJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of sentiment detection jobs that you have submitted.
     * </p>
     *
     * @param listSentimentDetectionJobsRequest
     * @return A Java Future containing the result of the ListSentimentDetectionJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListSentimentDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListSentimentDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListSentimentDetectionJobsResponse> listSentimentDetectionJobs(
            ListSentimentDetectionJobsRequest listSentimentDetectionJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSentimentDetectionJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSentimentDetectionJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSentimentDetectionJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSentimentDetectionJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListSentimentDetectionJobsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListSentimentDetectionJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSentimentDetectionJobsRequest, ListSentimentDetectionJobsResponse>()
                            .withOperationName("ListSentimentDetectionJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListSentimentDetectionJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listSentimentDetectionJobsRequest));
            CompletableFuture<ListSentimentDetectionJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all tags associated with a given Amazon Comprehend resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of targeted sentiment detection jobs that you have submitted.
     * </p>
     *
     * @param listTargetedSentimentDetectionJobsRequest
     * @return A Java Future containing the result of the ListTargetedSentimentDetectionJobs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListTargetedSentimentDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTargetedSentimentDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTargetedSentimentDetectionJobsResponse> listTargetedSentimentDetectionJobs(
            ListTargetedSentimentDetectionJobsRequest listTargetedSentimentDetectionJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTargetedSentimentDetectionJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listTargetedSentimentDetectionJobsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTargetedSentimentDetectionJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTargetedSentimentDetectionJobsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListTargetedSentimentDetectionJobsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListTargetedSentimentDetectionJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTargetedSentimentDetectionJobsRequest, ListTargetedSentimentDetectionJobsResponse>()
                            .withOperationName("ListTargetedSentimentDetectionJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTargetedSentimentDetectionJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTargetedSentimentDetectionJobsRequest));
            CompletableFuture<ListTargetedSentimentDetectionJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of the topic detection jobs that you have submitted.
     * </p>
     *
     * @param listTopicsDetectionJobsRequest
     * @return A Java Future containing the result of the ListTopicsDetectionJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListTopicsDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTopicsDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTopicsDetectionJobsResponse> listTopicsDetectionJobs(
            ListTopicsDetectionJobsRequest listTopicsDetectionJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTopicsDetectionJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTopicsDetectionJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTopicsDetectionJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTopicsDetectionJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTopicsDetectionJobsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListTopicsDetectionJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTopicsDetectionJobsRequest, ListTopicsDetectionJobsResponse>()
                            .withOperationName("ListTopicsDetectionJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTopicsDetectionJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTopicsDetectionJobsRequest));
            CompletableFuture<ListTopicsDetectionJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches a resource-based policy to a custom model. You can use this policy to authorize an entity in another
     * Amazon Web Services account to import the custom model, which replicates it in Amazon Comprehend in their
     * account.
     * </p>
     *
     * @param putResourcePolicyRequest
     * @return A Java Future containing the result of the PutResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/PutResourcePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<PutResourcePolicyResponse> putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putResourcePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutResourcePolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<PutResourcePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutResourcePolicyRequest, PutResourcePolicyResponse>()
                            .withOperationName("PutResourcePolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutResourcePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putResourcePolicyRequest));
            CompletableFuture<PutResourcePolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts an asynchronous document classification job using a custom classification model. Use the
     * <code>DescribeDocumentClassificationJob</code> operation to track the progress of the job.
     * </p>
     *
     * @param startDocumentClassificationJobRequest
     * @return A Java Future containing the result of the StartDocumentClassificationJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>ResourceUnavailableException The specified resource is not available. Check the resource and try your
     *         request again.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>ResourceInUseException The specified resource name is already in use. Use a different name and try
     *         your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StartDocumentClassificationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartDocumentClassificationJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartDocumentClassificationJobResponse> startDocumentClassificationJob(
            StartDocumentClassificationJobRequest startDocumentClassificationJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startDocumentClassificationJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                startDocumentClassificationJobRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartDocumentClassificationJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartDocumentClassificationJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartDocumentClassificationJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StartDocumentClassificationJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartDocumentClassificationJobRequest, StartDocumentClassificationJobResponse>()
                            .withOperationName("StartDocumentClassificationJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartDocumentClassificationJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startDocumentClassificationJobRequest));
            CompletableFuture<StartDocumentClassificationJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts an asynchronous dominant language detection job for a collection of documents. Use the operation to track
     * the status of a job.
     * </p>
     *
     * @param startDominantLanguageDetectionJobRequest
     * @return A Java Future containing the result of the StartDominantLanguageDetectionJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>ResourceInUseException The specified resource name is already in use. Use a different name and try
     *         your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StartDominantLanguageDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartDominantLanguageDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartDominantLanguageDetectionJobResponse> startDominantLanguageDetectionJob(
            StartDominantLanguageDetectionJobRequest startDominantLanguageDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startDominantLanguageDetectionJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                startDominantLanguageDetectionJobRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartDominantLanguageDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartDominantLanguageDetectionJobResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, StartDominantLanguageDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StartDominantLanguageDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartDominantLanguageDetectionJobRequest, StartDominantLanguageDetectionJobResponse>()
                            .withOperationName("StartDominantLanguageDetectionJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartDominantLanguageDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startDominantLanguageDetectionJobRequest));
            CompletableFuture<StartDominantLanguageDetectionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts an asynchronous entity detection job for a collection of documents. Use the operation to track the status
     * of a job.
     * </p>
     * <p>
     * This API can be used for either standard entity detection or custom entity recognition. In order to be used for
     * custom entity recognition, the optional <code>EntityRecognizerArn</code> must be used in order to provide access
     * to the recognizer being used to detect the custom entity.
     * </p>
     *
     * @param startEntitiesDetectionJobRequest
     * @return A Java Future containing the result of the StartEntitiesDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>ResourceUnavailableException The specified resource is not available. Check the resource and try your
     *         request again.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>ResourceInUseException The specified resource name is already in use. Use a different name and try
     *         your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StartEntitiesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartEntitiesDetectionJobResponse> startEntitiesDetectionJob(
            StartEntitiesDetectionJobRequest startEntitiesDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startEntitiesDetectionJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startEntitiesDetectionJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartEntitiesDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartEntitiesDetectionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartEntitiesDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StartEntitiesDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartEntitiesDetectionJobRequest, StartEntitiesDetectionJobResponse>()
                            .withOperationName("StartEntitiesDetectionJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartEntitiesDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startEntitiesDetectionJobRequest));
            CompletableFuture<StartEntitiesDetectionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts an asynchronous event detection job for a collection of documents.
     * </p>
     *
     * @param startEventsDetectionJobRequest
     * @return A Java Future containing the result of the StartEventsDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>ResourceInUseException The specified resource name is already in use. Use a different name and try
     *         your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StartEventsDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartEventsDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartEventsDetectionJobResponse> startEventsDetectionJob(
            StartEventsDetectionJobRequest startEventsDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startEventsDetectionJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startEventsDetectionJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartEventsDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartEventsDetectionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartEventsDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StartEventsDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartEventsDetectionJobRequest, StartEventsDetectionJobResponse>()
                            .withOperationName("StartEventsDetectionJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartEventsDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startEventsDetectionJobRequest));
            CompletableFuture<StartEventsDetectionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Start the flywheel iteration.This operation uses any new datasets to train a new model version. For more
     * information about flywheels, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html">
     * Flywheel overview</a> in the <i>Amazon Comprehend Developer Guide</i>.
     * </p>
     *
     * @param startFlywheelIterationRequest
     * @return A Java Future containing the result of the StartFlywheelIteration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceInUseException The specified resource name is already in use. Use a different name and try
     *         your request again.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StartFlywheelIteration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartFlywheelIteration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartFlywheelIterationResponse> startFlywheelIteration(
            StartFlywheelIterationRequest startFlywheelIterationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startFlywheelIterationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startFlywheelIterationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartFlywheelIteration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartFlywheelIterationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartFlywheelIterationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StartFlywheelIterationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartFlywheelIterationRequest, StartFlywheelIterationResponse>()
                            .withOperationName("StartFlywheelIteration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartFlywheelIterationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startFlywheelIterationRequest));
            CompletableFuture<StartFlywheelIterationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts an asynchronous key phrase detection job for a collection of documents. Use the operation to track the
     * status of a job.
     * </p>
     *
     * @param startKeyPhrasesDetectionJobRequest
     * @return A Java Future containing the result of the StartKeyPhrasesDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>ResourceInUseException The specified resource name is already in use. Use a different name and try
     *         your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StartKeyPhrasesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartKeyPhrasesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartKeyPhrasesDetectionJobResponse> startKeyPhrasesDetectionJob(
            StartKeyPhrasesDetectionJobRequest startKeyPhrasesDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startKeyPhrasesDetectionJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startKeyPhrasesDetectionJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartKeyPhrasesDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartKeyPhrasesDetectionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartKeyPhrasesDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StartKeyPhrasesDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartKeyPhrasesDetectionJobRequest, StartKeyPhrasesDetectionJobResponse>()
                            .withOperationName("StartKeyPhrasesDetectionJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartKeyPhrasesDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startKeyPhrasesDetectionJobRequest));
            CompletableFuture<StartKeyPhrasesDetectionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts an asynchronous PII entity detection job for a collection of documents.
     * </p>
     *
     * @param startPiiEntitiesDetectionJobRequest
     * @return A Java Future containing the result of the StartPiiEntitiesDetectionJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>ResourceInUseException The specified resource name is already in use. Use a different name and try
     *         your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StartPiiEntitiesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartPiiEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartPiiEntitiesDetectionJobResponse> startPiiEntitiesDetectionJob(
            StartPiiEntitiesDetectionJobRequest startPiiEntitiesDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startPiiEntitiesDetectionJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startPiiEntitiesDetectionJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartPiiEntitiesDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartPiiEntitiesDetectionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartPiiEntitiesDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StartPiiEntitiesDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartPiiEntitiesDetectionJobRequest, StartPiiEntitiesDetectionJobResponse>()
                            .withOperationName("StartPiiEntitiesDetectionJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartPiiEntitiesDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startPiiEntitiesDetectionJobRequest));
            CompletableFuture<StartPiiEntitiesDetectionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts an asynchronous sentiment detection job for a collection of documents. Use the operation to track the
     * status of a job.
     * </p>
     *
     * @param startSentimentDetectionJobRequest
     * @return A Java Future containing the result of the StartSentimentDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>ResourceInUseException The specified resource name is already in use. Use a different name and try
     *         your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StartSentimentDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartSentimentDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartSentimentDetectionJobResponse> startSentimentDetectionJob(
            StartSentimentDetectionJobRequest startSentimentDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startSentimentDetectionJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startSentimentDetectionJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartSentimentDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartSentimentDetectionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartSentimentDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StartSentimentDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartSentimentDetectionJobRequest, StartSentimentDetectionJobResponse>()
                            .withOperationName("StartSentimentDetectionJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartSentimentDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startSentimentDetectionJobRequest));
            CompletableFuture<StartSentimentDetectionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts an asynchronous targeted sentiment detection job for a collection of documents. Use the
     * <code>DescribeTargetedSentimentDetectionJob</code> operation to track the status of a job.
     * </p>
     *
     * @param startTargetedSentimentDetectionJobRequest
     * @return A Java Future containing the result of the StartTargetedSentimentDetectionJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>ResourceInUseException The specified resource name is already in use. Use a different name and try
     *         your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StartTargetedSentimentDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartTargetedSentimentDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartTargetedSentimentDetectionJobResponse> startTargetedSentimentDetectionJob(
            StartTargetedSentimentDetectionJobRequest startTargetedSentimentDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startTargetedSentimentDetectionJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                startTargetedSentimentDetectionJobRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartTargetedSentimentDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartTargetedSentimentDetectionJobResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, StartTargetedSentimentDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StartTargetedSentimentDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartTargetedSentimentDetectionJobRequest, StartTargetedSentimentDetectionJobResponse>()
                            .withOperationName("StartTargetedSentimentDetectionJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartTargetedSentimentDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startTargetedSentimentDetectionJobRequest));
            CompletableFuture<StartTargetedSentimentDetectionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts an asynchronous topic detection job. Use the <code>DescribeTopicDetectionJob</code> operation to track the
     * status of a job.
     * </p>
     *
     * @param startTopicsDetectionJobRequest
     * @return A Java Future containing the result of the StartTopicsDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>ResourceInUseException The specified resource name is already in use. Use a different name and try
     *         your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StartTopicsDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartTopicsDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartTopicsDetectionJobResponse> startTopicsDetectionJob(
            StartTopicsDetectionJobRequest startTopicsDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startTopicsDetectionJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startTopicsDetectionJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartTopicsDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartTopicsDetectionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartTopicsDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StartTopicsDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartTopicsDetectionJobRequest, StartTopicsDetectionJobResponse>()
                            .withOperationName("StartTopicsDetectionJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartTopicsDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startTopicsDetectionJobRequest));
            CompletableFuture<StartTopicsDetectionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops a dominant language detection job in progress.
     * </p>
     * <p>
     * If the job state is <code>IN_PROGRESS</code> the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the
     * <code>COMPLETED</code> state; otherwise the job is stopped and put into the <code>STOPPED</code> state.
     * </p>
     * <p>
     * If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the
     * <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception.
     * </p>
     * <p>
     * When a job is stopped, any documents already processed are written to the output location.
     * </p>
     *
     * @param stopDominantLanguageDetectionJobRequest
     * @return A Java Future containing the result of the StopDominantLanguageDetectionJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StopDominantLanguageDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopDominantLanguageDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StopDominantLanguageDetectionJobResponse> stopDominantLanguageDetectionJob(
            StopDominantLanguageDetectionJobRequest stopDominantLanguageDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopDominantLanguageDetectionJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                stopDominantLanguageDetectionJobRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopDominantLanguageDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopDominantLanguageDetectionJobResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, StopDominantLanguageDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StopDominantLanguageDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopDominantLanguageDetectionJobRequest, StopDominantLanguageDetectionJobResponse>()
                            .withOperationName("StopDominantLanguageDetectionJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StopDominantLanguageDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(stopDominantLanguageDetectionJobRequest));
            CompletableFuture<StopDominantLanguageDetectionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops an entities detection job in progress.
     * </p>
     * <p>
     * If the job state is <code>IN_PROGRESS</code> the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the
     * <code>COMPLETED</code> state; otherwise the job is stopped and put into the <code>STOPPED</code> state.
     * </p>
     * <p>
     * If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the
     * <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception.
     * </p>
     * <p>
     * When a job is stopped, any documents already processed are written to the output location.
     * </p>
     *
     * @param stopEntitiesDetectionJobRequest
     * @return A Java Future containing the result of the StopEntitiesDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StopEntitiesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StopEntitiesDetectionJobResponse> stopEntitiesDetectionJob(
            StopEntitiesDetectionJobRequest stopEntitiesDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopEntitiesDetectionJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopEntitiesDetectionJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopEntitiesDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopEntitiesDetectionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopEntitiesDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StopEntitiesDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopEntitiesDetectionJobRequest, StopEntitiesDetectionJobResponse>()
                            .withOperationName("StopEntitiesDetectionJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StopEntitiesDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(stopEntitiesDetectionJobRequest));
            CompletableFuture<StopEntitiesDetectionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops an events detection job in progress.
     * </p>
     *
     * @param stopEventsDetectionJobRequest
     * @return A Java Future containing the result of the StopEventsDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StopEventsDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopEventsDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StopEventsDetectionJobResponse> stopEventsDetectionJob(
            StopEventsDetectionJobRequest stopEventsDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopEventsDetectionJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopEventsDetectionJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopEventsDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopEventsDetectionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopEventsDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StopEventsDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopEventsDetectionJobRequest, StopEventsDetectionJobResponse>()
                            .withOperationName("StopEventsDetectionJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StopEventsDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(stopEventsDetectionJobRequest));
            CompletableFuture<StopEventsDetectionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops a key phrases detection job in progress.
     * </p>
     * <p>
     * If the job state is <code>IN_PROGRESS</code> the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the
     * <code>COMPLETED</code> state; otherwise the job is stopped and put into the <code>STOPPED</code> state.
     * </p>
     * <p>
     * If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the
     * <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception.
     * </p>
     * <p>
     * When a job is stopped, any documents already processed are written to the output location.
     * </p>
     *
     * @param stopKeyPhrasesDetectionJobRequest
     * @return A Java Future containing the result of the StopKeyPhrasesDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StopKeyPhrasesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopKeyPhrasesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StopKeyPhrasesDetectionJobResponse> stopKeyPhrasesDetectionJob(
            StopKeyPhrasesDetectionJobRequest stopKeyPhrasesDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopKeyPhrasesDetectionJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopKeyPhrasesDetectionJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopKeyPhrasesDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopKeyPhrasesDetectionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopKeyPhrasesDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StopKeyPhrasesDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopKeyPhrasesDetectionJobRequest, StopKeyPhrasesDetectionJobResponse>()
                            .withOperationName("StopKeyPhrasesDetectionJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StopKeyPhrasesDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(stopKeyPhrasesDetectionJobRequest));
            CompletableFuture<StopKeyPhrasesDetectionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops a PII entities detection job in progress.
     * </p>
     *
     * @param stopPiiEntitiesDetectionJobRequest
     * @return A Java Future containing the result of the StopPiiEntitiesDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StopPiiEntitiesDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopPiiEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StopPiiEntitiesDetectionJobResponse> stopPiiEntitiesDetectionJob(
            StopPiiEntitiesDetectionJobRequest stopPiiEntitiesDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopPiiEntitiesDetectionJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopPiiEntitiesDetectionJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopPiiEntitiesDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopPiiEntitiesDetectionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopPiiEntitiesDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StopPiiEntitiesDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopPiiEntitiesDetectionJobRequest, StopPiiEntitiesDetectionJobResponse>()
                            .withOperationName("StopPiiEntitiesDetectionJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StopPiiEntitiesDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(stopPiiEntitiesDetectionJobRequest));
            CompletableFuture<StopPiiEntitiesDetectionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops a sentiment detection job in progress.
     * </p>
     * <p>
     * If the job state is <code>IN_PROGRESS</code>, the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the
     * <code>COMPLETED</code> state; otherwise the job is be stopped and put into the <code>STOPPED</code> state.
     * </p>
     * <p>
     * If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the
     * <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception.
     * </p>
     * <p>
     * When a job is stopped, any documents already processed are written to the output location.
     * </p>
     *
     * @param stopSentimentDetectionJobRequest
     * @return A Java Future containing the result of the StopSentimentDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StopSentimentDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopSentimentDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StopSentimentDetectionJobResponse> stopSentimentDetectionJob(
            StopSentimentDetectionJobRequest stopSentimentDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopSentimentDetectionJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopSentimentDetectionJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopSentimentDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopSentimentDetectionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopSentimentDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StopSentimentDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopSentimentDetectionJobRequest, StopSentimentDetectionJobResponse>()
                            .withOperationName("StopSentimentDetectionJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StopSentimentDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(stopSentimentDetectionJobRequest));
            CompletableFuture<StopSentimentDetectionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops a targeted sentiment detection job in progress.
     * </p>
     * <p>
     * If the job state is <code>IN_PROGRESS</code>, the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the
     * <code>COMPLETED</code> state; otherwise the job is be stopped and put into the <code>STOPPED</code> state.
     * </p>
     * <p>
     * If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the
     * <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception.
     * </p>
     * <p>
     * When a job is stopped, any documents already processed are written to the output location.
     * </p>
     *
     * @param stopTargetedSentimentDetectionJobRequest
     * @return A Java Future containing the result of the StopTargetedSentimentDetectionJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StopTargetedSentimentDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopTargetedSentimentDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StopTargetedSentimentDetectionJobResponse> stopTargetedSentimentDetectionJob(
            StopTargetedSentimentDetectionJobRequest stopTargetedSentimentDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopTargetedSentimentDetectionJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                stopTargetedSentimentDetectionJobRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopTargetedSentimentDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopTargetedSentimentDetectionJobResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, StopTargetedSentimentDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StopTargetedSentimentDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopTargetedSentimentDetectionJobRequest, StopTargetedSentimentDetectionJobResponse>()
                            .withOperationName("StopTargetedSentimentDetectionJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StopTargetedSentimentDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(stopTargetedSentimentDetectionJobRequest));
            CompletableFuture<StopTargetedSentimentDetectionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops a document classifier training job while in progress.
     * </p>
     * <p>
     * If the training job state is <code>TRAINING</code>, the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the training job completes before it can be stopped, it is put into the
     * <code>TRAINED</code>; otherwise the training job is stopped and put into the <code>STOPPED</code> state and the
     * service sends back an HTTP 200 response with an empty HTTP body.
     * </p>
     *
     * @param stopTrainingDocumentClassifierRequest
     * @return A Java Future containing the result of the StopTrainingDocumentClassifier operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StopTrainingDocumentClassifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopTrainingDocumentClassifier"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StopTrainingDocumentClassifierResponse> stopTrainingDocumentClassifier(
            StopTrainingDocumentClassifierRequest stopTrainingDocumentClassifierRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopTrainingDocumentClassifierRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                stopTrainingDocumentClassifierRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopTrainingDocumentClassifier");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopTrainingDocumentClassifierResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopTrainingDocumentClassifierResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StopTrainingDocumentClassifierResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopTrainingDocumentClassifierRequest, StopTrainingDocumentClassifierResponse>()
                            .withOperationName("StopTrainingDocumentClassifier").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StopTrainingDocumentClassifierRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(stopTrainingDocumentClassifierRequest));
            CompletableFuture<StopTrainingDocumentClassifierResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops an entity recognizer training job while in progress.
     * </p>
     * <p>
     * If the training job state is <code>TRAINING</code>, the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the training job completes before it can be stopped, it is put into the
     * <code>TRAINED</code>; otherwise the training job is stopped and putted into the <code>STOPPED</code> state and
     * the service sends back an HTTP 200 response with an empty HTTP body.
     * </p>
     *
     * @param stopTrainingEntityRecognizerRequest
     * @return A Java Future containing the result of the StopTrainingEntityRecognizer operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StopTrainingEntityRecognizer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopTrainingEntityRecognizer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StopTrainingEntityRecognizerResponse> stopTrainingEntityRecognizer(
            StopTrainingEntityRecognizerRequest stopTrainingEntityRecognizerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopTrainingEntityRecognizerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopTrainingEntityRecognizerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopTrainingEntityRecognizer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopTrainingEntityRecognizerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopTrainingEntityRecognizerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StopTrainingEntityRecognizerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopTrainingEntityRecognizerRequest, StopTrainingEntityRecognizerResponse>()
                            .withOperationName("StopTrainingEntityRecognizer").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StopTrainingEntityRecognizerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(stopTrainingEntityRecognizerRequest));
            CompletableFuture<StopTrainingEntityRecognizerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a specific tag with an Amazon Comprehend resource. A tag is a key-value pair that adds as a metadata
     * to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource
     * to indicate its use by the sales department.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ConcurrentModificationException Concurrent modification of the tags associated with an Amazon
     *         Comprehend resource is not supported.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a specific tag associated with an Amazon Comprehend resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyTagKeysException The request contains more tag keys than can be associated with a resource (50
     *         tag keys per resource).</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ConcurrentModificationException Concurrent modification of the tags associated with an Amazon
     *         Comprehend resource is not supported.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates information about the specified endpoint. For information about endpoints, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html">Managing endpoints</a>.
     * </p>
     *
     * @param updateEndpointRequest
     * @return A Java Future containing the result of the UpdateEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceInUseException The specified resource name is already in use. Use a different name and try
     *         your request again.</li>
     *         <li>ResourceLimitExceededException The maximum number of resources per account has been exceeded. Review
     *         the resources, and then try your request again.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>ResourceUnavailableException The specified resource is not available. Check the resource and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.UpdateEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/UpdateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateEndpointResponse> updateEndpoint(UpdateEndpointRequest updateEndpointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateEndpointResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateEndpointRequest, UpdateEndpointResponse>()
                            .withOperationName("UpdateEndpoint").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateEndpointRequest));
            CompletableFuture<UpdateEndpointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Update the configuration information for an existing flywheel.
     * </p>
     *
     * @param updateFlywheelRequest
     * @return A Java Future containing the result of the UpdateFlywheel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.UpdateFlywheel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/UpdateFlywheel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateFlywheelResponse> updateFlywheel(UpdateFlywheelRequest updateFlywheelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFlywheelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFlywheelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFlywheel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateFlywheelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateFlywheelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                case "InvalidRequestException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRequestException::builder).build());
                case "KmsKeyValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                case "InvalidFilterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidFilterException::builder).build());
                case "TooManyTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                case "UnsupportedLanguageException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ResourceUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                case "ResourceLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "BatchSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                case "TextSizeLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "JobNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(JobNotFoundException::builder).build());
                case "TooManyRequestsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateFlywheelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateFlywheelRequest, UpdateFlywheelResponse>()
                            .withOperationName("UpdateFlywheel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateFlywheelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateFlywheelRequest));
            CompletableFuture<UpdateFlywheelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final ComprehendServiceClientConfiguration serviceClientConfiguration() {
        return new ComprehendServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder.clientConfiguration(clientConfiguration).defaultServiceExceptionSupplier(ComprehendException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        ComprehendServiceClientConfigurationBuilder serviceConfigBuilder = new ComprehendServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
