/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehend.model.ComprehendRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDocumentClassifierSummariesRequest
extends ComprehendRequest
implements ToCopyableBuilder<Builder, ListDocumentClassifierSummariesRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDocumentClassifierSummariesRequest.getter(ListDocumentClassifierSummariesRequest::nextToken)).setter(ListDocumentClassifierSummariesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListDocumentClassifierSummariesRequest.getter(ListDocumentClassifierSummariesRequest::maxResults)).setter(ListDocumentClassifierSummariesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDocumentClassifierSummariesRequest.memberNameToFieldInitializer();
    private final String nextToken;
    private final Integer maxResults;

    private ListDocumentClassifierSummariesRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDocumentClassifierSummariesRequest)) {
            return false;
        }
        ListDocumentClassifierSummariesRequest other = (ListDocumentClassifierSummariesRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListDocumentClassifierSummariesRequest").add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDocumentClassifierSummariesRequest, T> g) {
        return obj -> g.apply((ListDocumentClassifierSummariesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDocumentClassifierSummariesRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDocumentClassifierSummariesRequest build() {
            return new ListDocumentClassifierSummariesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ComprehendRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDocumentClassifierSummariesRequest> {
        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

