/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.comprehend.ComprehendAsyncClient;
import software.amazon.awssdk.services.comprehend.ComprehendServiceClientConfiguration;
import software.amazon.awssdk.services.comprehend.internal.ComprehendServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectEntitiesRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectEntitiesResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectKeyPhrasesRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectKeyPhrasesResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSyntaxRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSyntaxResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectTargetedSentimentRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectTargetedSentimentResponse;
import software.amazon.awssdk.services.comprehend.model.BatchSizeLimitExceededException;
import software.amazon.awssdk.services.comprehend.model.ClassifyDocumentRequest;
import software.amazon.awssdk.services.comprehend.model.ClassifyDocumentResponse;
import software.amazon.awssdk.services.comprehend.model.ComprehendException;
import software.amazon.awssdk.services.comprehend.model.ConcurrentModificationException;
import software.amazon.awssdk.services.comprehend.model.ContainsPiiEntitiesRequest;
import software.amazon.awssdk.services.comprehend.model.ContainsPiiEntitiesResponse;
import software.amazon.awssdk.services.comprehend.model.CreateDatasetRequest;
import software.amazon.awssdk.services.comprehend.model.CreateDatasetResponse;
import software.amazon.awssdk.services.comprehend.model.CreateDocumentClassifierRequest;
import software.amazon.awssdk.services.comprehend.model.CreateDocumentClassifierResponse;
import software.amazon.awssdk.services.comprehend.model.CreateEndpointRequest;
import software.amazon.awssdk.services.comprehend.model.CreateEndpointResponse;
import software.amazon.awssdk.services.comprehend.model.CreateEntityRecognizerRequest;
import software.amazon.awssdk.services.comprehend.model.CreateEntityRecognizerResponse;
import software.amazon.awssdk.services.comprehend.model.CreateFlywheelRequest;
import software.amazon.awssdk.services.comprehend.model.CreateFlywheelResponse;
import software.amazon.awssdk.services.comprehend.model.DeleteDocumentClassifierRequest;
import software.amazon.awssdk.services.comprehend.model.DeleteDocumentClassifierResponse;
import software.amazon.awssdk.services.comprehend.model.DeleteEndpointRequest;
import software.amazon.awssdk.services.comprehend.model.DeleteEndpointResponse;
import software.amazon.awssdk.services.comprehend.model.DeleteEntityRecognizerRequest;
import software.amazon.awssdk.services.comprehend.model.DeleteEntityRecognizerResponse;
import software.amazon.awssdk.services.comprehend.model.DeleteFlywheelRequest;
import software.amazon.awssdk.services.comprehend.model.DeleteFlywheelResponse;
import software.amazon.awssdk.services.comprehend.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.comprehend.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeDatasetRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeDatasetResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassificationJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassificationJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassifierRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassifierResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeDominantLanguageDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeDominantLanguageDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeEndpointRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeEndpointResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeEntityRecognizerRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeEntityRecognizerResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeEventsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeEventsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeFlywheelIterationRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeFlywheelIterationResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeFlywheelRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeFlywheelResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeKeyPhrasesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeKeyPhrasesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribePiiEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribePiiEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeResourcePolicyRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeResourcePolicyResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeSentimentDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeSentimentDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeTargetedSentimentDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeTargetedSentimentDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeTopicsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeTopicsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DetectDominantLanguageRequest;
import software.amazon.awssdk.services.comprehend.model.DetectDominantLanguageResponse;
import software.amazon.awssdk.services.comprehend.model.DetectEntitiesRequest;
import software.amazon.awssdk.services.comprehend.model.DetectEntitiesResponse;
import software.amazon.awssdk.services.comprehend.model.DetectKeyPhrasesRequest;
import software.amazon.awssdk.services.comprehend.model.DetectKeyPhrasesResponse;
import software.amazon.awssdk.services.comprehend.model.DetectPiiEntitiesRequest;
import software.amazon.awssdk.services.comprehend.model.DetectPiiEntitiesResponse;
import software.amazon.awssdk.services.comprehend.model.DetectSentimentRequest;
import software.amazon.awssdk.services.comprehend.model.DetectSentimentResponse;
import software.amazon.awssdk.services.comprehend.model.DetectSyntaxRequest;
import software.amazon.awssdk.services.comprehend.model.DetectSyntaxResponse;
import software.amazon.awssdk.services.comprehend.model.DetectTargetedSentimentRequest;
import software.amazon.awssdk.services.comprehend.model.DetectTargetedSentimentResponse;
import software.amazon.awssdk.services.comprehend.model.DetectToxicContentRequest;
import software.amazon.awssdk.services.comprehend.model.DetectToxicContentResponse;
import software.amazon.awssdk.services.comprehend.model.ImportModelRequest;
import software.amazon.awssdk.services.comprehend.model.ImportModelResponse;
import software.amazon.awssdk.services.comprehend.model.InternalServerException;
import software.amazon.awssdk.services.comprehend.model.InvalidFilterException;
import software.amazon.awssdk.services.comprehend.model.InvalidRequestException;
import software.amazon.awssdk.services.comprehend.model.JobNotFoundException;
import software.amazon.awssdk.services.comprehend.model.KmsKeyValidationException;
import software.amazon.awssdk.services.comprehend.model.ListDatasetsRequest;
import software.amazon.awssdk.services.comprehend.model.ListDatasetsResponse;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesRequest;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesResponse;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersRequest;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersResponse;
import software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListEndpointsRequest;
import software.amazon.awssdk.services.comprehend.model.ListEndpointsResponse;
import software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesRequest;
import software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesResponse;
import software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersRequest;
import software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersResponse;
import software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListFlywheelIterationHistoryRequest;
import software.amazon.awssdk.services.comprehend.model.ListFlywheelIterationHistoryResponse;
import software.amazon.awssdk.services.comprehend.model.ListFlywheelsRequest;
import software.amazon.awssdk.services.comprehend.model.ListFlywheelsResponse;
import software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.comprehend.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.comprehend.model.ListTargetedSentimentDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListTargetedSentimentDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.comprehend.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.comprehend.model.ResourceInUseException;
import software.amazon.awssdk.services.comprehend.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.comprehend.model.ResourceNotFoundException;
import software.amazon.awssdk.services.comprehend.model.ResourceUnavailableException;
import software.amazon.awssdk.services.comprehend.model.StartDocumentClassificationJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartDocumentClassificationJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartDominantLanguageDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartDominantLanguageDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartEventsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartEventsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartFlywheelIterationRequest;
import software.amazon.awssdk.services.comprehend.model.StartFlywheelIterationResponse;
import software.amazon.awssdk.services.comprehend.model.StartKeyPhrasesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartKeyPhrasesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartPiiEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartPiiEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartSentimentDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartSentimentDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartTargetedSentimentDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartTargetedSentimentDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartTopicsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartTopicsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopDominantLanguageDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopDominantLanguageDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopEventsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopEventsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopKeyPhrasesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopKeyPhrasesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopPiiEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopPiiEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopSentimentDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopSentimentDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopTargetedSentimentDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopTargetedSentimentDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopTrainingDocumentClassifierRequest;
import software.amazon.awssdk.services.comprehend.model.StopTrainingDocumentClassifierResponse;
import software.amazon.awssdk.services.comprehend.model.StopTrainingEntityRecognizerRequest;
import software.amazon.awssdk.services.comprehend.model.StopTrainingEntityRecognizerResponse;
import software.amazon.awssdk.services.comprehend.model.TagResourceRequest;
import software.amazon.awssdk.services.comprehend.model.TagResourceResponse;
import software.amazon.awssdk.services.comprehend.model.TextSizeLimitExceededException;
import software.amazon.awssdk.services.comprehend.model.TooManyRequestsException;
import software.amazon.awssdk.services.comprehend.model.TooManyTagKeysException;
import software.amazon.awssdk.services.comprehend.model.TooManyTagsException;
import software.amazon.awssdk.services.comprehend.model.UnsupportedLanguageException;
import software.amazon.awssdk.services.comprehend.model.UntagResourceRequest;
import software.amazon.awssdk.services.comprehend.model.UntagResourceResponse;
import software.amazon.awssdk.services.comprehend.model.UpdateEndpointRequest;
import software.amazon.awssdk.services.comprehend.model.UpdateEndpointResponse;
import software.amazon.awssdk.services.comprehend.model.UpdateFlywheelRequest;
import software.amazon.awssdk.services.comprehend.model.UpdateFlywheelResponse;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectDominantLanguageRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectEntitiesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectKeyPhrasesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectSentimentRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectSyntaxRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectTargetedSentimentRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ClassifyDocumentRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ContainsPiiEntitiesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.CreateDatasetRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.CreateDocumentClassifierRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.CreateEndpointRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.CreateEntityRecognizerRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.CreateFlywheelRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DeleteDocumentClassifierRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DeleteEndpointRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DeleteEntityRecognizerRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DeleteFlywheelRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DeleteResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeDatasetRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeDocumentClassificationJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeDocumentClassifierRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeDominantLanguageDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeEndpointRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeEntitiesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeEntityRecognizerRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeEventsDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeFlywheelIterationRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeFlywheelRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeKeyPhrasesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribePiiEntitiesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeSentimentDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeTargetedSentimentDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeTopicsDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectDominantLanguageRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectEntitiesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectKeyPhrasesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectPiiEntitiesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectSentimentRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectSyntaxRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectTargetedSentimentRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectToxicContentRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ImportModelRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListDatasetsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListDocumentClassificationJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListDocumentClassifierSummariesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListDocumentClassifiersRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListDominantLanguageDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListEndpointsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListEntitiesDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListEntityRecognizerSummariesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListEntityRecognizersRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListEventsDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListFlywheelIterationHistoryRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListFlywheelsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListKeyPhrasesDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListPiiEntitiesDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListSentimentDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListTargetedSentimentDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListTopicsDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.PutResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartDocumentClassificationJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartDominantLanguageDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartEntitiesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartEventsDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartFlywheelIterationRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartKeyPhrasesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartPiiEntitiesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartSentimentDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartTargetedSentimentDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartTopicsDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopDominantLanguageDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopEntitiesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopEventsDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopKeyPhrasesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopPiiEntitiesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopSentimentDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopTargetedSentimentDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopTrainingDocumentClassifierRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopTrainingEntityRecognizerRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.UpdateEndpointRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.UpdateFlywheelRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultComprehendAsyncClient
implements ComprehendAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultComprehendAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultComprehendAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Comprehend#2.34.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<BatchDetectDominantLanguageResponse> batchDetectDominantLanguage(BatchDetectDominantLanguageRequest batchDetectDominantLanguageRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchDetectDominantLanguageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, batchDetectDominantLanguageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDetectDominantLanguage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDetectDominantLanguageResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDetectDominantLanguage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new BatchDetectDominantLanguageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchDetectDominantLanguageRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$batchDetectDominantLanguage$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$batchDetectDominantLanguage$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchDetectEntitiesResponse> batchDetectEntities(BatchDetectEntitiesRequest batchDetectEntitiesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchDetectEntitiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, batchDetectEntitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDetectEntities");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDetectEntitiesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDetectEntities").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new BatchDetectEntitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchDetectEntitiesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$batchDetectEntities$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$batchDetectEntities$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchDetectKeyPhrasesResponse> batchDetectKeyPhrases(BatchDetectKeyPhrasesRequest batchDetectKeyPhrasesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchDetectKeyPhrasesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, batchDetectKeyPhrasesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDetectKeyPhrases");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDetectKeyPhrasesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDetectKeyPhrases").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new BatchDetectKeyPhrasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchDetectKeyPhrasesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$batchDetectKeyPhrases$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$batchDetectKeyPhrases$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchDetectSentimentResponse> batchDetectSentiment(BatchDetectSentimentRequest batchDetectSentimentRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchDetectSentimentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, batchDetectSentimentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDetectSentiment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDetectSentimentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDetectSentiment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new BatchDetectSentimentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchDetectSentimentRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$batchDetectSentiment$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$batchDetectSentiment$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchDetectSyntaxResponse> batchDetectSyntax(BatchDetectSyntaxRequest batchDetectSyntaxRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchDetectSyntaxRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, batchDetectSyntaxRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDetectSyntax");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDetectSyntaxResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDetectSyntax").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new BatchDetectSyntaxRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchDetectSyntaxRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$batchDetectSyntax$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$batchDetectSyntax$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchDetectTargetedSentimentResponse> batchDetectTargetedSentiment(BatchDetectTargetedSentimentRequest batchDetectTargetedSentimentRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchDetectTargetedSentimentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, batchDetectTargetedSentimentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDetectTargetedSentiment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDetectTargetedSentimentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDetectTargetedSentiment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new BatchDetectTargetedSentimentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchDetectTargetedSentimentRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$batchDetectTargetedSentiment$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$batchDetectTargetedSentiment$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ClassifyDocumentResponse> classifyDocument(ClassifyDocumentRequest classifyDocumentRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)classifyDocumentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, classifyDocumentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ClassifyDocument");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ClassifyDocumentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ClassifyDocument").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ClassifyDocumentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)classifyDocumentRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$classifyDocument$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$classifyDocument$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ContainsPiiEntitiesResponse> containsPiiEntities(ContainsPiiEntitiesRequest containsPiiEntitiesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)containsPiiEntitiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, containsPiiEntitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ContainsPiiEntities");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ContainsPiiEntitiesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ContainsPiiEntities").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ContainsPiiEntitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)containsPiiEntitiesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$containsPiiEntities$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$containsPiiEntities$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDatasetResponse> createDataset(CreateDatasetRequest createDatasetRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDatasetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, createDatasetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDataset");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDatasetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDataset").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateDatasetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createDatasetRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$createDataset$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$createDataset$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDocumentClassifierResponse> createDocumentClassifier(CreateDocumentClassifierRequest createDocumentClassifierRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDocumentClassifierRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, createDocumentClassifierRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDocumentClassifier");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDocumentClassifierResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDocumentClassifier").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateDocumentClassifierRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createDocumentClassifierRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$createDocumentClassifier$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$createDocumentClassifier$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateEndpointResponse> createEndpoint(CreateEndpointRequest createEndpointRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, createEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateEndpointResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEndpoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createEndpointRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$createEndpoint$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$createEndpoint$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateEntityRecognizerResponse> createEntityRecognizer(CreateEntityRecognizerRequest createEntityRecognizerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createEntityRecognizerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, createEntityRecognizerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateEntityRecognizer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateEntityRecognizerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEntityRecognizer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateEntityRecognizerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createEntityRecognizerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$createEntityRecognizer$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$createEntityRecognizer$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateFlywheelResponse> createFlywheel(CreateFlywheelRequest createFlywheelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createFlywheelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, createFlywheelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFlywheel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFlywheelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFlywheel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateFlywheelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createFlywheelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$createFlywheel$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$createFlywheel$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDocumentClassifierResponse> deleteDocumentClassifier(DeleteDocumentClassifierRequest deleteDocumentClassifierRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDocumentClassifierRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, deleteDocumentClassifierRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDocumentClassifier");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDocumentClassifierResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDocumentClassifier").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteDocumentClassifierRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteDocumentClassifierRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$deleteDocumentClassifier$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$deleteDocumentClassifier$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteEndpointResponse> deleteEndpoint(DeleteEndpointRequest deleteEndpointRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, deleteEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEndpointResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEndpoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteEndpointRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$deleteEndpoint$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$deleteEndpoint$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteEntityRecognizerResponse> deleteEntityRecognizer(DeleteEntityRecognizerRequest deleteEntityRecognizerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteEntityRecognizerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, deleteEntityRecognizerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEntityRecognizer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEntityRecognizerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEntityRecognizer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteEntityRecognizerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteEntityRecognizerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$deleteEntityRecognizer$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$deleteEntityRecognizer$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteFlywheelResponse> deleteFlywheel(DeleteFlywheelRequest deleteFlywheelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteFlywheelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, deleteFlywheelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFlywheel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFlywheelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFlywheel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteFlywheelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteFlywheelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$deleteFlywheel$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$deleteFlywheel$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, deleteResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteResourcePolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteResourcePolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$deleteResourcePolicy$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$deleteResourcePolicy$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDatasetResponse> describeDataset(DescribeDatasetRequest describeDatasetRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDatasetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, describeDatasetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDataset");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDatasetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDataset").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeDatasetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeDatasetRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$describeDataset$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$describeDataset$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDocumentClassificationJobResponse> describeDocumentClassificationJob(DescribeDocumentClassificationJobRequest describeDocumentClassificationJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDocumentClassificationJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, describeDocumentClassificationJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDocumentClassificationJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDocumentClassificationJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDocumentClassificationJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeDocumentClassificationJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeDocumentClassificationJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$describeDocumentClassificationJob$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$describeDocumentClassificationJob$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDocumentClassifierResponse> describeDocumentClassifier(DescribeDocumentClassifierRequest describeDocumentClassifierRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDocumentClassifierRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, describeDocumentClassifierRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDocumentClassifier");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDocumentClassifierResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDocumentClassifier").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeDocumentClassifierRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeDocumentClassifierRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$describeDocumentClassifier$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$describeDocumentClassifier$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDominantLanguageDetectionJobResponse> describeDominantLanguageDetectionJob(DescribeDominantLanguageDetectionJobRequest describeDominantLanguageDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDominantLanguageDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, describeDominantLanguageDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDominantLanguageDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDominantLanguageDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDominantLanguageDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeDominantLanguageDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeDominantLanguageDetectionJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$describeDominantLanguageDetectionJob$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$describeDominantLanguageDetectionJob$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeEndpointResponse> describeEndpoint(DescribeEndpointRequest describeEndpointRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, describeEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEndpointResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEndpoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeEndpointRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$describeEndpoint$90(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$describeEndpoint$91((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeEntitiesDetectionJobResponse> describeEntitiesDetectionJob(DescribeEntitiesDetectionJobRequest describeEntitiesDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeEntitiesDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, describeEntitiesDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEntitiesDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEntitiesDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEntitiesDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeEntitiesDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeEntitiesDetectionJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$describeEntitiesDetectionJob$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$describeEntitiesDetectionJob$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeEntityRecognizerResponse> describeEntityRecognizer(DescribeEntityRecognizerRequest describeEntityRecognizerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeEntityRecognizerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, describeEntityRecognizerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEntityRecognizer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEntityRecognizerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEntityRecognizer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeEntityRecognizerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeEntityRecognizerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$describeEntityRecognizer$98(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$describeEntityRecognizer$99((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeEventsDetectionJobResponse> describeEventsDetectionJob(DescribeEventsDetectionJobRequest describeEventsDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeEventsDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, describeEventsDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEventsDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEventsDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEventsDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeEventsDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeEventsDetectionJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$describeEventsDetectionJob$102(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$describeEventsDetectionJob$103((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeFlywheelResponse> describeFlywheel(DescribeFlywheelRequest describeFlywheelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeFlywheelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, describeFlywheelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFlywheel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFlywheelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFlywheel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeFlywheelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeFlywheelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$describeFlywheel$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$describeFlywheel$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeFlywheelIterationResponse> describeFlywheelIteration(DescribeFlywheelIterationRequest describeFlywheelIterationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeFlywheelIterationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, describeFlywheelIterationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFlywheelIteration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFlywheelIterationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFlywheelIteration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeFlywheelIterationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeFlywheelIterationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$describeFlywheelIteration$110(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$describeFlywheelIteration$111((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeKeyPhrasesDetectionJobResponse> describeKeyPhrasesDetectionJob(DescribeKeyPhrasesDetectionJobRequest describeKeyPhrasesDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeKeyPhrasesDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, describeKeyPhrasesDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeKeyPhrasesDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeKeyPhrasesDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeKeyPhrasesDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeKeyPhrasesDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeKeyPhrasesDetectionJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$describeKeyPhrasesDetectionJob$114(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$describeKeyPhrasesDetectionJob$115((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribePiiEntitiesDetectionJobResponse> describePiiEntitiesDetectionJob(DescribePiiEntitiesDetectionJobRequest describePiiEntitiesDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describePiiEntitiesDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, describePiiEntitiesDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribePiiEntitiesDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribePiiEntitiesDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePiiEntitiesDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribePiiEntitiesDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describePiiEntitiesDetectionJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$describePiiEntitiesDetectionJob$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$describePiiEntitiesDetectionJob$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeResourcePolicyResponse> describeResourcePolicy(DescribeResourcePolicyRequest describeResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, describeResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeResourcePolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeResourcePolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$describeResourcePolicy$122(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$describeResourcePolicy$123((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeSentimentDetectionJobResponse> describeSentimentDetectionJob(DescribeSentimentDetectionJobRequest describeSentimentDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeSentimentDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, describeSentimentDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSentimentDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSentimentDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSentimentDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeSentimentDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeSentimentDetectionJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$describeSentimentDetectionJob$126(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$describeSentimentDetectionJob$127((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeTargetedSentimentDetectionJobResponse> describeTargetedSentimentDetectionJob(DescribeTargetedSentimentDetectionJobRequest describeTargetedSentimentDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTargetedSentimentDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, describeTargetedSentimentDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTargetedSentimentDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTargetedSentimentDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTargetedSentimentDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeTargetedSentimentDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeTargetedSentimentDetectionJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$describeTargetedSentimentDetectionJob$130(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$describeTargetedSentimentDetectionJob$131((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeTopicsDetectionJobResponse> describeTopicsDetectionJob(DescribeTopicsDetectionJobRequest describeTopicsDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTopicsDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, describeTopicsDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTopicsDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTopicsDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTopicsDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeTopicsDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeTopicsDetectionJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$describeTopicsDetectionJob$134(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$describeTopicsDetectionJob$135((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DetectDominantLanguageResponse> detectDominantLanguage(DetectDominantLanguageRequest detectDominantLanguageRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detectDominantLanguageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, detectDominantLanguageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetectDominantLanguage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectDominantLanguageResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectDominantLanguage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DetectDominantLanguageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)detectDominantLanguageRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$detectDominantLanguage$138(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$detectDominantLanguage$139((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DetectEntitiesResponse> detectEntities(DetectEntitiesRequest detectEntitiesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detectEntitiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, detectEntitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetectEntities");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectEntitiesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectEntities").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DetectEntitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)detectEntitiesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$detectEntities$142(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$detectEntities$143((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DetectKeyPhrasesResponse> detectKeyPhrases(DetectKeyPhrasesRequest detectKeyPhrasesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detectKeyPhrasesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, detectKeyPhrasesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetectKeyPhrases");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectKeyPhrasesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectKeyPhrases").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DetectKeyPhrasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)detectKeyPhrasesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$detectKeyPhrases$146(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$detectKeyPhrases$147((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DetectPiiEntitiesResponse> detectPiiEntities(DetectPiiEntitiesRequest detectPiiEntitiesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detectPiiEntitiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, detectPiiEntitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetectPiiEntities");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectPiiEntitiesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectPiiEntities").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DetectPiiEntitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)detectPiiEntitiesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$detectPiiEntities$150(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$detectPiiEntities$151((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DetectSentimentResponse> detectSentiment(DetectSentimentRequest detectSentimentRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detectSentimentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, detectSentimentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetectSentiment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectSentimentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectSentiment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DetectSentimentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)detectSentimentRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$detectSentiment$154(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$detectSentiment$155((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DetectSyntaxResponse> detectSyntax(DetectSyntaxRequest detectSyntaxRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detectSyntaxRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, detectSyntaxRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetectSyntax");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectSyntaxResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectSyntax").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DetectSyntaxRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)detectSyntaxRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$detectSyntax$158(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$detectSyntax$159((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DetectTargetedSentimentResponse> detectTargetedSentiment(DetectTargetedSentimentRequest detectTargetedSentimentRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detectTargetedSentimentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, detectTargetedSentimentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetectTargetedSentiment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectTargetedSentimentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectTargetedSentiment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DetectTargetedSentimentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)detectTargetedSentimentRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$detectTargetedSentiment$162(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$detectTargetedSentiment$163((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DetectToxicContentResponse> detectToxicContent(DetectToxicContentRequest detectToxicContentRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detectToxicContentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, detectToxicContentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetectToxicContent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectToxicContentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectToxicContent").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DetectToxicContentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)detectToxicContentRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$detectToxicContent$166(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$detectToxicContent$167((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ImportModelResponse> importModel(ImportModelRequest importModelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)importModelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, importModelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ImportModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportModelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportModel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ImportModelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)importModelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$importModel$170(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$importModel$171((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListDatasetsResponse> listDatasets(ListDatasetsRequest listDatasetsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDatasetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, listDatasetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDatasets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDatasetsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDatasets").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListDatasetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listDatasetsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$listDatasets$174(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$listDatasets$175((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListDocumentClassificationJobsResponse> listDocumentClassificationJobs(ListDocumentClassificationJobsRequest listDocumentClassificationJobsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDocumentClassificationJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, listDocumentClassificationJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDocumentClassificationJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDocumentClassificationJobsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDocumentClassificationJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListDocumentClassificationJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listDocumentClassificationJobsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$listDocumentClassificationJobs$178(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$listDocumentClassificationJobs$179((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListDocumentClassifierSummariesResponse> listDocumentClassifierSummaries(ListDocumentClassifierSummariesRequest listDocumentClassifierSummariesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDocumentClassifierSummariesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, listDocumentClassifierSummariesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDocumentClassifierSummaries");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDocumentClassifierSummariesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDocumentClassifierSummaries").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListDocumentClassifierSummariesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listDocumentClassifierSummariesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$listDocumentClassifierSummaries$182(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$listDocumentClassifierSummaries$183((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListDocumentClassifiersResponse> listDocumentClassifiers(ListDocumentClassifiersRequest listDocumentClassifiersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDocumentClassifiersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, listDocumentClassifiersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDocumentClassifiers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDocumentClassifiersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDocumentClassifiers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListDocumentClassifiersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listDocumentClassifiersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$listDocumentClassifiers$186(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$listDocumentClassifiers$187((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListDominantLanguageDetectionJobsResponse> listDominantLanguageDetectionJobs(ListDominantLanguageDetectionJobsRequest listDominantLanguageDetectionJobsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDominantLanguageDetectionJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, listDominantLanguageDetectionJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDominantLanguageDetectionJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDominantLanguageDetectionJobsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDominantLanguageDetectionJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListDominantLanguageDetectionJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listDominantLanguageDetectionJobsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$listDominantLanguageDetectionJobs$190(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$listDominantLanguageDetectionJobs$191((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListEndpointsResponse> listEndpoints(ListEndpointsRequest listEndpointsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listEndpointsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, listEndpointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEndpoints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEndpointsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEndpoints").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListEndpointsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listEndpointsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$listEndpoints$194(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$listEndpoints$195((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListEntitiesDetectionJobsResponse> listEntitiesDetectionJobs(ListEntitiesDetectionJobsRequest listEntitiesDetectionJobsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listEntitiesDetectionJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, listEntitiesDetectionJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEntitiesDetectionJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEntitiesDetectionJobsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEntitiesDetectionJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListEntitiesDetectionJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listEntitiesDetectionJobsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$listEntitiesDetectionJobs$198(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$listEntitiesDetectionJobs$199((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListEntityRecognizerSummariesResponse> listEntityRecognizerSummaries(ListEntityRecognizerSummariesRequest listEntityRecognizerSummariesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listEntityRecognizerSummariesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, listEntityRecognizerSummariesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEntityRecognizerSummaries");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEntityRecognizerSummariesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEntityRecognizerSummaries").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListEntityRecognizerSummariesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listEntityRecognizerSummariesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$listEntityRecognizerSummaries$202(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$listEntityRecognizerSummaries$203((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListEntityRecognizersResponse> listEntityRecognizers(ListEntityRecognizersRequest listEntityRecognizersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listEntityRecognizersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, listEntityRecognizersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEntityRecognizers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEntityRecognizersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEntityRecognizers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListEntityRecognizersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listEntityRecognizersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$listEntityRecognizers$206(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$listEntityRecognizers$207((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListEventsDetectionJobsResponse> listEventsDetectionJobs(ListEventsDetectionJobsRequest listEventsDetectionJobsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listEventsDetectionJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, listEventsDetectionJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEventsDetectionJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEventsDetectionJobsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEventsDetectionJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListEventsDetectionJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listEventsDetectionJobsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$listEventsDetectionJobs$210(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$listEventsDetectionJobs$211((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListFlywheelIterationHistoryResponse> listFlywheelIterationHistory(ListFlywheelIterationHistoryRequest listFlywheelIterationHistoryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listFlywheelIterationHistoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, listFlywheelIterationHistoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFlywheelIterationHistory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFlywheelIterationHistoryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFlywheelIterationHistory").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListFlywheelIterationHistoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listFlywheelIterationHistoryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$listFlywheelIterationHistory$214(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$listFlywheelIterationHistory$215((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListFlywheelsResponse> listFlywheels(ListFlywheelsRequest listFlywheelsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listFlywheelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, listFlywheelsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFlywheels");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFlywheelsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFlywheels").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListFlywheelsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listFlywheelsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$listFlywheels$218(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$listFlywheels$219((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListKeyPhrasesDetectionJobsResponse> listKeyPhrasesDetectionJobs(ListKeyPhrasesDetectionJobsRequest listKeyPhrasesDetectionJobsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listKeyPhrasesDetectionJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, listKeyPhrasesDetectionJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListKeyPhrasesDetectionJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListKeyPhrasesDetectionJobsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListKeyPhrasesDetectionJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListKeyPhrasesDetectionJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listKeyPhrasesDetectionJobsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$listKeyPhrasesDetectionJobs$222(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$listKeyPhrasesDetectionJobs$223((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListPiiEntitiesDetectionJobsResponse> listPiiEntitiesDetectionJobs(ListPiiEntitiesDetectionJobsRequest listPiiEntitiesDetectionJobsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPiiEntitiesDetectionJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, listPiiEntitiesDetectionJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPiiEntitiesDetectionJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPiiEntitiesDetectionJobsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPiiEntitiesDetectionJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListPiiEntitiesDetectionJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listPiiEntitiesDetectionJobsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$listPiiEntitiesDetectionJobs$226(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$listPiiEntitiesDetectionJobs$227((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListSentimentDetectionJobsResponse> listSentimentDetectionJobs(ListSentimentDetectionJobsRequest listSentimentDetectionJobsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listSentimentDetectionJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, listSentimentDetectionJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSentimentDetectionJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSentimentDetectionJobsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSentimentDetectionJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListSentimentDetectionJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listSentimentDetectionJobsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$listSentimentDetectionJobs$230(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$listSentimentDetectionJobs$231((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$listTagsForResource$234(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$listTagsForResource$235((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTargetedSentimentDetectionJobsResponse> listTargetedSentimentDetectionJobs(ListTargetedSentimentDetectionJobsRequest listTargetedSentimentDetectionJobsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTargetedSentimentDetectionJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, listTargetedSentimentDetectionJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTargetedSentimentDetectionJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTargetedSentimentDetectionJobsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTargetedSentimentDetectionJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTargetedSentimentDetectionJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTargetedSentimentDetectionJobsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$listTargetedSentimentDetectionJobs$238(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$listTargetedSentimentDetectionJobs$239((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTopicsDetectionJobsResponse> listTopicsDetectionJobs(ListTopicsDetectionJobsRequest listTopicsDetectionJobsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTopicsDetectionJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, listTopicsDetectionJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTopicsDetectionJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTopicsDetectionJobsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTopicsDetectionJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTopicsDetectionJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTopicsDetectionJobsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$listTopicsDetectionJobs$242(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$listTopicsDetectionJobs$243((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutResourcePolicyResponse> putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, putResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutResourcePolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putResourcePolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$putResourcePolicy$246(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$putResourcePolicy$247((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartDocumentClassificationJobResponse> startDocumentClassificationJob(StartDocumentClassificationJobRequest startDocumentClassificationJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startDocumentClassificationJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, startDocumentClassificationJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartDocumentClassificationJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartDocumentClassificationJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartDocumentClassificationJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartDocumentClassificationJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startDocumentClassificationJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$startDocumentClassificationJob$250(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$startDocumentClassificationJob$251((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartDominantLanguageDetectionJobResponse> startDominantLanguageDetectionJob(StartDominantLanguageDetectionJobRequest startDominantLanguageDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startDominantLanguageDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, startDominantLanguageDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartDominantLanguageDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartDominantLanguageDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartDominantLanguageDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartDominantLanguageDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startDominantLanguageDetectionJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$startDominantLanguageDetectionJob$254(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$startDominantLanguageDetectionJob$255((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartEntitiesDetectionJobResponse> startEntitiesDetectionJob(StartEntitiesDetectionJobRequest startEntitiesDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startEntitiesDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, startEntitiesDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartEntitiesDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartEntitiesDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartEntitiesDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartEntitiesDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startEntitiesDetectionJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$startEntitiesDetectionJob$258(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$startEntitiesDetectionJob$259((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartEventsDetectionJobResponse> startEventsDetectionJob(StartEventsDetectionJobRequest startEventsDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startEventsDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, startEventsDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartEventsDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartEventsDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartEventsDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartEventsDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startEventsDetectionJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$startEventsDetectionJob$262(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$startEventsDetectionJob$263((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartFlywheelIterationResponse> startFlywheelIteration(StartFlywheelIterationRequest startFlywheelIterationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startFlywheelIterationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, startFlywheelIterationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartFlywheelIteration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartFlywheelIterationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartFlywheelIteration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartFlywheelIterationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startFlywheelIterationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$startFlywheelIteration$266(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$startFlywheelIteration$267((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartKeyPhrasesDetectionJobResponse> startKeyPhrasesDetectionJob(StartKeyPhrasesDetectionJobRequest startKeyPhrasesDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startKeyPhrasesDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, startKeyPhrasesDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartKeyPhrasesDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartKeyPhrasesDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartKeyPhrasesDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartKeyPhrasesDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startKeyPhrasesDetectionJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$startKeyPhrasesDetectionJob$270(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$startKeyPhrasesDetectionJob$271((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartPiiEntitiesDetectionJobResponse> startPiiEntitiesDetectionJob(StartPiiEntitiesDetectionJobRequest startPiiEntitiesDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startPiiEntitiesDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, startPiiEntitiesDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartPiiEntitiesDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartPiiEntitiesDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartPiiEntitiesDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartPiiEntitiesDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startPiiEntitiesDetectionJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$startPiiEntitiesDetectionJob$274(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$startPiiEntitiesDetectionJob$275((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartSentimentDetectionJobResponse> startSentimentDetectionJob(StartSentimentDetectionJobRequest startSentimentDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startSentimentDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, startSentimentDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartSentimentDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartSentimentDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartSentimentDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartSentimentDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startSentimentDetectionJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$startSentimentDetectionJob$278(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$startSentimentDetectionJob$279((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartTargetedSentimentDetectionJobResponse> startTargetedSentimentDetectionJob(StartTargetedSentimentDetectionJobRequest startTargetedSentimentDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startTargetedSentimentDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, startTargetedSentimentDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartTargetedSentimentDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartTargetedSentimentDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartTargetedSentimentDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartTargetedSentimentDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startTargetedSentimentDetectionJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$startTargetedSentimentDetectionJob$282(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$startTargetedSentimentDetectionJob$283((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartTopicsDetectionJobResponse> startTopicsDetectionJob(StartTopicsDetectionJobRequest startTopicsDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startTopicsDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, startTopicsDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartTopicsDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartTopicsDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartTopicsDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartTopicsDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startTopicsDetectionJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$startTopicsDetectionJob$286(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$startTopicsDetectionJob$287((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopDominantLanguageDetectionJobResponse> stopDominantLanguageDetectionJob(StopDominantLanguageDetectionJobRequest stopDominantLanguageDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopDominantLanguageDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, stopDominantLanguageDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopDominantLanguageDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopDominantLanguageDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopDominantLanguageDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StopDominantLanguageDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)stopDominantLanguageDetectionJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$stopDominantLanguageDetectionJob$290(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$stopDominantLanguageDetectionJob$291((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopEntitiesDetectionJobResponse> stopEntitiesDetectionJob(StopEntitiesDetectionJobRequest stopEntitiesDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopEntitiesDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, stopEntitiesDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopEntitiesDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopEntitiesDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopEntitiesDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StopEntitiesDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)stopEntitiesDetectionJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$stopEntitiesDetectionJob$294(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$stopEntitiesDetectionJob$295((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopEventsDetectionJobResponse> stopEventsDetectionJob(StopEventsDetectionJobRequest stopEventsDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopEventsDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, stopEventsDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopEventsDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopEventsDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopEventsDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StopEventsDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)stopEventsDetectionJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$stopEventsDetectionJob$298(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$stopEventsDetectionJob$299((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopKeyPhrasesDetectionJobResponse> stopKeyPhrasesDetectionJob(StopKeyPhrasesDetectionJobRequest stopKeyPhrasesDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopKeyPhrasesDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, stopKeyPhrasesDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopKeyPhrasesDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopKeyPhrasesDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopKeyPhrasesDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StopKeyPhrasesDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)stopKeyPhrasesDetectionJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$stopKeyPhrasesDetectionJob$302(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$stopKeyPhrasesDetectionJob$303((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopPiiEntitiesDetectionJobResponse> stopPiiEntitiesDetectionJob(StopPiiEntitiesDetectionJobRequest stopPiiEntitiesDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopPiiEntitiesDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, stopPiiEntitiesDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopPiiEntitiesDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopPiiEntitiesDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopPiiEntitiesDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StopPiiEntitiesDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)stopPiiEntitiesDetectionJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$stopPiiEntitiesDetectionJob$306(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$stopPiiEntitiesDetectionJob$307((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopSentimentDetectionJobResponse> stopSentimentDetectionJob(StopSentimentDetectionJobRequest stopSentimentDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopSentimentDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, stopSentimentDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopSentimentDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopSentimentDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopSentimentDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StopSentimentDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)stopSentimentDetectionJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$stopSentimentDetectionJob$310(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$stopSentimentDetectionJob$311((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopTargetedSentimentDetectionJobResponse> stopTargetedSentimentDetectionJob(StopTargetedSentimentDetectionJobRequest stopTargetedSentimentDetectionJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopTargetedSentimentDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, stopTargetedSentimentDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopTargetedSentimentDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopTargetedSentimentDetectionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopTargetedSentimentDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StopTargetedSentimentDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)stopTargetedSentimentDetectionJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$stopTargetedSentimentDetectionJob$314(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$stopTargetedSentimentDetectionJob$315((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopTrainingDocumentClassifierResponse> stopTrainingDocumentClassifier(StopTrainingDocumentClassifierRequest stopTrainingDocumentClassifierRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopTrainingDocumentClassifierRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, stopTrainingDocumentClassifierRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopTrainingDocumentClassifier");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopTrainingDocumentClassifierResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopTrainingDocumentClassifier").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StopTrainingDocumentClassifierRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)stopTrainingDocumentClassifierRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$stopTrainingDocumentClassifier$318(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$stopTrainingDocumentClassifier$319((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopTrainingEntityRecognizerResponse> stopTrainingEntityRecognizer(StopTrainingEntityRecognizerRequest stopTrainingEntityRecognizerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopTrainingEntityRecognizerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, stopTrainingEntityRecognizerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopTrainingEntityRecognizer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopTrainingEntityRecognizerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopTrainingEntityRecognizer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StopTrainingEntityRecognizerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)stopTrainingEntityRecognizerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$stopTrainingEntityRecognizer$322(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$stopTrainingEntityRecognizer$323((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$tagResource$326(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$tagResource$327((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$untagResource$330(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$untagResource$331((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateEndpointResponse> updateEndpoint(UpdateEndpointRequest updateEndpointRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, updateEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateEndpointResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateEndpoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateEndpointRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$updateEndpoint$334(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$updateEndpoint$335((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateFlywheelResponse> updateFlywheel(UpdateFlywheelRequest updateFlywheelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateFlywheelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendAsyncClient.resolveMetricPublishers(clientConfiguration, updateFlywheelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFlywheel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFlywheelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "KmsKeyValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                    }
                    case "InvalidFilterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                    }
                    case "TooManyTagKeysException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                    }
                    case "UnsupportedLanguageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ResourceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                    }
                    case "ResourceLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "BatchSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                    }
                    case "TextSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFlywheel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateFlywheelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateFlywheelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultComprehendAsyncClient.lambda$updateFlywheel$338(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultComprehendAsyncClient.lambda$updateFlywheel$339((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final ComprehendServiceClientConfiguration serviceClientConfiguration() {
        return new ComprehendServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "comprehend";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ComprehendException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        ComprehendServiceClientConfigurationBuilder serviceConfigBuilder = new ComprehendServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateFlywheel$339(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFlywheel$338(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateFlywheelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateEndpoint$335(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateEndpoint$334(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateEndpointResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$331(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$330(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$327(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$326(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$stopTrainingEntityRecognizer$323(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopTrainingEntityRecognizer$322(List metricPublishers, MetricCollector apiCallMetricCollector, StopTrainingEntityRecognizerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$stopTrainingDocumentClassifier$319(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopTrainingDocumentClassifier$318(List metricPublishers, MetricCollector apiCallMetricCollector, StopTrainingDocumentClassifierResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$stopTargetedSentimentDetectionJob$315(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopTargetedSentimentDetectionJob$314(List metricPublishers, MetricCollector apiCallMetricCollector, StopTargetedSentimentDetectionJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$stopSentimentDetectionJob$311(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopSentimentDetectionJob$310(List metricPublishers, MetricCollector apiCallMetricCollector, StopSentimentDetectionJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$stopPiiEntitiesDetectionJob$307(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopPiiEntitiesDetectionJob$306(List metricPublishers, MetricCollector apiCallMetricCollector, StopPiiEntitiesDetectionJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$stopKeyPhrasesDetectionJob$303(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopKeyPhrasesDetectionJob$302(List metricPublishers, MetricCollector apiCallMetricCollector, StopKeyPhrasesDetectionJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$stopEventsDetectionJob$299(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopEventsDetectionJob$298(List metricPublishers, MetricCollector apiCallMetricCollector, StopEventsDetectionJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$stopEntitiesDetectionJob$295(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopEntitiesDetectionJob$294(List metricPublishers, MetricCollector apiCallMetricCollector, StopEntitiesDetectionJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$stopDominantLanguageDetectionJob$291(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopDominantLanguageDetectionJob$290(List metricPublishers, MetricCollector apiCallMetricCollector, StopDominantLanguageDetectionJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startTopicsDetectionJob$287(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startTopicsDetectionJob$286(List metricPublishers, MetricCollector apiCallMetricCollector, StartTopicsDetectionJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startTargetedSentimentDetectionJob$283(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startTargetedSentimentDetectionJob$282(List metricPublishers, MetricCollector apiCallMetricCollector, StartTargetedSentimentDetectionJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startSentimentDetectionJob$279(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startSentimentDetectionJob$278(List metricPublishers, MetricCollector apiCallMetricCollector, StartSentimentDetectionJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startPiiEntitiesDetectionJob$275(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startPiiEntitiesDetectionJob$274(List metricPublishers, MetricCollector apiCallMetricCollector, StartPiiEntitiesDetectionJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startKeyPhrasesDetectionJob$271(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startKeyPhrasesDetectionJob$270(List metricPublishers, MetricCollector apiCallMetricCollector, StartKeyPhrasesDetectionJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startFlywheelIteration$267(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startFlywheelIteration$266(List metricPublishers, MetricCollector apiCallMetricCollector, StartFlywheelIterationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startEventsDetectionJob$263(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startEventsDetectionJob$262(List metricPublishers, MetricCollector apiCallMetricCollector, StartEventsDetectionJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startEntitiesDetectionJob$259(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startEntitiesDetectionJob$258(List metricPublishers, MetricCollector apiCallMetricCollector, StartEntitiesDetectionJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startDominantLanguageDetectionJob$255(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startDominantLanguageDetectionJob$254(List metricPublishers, MetricCollector apiCallMetricCollector, StartDominantLanguageDetectionJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startDocumentClassificationJob$251(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startDocumentClassificationJob$250(List metricPublishers, MetricCollector apiCallMetricCollector, StartDocumentClassificationJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putResourcePolicy$247(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putResourcePolicy$246(List metricPublishers, MetricCollector apiCallMetricCollector, PutResourcePolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTopicsDetectionJobs$243(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTopicsDetectionJobs$242(List metricPublishers, MetricCollector apiCallMetricCollector, ListTopicsDetectionJobsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTargetedSentimentDetectionJobs$239(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTargetedSentimentDetectionJobs$238(List metricPublishers, MetricCollector apiCallMetricCollector, ListTargetedSentimentDetectionJobsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$235(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$234(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listSentimentDetectionJobs$231(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSentimentDetectionJobs$230(List metricPublishers, MetricCollector apiCallMetricCollector, ListSentimentDetectionJobsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listPiiEntitiesDetectionJobs$227(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPiiEntitiesDetectionJobs$226(List metricPublishers, MetricCollector apiCallMetricCollector, ListPiiEntitiesDetectionJobsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listKeyPhrasesDetectionJobs$223(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listKeyPhrasesDetectionJobs$222(List metricPublishers, MetricCollector apiCallMetricCollector, ListKeyPhrasesDetectionJobsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listFlywheels$219(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFlywheels$218(List metricPublishers, MetricCollector apiCallMetricCollector, ListFlywheelsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listFlywheelIterationHistory$215(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFlywheelIterationHistory$214(List metricPublishers, MetricCollector apiCallMetricCollector, ListFlywheelIterationHistoryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listEventsDetectionJobs$211(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEventsDetectionJobs$210(List metricPublishers, MetricCollector apiCallMetricCollector, ListEventsDetectionJobsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listEntityRecognizers$207(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEntityRecognizers$206(List metricPublishers, MetricCollector apiCallMetricCollector, ListEntityRecognizersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listEntityRecognizerSummaries$203(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEntityRecognizerSummaries$202(List metricPublishers, MetricCollector apiCallMetricCollector, ListEntityRecognizerSummariesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listEntitiesDetectionJobs$199(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEntitiesDetectionJobs$198(List metricPublishers, MetricCollector apiCallMetricCollector, ListEntitiesDetectionJobsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listEndpoints$195(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEndpoints$194(List metricPublishers, MetricCollector apiCallMetricCollector, ListEndpointsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listDominantLanguageDetectionJobs$191(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDominantLanguageDetectionJobs$190(List metricPublishers, MetricCollector apiCallMetricCollector, ListDominantLanguageDetectionJobsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listDocumentClassifiers$187(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDocumentClassifiers$186(List metricPublishers, MetricCollector apiCallMetricCollector, ListDocumentClassifiersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listDocumentClassifierSummaries$183(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDocumentClassifierSummaries$182(List metricPublishers, MetricCollector apiCallMetricCollector, ListDocumentClassifierSummariesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listDocumentClassificationJobs$179(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDocumentClassificationJobs$178(List metricPublishers, MetricCollector apiCallMetricCollector, ListDocumentClassificationJobsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listDatasets$175(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDatasets$174(List metricPublishers, MetricCollector apiCallMetricCollector, ListDatasetsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$importModel$171(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$importModel$170(List metricPublishers, MetricCollector apiCallMetricCollector, ImportModelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$detectToxicContent$167(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detectToxicContent$166(List metricPublishers, MetricCollector apiCallMetricCollector, DetectToxicContentResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$detectTargetedSentiment$163(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detectTargetedSentiment$162(List metricPublishers, MetricCollector apiCallMetricCollector, DetectTargetedSentimentResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$detectSyntax$159(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detectSyntax$158(List metricPublishers, MetricCollector apiCallMetricCollector, DetectSyntaxResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$detectSentiment$155(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detectSentiment$154(List metricPublishers, MetricCollector apiCallMetricCollector, DetectSentimentResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$detectPiiEntities$151(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detectPiiEntities$150(List metricPublishers, MetricCollector apiCallMetricCollector, DetectPiiEntitiesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$detectKeyPhrases$147(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detectKeyPhrases$146(List metricPublishers, MetricCollector apiCallMetricCollector, DetectKeyPhrasesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$detectEntities$143(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detectEntities$142(List metricPublishers, MetricCollector apiCallMetricCollector, DetectEntitiesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$detectDominantLanguage$139(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detectDominantLanguage$138(List metricPublishers, MetricCollector apiCallMetricCollector, DetectDominantLanguageResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeTopicsDetectionJob$135(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTopicsDetectionJob$134(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeTopicsDetectionJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeTargetedSentimentDetectionJob$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTargetedSentimentDetectionJob$130(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeTargetedSentimentDetectionJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeSentimentDetectionJob$127(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSentimentDetectionJob$126(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeSentimentDetectionJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeResourcePolicy$123(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeResourcePolicy$122(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeResourcePolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describePiiEntitiesDetectionJob$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describePiiEntitiesDetectionJob$118(List metricPublishers, MetricCollector apiCallMetricCollector, DescribePiiEntitiesDetectionJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeKeyPhrasesDetectionJob$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeKeyPhrasesDetectionJob$114(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeKeyPhrasesDetectionJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeFlywheelIteration$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFlywheelIteration$110(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeFlywheelIterationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeFlywheel$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFlywheel$106(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeFlywheelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeEventsDetectionJob$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEventsDetectionJob$102(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeEventsDetectionJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeEntityRecognizer$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEntityRecognizer$98(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeEntityRecognizerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeEntitiesDetectionJob$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEntitiesDetectionJob$94(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeEntitiesDetectionJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeEndpoint$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEndpoint$90(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeEndpointResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeDominantLanguageDetectionJob$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDominantLanguageDetectionJob$86(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeDominantLanguageDetectionJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeDocumentClassifier$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDocumentClassifier$82(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeDocumentClassifierResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeDocumentClassificationJob$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDocumentClassificationJob$78(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeDocumentClassificationJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeDataset$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDataset$74(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeDatasetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteResourcePolicy$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteResourcePolicy$70(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteResourcePolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteFlywheel$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFlywheel$66(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteFlywheelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteEntityRecognizer$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteEntityRecognizer$62(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteEntityRecognizerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteEndpoint$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteEndpoint$58(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteEndpointResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteDocumentClassifier$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDocumentClassifier$54(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteDocumentClassifierResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createFlywheel$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createFlywheel$50(List metricPublishers, MetricCollector apiCallMetricCollector, CreateFlywheelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createEntityRecognizer$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createEntityRecognizer$46(List metricPublishers, MetricCollector apiCallMetricCollector, CreateEntityRecognizerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createEndpoint$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createEndpoint$42(List metricPublishers, MetricCollector apiCallMetricCollector, CreateEndpointResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createDocumentClassifier$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDocumentClassifier$38(List metricPublishers, MetricCollector apiCallMetricCollector, CreateDocumentClassifierResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createDataset$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDataset$34(List metricPublishers, MetricCollector apiCallMetricCollector, CreateDatasetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$containsPiiEntities$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$containsPiiEntities$30(List metricPublishers, MetricCollector apiCallMetricCollector, ContainsPiiEntitiesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$classifyDocument$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$classifyDocument$26(List metricPublishers, MetricCollector apiCallMetricCollector, ClassifyDocumentResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchDetectTargetedSentiment$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDetectTargetedSentiment$22(List metricPublishers, MetricCollector apiCallMetricCollector, BatchDetectTargetedSentimentResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchDetectSyntax$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDetectSyntax$18(List metricPublishers, MetricCollector apiCallMetricCollector, BatchDetectSyntaxResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchDetectSentiment$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDetectSentiment$14(List metricPublishers, MetricCollector apiCallMetricCollector, BatchDetectSentimentResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchDetectKeyPhrases$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDetectKeyPhrases$10(List metricPublishers, MetricCollector apiCallMetricCollector, BatchDetectKeyPhrasesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchDetectEntities$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDetectEntities$6(List metricPublishers, MetricCollector apiCallMetricCollector, BatchDetectEntitiesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchDetectDominantLanguage$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDetectDominantLanguage$2(List metricPublishers, MetricCollector apiCallMetricCollector, BatchDetectDominantLanguageResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

