/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectEntitiesResponse extends ComprehendResponse implements
        ToCopyableBuilder<DetectEntitiesResponse.Builder, DetectEntitiesResponse> {
    private static final SdkField<List<Entity>> ENTITIES_FIELD = SdkField
            .<List<Entity>> builder(MarshallingType.LIST)
            .memberName("Entities")
            .getter(getter(DetectEntitiesResponse::entities))
            .setter(setter(Builder::entities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Entity> builder(MarshallingType.SDK_POJO)
                                            .constructor(Entity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DocumentMetadata> DOCUMENT_METADATA_FIELD = SdkField
            .<DocumentMetadata> builder(MarshallingType.SDK_POJO).memberName("DocumentMetadata")
            .getter(getter(DetectEntitiesResponse::documentMetadata)).setter(setter(Builder::documentMetadata))
            .constructor(DocumentMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentMetadata").build()).build();

    private static final SdkField<List<DocumentTypeListItem>> DOCUMENT_TYPE_FIELD = SdkField
            .<List<DocumentTypeListItem>> builder(MarshallingType.LIST)
            .memberName("DocumentType")
            .getter(getter(DetectEntitiesResponse::documentType))
            .setter(setter(Builder::documentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentType").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentTypeListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentTypeListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Block>> BLOCKS_FIELD = SdkField
            .<List<Block>> builder(MarshallingType.LIST)
            .memberName("Blocks")
            .getter(getter(DetectEntitiesResponse::blocks))
            .setter(setter(Builder::blocks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Blocks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Block> builder(MarshallingType.SDK_POJO)
                                            .constructor(Block::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ErrorsListItem>> ERRORS_FIELD = SdkField
            .<List<ErrorsListItem>> builder(MarshallingType.LIST)
            .memberName("Errors")
            .getter(getter(DetectEntitiesResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ErrorsListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(ErrorsListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITIES_FIELD,
            DOCUMENT_METADATA_FIELD, DOCUMENT_TYPE_FIELD, BLOCKS_FIELD, ERRORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Entity> entities;

    private final DocumentMetadata documentMetadata;

    private final List<DocumentTypeListItem> documentType;

    private final List<Block> blocks;

    private final List<ErrorsListItem> errors;

    private DetectEntitiesResponse(BuilderImpl builder) {
        super(builder);
        this.entities = builder.entities;
        this.documentMetadata = builder.documentMetadata;
        this.documentType = builder.documentType;
        this.blocks = builder.blocks;
        this.errors = builder.errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the Entities property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEntities() {
        return entities != null && !(entities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of entities identified in the input text. For each entity, the response provides the entity text,
     * entity type, where the entity text begins and ends, and the level of confidence that Amazon Comprehend has in the
     * detection.
     * </p>
     * <p>
     * If your request uses a custom entity recognition model, Amazon Comprehend detects the entities that the model is
     * trained to recognize. Otherwise, it detects the default entity types. For a list of default entity types, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/how-entities.html">Entities</a> in the Comprehend
     * Developer Guide.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntities} method.
     * </p>
     * 
     * @return A collection of entities identified in the input text. For each entity, the response provides the entity
     *         text, entity type, where the entity text begins and ends, and the level of confidence that Amazon
     *         Comprehend has in the detection. </p>
     *         <p>
     *         If your request uses a custom entity recognition model, Amazon Comprehend detects the entities that the
     *         model is trained to recognize. Otherwise, it detects the default entity types. For a list of default
     *         entity types, see <a
     *         href="https://docs.aws.amazon.com/comprehend/latest/dg/how-entities.html">Entities</a> in the Comprehend
     *         Developer Guide.
     */
    public final List<Entity> entities() {
        return entities;
    }

    /**
     * <p>
     * Information about the document, discovered during text extraction. This field is present in the response only if
     * your request used the <code>Byte</code> parameter.
     * </p>
     * 
     * @return Information about the document, discovered during text extraction. This field is present in the response
     *         only if your request used the <code>Byte</code> parameter.
     */
    public final DocumentMetadata documentMetadata() {
        return documentMetadata;
    }

    /**
     * For responses, this returns true if the service returned a value for the DocumentType property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDocumentType() {
        return documentType != null && !(documentType instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The document type for each page in the input document. This field is present in the response only if your request
     * used the <code>Byte</code> parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDocumentType} method.
     * </p>
     * 
     * @return The document type for each page in the input document. This field is present in the response only if your
     *         request used the <code>Byte</code> parameter.
     */
    public final List<DocumentTypeListItem> documentType() {
        return documentType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Blocks property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBlocks() {
        return blocks != null && !(blocks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about each block of text in the input document. Blocks are nested. A page block contains a block for
     * each line of text, which contains a block for each word.
     * </p>
     * <p>
     * The <code>Block</code> content for a Word input document does not include a <code>Geometry</code> field.
     * </p>
     * <p>
     * The <code>Block</code> field is not present in the response for plain-text inputs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlocks} method.
     * </p>
     * 
     * @return Information about each block of text in the input document. Blocks are nested. A page block contains a
     *         block for each line of text, which contains a block for each word. </p>
     *         <p>
     *         The <code>Block</code> content for a Word input document does not include a <code>Geometry</code> field.
     *         </p>
     *         <p>
     *         The <code>Block</code> field is not present in the response for plain-text inputs.
     */
    public final List<Block> blocks() {
        return blocks;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Page-level errors that the system detected while processing the input document. The field is empty if the system
     * encountered no errors.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return Page-level errors that the system detected while processing the input document. The field is empty if the
     *         system encountered no errors.
     */
    public final List<ErrorsListItem> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEntities() ? entities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(documentMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(hasDocumentType() ? documentType() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBlocks() ? blocks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectEntitiesResponse)) {
            return false;
        }
        DetectEntitiesResponse other = (DetectEntitiesResponse) obj;
        return hasEntities() == other.hasEntities() && Objects.equals(entities(), other.entities())
                && Objects.equals(documentMetadata(), other.documentMetadata()) && hasDocumentType() == other.hasDocumentType()
                && Objects.equals(documentType(), other.documentType()) && hasBlocks() == other.hasBlocks()
                && Objects.equals(blocks(), other.blocks()) && hasErrors() == other.hasErrors()
                && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectEntitiesResponse").add("Entities", hasEntities() ? entities() : null)
                .add("DocumentMetadata", documentMetadata()).add("DocumentType", hasDocumentType() ? documentType() : null)
                .add("Blocks", hasBlocks() ? blocks() : null).add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Entities":
            return Optional.ofNullable(clazz.cast(entities()));
        case "DocumentMetadata":
            return Optional.ofNullable(clazz.cast(documentMetadata()));
        case "DocumentType":
            return Optional.ofNullable(clazz.cast(documentType()));
        case "Blocks":
            return Optional.ofNullable(clazz.cast(blocks()));
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Entities", ENTITIES_FIELD);
        map.put("DocumentMetadata", DOCUMENT_METADATA_FIELD);
        map.put("DocumentType", DOCUMENT_TYPE_FIELD);
        map.put("Blocks", BLOCKS_FIELD);
        map.put("Errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DetectEntitiesResponse, T> g) {
        return obj -> g.apply((DetectEntitiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ComprehendResponse.Builder, SdkPojo, CopyableBuilder<Builder, DetectEntitiesResponse> {
        /**
         * <p>
         * A collection of entities identified in the input text. For each entity, the response provides the entity
         * text, entity type, where the entity text begins and ends, and the level of confidence that Amazon Comprehend
         * has in the detection.
         * </p>
         * <p>
         * If your request uses a custom entity recognition model, Amazon Comprehend detects the entities that the model
         * is trained to recognize. Otherwise, it detects the default entity types. For a list of default entity types,
         * see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-entities.html">Entities</a> in the
         * Comprehend Developer Guide.
         * </p>
         * 
         * @param entities
         *        A collection of entities identified in the input text. For each entity, the response provides the
         *        entity text, entity type, where the entity text begins and ends, and the level of confidence that
         *        Amazon Comprehend has in the detection. </p>
         *        <p>
         *        If your request uses a custom entity recognition model, Amazon Comprehend detects the entities that
         *        the model is trained to recognize. Otherwise, it detects the default entity types. For a list of
         *        default entity types, see <a
         *        href="https://docs.aws.amazon.com/comprehend/latest/dg/how-entities.html">Entities</a> in the
         *        Comprehend Developer Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entities(Collection<Entity> entities);

        /**
         * <p>
         * A collection of entities identified in the input text. For each entity, the response provides the entity
         * text, entity type, where the entity text begins and ends, and the level of confidence that Amazon Comprehend
         * has in the detection.
         * </p>
         * <p>
         * If your request uses a custom entity recognition model, Amazon Comprehend detects the entities that the model
         * is trained to recognize. Otherwise, it detects the default entity types. For a list of default entity types,
         * see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-entities.html">Entities</a> in the
         * Comprehend Developer Guide.
         * </p>
         * 
         * @param entities
         *        A collection of entities identified in the input text. For each entity, the response provides the
         *        entity text, entity type, where the entity text begins and ends, and the level of confidence that
         *        Amazon Comprehend has in the detection. </p>
         *        <p>
         *        If your request uses a custom entity recognition model, Amazon Comprehend detects the entities that
         *        the model is trained to recognize. Otherwise, it detects the default entity types. For a list of
         *        default entity types, see <a
         *        href="https://docs.aws.amazon.com/comprehend/latest/dg/how-entities.html">Entities</a> in the
         *        Comprehend Developer Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entities(Entity... entities);

        /**
         * <p>
         * A collection of entities identified in the input text. For each entity, the response provides the entity
         * text, entity type, where the entity text begins and ends, and the level of confidence that Amazon Comprehend
         * has in the detection.
         * </p>
         * <p>
         * If your request uses a custom entity recognition model, Amazon Comprehend detects the entities that the model
         * is trained to recognize. Otherwise, it detects the default entity types. For a list of default entity types,
         * see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-entities.html">Entities</a> in the
         * Comprehend Developer Guide.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.comprehend.model.Entity.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.comprehend.model.Entity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.comprehend.model.Entity.Builder#build()} is called immediately and its
         * result is passed to {@link #entities(List<Entity>)}.
         * 
         * @param entities
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.comprehend.model.Entity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entities(java.util.Collection<Entity>)
         */
        Builder entities(Consumer<Entity.Builder>... entities);

        /**
         * <p>
         * Information about the document, discovered during text extraction. This field is present in the response only
         * if your request used the <code>Byte</code> parameter.
         * </p>
         * 
         * @param documentMetadata
         *        Information about the document, discovered during text extraction. This field is present in the
         *        response only if your request used the <code>Byte</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentMetadata(DocumentMetadata documentMetadata);

        /**
         * <p>
         * Information about the document, discovered during text extraction. This field is present in the response only
         * if your request used the <code>Byte</code> parameter.
         * </p>
         * This is a convenience method that creates an instance of the {@link DocumentMetadata.Builder} avoiding the
         * need to create one manually via {@link DocumentMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #documentMetadata(DocumentMetadata)}.
         * 
         * @param documentMetadata
         *        a consumer that will call methods on {@link DocumentMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentMetadata(DocumentMetadata)
         */
        default Builder documentMetadata(Consumer<DocumentMetadata.Builder> documentMetadata) {
            return documentMetadata(DocumentMetadata.builder().applyMutation(documentMetadata).build());
        }

        /**
         * <p>
         * The document type for each page in the input document. This field is present in the response only if your
         * request used the <code>Byte</code> parameter.
         * </p>
         * 
         * @param documentType
         *        The document type for each page in the input document. This field is present in the response only if
         *        your request used the <code>Byte</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentType(Collection<DocumentTypeListItem> documentType);

        /**
         * <p>
         * The document type for each page in the input document. This field is present in the response only if your
         * request used the <code>Byte</code> parameter.
         * </p>
         * 
         * @param documentType
         *        The document type for each page in the input document. This field is present in the response only if
         *        your request used the <code>Byte</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentType(DocumentTypeListItem... documentType);

        /**
         * <p>
         * The document type for each page in the input document. This field is present in the response only if your
         * request used the <code>Byte</code> parameter.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.comprehend.model.DocumentTypeListItem.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.comprehend.model.DocumentTypeListItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.comprehend.model.DocumentTypeListItem.Builder#build()} is called
         * immediately and its result is passed to {@link #documentType(List<DocumentTypeListItem>)}.
         * 
         * @param documentType
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.comprehend.model.DocumentTypeListItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentType(java.util.Collection<DocumentTypeListItem>)
         */
        Builder documentType(Consumer<DocumentTypeListItem.Builder>... documentType);

        /**
         * <p>
         * Information about each block of text in the input document. Blocks are nested. A page block contains a block
         * for each line of text, which contains a block for each word.
         * </p>
         * <p>
         * The <code>Block</code> content for a Word input document does not include a <code>Geometry</code> field.
         * </p>
         * <p>
         * The <code>Block</code> field is not present in the response for plain-text inputs.
         * </p>
         * 
         * @param blocks
         *        Information about each block of text in the input document. Blocks are nested. A page block contains a
         *        block for each line of text, which contains a block for each word. </p>
         *        <p>
         *        The <code>Block</code> content for a Word input document does not include a <code>Geometry</code>
         *        field.
         *        </p>
         *        <p>
         *        The <code>Block</code> field is not present in the response for plain-text inputs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blocks(Collection<Block> blocks);

        /**
         * <p>
         * Information about each block of text in the input document. Blocks are nested. A page block contains a block
         * for each line of text, which contains a block for each word.
         * </p>
         * <p>
         * The <code>Block</code> content for a Word input document does not include a <code>Geometry</code> field.
         * </p>
         * <p>
         * The <code>Block</code> field is not present in the response for plain-text inputs.
         * </p>
         * 
         * @param blocks
         *        Information about each block of text in the input document. Blocks are nested. A page block contains a
         *        block for each line of text, which contains a block for each word. </p>
         *        <p>
         *        The <code>Block</code> content for a Word input document does not include a <code>Geometry</code>
         *        field.
         *        </p>
         *        <p>
         *        The <code>Block</code> field is not present in the response for plain-text inputs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blocks(Block... blocks);

        /**
         * <p>
         * Information about each block of text in the input document. Blocks are nested. A page block contains a block
         * for each line of text, which contains a block for each word.
         * </p>
         * <p>
         * The <code>Block</code> content for a Word input document does not include a <code>Geometry</code> field.
         * </p>
         * <p>
         * The <code>Block</code> field is not present in the response for plain-text inputs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.comprehend.model.Block.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.comprehend.model.Block#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.comprehend.model.Block.Builder#build()} is called immediately and its
         * result is passed to {@link #blocks(List<Block>)}.
         * 
         * @param blocks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.comprehend.model.Block.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blocks(java.util.Collection<Block>)
         */
        Builder blocks(Consumer<Block.Builder>... blocks);

        /**
         * <p>
         * Page-level errors that the system detected while processing the input document. The field is empty if the
         * system encountered no errors.
         * </p>
         * 
         * @param errors
         *        Page-level errors that the system detected while processing the input document. The field is empty if
         *        the system encountered no errors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<ErrorsListItem> errors);

        /**
         * <p>
         * Page-level errors that the system detected while processing the input document. The field is empty if the
         * system encountered no errors.
         * </p>
         * 
         * @param errors
         *        Page-level errors that the system detected while processing the input document. The field is empty if
         *        the system encountered no errors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(ErrorsListItem... errors);

        /**
         * <p>
         * Page-level errors that the system detected while processing the input document. The field is empty if the
         * system encountered no errors.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.comprehend.model.ErrorsListItem.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.comprehend.model.ErrorsListItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.comprehend.model.ErrorsListItem.Builder#build()} is called immediately
         * and its result is passed to {@link #errors(List<ErrorsListItem>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.comprehend.model.ErrorsListItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<ErrorsListItem>)
         */
        Builder errors(Consumer<ErrorsListItem.Builder>... errors);
    }

    static final class BuilderImpl extends ComprehendResponse.BuilderImpl implements Builder {
        private List<Entity> entities = DefaultSdkAutoConstructList.getInstance();

        private DocumentMetadata documentMetadata;

        private List<DocumentTypeListItem> documentType = DefaultSdkAutoConstructList.getInstance();

        private List<Block> blocks = DefaultSdkAutoConstructList.getInstance();

        private List<ErrorsListItem> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetectEntitiesResponse model) {
            super(model);
            entities(model.entities);
            documentMetadata(model.documentMetadata);
            documentType(model.documentType);
            blocks(model.blocks);
            errors(model.errors);
        }

        public final List<Entity.Builder> getEntities() {
            List<Entity.Builder> result = ListOfEntitiesCopier.copyToBuilder(this.entities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntities(Collection<Entity.BuilderImpl> entities) {
            this.entities = ListOfEntitiesCopier.copyFromBuilder(entities);
        }

        @Override
        public final Builder entities(Collection<Entity> entities) {
            this.entities = ListOfEntitiesCopier.copy(entities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(Entity... entities) {
            entities(Arrays.asList(entities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(Consumer<Entity.Builder>... entities) {
            entities(Stream.of(entities).map(c -> Entity.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final DocumentMetadata.Builder getDocumentMetadata() {
            return documentMetadata != null ? documentMetadata.toBuilder() : null;
        }

        public final void setDocumentMetadata(DocumentMetadata.BuilderImpl documentMetadata) {
            this.documentMetadata = documentMetadata != null ? documentMetadata.build() : null;
        }

        @Override
        public final Builder documentMetadata(DocumentMetadata documentMetadata) {
            this.documentMetadata = documentMetadata;
            return this;
        }

        public final List<DocumentTypeListItem.Builder> getDocumentType() {
            List<DocumentTypeListItem.Builder> result = ListOfDocumentTypeCopier.copyToBuilder(this.documentType);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocumentType(Collection<DocumentTypeListItem.BuilderImpl> documentType) {
            this.documentType = ListOfDocumentTypeCopier.copyFromBuilder(documentType);
        }

        @Override
        public final Builder documentType(Collection<DocumentTypeListItem> documentType) {
            this.documentType = ListOfDocumentTypeCopier.copy(documentType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentType(DocumentTypeListItem... documentType) {
            documentType(Arrays.asList(documentType));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentType(Consumer<DocumentTypeListItem.Builder>... documentType) {
            documentType(Stream.of(documentType).map(c -> DocumentTypeListItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Block.Builder> getBlocks() {
            List<Block.Builder> result = ListOfBlocksCopier.copyToBuilder(this.blocks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlocks(Collection<Block.BuilderImpl> blocks) {
            this.blocks = ListOfBlocksCopier.copyFromBuilder(blocks);
        }

        @Override
        public final Builder blocks(Collection<Block> blocks) {
            this.blocks = ListOfBlocksCopier.copy(blocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blocks(Block... blocks) {
            blocks(Arrays.asList(blocks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blocks(Consumer<Block.Builder>... blocks) {
            blocks(Stream.of(blocks).map(c -> Block.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ErrorsListItem.Builder> getErrors() {
            List<ErrorsListItem.Builder> result = ListOfErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<ErrorsListItem.BuilderImpl> errors) {
            this.errors = ListOfErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<ErrorsListItem> errors) {
            this.errors = ListOfErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(ErrorsListItem... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<ErrorsListItem.Builder>... errors) {
            errors(Stream.of(errors).map(c -> ErrorsListItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DetectEntitiesResponse build() {
            return new DetectEntitiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
