/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectToxicContentRequest extends ComprehendRequest implements
        ToCopyableBuilder<DetectToxicContentRequest.Builder, DetectToxicContentRequest> {
    private static final SdkField<List<TextSegment>> TEXT_SEGMENTS_FIELD = SdkField
            .<List<TextSegment>> builder(MarshallingType.LIST)
            .memberName("TextSegments")
            .getter(getter(DetectToxicContentRequest::textSegments))
            .setter(setter(Builder::textSegments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextSegments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TextSegment> builder(MarshallingType.SDK_POJO)
                                            .constructor(TextSegment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(DetectToxicContentRequest::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_SEGMENTS_FIELD,
            LANGUAGE_CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<TextSegment> textSegments;

    private final String languageCode;

    private DetectToxicContentRequest(BuilderImpl builder) {
        super(builder);
        this.textSegments = builder.textSegments;
        this.languageCode = builder.languageCode;
    }

    /**
     * For responses, this returns true if the service returned a value for the TextSegments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTextSegments() {
        return textSegments != null && !(textSegments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of up to 10 text strings. Each string has a maximum size of 1 KB, and the maximum size of the list is 10
     * KB.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTextSegments} method.
     * </p>
     * 
     * @return A list of up to 10 text strings. Each string has a maximum size of 1 KB, and the maximum size of the list
     *         is 10 KB.
     */
    public final List<TextSegment> textSegments() {
        return textSegments;
    }

    /**
     * <p>
     * The language of the input text. Currently, English is the only supported language.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language of the input text. Currently, English is the only supported language.
     * @see LanguageCode
     */
    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * The language of the input text. Currently, English is the only supported language.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language of the input text. Currently, English is the only supported language.
     * @see LanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTextSegments() ? textSegments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectToxicContentRequest)) {
            return false;
        }
        DetectToxicContentRequest other = (DetectToxicContentRequest) obj;
        return hasTextSegments() == other.hasTextSegments() && Objects.equals(textSegments(), other.textSegments())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectToxicContentRequest")
                .add("TextSegments", textSegments() == null ? null : "*** Sensitive Data Redacted ***")
                .add("LanguageCode", languageCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TextSegments":
            return Optional.ofNullable(clazz.cast(textSegments()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TextSegments", TEXT_SEGMENTS_FIELD);
        map.put("LanguageCode", LANGUAGE_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DetectToxicContentRequest, T> g) {
        return obj -> g.apply((DetectToxicContentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ComprehendRequest.Builder, SdkPojo, CopyableBuilder<Builder, DetectToxicContentRequest> {
        /**
         * <p>
         * A list of up to 10 text strings. Each string has a maximum size of 1 KB, and the maximum size of the list is
         * 10 KB.
         * </p>
         * 
         * @param textSegments
         *        A list of up to 10 text strings. Each string has a maximum size of 1 KB, and the maximum size of the
         *        list is 10 KB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textSegments(Collection<TextSegment> textSegments);

        /**
         * <p>
         * A list of up to 10 text strings. Each string has a maximum size of 1 KB, and the maximum size of the list is
         * 10 KB.
         * </p>
         * 
         * @param textSegments
         *        A list of up to 10 text strings. Each string has a maximum size of 1 KB, and the maximum size of the
         *        list is 10 KB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textSegments(TextSegment... textSegments);

        /**
         * <p>
         * A list of up to 10 text strings. Each string has a maximum size of 1 KB, and the maximum size of the list is
         * 10 KB.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.comprehend.model.TextSegment.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.comprehend.model.TextSegment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.comprehend.model.TextSegment.Builder#build()} is called immediately
         * and its result is passed to {@link #textSegments(List<TextSegment>)}.
         * 
         * @param textSegments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.comprehend.model.TextSegment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textSegments(java.util.Collection<TextSegment>)
         */
        Builder textSegments(Consumer<TextSegment.Builder>... textSegments);

        /**
         * <p>
         * The language of the input text. Currently, English is the only supported language.
         * </p>
         * 
         * @param languageCode
         *        The language of the input text. Currently, English is the only supported language.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The language of the input text. Currently, English is the only supported language.
         * </p>
         * 
         * @param languageCode
         *        The language of the input text. Currently, English is the only supported language.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ComprehendRequest.BuilderImpl implements Builder {
        private List<TextSegment> textSegments = DefaultSdkAutoConstructList.getInstance();

        private String languageCode;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectToxicContentRequest model) {
            super(model);
            textSegments(model.textSegments);
            languageCode(model.languageCode);
        }

        public final List<TextSegment.Builder> getTextSegments() {
            List<TextSegment.Builder> result = ListOfTextSegmentsCopier.copyToBuilder(this.textSegments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTextSegments(Collection<TextSegment.BuilderImpl> textSegments) {
            this.textSegments = ListOfTextSegmentsCopier.copyFromBuilder(textSegments);
        }

        @Override
        public final Builder textSegments(Collection<TextSegment> textSegments) {
            this.textSegments = ListOfTextSegmentsCopier.copy(textSegments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textSegments(TextSegment... textSegments) {
            textSegments(Arrays.asList(textSegments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textSegments(Consumer<TextSegment.Builder>... textSegments) {
            textSegments(Stream.of(textSegments).map(c -> TextSegment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DetectToxicContentRequest build() {
            return new DetectToxicContentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
