/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehendmedical.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehendmedical.model.RxNormAttribute;
import software.amazon.awssdk.services.comprehendmedical.model.RxNormAttributeListCopier;
import software.amazon.awssdk.services.comprehendmedical.model.RxNormConcept;
import software.amazon.awssdk.services.comprehendmedical.model.RxNormConceptListCopier;
import software.amazon.awssdk.services.comprehendmedical.model.RxNormEntityCategory;
import software.amazon.awssdk.services.comprehendmedical.model.RxNormEntityType;
import software.amazon.awssdk.services.comprehendmedical.model.RxNormTrait;
import software.amazon.awssdk.services.comprehendmedical.model.RxNormTraitListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RxNormEntity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RxNormEntity> {
    private static final SdkField<Integer> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Id").getter(RxNormEntity.getter(RxNormEntity::id)).setter(RxNormEntity.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Text").getter(RxNormEntity.getter(RxNormEntity::text)).setter(RxNormEntity.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()}).build();
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Category").getter(RxNormEntity.getter(RxNormEntity::categoryAsString)).setter(RxNormEntity.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(RxNormEntity.getter(RxNormEntity::typeAsString)).setter(RxNormEntity.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Float> SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Score").getter(RxNormEntity.getter(RxNormEntity::score)).setter(RxNormEntity.setter(Builder::score)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Score").build()}).build();
    private static final SdkField<Integer> BEGIN_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BeginOffset").getter(RxNormEntity.getter(RxNormEntity::beginOffset)).setter(RxNormEntity.setter(Builder::beginOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeginOffset").build()}).build();
    private static final SdkField<Integer> END_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EndOffset").getter(RxNormEntity.getter(RxNormEntity::endOffset)).setter(RxNormEntity.setter(Builder::endOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndOffset").build()}).build();
    private static final SdkField<List<RxNormAttribute>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Attributes").getter(RxNormEntity.getter(RxNormEntity::attributes)).setter(RxNormEntity.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RxNormAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RxNormTrait>> TRAITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Traits").getter(RxNormEntity.getter(RxNormEntity::traits)).setter(RxNormEntity.setter(Builder::traits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Traits").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RxNormTrait::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RxNormConcept>> RX_NORM_CONCEPTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RxNormConcepts").getter(RxNormEntity.getter(RxNormEntity::rxNormConcepts)).setter(RxNormEntity.setter(Builder::rxNormConcepts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RxNormConcepts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RxNormConcept::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TEXT_FIELD, CATEGORY_FIELD, TYPE_FIELD, SCORE_FIELD, BEGIN_OFFSET_FIELD, END_OFFSET_FIELD, ATTRIBUTES_FIELD, TRAITS_FIELD, RX_NORM_CONCEPTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer id;
    private final String text;
    private final String category;
    private final String type;
    private final Float score;
    private final Integer beginOffset;
    private final Integer endOffset;
    private final List<RxNormAttribute> attributes;
    private final List<RxNormTrait> traits;
    private final List<RxNormConcept> rxNormConcepts;

    private RxNormEntity(BuilderImpl builder) {
        this.id = builder.id;
        this.text = builder.text;
        this.category = builder.category;
        this.type = builder.type;
        this.score = builder.score;
        this.beginOffset = builder.beginOffset;
        this.endOffset = builder.endOffset;
        this.attributes = builder.attributes;
        this.traits = builder.traits;
        this.rxNormConcepts = builder.rxNormConcepts;
    }

    public final Integer id() {
        return this.id;
    }

    public final String text() {
        return this.text;
    }

    public final RxNormEntityCategory category() {
        return RxNormEntityCategory.fromValue(this.category);
    }

    public final String categoryAsString() {
        return this.category;
    }

    public final RxNormEntityType type() {
        return RxNormEntityType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Float score() {
        return this.score;
    }

    public final Integer beginOffset() {
        return this.beginOffset;
    }

    public final Integer endOffset() {
        return this.endOffset;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructList);
    }

    public final List<RxNormAttribute> attributes() {
        return this.attributes;
    }

    public final boolean hasTraits() {
        return this.traits != null && !(this.traits instanceof SdkAutoConstructList);
    }

    public final List<RxNormTrait> traits() {
        return this.traits;
    }

    public final boolean hasRxNormConcepts() {
        return this.rxNormConcepts != null && !(this.rxNormConcepts instanceof SdkAutoConstructList);
    }

    public final List<RxNormConcept> rxNormConcepts() {
        return this.rxNormConcepts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.score());
        hashCode = 31 * hashCode + Objects.hashCode(this.beginOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.endOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTraits() ? this.traits() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRxNormConcepts() ? this.rxNormConcepts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RxNormEntity)) {
            return false;
        }
        RxNormEntity other = (RxNormEntity)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.text(), other.text()) && Objects.equals(this.categoryAsString(), other.categoryAsString()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.score(), other.score()) && Objects.equals(this.beginOffset(), other.beginOffset()) && Objects.equals(this.endOffset(), other.endOffset()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && this.hasTraits() == other.hasTraits() && Objects.equals(this.traits(), other.traits()) && this.hasRxNormConcepts() == other.hasRxNormConcepts() && Objects.equals(this.rxNormConcepts(), other.rxNormConcepts());
    }

    public final String toString() {
        return ToString.builder((String)"RxNormEntity").add("Id", (Object)this.id()).add("Text", (Object)this.text()).add("Category", (Object)this.categoryAsString()).add("Type", (Object)this.typeAsString()).add("Score", (Object)this.score()).add("BeginOffset", (Object)this.beginOffset()).add("EndOffset", (Object)this.endOffset()).add("Attributes", this.hasAttributes() ? this.attributes() : null).add("Traits", this.hasTraits() ? this.traits() : null).add("RxNormConcepts", this.hasRxNormConcepts() ? this.rxNormConcepts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "Category": {
                return Optional.ofNullable(clazz.cast(this.categoryAsString()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Score": {
                return Optional.ofNullable(clazz.cast(this.score()));
            }
            case "BeginOffset": {
                return Optional.ofNullable(clazz.cast(this.beginOffset()));
            }
            case "EndOffset": {
                return Optional.ofNullable(clazz.cast(this.endOffset()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "Traits": {
                return Optional.ofNullable(clazz.cast(this.traits()));
            }
            case "RxNormConcepts": {
                return Optional.ofNullable(clazz.cast(this.rxNormConcepts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RxNormEntity, T> g) {
        return obj -> g.apply((RxNormEntity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer id;
        private String text;
        private String category;
        private String type;
        private Float score;
        private Integer beginOffset;
        private Integer endOffset;
        private List<RxNormAttribute> attributes = DefaultSdkAutoConstructList.getInstance();
        private List<RxNormTrait> traits = DefaultSdkAutoConstructList.getInstance();
        private List<RxNormConcept> rxNormConcepts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RxNormEntity model) {
            this.id(model.id);
            this.text(model.text);
            this.category(model.category);
            this.type(model.type);
            this.score(model.score);
            this.beginOffset(model.beginOffset);
            this.endOffset(model.endOffset);
            this.attributes(model.attributes);
            this.traits(model.traits);
            this.rxNormConcepts(model.rxNormConcepts);
        }

        public final Integer getId() {
            return this.id;
        }

        @Override
        public final Builder id(Integer id) {
            this.id = id;
            return this;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        public final String getText() {
            return this.text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final void setText(String text) {
            this.text = text;
        }

        public final String getCategory() {
            return this.category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(RxNormEntityCategory category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RxNormEntityType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Float getScore() {
            return this.score;
        }

        @Override
        public final Builder score(Float score) {
            this.score = score;
            return this;
        }

        public final void setScore(Float score) {
            this.score = score;
        }

        public final Integer getBeginOffset() {
            return this.beginOffset;
        }

        @Override
        public final Builder beginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
            return this;
        }

        public final void setBeginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
        }

        public final Integer getEndOffset() {
            return this.endOffset;
        }

        @Override
        public final Builder endOffset(Integer endOffset) {
            this.endOffset = endOffset;
            return this;
        }

        public final void setEndOffset(Integer endOffset) {
            this.endOffset = endOffset;
        }

        public final Collection<RxNormAttribute.Builder> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attributes != null ? (Collection)this.attributes.stream().map(RxNormAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributes(Collection<RxNormAttribute> attributes) {
            this.attributes = RxNormAttributeListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(RxNormAttribute ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<RxNormAttribute.Builder> ... attributes) {
            this.attributes(Stream.of(attributes).map(c -> (RxNormAttribute)((RxNormAttribute.Builder)RxNormAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttributes(Collection<RxNormAttribute.BuilderImpl> attributes) {
            this.attributes = RxNormAttributeListCopier.copyFromBuilder(attributes);
        }

        public final Collection<RxNormTrait.Builder> getTraits() {
            if (this.traits instanceof SdkAutoConstructList) {
                return null;
            }
            return this.traits != null ? (Collection)this.traits.stream().map(RxNormTrait::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder traits(Collection<RxNormTrait> traits) {
            this.traits = RxNormTraitListCopier.copy(traits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder traits(RxNormTrait ... traits) {
            this.traits(Arrays.asList(traits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder traits(Consumer<RxNormTrait.Builder> ... traits) {
            this.traits(Stream.of(traits).map(c -> (RxNormTrait)((RxNormTrait.Builder)RxNormTrait.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTraits(Collection<RxNormTrait.BuilderImpl> traits) {
            this.traits = RxNormTraitListCopier.copyFromBuilder(traits);
        }

        public final Collection<RxNormConcept.Builder> getRxNormConcepts() {
            if (this.rxNormConcepts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.rxNormConcepts != null ? (Collection)this.rxNormConcepts.stream().map(RxNormConcept::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rxNormConcepts(Collection<RxNormConcept> rxNormConcepts) {
            this.rxNormConcepts = RxNormConceptListCopier.copy(rxNormConcepts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rxNormConcepts(RxNormConcept ... rxNormConcepts) {
            this.rxNormConcepts(Arrays.asList(rxNormConcepts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rxNormConcepts(Consumer<RxNormConcept.Builder> ... rxNormConcepts) {
            this.rxNormConcepts(Stream.of(rxNormConcepts).map(c -> (RxNormConcept)((RxNormConcept.Builder)RxNormConcept.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRxNormConcepts(Collection<RxNormConcept.BuilderImpl> rxNormConcepts) {
            this.rxNormConcepts = RxNormConceptListCopier.copyFromBuilder(rxNormConcepts);
        }

        public RxNormEntity build() {
            return new RxNormEntity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RxNormEntity> {
        public Builder id(Integer var1);

        public Builder text(String var1);

        public Builder category(String var1);

        public Builder category(RxNormEntityCategory var1);

        public Builder type(String var1);

        public Builder type(RxNormEntityType var1);

        public Builder score(Float var1);

        public Builder beginOffset(Integer var1);

        public Builder endOffset(Integer var1);

        public Builder attributes(Collection<RxNormAttribute> var1);

        public Builder attributes(RxNormAttribute ... var1);

        public Builder attributes(Consumer<RxNormAttribute.Builder> ... var1);

        public Builder traits(Collection<RxNormTrait> var1);

        public Builder traits(RxNormTrait ... var1);

        public Builder traits(Consumer<RxNormTrait.Builder> ... var1);

        public Builder rxNormConcepts(Collection<RxNormConcept> var1);

        public Builder rxNormConcepts(RxNormConcept ... var1);

        public Builder rxNormConcepts(Consumer<RxNormConcept.Builder> ... var1);
    }
}

