/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehendmedical.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehendmedical.model.SNOMEDCTAttribute;
import software.amazon.awssdk.services.comprehendmedical.model.SNOMEDCTAttributeListCopier;
import software.amazon.awssdk.services.comprehendmedical.model.SNOMEDCTConcept;
import software.amazon.awssdk.services.comprehendmedical.model.SNOMEDCTConceptListCopier;
import software.amazon.awssdk.services.comprehendmedical.model.SNOMEDCTEntityCategory;
import software.amazon.awssdk.services.comprehendmedical.model.SNOMEDCTEntityType;
import software.amazon.awssdk.services.comprehendmedical.model.SNOMEDCTTrait;
import software.amazon.awssdk.services.comprehendmedical.model.SNOMEDCTTraitListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SNOMEDCTEntity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SNOMEDCTEntity> {
    private static final SdkField<Integer> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Id").getter(SNOMEDCTEntity.getter(SNOMEDCTEntity::id)).setter(SNOMEDCTEntity.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Text").getter(SNOMEDCTEntity.getter(SNOMEDCTEntity::text)).setter(SNOMEDCTEntity.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()}).build();
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Category").getter(SNOMEDCTEntity.getter(SNOMEDCTEntity::categoryAsString)).setter(SNOMEDCTEntity.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(SNOMEDCTEntity.getter(SNOMEDCTEntity::typeAsString)).setter(SNOMEDCTEntity.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Float> SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Score").getter(SNOMEDCTEntity.getter(SNOMEDCTEntity::score)).setter(SNOMEDCTEntity.setter(Builder::score)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Score").build()}).build();
    private static final SdkField<Integer> BEGIN_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BeginOffset").getter(SNOMEDCTEntity.getter(SNOMEDCTEntity::beginOffset)).setter(SNOMEDCTEntity.setter(Builder::beginOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeginOffset").build()}).build();
    private static final SdkField<Integer> END_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EndOffset").getter(SNOMEDCTEntity.getter(SNOMEDCTEntity::endOffset)).setter(SNOMEDCTEntity.setter(Builder::endOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndOffset").build()}).build();
    private static final SdkField<List<SNOMEDCTAttribute>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Attributes").getter(SNOMEDCTEntity.getter(SNOMEDCTEntity::attributes)).setter(SNOMEDCTEntity.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SNOMEDCTAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SNOMEDCTTrait>> TRAITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Traits").getter(SNOMEDCTEntity.getter(SNOMEDCTEntity::traits)).setter(SNOMEDCTEntity.setter(Builder::traits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Traits").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SNOMEDCTTrait::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SNOMEDCTConcept>> SNOMEDCT_CONCEPTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SNOMEDCTConcepts").getter(SNOMEDCTEntity.getter(SNOMEDCTEntity::snomedctConcepts)).setter(SNOMEDCTEntity.setter(Builder::snomedctConcepts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SNOMEDCTConcepts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SNOMEDCTConcept::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TEXT_FIELD, CATEGORY_FIELD, TYPE_FIELD, SCORE_FIELD, BEGIN_OFFSET_FIELD, END_OFFSET_FIELD, ATTRIBUTES_FIELD, TRAITS_FIELD, SNOMEDCT_CONCEPTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer id;
    private final String text;
    private final String category;
    private final String type;
    private final Float score;
    private final Integer beginOffset;
    private final Integer endOffset;
    private final List<SNOMEDCTAttribute> attributes;
    private final List<SNOMEDCTTrait> traits;
    private final List<SNOMEDCTConcept> snomedctConcepts;

    private SNOMEDCTEntity(BuilderImpl builder) {
        this.id = builder.id;
        this.text = builder.text;
        this.category = builder.category;
        this.type = builder.type;
        this.score = builder.score;
        this.beginOffset = builder.beginOffset;
        this.endOffset = builder.endOffset;
        this.attributes = builder.attributes;
        this.traits = builder.traits;
        this.snomedctConcepts = builder.snomedctConcepts;
    }

    public final Integer id() {
        return this.id;
    }

    public final String text() {
        return this.text;
    }

    public final SNOMEDCTEntityCategory category() {
        return SNOMEDCTEntityCategory.fromValue(this.category);
    }

    public final String categoryAsString() {
        return this.category;
    }

    public final SNOMEDCTEntityType type() {
        return SNOMEDCTEntityType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Float score() {
        return this.score;
    }

    public final Integer beginOffset() {
        return this.beginOffset;
    }

    public final Integer endOffset() {
        return this.endOffset;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructList);
    }

    public final List<SNOMEDCTAttribute> attributes() {
        return this.attributes;
    }

    public final boolean hasTraits() {
        return this.traits != null && !(this.traits instanceof SdkAutoConstructList);
    }

    public final List<SNOMEDCTTrait> traits() {
        return this.traits;
    }

    public final boolean hasSnomedctConcepts() {
        return this.snomedctConcepts != null && !(this.snomedctConcepts instanceof SdkAutoConstructList);
    }

    public final List<SNOMEDCTConcept> snomedctConcepts() {
        return this.snomedctConcepts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.score());
        hashCode = 31 * hashCode + Objects.hashCode(this.beginOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.endOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTraits() ? this.traits() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSnomedctConcepts() ? this.snomedctConcepts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SNOMEDCTEntity)) {
            return false;
        }
        SNOMEDCTEntity other = (SNOMEDCTEntity)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.text(), other.text()) && Objects.equals(this.categoryAsString(), other.categoryAsString()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.score(), other.score()) && Objects.equals(this.beginOffset(), other.beginOffset()) && Objects.equals(this.endOffset(), other.endOffset()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && this.hasTraits() == other.hasTraits() && Objects.equals(this.traits(), other.traits()) && this.hasSnomedctConcepts() == other.hasSnomedctConcepts() && Objects.equals(this.snomedctConcepts(), other.snomedctConcepts());
    }

    public final String toString() {
        return ToString.builder((String)"SNOMEDCTEntity").add("Id", (Object)this.id()).add("Text", (Object)this.text()).add("Category", (Object)this.categoryAsString()).add("Type", (Object)this.typeAsString()).add("Score", (Object)this.score()).add("BeginOffset", (Object)this.beginOffset()).add("EndOffset", (Object)this.endOffset()).add("Attributes", this.hasAttributes() ? this.attributes() : null).add("Traits", this.hasTraits() ? this.traits() : null).add("SNOMEDCTConcepts", this.hasSnomedctConcepts() ? this.snomedctConcepts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "Category": {
                return Optional.ofNullable(clazz.cast(this.categoryAsString()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Score": {
                return Optional.ofNullable(clazz.cast(this.score()));
            }
            case "BeginOffset": {
                return Optional.ofNullable(clazz.cast(this.beginOffset()));
            }
            case "EndOffset": {
                return Optional.ofNullable(clazz.cast(this.endOffset()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "Traits": {
                return Optional.ofNullable(clazz.cast(this.traits()));
            }
            case "SNOMEDCTConcepts": {
                return Optional.ofNullable(clazz.cast(this.snomedctConcepts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SNOMEDCTEntity, T> g) {
        return obj -> g.apply((SNOMEDCTEntity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer id;
        private String text;
        private String category;
        private String type;
        private Float score;
        private Integer beginOffset;
        private Integer endOffset;
        private List<SNOMEDCTAttribute> attributes = DefaultSdkAutoConstructList.getInstance();
        private List<SNOMEDCTTrait> traits = DefaultSdkAutoConstructList.getInstance();
        private List<SNOMEDCTConcept> snomedctConcepts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SNOMEDCTEntity model) {
            this.id(model.id);
            this.text(model.text);
            this.category(model.category);
            this.type(model.type);
            this.score(model.score);
            this.beginOffset(model.beginOffset);
            this.endOffset(model.endOffset);
            this.attributes(model.attributes);
            this.traits(model.traits);
            this.snomedctConcepts(model.snomedctConcepts);
        }

        public final Integer getId() {
            return this.id;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(Integer id) {
            this.id = id;
            return this;
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        @Transient
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final String getCategory() {
            return this.category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        @Transient
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        @Transient
        public final Builder category(SNOMEDCTEntityCategory category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(SNOMEDCTEntityType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Float getScore() {
            return this.score;
        }

        public final void setScore(Float score) {
            this.score = score;
        }

        @Override
        @Transient
        public final Builder score(Float score) {
            this.score = score;
            return this;
        }

        public final Integer getBeginOffset() {
            return this.beginOffset;
        }

        public final void setBeginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
        }

        @Override
        @Transient
        public final Builder beginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
            return this;
        }

        public final Integer getEndOffset() {
            return this.endOffset;
        }

        public final void setEndOffset(Integer endOffset) {
            this.endOffset = endOffset;
        }

        @Override
        @Transient
        public final Builder endOffset(Integer endOffset) {
            this.endOffset = endOffset;
            return this;
        }

        public final List<SNOMEDCTAttribute.Builder> getAttributes() {
            List<SNOMEDCTAttribute.Builder> result = SNOMEDCTAttributeListCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Collection<SNOMEDCTAttribute.BuilderImpl> attributes) {
            this.attributes = SNOMEDCTAttributeListCopier.copyFromBuilder(attributes);
        }

        @Override
        @Transient
        public final Builder attributes(Collection<SNOMEDCTAttribute> attributes) {
            this.attributes = SNOMEDCTAttributeListCopier.copy(attributes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attributes(SNOMEDCTAttribute ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attributes(Consumer<SNOMEDCTAttribute.Builder> ... attributes) {
            this.attributes(Stream.of(attributes).map(c -> (SNOMEDCTAttribute)((SNOMEDCTAttribute.Builder)SNOMEDCTAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SNOMEDCTTrait.Builder> getTraits() {
            List<SNOMEDCTTrait.Builder> result = SNOMEDCTTraitListCopier.copyToBuilder(this.traits);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTraits(Collection<SNOMEDCTTrait.BuilderImpl> traits) {
            this.traits = SNOMEDCTTraitListCopier.copyFromBuilder(traits);
        }

        @Override
        @Transient
        public final Builder traits(Collection<SNOMEDCTTrait> traits) {
            this.traits = SNOMEDCTTraitListCopier.copy(traits);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder traits(SNOMEDCTTrait ... traits) {
            this.traits(Arrays.asList(traits));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder traits(Consumer<SNOMEDCTTrait.Builder> ... traits) {
            this.traits(Stream.of(traits).map(c -> (SNOMEDCTTrait)((SNOMEDCTTrait.Builder)SNOMEDCTTrait.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SNOMEDCTConcept.Builder> getSnomedctConcepts() {
            List<SNOMEDCTConcept.Builder> result = SNOMEDCTConceptListCopier.copyToBuilder(this.snomedctConcepts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSnomedctConcepts(Collection<SNOMEDCTConcept.BuilderImpl> snomedctConcepts) {
            this.snomedctConcepts = SNOMEDCTConceptListCopier.copyFromBuilder(snomedctConcepts);
        }

        @Override
        @Transient
        public final Builder snomedctConcepts(Collection<SNOMEDCTConcept> snomedctConcepts) {
            this.snomedctConcepts = SNOMEDCTConceptListCopier.copy(snomedctConcepts);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder snomedctConcepts(SNOMEDCTConcept ... snomedctConcepts) {
            this.snomedctConcepts(Arrays.asList(snomedctConcepts));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder snomedctConcepts(Consumer<SNOMEDCTConcept.Builder> ... snomedctConcepts) {
            this.snomedctConcepts(Stream.of(snomedctConcepts).map(c -> (SNOMEDCTConcept)((SNOMEDCTConcept.Builder)SNOMEDCTConcept.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SNOMEDCTEntity build() {
            return new SNOMEDCTEntity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SNOMEDCTEntity> {
        public Builder id(Integer var1);

        public Builder text(String var1);

        public Builder category(String var1);

        public Builder category(SNOMEDCTEntityCategory var1);

        public Builder type(String var1);

        public Builder type(SNOMEDCTEntityType var1);

        public Builder score(Float var1);

        public Builder beginOffset(Integer var1);

        public Builder endOffset(Integer var1);

        public Builder attributes(Collection<SNOMEDCTAttribute> var1);

        public Builder attributes(SNOMEDCTAttribute ... var1);

        public Builder attributes(Consumer<SNOMEDCTAttribute.Builder> ... var1);

        public Builder traits(Collection<SNOMEDCTTrait> var1);

        public Builder traits(SNOMEDCTTrait ... var1);

        public Builder traits(Consumer<SNOMEDCTTrait.Builder> ... var1);

        public Builder snomedctConcepts(Collection<SNOMEDCTConcept> var1);

        public Builder snomedctConcepts(SNOMEDCTConcept ... var1);

        public Builder snomedctConcepts(Consumer<SNOMEDCTConcept.Builder> ... var1);
    }
}

