/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehendmedical.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EntitySubType {
    NAME("NAME"),
    DOSAGE("DOSAGE"),
    ROUTE_OR_MODE("ROUTE_OR_MODE"),
    FORM("FORM"),
    FREQUENCY("FREQUENCY"),
    DURATION("DURATION"),
    GENERIC_NAME("GENERIC_NAME"),
    BRAND_NAME("BRAND_NAME"),
    STRENGTH("STRENGTH"),
    RATE("RATE"),
    ACUITY("ACUITY"),
    TEST_NAME("TEST_NAME"),
    TEST_VALUE("TEST_VALUE"),
    TEST_UNITS("TEST_UNITS"),
    PROCEDURE_NAME("PROCEDURE_NAME"),
    TREATMENT_NAME("TREATMENT_NAME"),
    DATE("DATE"),
    AGE("AGE"),
    CONTACT_POINT("CONTACT_POINT"),
    EMAIL("EMAIL"),
    IDENTIFIER("IDENTIFIER"),
    URL("URL"),
    ADDRESS("ADDRESS"),
    PROFESSION("PROFESSION"),
    SYSTEM_ORGAN_SITE("SYSTEM_ORGAN_SITE"),
    DIRECTION("DIRECTION"),
    QUALITY("QUALITY"),
    QUANTITY("QUANTITY"),
    TIME_EXPRESSION("TIME_EXPRESSION"),
    TIME_TO_MEDICATION_NAME("TIME_TO_MEDICATION_NAME"),
    TIME_TO_DX_NAME("TIME_TO_DX_NAME"),
    TIME_TO_TEST_NAME("TIME_TO_TEST_NAME"),
    TIME_TO_PROCEDURE_NAME("TIME_TO_PROCEDURE_NAME"),
    TIME_TO_TREATMENT_NAME("TIME_TO_TREATMENT_NAME"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EntitySubType> VALUE_MAP;
    private final String value;

    private EntitySubType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EntitySubType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EntitySubType> knownValues() {
        EnumSet<EntitySubType> knownValues = EnumSet.allOf(EntitySubType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EntitySubType.class, EntitySubType::toString);
    }
}

