/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehendmedical;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.comprehendmedical.ComprehendMedicalAsyncClient;
import software.amazon.awssdk.services.comprehendmedical.ComprehendMedicalAsyncClientBuilder;
import software.amazon.awssdk.services.comprehendmedical.ComprehendMedicalServiceClientConfiguration;
import software.amazon.awssdk.services.comprehendmedical.DefaultComprehendMedicalAsyncClient;
import software.amazon.awssdk.services.comprehendmedical.DefaultComprehendMedicalBaseClientBuilder;
import software.amazon.awssdk.services.comprehendmedical.endpoints.ComprehendMedicalEndpointProvider;

@SdkInternalApi
final class DefaultComprehendMedicalAsyncClientBuilder
extends DefaultComprehendMedicalBaseClientBuilder<ComprehendMedicalAsyncClientBuilder, ComprehendMedicalAsyncClient>
implements ComprehendMedicalAsyncClientBuilder {
    DefaultComprehendMedicalAsyncClientBuilder() {
    }

    @Override
    public DefaultComprehendMedicalAsyncClientBuilder endpointProvider(ComprehendMedicalEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ComprehendMedicalAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultComprehendMedicalAsyncClientBuilder.validateClientOptions(clientConfiguration);
        ComprehendMedicalServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultComprehendMedicalAsyncClient client = new DefaultComprehendMedicalAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ComprehendMedicalServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ComprehendMedicalServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

