/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehendmedical;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.comprehendmedical.ComprehendMedicalClient;
import software.amazon.awssdk.services.comprehendmedical.ComprehendMedicalServiceClientConfiguration;
import software.amazon.awssdk.services.comprehendmedical.internal.ComprehendMedicalServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.comprehendmedical.model.ComprehendMedicalException;
import software.amazon.awssdk.services.comprehendmedical.model.DescribeEntitiesDetectionV2JobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.DescribeEntitiesDetectionV2JobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.DescribeIcd10CmInferenceJobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.DescribeIcd10CmInferenceJobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.DescribePhiDetectionJobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.DescribePhiDetectionJobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.DescribeRxNormInferenceJobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.DescribeRxNormInferenceJobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.DescribeSnomedctInferenceJobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.DescribeSnomedctInferenceJobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.DetectEntitiesRequest;
import software.amazon.awssdk.services.comprehendmedical.model.DetectEntitiesResponse;
import software.amazon.awssdk.services.comprehendmedical.model.DetectEntitiesV2Request;
import software.amazon.awssdk.services.comprehendmedical.model.DetectEntitiesV2Response;
import software.amazon.awssdk.services.comprehendmedical.model.DetectPhiRequest;
import software.amazon.awssdk.services.comprehendmedical.model.DetectPhiResponse;
import software.amazon.awssdk.services.comprehendmedical.model.InferIcd10CmRequest;
import software.amazon.awssdk.services.comprehendmedical.model.InferIcd10CmResponse;
import software.amazon.awssdk.services.comprehendmedical.model.InferRxNormRequest;
import software.amazon.awssdk.services.comprehendmedical.model.InferRxNormResponse;
import software.amazon.awssdk.services.comprehendmedical.model.InferSnomedctRequest;
import software.amazon.awssdk.services.comprehendmedical.model.InferSnomedctResponse;
import software.amazon.awssdk.services.comprehendmedical.model.InternalServerException;
import software.amazon.awssdk.services.comprehendmedical.model.InvalidEncodingException;
import software.amazon.awssdk.services.comprehendmedical.model.InvalidRequestException;
import software.amazon.awssdk.services.comprehendmedical.model.ListEntitiesDetectionV2JobsRequest;
import software.amazon.awssdk.services.comprehendmedical.model.ListEntitiesDetectionV2JobsResponse;
import software.amazon.awssdk.services.comprehendmedical.model.ListIcd10CmInferenceJobsRequest;
import software.amazon.awssdk.services.comprehendmedical.model.ListIcd10CmInferenceJobsResponse;
import software.amazon.awssdk.services.comprehendmedical.model.ListPhiDetectionJobsRequest;
import software.amazon.awssdk.services.comprehendmedical.model.ListPhiDetectionJobsResponse;
import software.amazon.awssdk.services.comprehendmedical.model.ListRxNormInferenceJobsRequest;
import software.amazon.awssdk.services.comprehendmedical.model.ListRxNormInferenceJobsResponse;
import software.amazon.awssdk.services.comprehendmedical.model.ListSnomedctInferenceJobsRequest;
import software.amazon.awssdk.services.comprehendmedical.model.ListSnomedctInferenceJobsResponse;
import software.amazon.awssdk.services.comprehendmedical.model.ResourceNotFoundException;
import software.amazon.awssdk.services.comprehendmedical.model.ServiceUnavailableException;
import software.amazon.awssdk.services.comprehendmedical.model.StartEntitiesDetectionV2JobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.StartEntitiesDetectionV2JobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.StartIcd10CmInferenceJobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.StartIcd10CmInferenceJobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.StartPhiDetectionJobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.StartPhiDetectionJobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.StartRxNormInferenceJobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.StartRxNormInferenceJobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.StartSnomedctInferenceJobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.StartSnomedctInferenceJobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.StopEntitiesDetectionV2JobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.StopEntitiesDetectionV2JobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.StopIcd10CmInferenceJobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.StopIcd10CmInferenceJobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.StopPhiDetectionJobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.StopPhiDetectionJobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.StopRxNormInferenceJobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.StopRxNormInferenceJobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.StopSnomedctInferenceJobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.StopSnomedctInferenceJobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.TextSizeLimitExceededException;
import software.amazon.awssdk.services.comprehendmedical.model.TooManyRequestsException;
import software.amazon.awssdk.services.comprehendmedical.model.ValidationException;
import software.amazon.awssdk.services.comprehendmedical.transform.DescribeEntitiesDetectionV2JobRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.DescribeIcd10CmInferenceJobRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.DescribePhiDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.DescribeRxNormInferenceJobRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.DescribeSnomedctInferenceJobRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.DetectEntitiesRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.DetectEntitiesV2RequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.DetectPhiRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.InferIcd10CmRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.InferRxNormRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.InferSnomedctRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.ListEntitiesDetectionV2JobsRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.ListIcd10CmInferenceJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.ListPhiDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.ListRxNormInferenceJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.ListSnomedctInferenceJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.StartEntitiesDetectionV2JobRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.StartIcd10CmInferenceJobRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.StartPhiDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.StartRxNormInferenceJobRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.StartSnomedctInferenceJobRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.StopEntitiesDetectionV2JobRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.StopIcd10CmInferenceJobRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.StopPhiDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.StopRxNormInferenceJobRequestMarshaller;
import software.amazon.awssdk.services.comprehendmedical.transform.StopSnomedctInferenceJobRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultComprehendMedicalClient
implements ComprehendMedicalClient {
    private static final Logger log = Logger.loggerFor(DefaultComprehendMedicalClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final ComprehendMedicalServiceClientConfiguration serviceClientConfiguration;

    protected DefaultComprehendMedicalClient(ComprehendMedicalServiceClientConfiguration serviceClientConfiguration, SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEntitiesDetectionV2JobResponse describeEntitiesDetectionV2Job(DescribeEntitiesDetectionV2JobRequest describeEntitiesDetectionV2JobRequest) throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEntitiesDetectionV2JobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeEntitiesDetectionV2JobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendMedicalClient.resolveMetricPublishers(clientConfiguration, describeEntitiesDetectionV2JobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEntitiesDetectionV2Job");
            DescribeEntitiesDetectionV2JobResponse describeEntitiesDetectionV2JobResponse = (DescribeEntitiesDetectionV2JobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEntitiesDetectionV2Job").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeEntitiesDetectionV2JobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEntitiesDetectionV2JobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEntitiesDetectionV2JobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendMedicalClient.lambda$describeEntitiesDetectionV2Job$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeIcd10CmInferenceJobResponse describeICD10CMInferenceJob(DescribeIcd10CmInferenceJobRequest describeIcd10CmInferenceJobRequest) throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeIcd10CmInferenceJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeIcd10CmInferenceJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendMedicalClient.resolveMetricPublishers(clientConfiguration, describeIcd10CmInferenceJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeICD10CMInferenceJob");
            DescribeIcd10CmInferenceJobResponse describeIcd10CmInferenceJobResponse = (DescribeIcd10CmInferenceJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeICD10CMInferenceJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeIcd10CmInferenceJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeIcd10CmInferenceJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeIcd10CmInferenceJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendMedicalClient.lambda$describeICD10CMInferenceJob$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribePhiDetectionJobResponse describePHIDetectionJob(DescribePhiDetectionJobRequest describePhiDetectionJobRequest) throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribePhiDetectionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describePhiDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendMedicalClient.resolveMetricPublishers(clientConfiguration, describePhiDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribePHIDetectionJob");
            DescribePhiDetectionJobResponse describePhiDetectionJobResponse = (DescribePhiDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePHIDetectionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describePhiDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribePhiDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describePhiDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendMedicalClient.lambda$describePHIDetectionJob$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRxNormInferenceJobResponse describeRxNormInferenceJob(DescribeRxNormInferenceJobRequest describeRxNormInferenceJobRequest) throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRxNormInferenceJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeRxNormInferenceJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendMedicalClient.resolveMetricPublishers(clientConfiguration, describeRxNormInferenceJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRxNormInferenceJob");
            DescribeRxNormInferenceJobResponse describeRxNormInferenceJobResponse = (DescribeRxNormInferenceJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRxNormInferenceJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeRxNormInferenceJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeRxNormInferenceJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeRxNormInferenceJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendMedicalClient.lambda$describeRxNormInferenceJob$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSnomedctInferenceJobResponse describeSNOMEDCTInferenceJob(DescribeSnomedctInferenceJobRequest describeSnomedctInferenceJobRequest) throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSnomedctInferenceJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeSnomedctInferenceJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendMedicalClient.resolveMetricPublishers(clientConfiguration, describeSnomedctInferenceJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSNOMEDCTInferenceJob");
            DescribeSnomedctInferenceJobResponse describeSnomedctInferenceJobResponse = (DescribeSnomedctInferenceJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSNOMEDCTInferenceJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeSnomedctInferenceJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeSnomedctInferenceJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeSnomedctInferenceJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendMedicalClient.lambda$describeSNOMEDCTInferenceJob$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetectEntitiesResponse detectEntities(DetectEntitiesRequest detectEntitiesRequest) throws InternalServerException, ServiceUnavailableException, TooManyRequestsException, InvalidRequestException, InvalidEncodingException, TextSizeLimitExceededException, AwsServiceException, SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectEntitiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detectEntitiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendMedicalClient.resolveMetricPublishers(clientConfiguration, detectEntitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetectEntities");
            DetectEntitiesResponse detectEntitiesResponse = (DetectEntitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectEntities").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)detectEntitiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DetectEntitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return detectEntitiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendMedicalClient.lambda$detectEntities$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetectEntitiesV2Response detectEntitiesV2(DetectEntitiesV2Request detectEntitiesV2Request) throws InternalServerException, ServiceUnavailableException, TooManyRequestsException, InvalidRequestException, InvalidEncodingException, TextSizeLimitExceededException, AwsServiceException, SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectEntitiesV2Response::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detectEntitiesV2Request, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendMedicalClient.resolveMetricPublishers(clientConfiguration, detectEntitiesV2Request.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetectEntitiesV2");
            DetectEntitiesV2Response detectEntitiesV2Response = (DetectEntitiesV2Response)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectEntitiesV2").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)detectEntitiesV2Request).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DetectEntitiesV2RequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return detectEntitiesV2Response;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendMedicalClient.lambda$detectEntitiesV2$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetectPhiResponse detectPHI(DetectPhiRequest detectPhiRequest) throws InternalServerException, ServiceUnavailableException, TooManyRequestsException, InvalidRequestException, InvalidEncodingException, TextSizeLimitExceededException, AwsServiceException, SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectPhiResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detectPhiRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendMedicalClient.resolveMetricPublishers(clientConfiguration, detectPhiRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetectPHI");
            DetectPhiResponse detectPhiResponse = (DetectPhiResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectPHI").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)detectPhiRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DetectPhiRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return detectPhiResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendMedicalClient.lambda$detectPHI$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InferIcd10CmResponse inferICD10CM(InferIcd10CmRequest inferIcd10CmRequest) throws InternalServerException, ServiceUnavailableException, TooManyRequestsException, InvalidRequestException, InvalidEncodingException, TextSizeLimitExceededException, AwsServiceException, SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, InferIcd10CmResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)inferIcd10CmRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendMedicalClient.resolveMetricPublishers(clientConfiguration, inferIcd10CmRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"InferICD10CM");
            InferIcd10CmResponse inferIcd10CmResponse = (InferIcd10CmResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("InferICD10CM").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)inferIcd10CmRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new InferIcd10CmRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return inferIcd10CmResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendMedicalClient.lambda$inferICD10CM$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InferRxNormResponse inferRxNorm(InferRxNormRequest inferRxNormRequest) throws InternalServerException, ServiceUnavailableException, TooManyRequestsException, InvalidRequestException, InvalidEncodingException, TextSizeLimitExceededException, AwsServiceException, SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, InferRxNormResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)inferRxNormRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendMedicalClient.resolveMetricPublishers(clientConfiguration, inferRxNormRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"InferRxNorm");
            InferRxNormResponse inferRxNormResponse = (InferRxNormResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("InferRxNorm").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)inferRxNormRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new InferRxNormRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return inferRxNormResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendMedicalClient.lambda$inferRxNorm$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InferSnomedctResponse inferSNOMEDCT(InferSnomedctRequest inferSnomedctRequest) throws InternalServerException, ServiceUnavailableException, TooManyRequestsException, InvalidRequestException, InvalidEncodingException, TextSizeLimitExceededException, AwsServiceException, SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, InferSnomedctResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)inferSnomedctRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendMedicalClient.resolveMetricPublishers(clientConfiguration, inferSnomedctRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"InferSNOMEDCT");
            InferSnomedctResponse inferSnomedctResponse = (InferSnomedctResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("InferSNOMEDCT").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)inferSnomedctRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new InferSnomedctRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return inferSnomedctResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendMedicalClient.lambda$inferSNOMEDCT$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEntitiesDetectionV2JobsResponse listEntitiesDetectionV2Jobs(ListEntitiesDetectionV2JobsRequest listEntitiesDetectionV2JobsRequest) throws InvalidRequestException, ValidationException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEntitiesDetectionV2JobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listEntitiesDetectionV2JobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendMedicalClient.resolveMetricPublishers(clientConfiguration, listEntitiesDetectionV2JobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEntitiesDetectionV2Jobs");
            ListEntitiesDetectionV2JobsResponse listEntitiesDetectionV2JobsResponse = (ListEntitiesDetectionV2JobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEntitiesDetectionV2Jobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listEntitiesDetectionV2JobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListEntitiesDetectionV2JobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listEntitiesDetectionV2JobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendMedicalClient.lambda$listEntitiesDetectionV2Jobs$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIcd10CmInferenceJobsResponse listICD10CMInferenceJobs(ListIcd10CmInferenceJobsRequest listIcd10CmInferenceJobsRequest) throws InvalidRequestException, ValidationException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListIcd10CmInferenceJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listIcd10CmInferenceJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendMedicalClient.resolveMetricPublishers(clientConfiguration, listIcd10CmInferenceJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListICD10CMInferenceJobs");
            ListIcd10CmInferenceJobsResponse listIcd10CmInferenceJobsResponse = (ListIcd10CmInferenceJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListICD10CMInferenceJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listIcd10CmInferenceJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListIcd10CmInferenceJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listIcd10CmInferenceJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendMedicalClient.lambda$listICD10CMInferenceJobs$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPhiDetectionJobsResponse listPHIDetectionJobs(ListPhiDetectionJobsRequest listPhiDetectionJobsRequest) throws InvalidRequestException, ValidationException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPhiDetectionJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPhiDetectionJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendMedicalClient.resolveMetricPublishers(clientConfiguration, listPhiDetectionJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPHIDetectionJobs");
            ListPhiDetectionJobsResponse listPhiDetectionJobsResponse = (ListPhiDetectionJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPHIDetectionJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listPhiDetectionJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPhiDetectionJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPhiDetectionJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendMedicalClient.lambda$listPHIDetectionJobs$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRxNormInferenceJobsResponse listRxNormInferenceJobs(ListRxNormInferenceJobsRequest listRxNormInferenceJobsRequest) throws InvalidRequestException, ValidationException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRxNormInferenceJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listRxNormInferenceJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendMedicalClient.resolveMetricPublishers(clientConfiguration, listRxNormInferenceJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRxNormInferenceJobs");
            ListRxNormInferenceJobsResponse listRxNormInferenceJobsResponse = (ListRxNormInferenceJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRxNormInferenceJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listRxNormInferenceJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRxNormInferenceJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRxNormInferenceJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendMedicalClient.lambda$listRxNormInferenceJobs$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSnomedctInferenceJobsResponse listSNOMEDCTInferenceJobs(ListSnomedctInferenceJobsRequest listSnomedctInferenceJobsRequest) throws InvalidRequestException, ValidationException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSnomedctInferenceJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listSnomedctInferenceJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendMedicalClient.resolveMetricPublishers(clientConfiguration, listSnomedctInferenceJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSNOMEDCTInferenceJobs");
            ListSnomedctInferenceJobsResponse listSnomedctInferenceJobsResponse = (ListSnomedctInferenceJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSNOMEDCTInferenceJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listSnomedctInferenceJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSnomedctInferenceJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSnomedctInferenceJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendMedicalClient.lambda$listSNOMEDCTInferenceJobs$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartEntitiesDetectionV2JobResponse startEntitiesDetectionV2Job(StartEntitiesDetectionV2JobRequest startEntitiesDetectionV2JobRequest) throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartEntitiesDetectionV2JobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startEntitiesDetectionV2JobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendMedicalClient.resolveMetricPublishers(clientConfiguration, startEntitiesDetectionV2JobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartEntitiesDetectionV2Job");
            StartEntitiesDetectionV2JobResponse startEntitiesDetectionV2JobResponse = (StartEntitiesDetectionV2JobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartEntitiesDetectionV2Job").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startEntitiesDetectionV2JobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartEntitiesDetectionV2JobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startEntitiesDetectionV2JobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendMedicalClient.lambda$startEntitiesDetectionV2Job$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartIcd10CmInferenceJobResponse startICD10CMInferenceJob(StartIcd10CmInferenceJobRequest startIcd10CmInferenceJobRequest) throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartIcd10CmInferenceJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startIcd10CmInferenceJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendMedicalClient.resolveMetricPublishers(clientConfiguration, startIcd10CmInferenceJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartICD10CMInferenceJob");
            StartIcd10CmInferenceJobResponse startIcd10CmInferenceJobResponse = (StartIcd10CmInferenceJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartICD10CMInferenceJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startIcd10CmInferenceJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartIcd10CmInferenceJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startIcd10CmInferenceJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendMedicalClient.lambda$startICD10CMInferenceJob$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartPhiDetectionJobResponse startPHIDetectionJob(StartPhiDetectionJobRequest startPhiDetectionJobRequest) throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartPhiDetectionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startPhiDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendMedicalClient.resolveMetricPublishers(clientConfiguration, startPhiDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartPHIDetectionJob");
            StartPhiDetectionJobResponse startPhiDetectionJobResponse = (StartPhiDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartPHIDetectionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startPhiDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartPhiDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startPhiDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendMedicalClient.lambda$startPHIDetectionJob$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartRxNormInferenceJobResponse startRxNormInferenceJob(StartRxNormInferenceJobRequest startRxNormInferenceJobRequest) throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartRxNormInferenceJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startRxNormInferenceJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendMedicalClient.resolveMetricPublishers(clientConfiguration, startRxNormInferenceJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartRxNormInferenceJob");
            StartRxNormInferenceJobResponse startRxNormInferenceJobResponse = (StartRxNormInferenceJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartRxNormInferenceJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startRxNormInferenceJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartRxNormInferenceJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startRxNormInferenceJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendMedicalClient.lambda$startRxNormInferenceJob$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartSnomedctInferenceJobResponse startSNOMEDCTInferenceJob(StartSnomedctInferenceJobRequest startSnomedctInferenceJobRequest) throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartSnomedctInferenceJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startSnomedctInferenceJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendMedicalClient.resolveMetricPublishers(clientConfiguration, startSnomedctInferenceJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartSNOMEDCTInferenceJob");
            StartSnomedctInferenceJobResponse startSnomedctInferenceJobResponse = (StartSnomedctInferenceJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartSNOMEDCTInferenceJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startSnomedctInferenceJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartSnomedctInferenceJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startSnomedctInferenceJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendMedicalClient.lambda$startSNOMEDCTInferenceJob$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopEntitiesDetectionV2JobResponse stopEntitiesDetectionV2Job(StopEntitiesDetectionV2JobRequest stopEntitiesDetectionV2JobRequest) throws InvalidRequestException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopEntitiesDetectionV2JobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopEntitiesDetectionV2JobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendMedicalClient.resolveMetricPublishers(clientConfiguration, stopEntitiesDetectionV2JobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopEntitiesDetectionV2Job");
            StopEntitiesDetectionV2JobResponse stopEntitiesDetectionV2JobResponse = (StopEntitiesDetectionV2JobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopEntitiesDetectionV2Job").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopEntitiesDetectionV2JobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopEntitiesDetectionV2JobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopEntitiesDetectionV2JobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendMedicalClient.lambda$stopEntitiesDetectionV2Job$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopIcd10CmInferenceJobResponse stopICD10CMInferenceJob(StopIcd10CmInferenceJobRequest stopIcd10CmInferenceJobRequest) throws InvalidRequestException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopIcd10CmInferenceJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopIcd10CmInferenceJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendMedicalClient.resolveMetricPublishers(clientConfiguration, stopIcd10CmInferenceJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopICD10CMInferenceJob");
            StopIcd10CmInferenceJobResponse stopIcd10CmInferenceJobResponse = (StopIcd10CmInferenceJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopICD10CMInferenceJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopIcd10CmInferenceJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopIcd10CmInferenceJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopIcd10CmInferenceJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendMedicalClient.lambda$stopICD10CMInferenceJob$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopPhiDetectionJobResponse stopPHIDetectionJob(StopPhiDetectionJobRequest stopPhiDetectionJobRequest) throws InvalidRequestException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopPhiDetectionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopPhiDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendMedicalClient.resolveMetricPublishers(clientConfiguration, stopPhiDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopPHIDetectionJob");
            StopPhiDetectionJobResponse stopPhiDetectionJobResponse = (StopPhiDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopPHIDetectionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopPhiDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopPhiDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopPhiDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendMedicalClient.lambda$stopPHIDetectionJob$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopRxNormInferenceJobResponse stopRxNormInferenceJob(StopRxNormInferenceJobRequest stopRxNormInferenceJobRequest) throws InvalidRequestException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopRxNormInferenceJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopRxNormInferenceJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendMedicalClient.resolveMetricPublishers(clientConfiguration, stopRxNormInferenceJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopRxNormInferenceJob");
            StopRxNormInferenceJobResponse stopRxNormInferenceJobResponse = (StopRxNormInferenceJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopRxNormInferenceJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopRxNormInferenceJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopRxNormInferenceJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopRxNormInferenceJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendMedicalClient.lambda$stopRxNormInferenceJob$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopSnomedctInferenceJobResponse stopSNOMEDCTInferenceJob(StopSnomedctInferenceJobRequest stopSnomedctInferenceJobRequest) throws InvalidRequestException, ResourceNotFoundException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendMedicalException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopSnomedctInferenceJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopSnomedctInferenceJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendMedicalClient.resolveMetricPublishers(clientConfiguration, stopSnomedctInferenceJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ComprehendMedical");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopSNOMEDCTInferenceJob");
            StopSnomedctInferenceJobResponse stopSnomedctInferenceJobResponse = (StopSnomedctInferenceJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopSNOMEDCTInferenceJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopSnomedctInferenceJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopSnomedctInferenceJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopSnomedctInferenceJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendMedicalClient.lambda$stopSNOMEDCTInferenceJob$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "comprehendmedical";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        ComprehendMedicalServiceClientConfigurationBuilder.BuilderInternal serviceConfigBuilder = ComprehendMedicalServiceClientConfigurationBuilder.builder(clientConfiguration.toBuilder());
        serviceConfigBuilder.overrideConfiguration(this.serviceClientConfiguration.overrideConfiguration());
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        return serviceConfigBuilder.buildSdkClientConfiguration();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ComprehendMedicalException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").exceptionBuilderSupplier(TextSizeLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidEncodingException").exceptionBuilderSupplier(InvalidEncodingException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").exceptionBuilderSupplier(ServiceUnavailableException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyRequestsException").exceptionBuilderSupplier(TooManyRequestsException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    @Override
    public final ComprehendMedicalServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$stopSNOMEDCTInferenceJob$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopRxNormInferenceJob$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopPHIDetectionJob$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopICD10CMInferenceJob$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopEntitiesDetectionV2Job$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startSNOMEDCTInferenceJob$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startRxNormInferenceJob$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startPHIDetectionJob$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startICD10CMInferenceJob$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startEntitiesDetectionV2Job$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSNOMEDCTInferenceJobs$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRxNormInferenceJobs$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPHIDetectionJobs$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listICD10CMInferenceJobs$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEntitiesDetectionV2Jobs$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$inferSNOMEDCT$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$inferRxNorm$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$inferICD10CM$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detectPHI$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detectEntitiesV2$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detectEntities$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSNOMEDCTInferenceJob$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeRxNormInferenceJob$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describePHIDetectionJob$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeICD10CMInferenceJob$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEntitiesDetectionV2Job$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

