/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehendmedical.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SNOMEDCTEntityType {
    DX_NAME("DX_NAME"),
    TEST_NAME("TEST_NAME"),
    PROCEDURE_NAME("PROCEDURE_NAME"),
    TREATMENT_NAME("TREATMENT_NAME"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SNOMEDCTEntityType> VALUE_MAP;
    private final String value;

    private SNOMEDCTEntityType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SNOMEDCTEntityType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SNOMEDCTEntityType> knownValues() {
        EnumSet<SNOMEDCTEntityType> knownValues = EnumSet.allOf(SNOMEDCTEntityType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SNOMEDCTEntityType.class, SNOMEDCTEntityType::toString);
    }
}

