/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehendmedical;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.comprehendmedical.model.ComprehendMedicalException;
import software.amazon.awssdk.services.comprehendmedical.model.DescribeEntitiesDetectionV2JobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.DescribeEntitiesDetectionV2JobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.DescribeIcd10CmInferenceJobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.DescribeIcd10CmInferenceJobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.DescribePhiDetectionJobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.DescribePhiDetectionJobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.DescribeRxNormInferenceJobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.DescribeRxNormInferenceJobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.DescribeSnomedctInferenceJobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.DescribeSnomedctInferenceJobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.DetectEntitiesRequest;
import software.amazon.awssdk.services.comprehendmedical.model.DetectEntitiesResponse;
import software.amazon.awssdk.services.comprehendmedical.model.DetectEntitiesV2Request;
import software.amazon.awssdk.services.comprehendmedical.model.DetectEntitiesV2Response;
import software.amazon.awssdk.services.comprehendmedical.model.DetectPhiRequest;
import software.amazon.awssdk.services.comprehendmedical.model.DetectPhiResponse;
import software.amazon.awssdk.services.comprehendmedical.model.InferIcd10CmRequest;
import software.amazon.awssdk.services.comprehendmedical.model.InferIcd10CmResponse;
import software.amazon.awssdk.services.comprehendmedical.model.InferRxNormRequest;
import software.amazon.awssdk.services.comprehendmedical.model.InferRxNormResponse;
import software.amazon.awssdk.services.comprehendmedical.model.InferSnomedctRequest;
import software.amazon.awssdk.services.comprehendmedical.model.InferSnomedctResponse;
import software.amazon.awssdk.services.comprehendmedical.model.InternalServerException;
import software.amazon.awssdk.services.comprehendmedical.model.InvalidEncodingException;
import software.amazon.awssdk.services.comprehendmedical.model.InvalidRequestException;
import software.amazon.awssdk.services.comprehendmedical.model.ListEntitiesDetectionV2JobsRequest;
import software.amazon.awssdk.services.comprehendmedical.model.ListEntitiesDetectionV2JobsResponse;
import software.amazon.awssdk.services.comprehendmedical.model.ListIcd10CmInferenceJobsRequest;
import software.amazon.awssdk.services.comprehendmedical.model.ListIcd10CmInferenceJobsResponse;
import software.amazon.awssdk.services.comprehendmedical.model.ListPhiDetectionJobsRequest;
import software.amazon.awssdk.services.comprehendmedical.model.ListPhiDetectionJobsResponse;
import software.amazon.awssdk.services.comprehendmedical.model.ListRxNormInferenceJobsRequest;
import software.amazon.awssdk.services.comprehendmedical.model.ListRxNormInferenceJobsResponse;
import software.amazon.awssdk.services.comprehendmedical.model.ListSnomedctInferenceJobsRequest;
import software.amazon.awssdk.services.comprehendmedical.model.ListSnomedctInferenceJobsResponse;
import software.amazon.awssdk.services.comprehendmedical.model.ResourceNotFoundException;
import software.amazon.awssdk.services.comprehendmedical.model.ServiceUnavailableException;
import software.amazon.awssdk.services.comprehendmedical.model.StartEntitiesDetectionV2JobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.StartEntitiesDetectionV2JobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.StartIcd10CmInferenceJobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.StartIcd10CmInferenceJobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.StartPhiDetectionJobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.StartPhiDetectionJobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.StartRxNormInferenceJobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.StartRxNormInferenceJobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.StartSnomedctInferenceJobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.StartSnomedctInferenceJobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.StopEntitiesDetectionV2JobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.StopEntitiesDetectionV2JobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.StopIcd10CmInferenceJobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.StopIcd10CmInferenceJobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.StopPhiDetectionJobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.StopPhiDetectionJobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.StopRxNormInferenceJobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.StopRxNormInferenceJobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.StopSnomedctInferenceJobRequest;
import software.amazon.awssdk.services.comprehendmedical.model.StopSnomedctInferenceJobResponse;
import software.amazon.awssdk.services.comprehendmedical.model.TextSizeLimitExceededException;
import software.amazon.awssdk.services.comprehendmedical.model.TooManyRequestsException;
import software.amazon.awssdk.services.comprehendmedical.model.ValidationException;

/**
 * Service client for accessing ComprehendMedical. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon Comprehend Medical extracts structured information from unstructured clinical text. Use these actions to gain
 * insight in your documents. Amazon Comprehend Medical only detects entities in English language texts. Amazon
 * Comprehend Medical places limits on the sizes of files allowed for different API operations. To learn more, see <a
 * href="https://docs.aws.amazon.com/comprehend-medical/latest/dev/comprehendmedical-quotas.html">Guidelines and
 * quotas</a> in the <i>Amazon Comprehend Medical Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ComprehendMedicalClient extends AwsClient {
    String SERVICE_NAME = "comprehendmedical";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "comprehendmedical";

    /**
     * <p>
     * Gets the properties associated with a medical entities detection job. Use this operation to get the status of a
     * detection job.
     * </p>
     *
     * @param describeEntitiesDetectionV2JobRequest
     * @return Result of the DescribeEntitiesDetectionV2Job operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.DescribeEntitiesDetectionV2Job
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DescribeEntitiesDetectionV2Job"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEntitiesDetectionV2JobResponse describeEntitiesDetectionV2Job(
            DescribeEntitiesDetectionV2JobRequest describeEntitiesDetectionV2JobRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendMedicalException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the properties associated with a medical entities detection job. Use this operation to get the status of a
     * detection job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEntitiesDetectionV2JobRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeEntitiesDetectionV2JobRequest#builder()}
     * </p>
     *
     * @param describeEntitiesDetectionV2JobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehendmedical.model.DescribeEntitiesDetectionV2JobRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeEntitiesDetectionV2Job operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.DescribeEntitiesDetectionV2Job
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DescribeEntitiesDetectionV2Job"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEntitiesDetectionV2JobResponse describeEntitiesDetectionV2Job(
            Consumer<DescribeEntitiesDetectionV2JobRequest.Builder> describeEntitiesDetectionV2JobRequest)
            throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendMedicalException {
        return describeEntitiesDetectionV2Job(DescribeEntitiesDetectionV2JobRequest.builder()
                .applyMutation(describeEntitiesDetectionV2JobRequest).build());
    }

    /**
     * <p>
     * Gets the properties associated with an InferICD10CM job. Use this operation to get the status of an inference
     * job.
     * </p>
     *
     * @param describeIcd10CmInferenceJobRequest
     * @return Result of the DescribeICD10CMInferenceJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.DescribeICD10CMInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DescribeICD10CMInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeIcd10CmInferenceJobResponse describeICD10CMInferenceJob(
            DescribeIcd10CmInferenceJobRequest describeIcd10CmInferenceJobRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendMedicalException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the properties associated with an InferICD10CM job. Use this operation to get the status of an inference
     * job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeIcd10CmInferenceJobRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeIcd10CmInferenceJobRequest#builder()}
     * </p>
     *
     * @param describeIcd10CmInferenceJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehendmedical.model.DescribeIcd10CmInferenceJobRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeICD10CMInferenceJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.DescribeICD10CMInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DescribeICD10CMInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeIcd10CmInferenceJobResponse describeICD10CMInferenceJob(
            Consumer<DescribeIcd10CmInferenceJobRequest.Builder> describeIcd10CmInferenceJobRequest)
            throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendMedicalException {
        return describeICD10CMInferenceJob(DescribeIcd10CmInferenceJobRequest.builder()
                .applyMutation(describeIcd10CmInferenceJobRequest).build());
    }

    /**
     * <p>
     * Gets the properties associated with a protected health information (PHI) detection job. Use this operation to get
     * the status of a detection job.
     * </p>
     *
     * @param describePhiDetectionJobRequest
     * @return Result of the DescribePHIDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.DescribePHIDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DescribePHIDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePhiDetectionJobResponse describePHIDetectionJob(DescribePhiDetectionJobRequest describePhiDetectionJobRequest)
            throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendMedicalException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the properties associated with a protected health information (PHI) detection job. Use this operation to get
     * the status of a detection job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePhiDetectionJobRequest.Builder} avoiding
     * the need to create one manually via {@link DescribePhiDetectionJobRequest#builder()}
     * </p>
     *
     * @param describePhiDetectionJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehendmedical.model.DescribePhiDetectionJobRequest.Builder} to
     *        create a request.
     * @return Result of the DescribePHIDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.DescribePHIDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DescribePHIDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePhiDetectionJobResponse describePHIDetectionJob(
            Consumer<DescribePhiDetectionJobRequest.Builder> describePhiDetectionJobRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendMedicalException {
        return describePHIDetectionJob(DescribePhiDetectionJobRequest.builder().applyMutation(describePhiDetectionJobRequest)
                .build());
    }

    /**
     * <p>
     * Gets the properties associated with an InferRxNorm job. Use this operation to get the status of an inference job.
     * </p>
     *
     * @param describeRxNormInferenceJobRequest
     * @return Result of the DescribeRxNormInferenceJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.DescribeRxNormInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DescribeRxNormInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRxNormInferenceJobResponse describeRxNormInferenceJob(
            DescribeRxNormInferenceJobRequest describeRxNormInferenceJobRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendMedicalException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the properties associated with an InferRxNorm job. Use this operation to get the status of an inference job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRxNormInferenceJobRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeRxNormInferenceJobRequest#builder()}
     * </p>
     *
     * @param describeRxNormInferenceJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehendmedical.model.DescribeRxNormInferenceJobRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeRxNormInferenceJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.DescribeRxNormInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DescribeRxNormInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRxNormInferenceJobResponse describeRxNormInferenceJob(
            Consumer<DescribeRxNormInferenceJobRequest.Builder> describeRxNormInferenceJobRequest)
            throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendMedicalException {
        return describeRxNormInferenceJob(DescribeRxNormInferenceJobRequest.builder()
                .applyMutation(describeRxNormInferenceJobRequest).build());
    }

    /**
     * <p>
     * Gets the properties associated with an InferSNOMEDCT job. Use this operation to get the status of an inference
     * job.
     * </p>
     *
     * @param describeSnomedctInferenceJobRequest
     * @return Result of the DescribeSNOMEDCTInferenceJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.DescribeSNOMEDCTInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DescribeSNOMEDCTInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSnomedctInferenceJobResponse describeSNOMEDCTInferenceJob(
            DescribeSnomedctInferenceJobRequest describeSnomedctInferenceJobRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendMedicalException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the properties associated with an InferSNOMEDCT job. Use this operation to get the status of an inference
     * job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSnomedctInferenceJobRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeSnomedctInferenceJobRequest#builder()}
     * </p>
     *
     * @param describeSnomedctInferenceJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehendmedical.model.DescribeSnomedctInferenceJobRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeSNOMEDCTInferenceJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.DescribeSNOMEDCTInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DescribeSNOMEDCTInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSnomedctInferenceJobResponse describeSNOMEDCTInferenceJob(
            Consumer<DescribeSnomedctInferenceJobRequest.Builder> describeSnomedctInferenceJobRequest)
            throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendMedicalException {
        return describeSNOMEDCTInferenceJob(DescribeSnomedctInferenceJobRequest.builder()
                .applyMutation(describeSnomedctInferenceJobRequest).build());
    }

    /**
     * <p>
     * The <code>DetectEntities</code> operation is deprecated. You should use the <a>DetectEntitiesV2</a> operation
     * instead.
     * </p>
     * <p>
     * Inspects the clinical text for a variety of medical entities and returns specific information about them such as
     * entity category, location, and confidence score on that information.
     * </p>
     *
     * @param detectEntitiesRequest
     * @return Result of the DetectEntities operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ServiceUnavailableException
     *         The Amazon Comprehend Medical service is temporarily unavailable. Please wait and then retry your
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws InvalidEncodingException
     *         The input text was not in valid UTF-8 character encoding. Check your text then retry your request.
     * @throws TextSizeLimitExceededException
     *         The size of the text you submitted exceeds the size limit. Reduce the size of the text or use a smaller
     *         document and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.DetectEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DetectEntities"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated This operation is deprecated, use DetectEntitiesV2 instead.
     */
    @Deprecated
    default DetectEntitiesResponse detectEntities(DetectEntitiesRequest detectEntitiesRequest) throws InternalServerException,
            ServiceUnavailableException, TooManyRequestsException, InvalidRequestException, InvalidEncodingException,
            TextSizeLimitExceededException, AwsServiceException, SdkClientException, ComprehendMedicalException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>DetectEntities</code> operation is deprecated. You should use the <a>DetectEntitiesV2</a> operation
     * instead.
     * </p>
     * <p>
     * Inspects the clinical text for a variety of medical entities and returns specific information about them such as
     * entity category, location, and confidence score on that information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectEntitiesRequest.Builder} avoiding the need to
     * create one manually via {@link DetectEntitiesRequest#builder()}
     * </p>
     *
     * @param detectEntitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehendmedical.model.DetectEntitiesRequest.Builder} to create a
     *        request.
     * @return Result of the DetectEntities operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ServiceUnavailableException
     *         The Amazon Comprehend Medical service is temporarily unavailable. Please wait and then retry your
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws InvalidEncodingException
     *         The input text was not in valid UTF-8 character encoding. Check your text then retry your request.
     * @throws TextSizeLimitExceededException
     *         The size of the text you submitted exceeds the size limit. Reduce the size of the text or use a smaller
     *         document and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.DetectEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DetectEntities"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated This operation is deprecated, use DetectEntitiesV2 instead.
     */
    @Deprecated
    default DetectEntitiesResponse detectEntities(Consumer<DetectEntitiesRequest.Builder> detectEntitiesRequest)
            throws InternalServerException, ServiceUnavailableException, TooManyRequestsException, InvalidRequestException,
            InvalidEncodingException, TextSizeLimitExceededException, AwsServiceException, SdkClientException,
            ComprehendMedicalException {
        return detectEntities(DetectEntitiesRequest.builder().applyMutation(detectEntitiesRequest).build());
    }

    /**
     * <p>
     * Inspects the clinical text for a variety of medical entities and returns specific information about them such as
     * entity category, location, and confidence score on that information. Amazon Comprehend Medical only detects
     * medical entities in English language texts.
     * </p>
     * <p>
     * The <code>DetectEntitiesV2</code> operation replaces the <a>DetectEntities</a> operation. This new action uses a
     * different model for determining the entities in your medical text and changes the way that some entities are
     * returned in the output. You should use the <code>DetectEntitiesV2</code> operation in all new applications.
     * </p>
     * <p>
     * The <code>DetectEntitiesV2</code> operation returns the <code>Acuity</code> and <code>Direction</code> entities
     * as attributes instead of types.
     * </p>
     *
     * @param detectEntitiesV2Request
     * @return Result of the DetectEntitiesV2 operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ServiceUnavailableException
     *         The Amazon Comprehend Medical service is temporarily unavailable. Please wait and then retry your
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws InvalidEncodingException
     *         The input text was not in valid UTF-8 character encoding. Check your text then retry your request.
     * @throws TextSizeLimitExceededException
     *         The size of the text you submitted exceeds the size limit. Reduce the size of the text or use a smaller
     *         document and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.DetectEntitiesV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DetectEntitiesV2"
     *      target="_top">AWS API Documentation</a>
     */
    default DetectEntitiesV2Response detectEntitiesV2(DetectEntitiesV2Request detectEntitiesV2Request)
            throws InternalServerException, ServiceUnavailableException, TooManyRequestsException, InvalidRequestException,
            InvalidEncodingException, TextSizeLimitExceededException, AwsServiceException, SdkClientException,
            ComprehendMedicalException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Inspects the clinical text for a variety of medical entities and returns specific information about them such as
     * entity category, location, and confidence score on that information. Amazon Comprehend Medical only detects
     * medical entities in English language texts.
     * </p>
     * <p>
     * The <code>DetectEntitiesV2</code> operation replaces the <a>DetectEntities</a> operation. This new action uses a
     * different model for determining the entities in your medical text and changes the way that some entities are
     * returned in the output. You should use the <code>DetectEntitiesV2</code> operation in all new applications.
     * </p>
     * <p>
     * The <code>DetectEntitiesV2</code> operation returns the <code>Acuity</code> and <code>Direction</code> entities
     * as attributes instead of types.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectEntitiesV2Request.Builder} avoiding the need
     * to create one manually via {@link DetectEntitiesV2Request#builder()}
     * </p>
     *
     * @param detectEntitiesV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehendmedical.model.DetectEntitiesV2Request.Builder} to create
     *        a request.
     * @return Result of the DetectEntitiesV2 operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ServiceUnavailableException
     *         The Amazon Comprehend Medical service is temporarily unavailable. Please wait and then retry your
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws InvalidEncodingException
     *         The input text was not in valid UTF-8 character encoding. Check your text then retry your request.
     * @throws TextSizeLimitExceededException
     *         The size of the text you submitted exceeds the size limit. Reduce the size of the text or use a smaller
     *         document and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.DetectEntitiesV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DetectEntitiesV2"
     *      target="_top">AWS API Documentation</a>
     */
    default DetectEntitiesV2Response detectEntitiesV2(Consumer<DetectEntitiesV2Request.Builder> detectEntitiesV2Request)
            throws InternalServerException, ServiceUnavailableException, TooManyRequestsException, InvalidRequestException,
            InvalidEncodingException, TextSizeLimitExceededException, AwsServiceException, SdkClientException,
            ComprehendMedicalException {
        return detectEntitiesV2(DetectEntitiesV2Request.builder().applyMutation(detectEntitiesV2Request).build());
    }

    /**
     * <p>
     * Inspects the clinical text for protected health information (PHI) entities and returns the entity category,
     * location, and confidence score for each entity. Amazon Comprehend Medical only detects entities in English
     * language texts.
     * </p>
     *
     * @param detectPhiRequest
     * @return Result of the DetectPHI operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ServiceUnavailableException
     *         The Amazon Comprehend Medical service is temporarily unavailable. Please wait and then retry your
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws InvalidEncodingException
     *         The input text was not in valid UTF-8 character encoding. Check your text then retry your request.
     * @throws TextSizeLimitExceededException
     *         The size of the text you submitted exceeds the size limit. Reduce the size of the text or use a smaller
     *         document and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.DetectPHI
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DetectPHI" target="_top">AWS
     *      API Documentation</a>
     */
    default DetectPhiResponse detectPHI(DetectPhiRequest detectPhiRequest) throws InternalServerException,
            ServiceUnavailableException, TooManyRequestsException, InvalidRequestException, InvalidEncodingException,
            TextSizeLimitExceededException, AwsServiceException, SdkClientException, ComprehendMedicalException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Inspects the clinical text for protected health information (PHI) entities and returns the entity category,
     * location, and confidence score for each entity. Amazon Comprehend Medical only detects entities in English
     * language texts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectPhiRequest.Builder} avoiding the need to
     * create one manually via {@link DetectPhiRequest#builder()}
     * </p>
     *
     * @param detectPhiRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehendmedical.model.DetectPhiRequest.Builder} to create a
     *        request.
     * @return Result of the DetectPHI operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ServiceUnavailableException
     *         The Amazon Comprehend Medical service is temporarily unavailable. Please wait and then retry your
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws InvalidEncodingException
     *         The input text was not in valid UTF-8 character encoding. Check your text then retry your request.
     * @throws TextSizeLimitExceededException
     *         The size of the text you submitted exceeds the size limit. Reduce the size of the text or use a smaller
     *         document and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.DetectPHI
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DetectPHI" target="_top">AWS
     *      API Documentation</a>
     */
    default DetectPhiResponse detectPHI(Consumer<DetectPhiRequest.Builder> detectPhiRequest) throws InternalServerException,
            ServiceUnavailableException, TooManyRequestsException, InvalidRequestException, InvalidEncodingException,
            TextSizeLimitExceededException, AwsServiceException, SdkClientException, ComprehendMedicalException {
        return detectPHI(DetectPhiRequest.builder().applyMutation(detectPhiRequest).build());
    }

    /**
     * <p>
     * InferICD10CM detects medical conditions as entities listed in a patient record and links those entities to
     * normalized concept identifiers in the ICD-10-CM knowledge base from the Centers for Disease Control. Amazon
     * Comprehend Medical only detects medical entities in English language texts.
     * </p>
     *
     * @param inferIcd10CmRequest
     * @return Result of the InferICD10CM operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ServiceUnavailableException
     *         The Amazon Comprehend Medical service is temporarily unavailable. Please wait and then retry your
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws InvalidEncodingException
     *         The input text was not in valid UTF-8 character encoding. Check your text then retry your request.
     * @throws TextSizeLimitExceededException
     *         The size of the text you submitted exceeds the size limit. Reduce the size of the text or use a smaller
     *         document and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.InferICD10CM
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/InferICD10CM"
     *      target="_top">AWS API Documentation</a>
     */
    default InferIcd10CmResponse inferICD10CM(InferIcd10CmRequest inferIcd10CmRequest) throws InternalServerException,
            ServiceUnavailableException, TooManyRequestsException, InvalidRequestException, InvalidEncodingException,
            TextSizeLimitExceededException, AwsServiceException, SdkClientException, ComprehendMedicalException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * InferICD10CM detects medical conditions as entities listed in a patient record and links those entities to
     * normalized concept identifiers in the ICD-10-CM knowledge base from the Centers for Disease Control. Amazon
     * Comprehend Medical only detects medical entities in English language texts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InferIcd10CmRequest.Builder} avoiding the need to
     * create one manually via {@link InferIcd10CmRequest#builder()}
     * </p>
     *
     * @param inferIcd10CmRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehendmedical.model.InferIcd10CmRequest.Builder} to create a
     *        request.
     * @return Result of the InferICD10CM operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ServiceUnavailableException
     *         The Amazon Comprehend Medical service is temporarily unavailable. Please wait and then retry your
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws InvalidEncodingException
     *         The input text was not in valid UTF-8 character encoding. Check your text then retry your request.
     * @throws TextSizeLimitExceededException
     *         The size of the text you submitted exceeds the size limit. Reduce the size of the text or use a smaller
     *         document and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.InferICD10CM
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/InferICD10CM"
     *      target="_top">AWS API Documentation</a>
     */
    default InferIcd10CmResponse inferICD10CM(Consumer<InferIcd10CmRequest.Builder> inferIcd10CmRequest)
            throws InternalServerException, ServiceUnavailableException, TooManyRequestsException, InvalidRequestException,
            InvalidEncodingException, TextSizeLimitExceededException, AwsServiceException, SdkClientException,
            ComprehendMedicalException {
        return inferICD10CM(InferIcd10CmRequest.builder().applyMutation(inferIcd10CmRequest).build());
    }

    /**
     * <p>
     * InferRxNorm detects medications as entities listed in a patient record and links to the normalized concept
     * identifiers in the RxNorm database from the National Library of Medicine. Amazon Comprehend Medical only detects
     * medical entities in English language texts.
     * </p>
     *
     * @param inferRxNormRequest
     * @return Result of the InferRxNorm operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ServiceUnavailableException
     *         The Amazon Comprehend Medical service is temporarily unavailable. Please wait and then retry your
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws InvalidEncodingException
     *         The input text was not in valid UTF-8 character encoding. Check your text then retry your request.
     * @throws TextSizeLimitExceededException
     *         The size of the text you submitted exceeds the size limit. Reduce the size of the text or use a smaller
     *         document and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.InferRxNorm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/InferRxNorm" target="_top">AWS
     *      API Documentation</a>
     */
    default InferRxNormResponse inferRxNorm(InferRxNormRequest inferRxNormRequest) throws InternalServerException,
            ServiceUnavailableException, TooManyRequestsException, InvalidRequestException, InvalidEncodingException,
            TextSizeLimitExceededException, AwsServiceException, SdkClientException, ComprehendMedicalException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * InferRxNorm detects medications as entities listed in a patient record and links to the normalized concept
     * identifiers in the RxNorm database from the National Library of Medicine. Amazon Comprehend Medical only detects
     * medical entities in English language texts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InferRxNormRequest.Builder} avoiding the need to
     * create one manually via {@link InferRxNormRequest#builder()}
     * </p>
     *
     * @param inferRxNormRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehendmedical.model.InferRxNormRequest.Builder} to create a
     *        request.
     * @return Result of the InferRxNorm operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ServiceUnavailableException
     *         The Amazon Comprehend Medical service is temporarily unavailable. Please wait and then retry your
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws InvalidEncodingException
     *         The input text was not in valid UTF-8 character encoding. Check your text then retry your request.
     * @throws TextSizeLimitExceededException
     *         The size of the text you submitted exceeds the size limit. Reduce the size of the text or use a smaller
     *         document and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.InferRxNorm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/InferRxNorm" target="_top">AWS
     *      API Documentation</a>
     */
    default InferRxNormResponse inferRxNorm(Consumer<InferRxNormRequest.Builder> inferRxNormRequest)
            throws InternalServerException, ServiceUnavailableException, TooManyRequestsException, InvalidRequestException,
            InvalidEncodingException, TextSizeLimitExceededException, AwsServiceException, SdkClientException,
            ComprehendMedicalException {
        return inferRxNorm(InferRxNormRequest.builder().applyMutation(inferRxNormRequest).build());
    }

    /**
     * <p>
     * InferSNOMEDCT detects possible medical concepts as entities and links them to codes from the Systematized
     * Nomenclature of Medicine, Clinical Terms (SNOMED-CT) ontology
     * </p>
     *
     * @param inferSnomedctRequest
     * @return Result of the InferSNOMEDCT operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ServiceUnavailableException
     *         The Amazon Comprehend Medical service is temporarily unavailable. Please wait and then retry your
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws InvalidEncodingException
     *         The input text was not in valid UTF-8 character encoding. Check your text then retry your request.
     * @throws TextSizeLimitExceededException
     *         The size of the text you submitted exceeds the size limit. Reduce the size of the text or use a smaller
     *         document and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.InferSNOMEDCT
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/InferSNOMEDCT"
     *      target="_top">AWS API Documentation</a>
     */
    default InferSnomedctResponse inferSNOMEDCT(InferSnomedctRequest inferSnomedctRequest) throws InternalServerException,
            ServiceUnavailableException, TooManyRequestsException, InvalidRequestException, InvalidEncodingException,
            TextSizeLimitExceededException, AwsServiceException, SdkClientException, ComprehendMedicalException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * InferSNOMEDCT detects possible medical concepts as entities and links them to codes from the Systematized
     * Nomenclature of Medicine, Clinical Terms (SNOMED-CT) ontology
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InferSnomedctRequest.Builder} avoiding the need to
     * create one manually via {@link InferSnomedctRequest#builder()}
     * </p>
     *
     * @param inferSnomedctRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehendmedical.model.InferSnomedctRequest.Builder} to create a
     *        request.
     * @return Result of the InferSNOMEDCT operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ServiceUnavailableException
     *         The Amazon Comprehend Medical service is temporarily unavailable. Please wait and then retry your
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws InvalidEncodingException
     *         The input text was not in valid UTF-8 character encoding. Check your text then retry your request.
     * @throws TextSizeLimitExceededException
     *         The size of the text you submitted exceeds the size limit. Reduce the size of the text or use a smaller
     *         document and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.InferSNOMEDCT
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/InferSNOMEDCT"
     *      target="_top">AWS API Documentation</a>
     */
    default InferSnomedctResponse inferSNOMEDCT(Consumer<InferSnomedctRequest.Builder> inferSnomedctRequest)
            throws InternalServerException, ServiceUnavailableException, TooManyRequestsException, InvalidRequestException,
            InvalidEncodingException, TextSizeLimitExceededException, AwsServiceException, SdkClientException,
            ComprehendMedicalException {
        return inferSNOMEDCT(InferSnomedctRequest.builder().applyMutation(inferSnomedctRequest).build());
    }

    /**
     * <p>
     * Gets a list of medical entity detection jobs that you have submitted.
     * </p>
     *
     * @param listEntitiesDetectionV2JobsRequest
     * @return Result of the ListEntitiesDetectionV2Jobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws ValidationException
     *         The filter that you specified for the operation is invalid. Check the filter values that you entered and
     *         try your request again.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.ListEntitiesDetectionV2Jobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/ListEntitiesDetectionV2Jobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntitiesDetectionV2JobsResponse listEntitiesDetectionV2Jobs(
            ListEntitiesDetectionV2JobsRequest listEntitiesDetectionV2JobsRequest) throws InvalidRequestException,
            ValidationException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendMedicalException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of medical entity detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntitiesDetectionV2JobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListEntitiesDetectionV2JobsRequest#builder()}
     * </p>
     *
     * @param listEntitiesDetectionV2JobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehendmedical.model.ListEntitiesDetectionV2JobsRequest.Builder}
     *        to create a request.
     * @return Result of the ListEntitiesDetectionV2Jobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws ValidationException
     *         The filter that you specified for the operation is invalid. Check the filter values that you entered and
     *         try your request again.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.ListEntitiesDetectionV2Jobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/ListEntitiesDetectionV2Jobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntitiesDetectionV2JobsResponse listEntitiesDetectionV2Jobs(
            Consumer<ListEntitiesDetectionV2JobsRequest.Builder> listEntitiesDetectionV2JobsRequest)
            throws InvalidRequestException, ValidationException, TooManyRequestsException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendMedicalException {
        return listEntitiesDetectionV2Jobs(ListEntitiesDetectionV2JobsRequest.builder()
                .applyMutation(listEntitiesDetectionV2JobsRequest).build());
    }

    /**
     * <p>
     * Gets a list of InferICD10CM jobs that you have submitted.
     * </p>
     *
     * @param listIcd10CmInferenceJobsRequest
     * @return Result of the ListICD10CMInferenceJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws ValidationException
     *         The filter that you specified for the operation is invalid. Check the filter values that you entered and
     *         try your request again.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.ListICD10CMInferenceJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/ListICD10CMInferenceJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIcd10CmInferenceJobsResponse listICD10CMInferenceJobs(
            ListIcd10CmInferenceJobsRequest listIcd10CmInferenceJobsRequest) throws InvalidRequestException, ValidationException,
            TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendMedicalException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of InferICD10CM jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIcd10CmInferenceJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListIcd10CmInferenceJobsRequest#builder()}
     * </p>
     *
     * @param listIcd10CmInferenceJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehendmedical.model.ListIcd10CmInferenceJobsRequest.Builder} to
     *        create a request.
     * @return Result of the ListICD10CMInferenceJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws ValidationException
     *         The filter that you specified for the operation is invalid. Check the filter values that you entered and
     *         try your request again.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.ListICD10CMInferenceJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/ListICD10CMInferenceJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIcd10CmInferenceJobsResponse listICD10CMInferenceJobs(
            Consumer<ListIcd10CmInferenceJobsRequest.Builder> listIcd10CmInferenceJobsRequest) throws InvalidRequestException,
            ValidationException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendMedicalException {
        return listICD10CMInferenceJobs(ListIcd10CmInferenceJobsRequest.builder().applyMutation(listIcd10CmInferenceJobsRequest)
                .build());
    }

    /**
     * <p>
     * Gets a list of protected health information (PHI) detection jobs you have submitted.
     * </p>
     *
     * @param listPhiDetectionJobsRequest
     * @return Result of the ListPHIDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws ValidationException
     *         The filter that you specified for the operation is invalid. Check the filter values that you entered and
     *         try your request again.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.ListPHIDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/ListPHIDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPhiDetectionJobsResponse listPHIDetectionJobs(ListPhiDetectionJobsRequest listPhiDetectionJobsRequest)
            throws InvalidRequestException, ValidationException, TooManyRequestsException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendMedicalException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of protected health information (PHI) detection jobs you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPhiDetectionJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPhiDetectionJobsRequest#builder()}
     * </p>
     *
     * @param listPhiDetectionJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehendmedical.model.ListPhiDetectionJobsRequest.Builder} to
     *        create a request.
     * @return Result of the ListPHIDetectionJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws ValidationException
     *         The filter that you specified for the operation is invalid. Check the filter values that you entered and
     *         try your request again.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.ListPHIDetectionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/ListPHIDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPhiDetectionJobsResponse listPHIDetectionJobs(
            Consumer<ListPhiDetectionJobsRequest.Builder> listPhiDetectionJobsRequest) throws InvalidRequestException,
            ValidationException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendMedicalException {
        return listPHIDetectionJobs(ListPhiDetectionJobsRequest.builder().applyMutation(listPhiDetectionJobsRequest).build());
    }

    /**
     * <p>
     * Gets a list of InferRxNorm jobs that you have submitted.
     * </p>
     *
     * @param listRxNormInferenceJobsRequest
     * @return Result of the ListRxNormInferenceJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws ValidationException
     *         The filter that you specified for the operation is invalid. Check the filter values that you entered and
     *         try your request again.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.ListRxNormInferenceJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/ListRxNormInferenceJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRxNormInferenceJobsResponse listRxNormInferenceJobs(ListRxNormInferenceJobsRequest listRxNormInferenceJobsRequest)
            throws InvalidRequestException, ValidationException, TooManyRequestsException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendMedicalException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of InferRxNorm jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRxNormInferenceJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListRxNormInferenceJobsRequest#builder()}
     * </p>
     *
     * @param listRxNormInferenceJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehendmedical.model.ListRxNormInferenceJobsRequest.Builder} to
     *        create a request.
     * @return Result of the ListRxNormInferenceJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws ValidationException
     *         The filter that you specified for the operation is invalid. Check the filter values that you entered and
     *         try your request again.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.ListRxNormInferenceJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/ListRxNormInferenceJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRxNormInferenceJobsResponse listRxNormInferenceJobs(
            Consumer<ListRxNormInferenceJobsRequest.Builder> listRxNormInferenceJobsRequest) throws InvalidRequestException,
            ValidationException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendMedicalException {
        return listRxNormInferenceJobs(ListRxNormInferenceJobsRequest.builder().applyMutation(listRxNormInferenceJobsRequest)
                .build());
    }

    /**
     * <p>
     * Gets a list of InferSNOMEDCT jobs a user has submitted.
     * </p>
     *
     * @param listSnomedctInferenceJobsRequest
     * @return Result of the ListSNOMEDCTInferenceJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws ValidationException
     *         The filter that you specified for the operation is invalid. Check the filter values that you entered and
     *         try your request again.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.ListSNOMEDCTInferenceJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/ListSNOMEDCTInferenceJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSnomedctInferenceJobsResponse listSNOMEDCTInferenceJobs(
            ListSnomedctInferenceJobsRequest listSnomedctInferenceJobsRequest) throws InvalidRequestException,
            ValidationException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendMedicalException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of InferSNOMEDCT jobs a user has submitted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSnomedctInferenceJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSnomedctInferenceJobsRequest#builder()}
     * </p>
     *
     * @param listSnomedctInferenceJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehendmedical.model.ListSnomedctInferenceJobsRequest.Builder}
     *        to create a request.
     * @return Result of the ListSNOMEDCTInferenceJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws ValidationException
     *         The filter that you specified for the operation is invalid. Check the filter values that you entered and
     *         try your request again.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.ListSNOMEDCTInferenceJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/ListSNOMEDCTInferenceJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSnomedctInferenceJobsResponse listSNOMEDCTInferenceJobs(
            Consumer<ListSnomedctInferenceJobsRequest.Builder> listSnomedctInferenceJobsRequest) throws InvalidRequestException,
            ValidationException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendMedicalException {
        return listSNOMEDCTInferenceJobs(ListSnomedctInferenceJobsRequest.builder()
                .applyMutation(listSnomedctInferenceJobsRequest).build());
    }

    /**
     * <p>
     * Starts an asynchronous medical entity detection job for a collection of documents. Use the
     * <code>DescribeEntitiesDetectionV2Job</code> operation to track the status of a job.
     * </p>
     *
     * @param startEntitiesDetectionV2JobRequest
     * @return Result of the StartEntitiesDetectionV2Job operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.StartEntitiesDetectionV2Job
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StartEntitiesDetectionV2Job"
     *      target="_top">AWS API Documentation</a>
     */
    default StartEntitiesDetectionV2JobResponse startEntitiesDetectionV2Job(
            StartEntitiesDetectionV2JobRequest startEntitiesDetectionV2JobRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendMedicalException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an asynchronous medical entity detection job for a collection of documents. Use the
     * <code>DescribeEntitiesDetectionV2Job</code> operation to track the status of a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartEntitiesDetectionV2JobRequest.Builder}
     * avoiding the need to create one manually via {@link StartEntitiesDetectionV2JobRequest#builder()}
     * </p>
     *
     * @param startEntitiesDetectionV2JobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehendmedical.model.StartEntitiesDetectionV2JobRequest.Builder}
     *        to create a request.
     * @return Result of the StartEntitiesDetectionV2Job operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.StartEntitiesDetectionV2Job
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StartEntitiesDetectionV2Job"
     *      target="_top">AWS API Documentation</a>
     */
    default StartEntitiesDetectionV2JobResponse startEntitiesDetectionV2Job(
            Consumer<StartEntitiesDetectionV2JobRequest.Builder> startEntitiesDetectionV2JobRequest)
            throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendMedicalException {
        return startEntitiesDetectionV2Job(StartEntitiesDetectionV2JobRequest.builder()
                .applyMutation(startEntitiesDetectionV2JobRequest).build());
    }

    /**
     * <p>
     * Starts an asynchronous job to detect medical conditions and link them to the ICD-10-CM ontology. Use the
     * <code>DescribeICD10CMInferenceJob</code> operation to track the status of a job.
     * </p>
     *
     * @param startIcd10CmInferenceJobRequest
     * @return Result of the StartICD10CMInferenceJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.StartICD10CMInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StartICD10CMInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartIcd10CmInferenceJobResponse startICD10CMInferenceJob(
            StartIcd10CmInferenceJobRequest startIcd10CmInferenceJobRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendMedicalException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an asynchronous job to detect medical conditions and link them to the ICD-10-CM ontology. Use the
     * <code>DescribeICD10CMInferenceJob</code> operation to track the status of a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartIcd10CmInferenceJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartIcd10CmInferenceJobRequest#builder()}
     * </p>
     *
     * @param startIcd10CmInferenceJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehendmedical.model.StartIcd10CmInferenceJobRequest.Builder} to
     *        create a request.
     * @return Result of the StartICD10CMInferenceJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.StartICD10CMInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StartICD10CMInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartIcd10CmInferenceJobResponse startICD10CMInferenceJob(
            Consumer<StartIcd10CmInferenceJobRequest.Builder> startIcd10CmInferenceJobRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendMedicalException {
        return startICD10CMInferenceJob(StartIcd10CmInferenceJobRequest.builder().applyMutation(startIcd10CmInferenceJobRequest)
                .build());
    }

    /**
     * <p>
     * Starts an asynchronous job to detect protected health information (PHI). Use the
     * <code>DescribePHIDetectionJob</code> operation to track the status of a job.
     * </p>
     *
     * @param startPhiDetectionJobRequest
     * @return Result of the StartPHIDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.StartPHIDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StartPHIDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartPhiDetectionJobResponse startPHIDetectionJob(StartPhiDetectionJobRequest startPhiDetectionJobRequest)
            throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendMedicalException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an asynchronous job to detect protected health information (PHI). Use the
     * <code>DescribePHIDetectionJob</code> operation to track the status of a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartPhiDetectionJobRequest.Builder} avoiding the
     * need to create one manually via {@link StartPhiDetectionJobRequest#builder()}
     * </p>
     *
     * @param startPhiDetectionJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehendmedical.model.StartPhiDetectionJobRequest.Builder} to
     *        create a request.
     * @return Result of the StartPHIDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.StartPHIDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StartPHIDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartPhiDetectionJobResponse startPHIDetectionJob(
            Consumer<StartPhiDetectionJobRequest.Builder> startPhiDetectionJobRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendMedicalException {
        return startPHIDetectionJob(StartPhiDetectionJobRequest.builder().applyMutation(startPhiDetectionJobRequest).build());
    }

    /**
     * <p>
     * Starts an asynchronous job to detect medication entities and link them to the RxNorm ontology. Use the
     * <code>DescribeRxNormInferenceJob</code> operation to track the status of a job.
     * </p>
     *
     * @param startRxNormInferenceJobRequest
     * @return Result of the StartRxNormInferenceJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.StartRxNormInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StartRxNormInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartRxNormInferenceJobResponse startRxNormInferenceJob(StartRxNormInferenceJobRequest startRxNormInferenceJobRequest)
            throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, ComprehendMedicalException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an asynchronous job to detect medication entities and link them to the RxNorm ontology. Use the
     * <code>DescribeRxNormInferenceJob</code> operation to track the status of a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartRxNormInferenceJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartRxNormInferenceJobRequest#builder()}
     * </p>
     *
     * @param startRxNormInferenceJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehendmedical.model.StartRxNormInferenceJobRequest.Builder} to
     *        create a request.
     * @return Result of the StartRxNormInferenceJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.StartRxNormInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StartRxNormInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartRxNormInferenceJobResponse startRxNormInferenceJob(
            Consumer<StartRxNormInferenceJobRequest.Builder> startRxNormInferenceJobRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendMedicalException {
        return startRxNormInferenceJob(StartRxNormInferenceJobRequest.builder().applyMutation(startRxNormInferenceJobRequest)
                .build());
    }

    /**
     * <p>
     * Starts an asynchronous job to detect medical concepts and link them to the SNOMED-CT ontology. Use the
     * DescribeSNOMEDCTInferenceJob operation to track the status of a job.
     * </p>
     *
     * @param startSnomedctInferenceJobRequest
     * @return Result of the StartSNOMEDCTInferenceJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.StartSNOMEDCTInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StartSNOMEDCTInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartSnomedctInferenceJobResponse startSNOMEDCTInferenceJob(
            StartSnomedctInferenceJobRequest startSnomedctInferenceJobRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendMedicalException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an asynchronous job to detect medical concepts and link them to the SNOMED-CT ontology. Use the
     * DescribeSNOMEDCTInferenceJob operation to track the status of a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartSnomedctInferenceJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartSnomedctInferenceJobRequest#builder()}
     * </p>
     *
     * @param startSnomedctInferenceJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehendmedical.model.StartSnomedctInferenceJobRequest.Builder}
     *        to create a request.
     * @return Result of the StartSNOMEDCTInferenceJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.StartSNOMEDCTInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StartSNOMEDCTInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartSnomedctInferenceJobResponse startSNOMEDCTInferenceJob(
            Consumer<StartSnomedctInferenceJobRequest.Builder> startSnomedctInferenceJobRequest) throws InvalidRequestException,
            TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendMedicalException {
        return startSNOMEDCTInferenceJob(StartSnomedctInferenceJobRequest.builder()
                .applyMutation(startSnomedctInferenceJobRequest).build());
    }

    /**
     * <p>
     * Stops a medical entities detection job in progress.
     * </p>
     *
     * @param stopEntitiesDetectionV2JobRequest
     * @return Result of the StopEntitiesDetectionV2Job operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.StopEntitiesDetectionV2Job
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StopEntitiesDetectionV2Job"
     *      target="_top">AWS API Documentation</a>
     */
    default StopEntitiesDetectionV2JobResponse stopEntitiesDetectionV2Job(
            StopEntitiesDetectionV2JobRequest stopEntitiesDetectionV2JobRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendMedicalException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a medical entities detection job in progress.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopEntitiesDetectionV2JobRequest.Builder} avoiding
     * the need to create one manually via {@link StopEntitiesDetectionV2JobRequest#builder()}
     * </p>
     *
     * @param stopEntitiesDetectionV2JobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehendmedical.model.StopEntitiesDetectionV2JobRequest.Builder}
     *        to create a request.
     * @return Result of the StopEntitiesDetectionV2Job operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.StopEntitiesDetectionV2Job
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StopEntitiesDetectionV2Job"
     *      target="_top">AWS API Documentation</a>
     */
    default StopEntitiesDetectionV2JobResponse stopEntitiesDetectionV2Job(
            Consumer<StopEntitiesDetectionV2JobRequest.Builder> stopEntitiesDetectionV2JobRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendMedicalException {
        return stopEntitiesDetectionV2Job(StopEntitiesDetectionV2JobRequest.builder()
                .applyMutation(stopEntitiesDetectionV2JobRequest).build());
    }

    /**
     * <p>
     * Stops an InferICD10CM inference job in progress.
     * </p>
     *
     * @param stopIcd10CmInferenceJobRequest
     * @return Result of the StopICD10CMInferenceJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.StopICD10CMInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StopICD10CMInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopIcd10CmInferenceJobResponse stopICD10CMInferenceJob(StopIcd10CmInferenceJobRequest stopIcd10CmInferenceJobRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendMedicalException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops an InferICD10CM inference job in progress.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopIcd10CmInferenceJobRequest.Builder} avoiding
     * the need to create one manually via {@link StopIcd10CmInferenceJobRequest#builder()}
     * </p>
     *
     * @param stopIcd10CmInferenceJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehendmedical.model.StopIcd10CmInferenceJobRequest.Builder} to
     *        create a request.
     * @return Result of the StopICD10CMInferenceJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.StopICD10CMInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StopICD10CMInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopIcd10CmInferenceJobResponse stopICD10CMInferenceJob(
            Consumer<StopIcd10CmInferenceJobRequest.Builder> stopIcd10CmInferenceJobRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendMedicalException {
        return stopICD10CMInferenceJob(StopIcd10CmInferenceJobRequest.builder().applyMutation(stopIcd10CmInferenceJobRequest)
                .build());
    }

    /**
     * <p>
     * Stops a protected health information (PHI) detection job in progress.
     * </p>
     *
     * @param stopPhiDetectionJobRequest
     * @return Result of the StopPHIDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.StopPHIDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StopPHIDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopPhiDetectionJobResponse stopPHIDetectionJob(StopPhiDetectionJobRequest stopPhiDetectionJobRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendMedicalException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a protected health information (PHI) detection job in progress.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopPhiDetectionJobRequest.Builder} avoiding the
     * need to create one manually via {@link StopPhiDetectionJobRequest#builder()}
     * </p>
     *
     * @param stopPhiDetectionJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehendmedical.model.StopPhiDetectionJobRequest.Builder} to
     *        create a request.
     * @return Result of the StopPHIDetectionJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.StopPHIDetectionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StopPHIDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopPhiDetectionJobResponse stopPHIDetectionJob(
            Consumer<StopPhiDetectionJobRequest.Builder> stopPhiDetectionJobRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendMedicalException {
        return stopPHIDetectionJob(StopPhiDetectionJobRequest.builder().applyMutation(stopPhiDetectionJobRequest).build());
    }

    /**
     * <p>
     * Stops an InferRxNorm inference job in progress.
     * </p>
     *
     * @param stopRxNormInferenceJobRequest
     * @return Result of the StopRxNormInferenceJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.StopRxNormInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StopRxNormInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopRxNormInferenceJobResponse stopRxNormInferenceJob(StopRxNormInferenceJobRequest stopRxNormInferenceJobRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendMedicalException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops an InferRxNorm inference job in progress.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopRxNormInferenceJobRequest.Builder} avoiding the
     * need to create one manually via {@link StopRxNormInferenceJobRequest#builder()}
     * </p>
     *
     * @param stopRxNormInferenceJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehendmedical.model.StopRxNormInferenceJobRequest.Builder} to
     *        create a request.
     * @return Result of the StopRxNormInferenceJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.StopRxNormInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StopRxNormInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopRxNormInferenceJobResponse stopRxNormInferenceJob(
            Consumer<StopRxNormInferenceJobRequest.Builder> stopRxNormInferenceJobRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            ComprehendMedicalException {
        return stopRxNormInferenceJob(StopRxNormInferenceJobRequest.builder().applyMutation(stopRxNormInferenceJobRequest)
                .build());
    }

    /**
     * <p>
     * Stops an InferSNOMEDCT inference job in progress.
     * </p>
     *
     * @param stopSnomedctInferenceJobRequest
     * @return Result of the StopSNOMEDCTInferenceJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.StopSNOMEDCTInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StopSNOMEDCTInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopSnomedctInferenceJobResponse stopSNOMEDCTInferenceJob(
            StopSnomedctInferenceJobRequest stopSnomedctInferenceJobRequest) throws InvalidRequestException,
            ResourceNotFoundException, TooManyRequestsException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendMedicalException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops an InferSNOMEDCT inference job in progress.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopSnomedctInferenceJobRequest.Builder} avoiding
     * the need to create one manually via {@link StopSnomedctInferenceJobRequest#builder()}
     * </p>
     *
     * @param stopSnomedctInferenceJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.comprehendmedical.model.StopSnomedctInferenceJobRequest.Builder} to
     *        create a request.
     * @return Result of the StopSNOMEDCTInferenceJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is invalid. Check your request to determine why it's invalid and then retry the
     *         request.
     * @throws ResourceNotFoundException
     *         The resource identified by the specified Amazon Resource Name (ARN) was not found. Check the ARN and try
     *         your request again.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again. Contact customer support for more information about a service limit increase.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComprehendMedicalException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComprehendMedicalClient.StopSNOMEDCTInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StopSNOMEDCTInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopSnomedctInferenceJobResponse stopSNOMEDCTInferenceJob(
            Consumer<StopSnomedctInferenceJobRequest.Builder> stopSnomedctInferenceJobRequest) throws InvalidRequestException,
            ResourceNotFoundException, TooManyRequestsException, InternalServerException, AwsServiceException,
            SdkClientException, ComprehendMedicalException {
        return stopSNOMEDCTInferenceJob(StopSnomedctInferenceJobRequest.builder().applyMutation(stopSnomedctInferenceJobRequest)
                .build());
    }

    /**
     * Create a {@link ComprehendMedicalClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ComprehendMedicalClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ComprehendMedicalClient}.
     */
    static ComprehendMedicalClientBuilder builder() {
        return new DefaultComprehendMedicalClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default ComprehendMedicalServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
