/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehendmedical.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The information about the revision of the SNOMED-CT ontology in the response. Specifically, the details include the
 * SNOMED-CT edition, language, and version date.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SNOMEDCTDetails implements SdkPojo, Serializable, ToCopyableBuilder<SNOMEDCTDetails.Builder, SNOMEDCTDetails> {
    private static final SdkField<String> EDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Edition")
            .getter(getter(SNOMEDCTDetails::edition)).setter(setter(Builder::edition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Edition").build()).build();

    private static final SdkField<String> LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Language").getter(getter(SNOMEDCTDetails::language)).setter(setter(Builder::language))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Language").build()).build();

    private static final SdkField<String> VERSION_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionDate").getter(getter(SNOMEDCTDetails::versionDate)).setter(setter(Builder::versionDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EDITION_FIELD, LANGUAGE_FIELD,
            VERSION_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Edition", EDITION_FIELD);
                    put("Language", LANGUAGE_FIELD);
                    put("VersionDate", VERSION_DATE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String edition;

    private final String language;

    private final String versionDate;

    private SNOMEDCTDetails(BuilderImpl builder) {
        this.edition = builder.edition;
        this.language = builder.language;
        this.versionDate = builder.versionDate;
    }

    /**
     * <p>
     * The edition of SNOMED-CT used. The edition used for the InferSNOMEDCT editions is the US edition.
     * </p>
     * 
     * @return The edition of SNOMED-CT used. The edition used for the InferSNOMEDCT editions is the US edition.
     */
    public final String edition() {
        return edition;
    }

    /**
     * <p>
     * The language used in the SNOMED-CT ontology. All Amazon Comprehend Medical operations are US English (en).
     * </p>
     * 
     * @return The language used in the SNOMED-CT ontology. All Amazon Comprehend Medical operations are US English
     *         (en).
     */
    public final String language() {
        return language;
    }

    /**
     * <p>
     * The version date of the SNOMED-CT ontology used.
     * </p>
     * 
     * @return The version date of the SNOMED-CT ontology used.
     */
    public final String versionDate() {
        return versionDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(edition());
        hashCode = 31 * hashCode + Objects.hashCode(language());
        hashCode = 31 * hashCode + Objects.hashCode(versionDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SNOMEDCTDetails)) {
            return false;
        }
        SNOMEDCTDetails other = (SNOMEDCTDetails) obj;
        return Objects.equals(edition(), other.edition()) && Objects.equals(language(), other.language())
                && Objects.equals(versionDate(), other.versionDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SNOMEDCTDetails").add("Edition", edition()).add("Language", language())
                .add("VersionDate", versionDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Edition":
            return Optional.ofNullable(clazz.cast(edition()));
        case "Language":
            return Optional.ofNullable(clazz.cast(language()));
        case "VersionDate":
            return Optional.ofNullable(clazz.cast(versionDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SNOMEDCTDetails, T> g) {
        return obj -> g.apply((SNOMEDCTDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SNOMEDCTDetails> {
        /**
         * <p>
         * The edition of SNOMED-CT used. The edition used for the InferSNOMEDCT editions is the US edition.
         * </p>
         * 
         * @param edition
         *        The edition of SNOMED-CT used. The edition used for the InferSNOMEDCT editions is the US edition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edition(String edition);

        /**
         * <p>
         * The language used in the SNOMED-CT ontology. All Amazon Comprehend Medical operations are US English (en).
         * </p>
         * 
         * @param language
         *        The language used in the SNOMED-CT ontology. All Amazon Comprehend Medical operations are US English
         *        (en).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder language(String language);

        /**
         * <p>
         * The version date of the SNOMED-CT ontology used.
         * </p>
         * 
         * @param versionDate
         *        The version date of the SNOMED-CT ontology used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionDate(String versionDate);
    }

    static final class BuilderImpl implements Builder {
        private String edition;

        private String language;

        private String versionDate;

        private BuilderImpl() {
        }

        private BuilderImpl(SNOMEDCTDetails model) {
            edition(model.edition);
            language(model.language);
            versionDate(model.versionDate);
        }

        public final String getEdition() {
            return edition;
        }

        public final void setEdition(String edition) {
            this.edition = edition;
        }

        @Override
        public final Builder edition(String edition) {
            this.edition = edition;
            return this;
        }

        public final String getLanguage() {
            return language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final String getVersionDate() {
            return versionDate;
        }

        public final void setVersionDate(String versionDate) {
            this.versionDate = versionDate;
        }

        @Override
        public final Builder versionDate(String versionDate) {
            this.versionDate = versionDate;
            return this;
        }

        @Override
        public SNOMEDCTDetails build() {
            return new SNOMEDCTDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
