/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehendmedical.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The collection of medical entities extracted from the input text and their associated information. For each entity,
 * the response provides the entity text, the entity category, where the entity text begins and ends, and the level of
 * confidence that Amazon Comprehend Medical has in the detection and analysis. Attributes and traits of the entity are
 * also returned.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SNOMEDCTEntity implements SdkPojo, Serializable, ToCopyableBuilder<SNOMEDCTEntity.Builder, SNOMEDCTEntity> {
    private static final SdkField<Integer> ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Id")
            .getter(getter(SNOMEDCTEntity::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Text")
            .getter(getter(SNOMEDCTEntity::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()).build();

    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Category").getter(getter(SNOMEDCTEntity::categoryAsString)).setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(SNOMEDCTEntity::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Float> SCORE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("Score")
            .getter(getter(SNOMEDCTEntity::score)).setter(setter(Builder::score))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Score").build()).build();

    private static final SdkField<Integer> BEGIN_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BeginOffset").getter(getter(SNOMEDCTEntity::beginOffset)).setter(setter(Builder::beginOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeginOffset").build()).build();

    private static final SdkField<Integer> END_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EndOffset").getter(getter(SNOMEDCTEntity::endOffset)).setter(setter(Builder::endOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndOffset").build()).build();

    private static final SdkField<List<SNOMEDCTAttribute>> ATTRIBUTES_FIELD = SdkField
            .<List<SNOMEDCTAttribute>> builder(MarshallingType.LIST)
            .memberName("Attributes")
            .getter(getter(SNOMEDCTEntity::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SNOMEDCTAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(SNOMEDCTAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SNOMEDCTTrait>> TRAITS_FIELD = SdkField
            .<List<SNOMEDCTTrait>> builder(MarshallingType.LIST)
            .memberName("Traits")
            .getter(getter(SNOMEDCTEntity::traits))
            .setter(setter(Builder::traits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Traits").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SNOMEDCTTrait> builder(MarshallingType.SDK_POJO)
                                            .constructor(SNOMEDCTTrait::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SNOMEDCTConcept>> SNOMEDCT_CONCEPTS_FIELD = SdkField
            .<List<SNOMEDCTConcept>> builder(MarshallingType.LIST)
            .memberName("SNOMEDCTConcepts")
            .getter(getter(SNOMEDCTEntity::snomedctConcepts))
            .setter(setter(Builder::snomedctConcepts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SNOMEDCTConcepts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SNOMEDCTConcept> builder(MarshallingType.SDK_POJO)
                                            .constructor(SNOMEDCTConcept::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TEXT_FIELD,
            CATEGORY_FIELD, TYPE_FIELD, SCORE_FIELD, BEGIN_OFFSET_FIELD, END_OFFSET_FIELD, ATTRIBUTES_FIELD, TRAITS_FIELD,
            SNOMEDCT_CONCEPTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Id", ID_FIELD);
                    put("Text", TEXT_FIELD);
                    put("Category", CATEGORY_FIELD);
                    put("Type", TYPE_FIELD);
                    put("Score", SCORE_FIELD);
                    put("BeginOffset", BEGIN_OFFSET_FIELD);
                    put("EndOffset", END_OFFSET_FIELD);
                    put("Attributes", ATTRIBUTES_FIELD);
                    put("Traits", TRAITS_FIELD);
                    put("SNOMEDCTConcepts", SNOMEDCT_CONCEPTS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Integer id;

    private final String text;

    private final String category;

    private final String type;

    private final Float score;

    private final Integer beginOffset;

    private final Integer endOffset;

    private final List<SNOMEDCTAttribute> attributes;

    private final List<SNOMEDCTTrait> traits;

    private final List<SNOMEDCTConcept> snomedctConcepts;

    private SNOMEDCTEntity(BuilderImpl builder) {
        this.id = builder.id;
        this.text = builder.text;
        this.category = builder.category;
        this.type = builder.type;
        this.score = builder.score;
        this.beginOffset = builder.beginOffset;
        this.endOffset = builder.endOffset;
        this.attributes = builder.attributes;
        this.traits = builder.traits;
        this.snomedctConcepts = builder.snomedctConcepts;
    }

    /**
     * <p>
     * The numeric identifier for the entity. This is a monotonically increasing id unique within this response rather
     * than a global unique identifier.
     * </p>
     * 
     * @return The numeric identifier for the entity. This is a monotonically increasing id unique within this response
     *         rather than a global unique identifier.
     */
    public final Integer id() {
        return id;
    }

    /**
     * <p>
     * The segment of input text extracted as this entity.
     * </p>
     * 
     * @return The segment of input text extracted as this entity.
     */
    public final String text() {
        return text;
    }

    /**
     * <p>
     * The category of the detected entity. Possible categories are MEDICAL_CONDITION, ANATOMY, or
     * TEST_TREATMENT_PROCEDURE.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link SNOMEDCTEntityCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #categoryAsString}.
     * </p>
     * 
     * @return The category of the detected entity. Possible categories are MEDICAL_CONDITION, ANATOMY, or
     *         TEST_TREATMENT_PROCEDURE.
     * @see SNOMEDCTEntityCategory
     */
    public final SNOMEDCTEntityCategory category() {
        return SNOMEDCTEntityCategory.fromValue(category);
    }

    /**
     * <p>
     * The category of the detected entity. Possible categories are MEDICAL_CONDITION, ANATOMY, or
     * TEST_TREATMENT_PROCEDURE.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link SNOMEDCTEntityCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #categoryAsString}.
     * </p>
     * 
     * @return The category of the detected entity. Possible categories are MEDICAL_CONDITION, ANATOMY, or
     *         TEST_TREATMENT_PROCEDURE.
     * @see SNOMEDCTEntityCategory
     */
    public final String categoryAsString() {
        return category;
    }

    /**
     * <p>
     * Describes the specific type of entity with category of entities. Possible types include DX_NAME, ACUITY,
     * DIRECTION, SYSTEM_ORGAN_SITE, TEST_NAME, TEST_VALUE, TEST_UNIT, PROCEDURE_NAME, or TREATMENT_NAME.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SNOMEDCTEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Describes the specific type of entity with category of entities. Possible types include DX_NAME, ACUITY,
     *         DIRECTION, SYSTEM_ORGAN_SITE, TEST_NAME, TEST_VALUE, TEST_UNIT, PROCEDURE_NAME, or TREATMENT_NAME.
     * @see SNOMEDCTEntityType
     */
    public final SNOMEDCTEntityType type() {
        return SNOMEDCTEntityType.fromValue(type);
    }

    /**
     * <p>
     * Describes the specific type of entity with category of entities. Possible types include DX_NAME, ACUITY,
     * DIRECTION, SYSTEM_ORGAN_SITE, TEST_NAME, TEST_VALUE, TEST_UNIT, PROCEDURE_NAME, or TREATMENT_NAME.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SNOMEDCTEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Describes the specific type of entity with category of entities. Possible types include DX_NAME, ACUITY,
     *         DIRECTION, SYSTEM_ORGAN_SITE, TEST_NAME, TEST_VALUE, TEST_UNIT, PROCEDURE_NAME, or TREATMENT_NAME.
     * @see SNOMEDCTEntityType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The level of confidence that Amazon Comprehend Medical has in the accuracy of the detected entity.
     * </p>
     * 
     * @return The level of confidence that Amazon Comprehend Medical has in the accuracy of the detected entity.
     */
    public final Float score() {
        return score;
    }

    /**
     * <p>
     * The 0-based character offset in the input text that shows where the entity begins. The offset returns the UTF-8
     * code point in the string.
     * </p>
     * 
     * @return The 0-based character offset in the input text that shows where the entity begins. The offset returns the
     *         UTF-8 code point in the string.
     */
    public final Integer beginOffset() {
        return beginOffset;
    }

    /**
     * <p>
     * The 0-based character offset in the input text that shows where the entity ends. The offset returns the UTF-8
     * code point in the string.
     * </p>
     * 
     * @return The 0-based character offset in the input text that shows where the entity ends. The offset returns the
     *         UTF-8 code point in the string.
     */
    public final Integer endOffset() {
        return endOffset;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An extracted segment of the text that is an attribute of an entity, or otherwise related to an entity, such as
     * the dosage of a medication taken.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return An extracted segment of the text that is an attribute of an entity, or otherwise related to an entity,
     *         such as the dosage of a medication taken.
     */
    public final List<SNOMEDCTAttribute> attributes() {
        return attributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Traits property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTraits() {
        return traits != null && !(traits instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contextual information for the entity.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTraits} method.
     * </p>
     * 
     * @return Contextual information for the entity.
     */
    public final List<SNOMEDCTTrait> traits() {
        return traits;
    }

    /**
     * For responses, this returns true if the service returned a value for the SNOMEDCTConcepts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSnomedctConcepts() {
        return snomedctConcepts != null && !(snomedctConcepts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The SNOMED concepts that the entity could refer to, along with a score indicating the likelihood of the match.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSnomedctConcepts} method.
     * </p>
     * 
     * @return The SNOMED concepts that the entity could refer to, along with a score indicating the likelihood of the
     *         match.
     */
    public final List<SNOMEDCTConcept> snomedctConcepts() {
        return snomedctConcepts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(score());
        hashCode = 31 * hashCode + Objects.hashCode(beginOffset());
        hashCode = 31 * hashCode + Objects.hashCode(endOffset());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTraits() ? traits() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSnomedctConcepts() ? snomedctConcepts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SNOMEDCTEntity)) {
            return false;
        }
        SNOMEDCTEntity other = (SNOMEDCTEntity) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(text(), other.text())
                && Objects.equals(categoryAsString(), other.categoryAsString())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(score(), other.score())
                && Objects.equals(beginOffset(), other.beginOffset()) && Objects.equals(endOffset(), other.endOffset())
                && hasAttributes() == other.hasAttributes() && Objects.equals(attributes(), other.attributes())
                && hasTraits() == other.hasTraits() && Objects.equals(traits(), other.traits())
                && hasSnomedctConcepts() == other.hasSnomedctConcepts()
                && Objects.equals(snomedctConcepts(), other.snomedctConcepts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SNOMEDCTEntity").add("Id", id()).add("Text", text()).add("Category", categoryAsString())
                .add("Type", typeAsString()).add("Score", score()).add("BeginOffset", beginOffset())
                .add("EndOffset", endOffset()).add("Attributes", hasAttributes() ? attributes() : null)
                .add("Traits", hasTraits() ? traits() : null)
                .add("SNOMEDCTConcepts", hasSnomedctConcepts() ? snomedctConcepts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Text":
            return Optional.ofNullable(clazz.cast(text()));
        case "Category":
            return Optional.ofNullable(clazz.cast(categoryAsString()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Score":
            return Optional.ofNullable(clazz.cast(score()));
        case "BeginOffset":
            return Optional.ofNullable(clazz.cast(beginOffset()));
        case "EndOffset":
            return Optional.ofNullable(clazz.cast(endOffset()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "Traits":
            return Optional.ofNullable(clazz.cast(traits()));
        case "SNOMEDCTConcepts":
            return Optional.ofNullable(clazz.cast(snomedctConcepts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SNOMEDCTEntity, T> g) {
        return obj -> g.apply((SNOMEDCTEntity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SNOMEDCTEntity> {
        /**
         * <p>
         * The numeric identifier for the entity. This is a monotonically increasing id unique within this response
         * rather than a global unique identifier.
         * </p>
         * 
         * @param id
         *        The numeric identifier for the entity. This is a monotonically increasing id unique within this
         *        response rather than a global unique identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(Integer id);

        /**
         * <p>
         * The segment of input text extracted as this entity.
         * </p>
         * 
         * @param text
         *        The segment of input text extracted as this entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * The category of the detected entity. Possible categories are MEDICAL_CONDITION, ANATOMY, or
         * TEST_TREATMENT_PROCEDURE.
         * </p>
         * 
         * @param category
         *        The category of the detected entity. Possible categories are MEDICAL_CONDITION, ANATOMY, or
         *        TEST_TREATMENT_PROCEDURE.
         * @see SNOMEDCTEntityCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SNOMEDCTEntityCategory
         */
        Builder category(String category);

        /**
         * <p>
         * The category of the detected entity. Possible categories are MEDICAL_CONDITION, ANATOMY, or
         * TEST_TREATMENT_PROCEDURE.
         * </p>
         * 
         * @param category
         *        The category of the detected entity. Possible categories are MEDICAL_CONDITION, ANATOMY, or
         *        TEST_TREATMENT_PROCEDURE.
         * @see SNOMEDCTEntityCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SNOMEDCTEntityCategory
         */
        Builder category(SNOMEDCTEntityCategory category);

        /**
         * <p>
         * Describes the specific type of entity with category of entities. Possible types include DX_NAME, ACUITY,
         * DIRECTION, SYSTEM_ORGAN_SITE, TEST_NAME, TEST_VALUE, TEST_UNIT, PROCEDURE_NAME, or TREATMENT_NAME.
         * </p>
         * 
         * @param type
         *        Describes the specific type of entity with category of entities. Possible types include DX_NAME,
         *        ACUITY, DIRECTION, SYSTEM_ORGAN_SITE, TEST_NAME, TEST_VALUE, TEST_UNIT, PROCEDURE_NAME, or
         *        TREATMENT_NAME.
         * @see SNOMEDCTEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SNOMEDCTEntityType
         */
        Builder type(String type);

        /**
         * <p>
         * Describes the specific type of entity with category of entities. Possible types include DX_NAME, ACUITY,
         * DIRECTION, SYSTEM_ORGAN_SITE, TEST_NAME, TEST_VALUE, TEST_UNIT, PROCEDURE_NAME, or TREATMENT_NAME.
         * </p>
         * 
         * @param type
         *        Describes the specific type of entity with category of entities. Possible types include DX_NAME,
         *        ACUITY, DIRECTION, SYSTEM_ORGAN_SITE, TEST_NAME, TEST_VALUE, TEST_UNIT, PROCEDURE_NAME, or
         *        TREATMENT_NAME.
         * @see SNOMEDCTEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SNOMEDCTEntityType
         */
        Builder type(SNOMEDCTEntityType type);

        /**
         * <p>
         * The level of confidence that Amazon Comprehend Medical has in the accuracy of the detected entity.
         * </p>
         * 
         * @param score
         *        The level of confidence that Amazon Comprehend Medical has in the accuracy of the detected entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder score(Float score);

        /**
         * <p>
         * The 0-based character offset in the input text that shows where the entity begins. The offset returns the
         * UTF-8 code point in the string.
         * </p>
         * 
         * @param beginOffset
         *        The 0-based character offset in the input text that shows where the entity begins. The offset returns
         *        the UTF-8 code point in the string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beginOffset(Integer beginOffset);

        /**
         * <p>
         * The 0-based character offset in the input text that shows where the entity ends. The offset returns the UTF-8
         * code point in the string.
         * </p>
         * 
         * @param endOffset
         *        The 0-based character offset in the input text that shows where the entity ends. The offset returns
         *        the UTF-8 code point in the string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endOffset(Integer endOffset);

        /**
         * <p>
         * An extracted segment of the text that is an attribute of an entity, or otherwise related to an entity, such
         * as the dosage of a medication taken.
         * </p>
         * 
         * @param attributes
         *        An extracted segment of the text that is an attribute of an entity, or otherwise related to an entity,
         *        such as the dosage of a medication taken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Collection<SNOMEDCTAttribute> attributes);

        /**
         * <p>
         * An extracted segment of the text that is an attribute of an entity, or otherwise related to an entity, such
         * as the dosage of a medication taken.
         * </p>
         * 
         * @param attributes
         *        An extracted segment of the text that is an attribute of an entity, or otherwise related to an entity,
         *        such as the dosage of a medication taken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(SNOMEDCTAttribute... attributes);

        /**
         * <p>
         * An extracted segment of the text that is an attribute of an entity, or otherwise related to an entity, such
         * as the dosage of a medication taken.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.comprehendmedical.model.SNOMEDCTAttribute.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.comprehendmedical.model.SNOMEDCTAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.comprehendmedical.model.SNOMEDCTAttribute.Builder#build()} is called
         * immediately and its result is passed to {@link #attributes(List<SNOMEDCTAttribute>)}.
         * 
         * @param attributes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.comprehendmedical.model.SNOMEDCTAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(java.util.Collection<SNOMEDCTAttribute>)
         */
        Builder attributes(Consumer<SNOMEDCTAttribute.Builder>... attributes);

        /**
         * <p>
         * Contextual information for the entity.
         * </p>
         * 
         * @param traits
         *        Contextual information for the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traits(Collection<SNOMEDCTTrait> traits);

        /**
         * <p>
         * Contextual information for the entity.
         * </p>
         * 
         * @param traits
         *        Contextual information for the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traits(SNOMEDCTTrait... traits);

        /**
         * <p>
         * Contextual information for the entity.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.comprehendmedical.model.SNOMEDCTTrait.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.comprehendmedical.model.SNOMEDCTTrait#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.comprehendmedical.model.SNOMEDCTTrait.Builder#build()} is called
         * immediately and its result is passed to {@link #traits(List<SNOMEDCTTrait>)}.
         * 
         * @param traits
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.comprehendmedical.model.SNOMEDCTTrait.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #traits(java.util.Collection<SNOMEDCTTrait>)
         */
        Builder traits(Consumer<SNOMEDCTTrait.Builder>... traits);

        /**
         * <p>
         * The SNOMED concepts that the entity could refer to, along with a score indicating the likelihood of the
         * match.
         * </p>
         * 
         * @param snomedctConcepts
         *        The SNOMED concepts that the entity could refer to, along with a score indicating the likelihood of
         *        the match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snomedctConcepts(Collection<SNOMEDCTConcept> snomedctConcepts);

        /**
         * <p>
         * The SNOMED concepts that the entity could refer to, along with a score indicating the likelihood of the
         * match.
         * </p>
         * 
         * @param snomedctConcepts
         *        The SNOMED concepts that the entity could refer to, along with a score indicating the likelihood of
         *        the match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snomedctConcepts(SNOMEDCTConcept... snomedctConcepts);

        /**
         * <p>
         * The SNOMED concepts that the entity could refer to, along with a score indicating the likelihood of the
         * match.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.comprehendmedical.model.SNOMEDCTConcept.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.comprehendmedical.model.SNOMEDCTConcept#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.comprehendmedical.model.SNOMEDCTConcept.Builder#build()} is called
         * immediately and its result is passed to {@link #snomedctConcepts(List<SNOMEDCTConcept>)}.
         * 
         * @param snomedctConcepts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.comprehendmedical.model.SNOMEDCTConcept.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snomedctConcepts(java.util.Collection<SNOMEDCTConcept>)
         */
        Builder snomedctConcepts(Consumer<SNOMEDCTConcept.Builder>... snomedctConcepts);
    }

    static final class BuilderImpl implements Builder {
        private Integer id;

        private String text;

        private String category;

        private String type;

        private Float score;

        private Integer beginOffset;

        private Integer endOffset;

        private List<SNOMEDCTAttribute> attributes = DefaultSdkAutoConstructList.getInstance();

        private List<SNOMEDCTTrait> traits = DefaultSdkAutoConstructList.getInstance();

        private List<SNOMEDCTConcept> snomedctConcepts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SNOMEDCTEntity model) {
            id(model.id);
            text(model.text);
            category(model.category);
            type(model.type);
            score(model.score);
            beginOffset(model.beginOffset);
            endOffset(model.endOffset);
            attributes(model.attributes);
            traits(model.traits);
            snomedctConcepts(model.snomedctConcepts);
        }

        public final Integer getId() {
            return id;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        @Override
        public final Builder id(Integer id) {
            this.id = id;
            return this;
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final String getCategory() {
            return category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(SNOMEDCTEntityCategory category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SNOMEDCTEntityType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Float getScore() {
            return score;
        }

        public final void setScore(Float score) {
            this.score = score;
        }

        @Override
        public final Builder score(Float score) {
            this.score = score;
            return this;
        }

        public final Integer getBeginOffset() {
            return beginOffset;
        }

        public final void setBeginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
        }

        @Override
        public final Builder beginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
            return this;
        }

        public final Integer getEndOffset() {
            return endOffset;
        }

        public final void setEndOffset(Integer endOffset) {
            this.endOffset = endOffset;
        }

        @Override
        public final Builder endOffset(Integer endOffset) {
            this.endOffset = endOffset;
            return this;
        }

        public final List<SNOMEDCTAttribute.Builder> getAttributes() {
            List<SNOMEDCTAttribute.Builder> result = SNOMEDCTAttributeListCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Collection<SNOMEDCTAttribute.BuilderImpl> attributes) {
            this.attributes = SNOMEDCTAttributeListCopier.copyFromBuilder(attributes);
        }

        @Override
        public final Builder attributes(Collection<SNOMEDCTAttribute> attributes) {
            this.attributes = SNOMEDCTAttributeListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(SNOMEDCTAttribute... attributes) {
            attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<SNOMEDCTAttribute.Builder>... attributes) {
            attributes(Stream.of(attributes).map(c -> SNOMEDCTAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<SNOMEDCTTrait.Builder> getTraits() {
            List<SNOMEDCTTrait.Builder> result = SNOMEDCTTraitListCopier.copyToBuilder(this.traits);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTraits(Collection<SNOMEDCTTrait.BuilderImpl> traits) {
            this.traits = SNOMEDCTTraitListCopier.copyFromBuilder(traits);
        }

        @Override
        public final Builder traits(Collection<SNOMEDCTTrait> traits) {
            this.traits = SNOMEDCTTraitListCopier.copy(traits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder traits(SNOMEDCTTrait... traits) {
            traits(Arrays.asList(traits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder traits(Consumer<SNOMEDCTTrait.Builder>... traits) {
            traits(Stream.of(traits).map(c -> SNOMEDCTTrait.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SNOMEDCTConcept.Builder> getSnomedctConcepts() {
            List<SNOMEDCTConcept.Builder> result = SNOMEDCTConceptListCopier.copyToBuilder(this.snomedctConcepts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSnomedctConcepts(Collection<SNOMEDCTConcept.BuilderImpl> snomedctConcepts) {
            this.snomedctConcepts = SNOMEDCTConceptListCopier.copyFromBuilder(snomedctConcepts);
        }

        @Override
        public final Builder snomedctConcepts(Collection<SNOMEDCTConcept> snomedctConcepts) {
            this.snomedctConcepts = SNOMEDCTConceptListCopier.copy(snomedctConcepts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snomedctConcepts(SNOMEDCTConcept... snomedctConcepts) {
            snomedctConcepts(Arrays.asList(snomedctConcepts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snomedctConcepts(Consumer<SNOMEDCTConcept.Builder>... snomedctConcepts) {
            snomedctConcepts(Stream.of(snomedctConcepts).map(c -> SNOMEDCTConcept.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SNOMEDCTEntity build() {
            return new SNOMEDCTEntity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
