/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Date;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.config.transform.ComplianceSummaryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The number of AWS Config rules or AWS resources that are compliant and noncompliant.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ComplianceSummary implements StructuredPojo, ToCopyableBuilder<ComplianceSummary.Builder, ComplianceSummary> {
    private final ComplianceContributorCount compliantResourceCount;

    private final ComplianceContributorCount nonCompliantResourceCount;

    private final Date complianceSummaryTimestamp;

    private ComplianceSummary(BuilderImpl builder) {
        this.compliantResourceCount = builder.compliantResourceCount;
        this.nonCompliantResourceCount = builder.nonCompliantResourceCount;
        this.complianceSummaryTimestamp = builder.complianceSummaryTimestamp;
    }

    /**
     * <p>
     * The number of AWS Config rules or AWS resources that are compliant, up to a maximum of 25 for rules and 100 for
     * resources.
     * </p>
     * 
     * @return The number of AWS Config rules or AWS resources that are compliant, up to a maximum of 25 for rules and
     *         100 for resources.
     */
    public ComplianceContributorCount compliantResourceCount() {
        return compliantResourceCount;
    }

    /**
     * <p>
     * The number of AWS Config rules or AWS resources that are noncompliant, up to a maximum of 25 for rules and 100
     * for resources.
     * </p>
     * 
     * @return The number of AWS Config rules or AWS resources that are noncompliant, up to a maximum of 25 for rules
     *         and 100 for resources.
     */
    public ComplianceContributorCount nonCompliantResourceCount() {
        return nonCompliantResourceCount;
    }

    /**
     * <p>
     * The time that AWS Config created the compliance summary.
     * </p>
     * 
     * @return The time that AWS Config created the compliance summary.
     */
    public Date complianceSummaryTimestamp() {
        return complianceSummaryTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((compliantResourceCount() == null) ? 0 : compliantResourceCount().hashCode());
        hashCode = 31 * hashCode + ((nonCompliantResourceCount() == null) ? 0 : nonCompliantResourceCount().hashCode());
        hashCode = 31 * hashCode + ((complianceSummaryTimestamp() == null) ? 0 : complianceSummaryTimestamp().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComplianceSummary)) {
            return false;
        }
        ComplianceSummary other = (ComplianceSummary) obj;
        if (other.compliantResourceCount() == null ^ this.compliantResourceCount() == null) {
            return false;
        }
        if (other.compliantResourceCount() != null && !other.compliantResourceCount().equals(this.compliantResourceCount())) {
            return false;
        }
        if (other.nonCompliantResourceCount() == null ^ this.nonCompliantResourceCount() == null) {
            return false;
        }
        if (other.nonCompliantResourceCount() != null
                && !other.nonCompliantResourceCount().equals(this.nonCompliantResourceCount())) {
            return false;
        }
        if (other.complianceSummaryTimestamp() == null ^ this.complianceSummaryTimestamp() == null) {
            return false;
        }
        if (other.complianceSummaryTimestamp() != null
                && !other.complianceSummaryTimestamp().equals(this.complianceSummaryTimestamp())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (compliantResourceCount() != null) {
            sb.append("CompliantResourceCount: ").append(compliantResourceCount()).append(",");
        }
        if (nonCompliantResourceCount() != null) {
            sb.append("NonCompliantResourceCount: ").append(nonCompliantResourceCount()).append(",");
        }
        if (complianceSummaryTimestamp() != null) {
            sb.append("ComplianceSummaryTimestamp: ").append(complianceSummaryTimestamp()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComplianceSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ComplianceSummary> {
        /**
         * <p>
         * The number of AWS Config rules or AWS resources that are compliant, up to a maximum of 25 for rules and 100
         * for resources.
         * </p>
         * 
         * @param compliantResourceCount
         *        The number of AWS Config rules or AWS resources that are compliant, up to a maximum of 25 for rules
         *        and 100 for resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compliantResourceCount(ComplianceContributorCount compliantResourceCount);

        /**
         * <p>
         * The number of AWS Config rules or AWS resources that are noncompliant, up to a maximum of 25 for rules and
         * 100 for resources.
         * </p>
         * 
         * @param nonCompliantResourceCount
         *        The number of AWS Config rules or AWS resources that are noncompliant, up to a maximum of 25 for rules
         *        and 100 for resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonCompliantResourceCount(ComplianceContributorCount nonCompliantResourceCount);

        /**
         * <p>
         * The time that AWS Config created the compliance summary.
         * </p>
         * 
         * @param complianceSummaryTimestamp
         *        The time that AWS Config created the compliance summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceSummaryTimestamp(Date complianceSummaryTimestamp);
    }

    private static final class BuilderImpl implements Builder {
        private ComplianceContributorCount compliantResourceCount;

        private ComplianceContributorCount nonCompliantResourceCount;

        private Date complianceSummaryTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ComplianceSummary model) {
            setCompliantResourceCount(model.compliantResourceCount);
            setNonCompliantResourceCount(model.nonCompliantResourceCount);
            setComplianceSummaryTimestamp(model.complianceSummaryTimestamp);
        }

        public final ComplianceContributorCount getCompliantResourceCount() {
            return compliantResourceCount;
        }

        @Override
        public final Builder compliantResourceCount(ComplianceContributorCount compliantResourceCount) {
            this.compliantResourceCount = compliantResourceCount;
            return this;
        }

        public final void setCompliantResourceCount(ComplianceContributorCount compliantResourceCount) {
            this.compliantResourceCount = compliantResourceCount;
        }

        public final ComplianceContributorCount getNonCompliantResourceCount() {
            return nonCompliantResourceCount;
        }

        @Override
        public final Builder nonCompliantResourceCount(ComplianceContributorCount nonCompliantResourceCount) {
            this.nonCompliantResourceCount = nonCompliantResourceCount;
            return this;
        }

        public final void setNonCompliantResourceCount(ComplianceContributorCount nonCompliantResourceCount) {
            this.nonCompliantResourceCount = nonCompliantResourceCount;
        }

        public final Date getComplianceSummaryTimestamp() {
            return complianceSummaryTimestamp;
        }

        @Override
        public final Builder complianceSummaryTimestamp(Date complianceSummaryTimestamp) {
            this.complianceSummaryTimestamp = StandardMemberCopier.copy(complianceSummaryTimestamp);
            return this;
        }

        public final void setComplianceSummaryTimestamp(Date complianceSummaryTimestamp) {
            this.complianceSummaryTimestamp = StandardMemberCopier.copy(complianceSummaryTimestamp);
        }

        @Override
        public ComplianceSummary build() {
            return new ComplianceSummary(this);
        }
    }
}
