/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Date;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.config.transform.ConfigStreamDeliveryInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list that contains the status of the delivery of the configuration stream notification to the Amazon SNS topic.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ConfigStreamDeliveryInfo implements StructuredPojo,
        ToCopyableBuilder<ConfigStreamDeliveryInfo.Builder, ConfigStreamDeliveryInfo> {
    private final String lastStatus;

    private final String lastErrorCode;

    private final String lastErrorMessage;

    private final Date lastStatusChangeTime;

    private ConfigStreamDeliveryInfo(BuilderImpl builder) {
        this.lastStatus = builder.lastStatus;
        this.lastErrorCode = builder.lastErrorCode;
        this.lastErrorMessage = builder.lastErrorMessage;
        this.lastStatusChangeTime = builder.lastStatusChangeTime;
    }

    /**
     * <p>
     * Status of the last attempted delivery.
     * </p>
     * <p>
     * <b>Note</b> Providing an SNS topic on a <a
     * href="http://docs.aws.amazon.com/config/latest/APIReference/API_DeliveryChannel.html">DeliveryChannel</a> for AWS
     * Config is optional. If the SNS delivery is turned off, the last status will be <b>Not_Applicable</b>.
     * </p>
     * 
     * @return Status of the last attempted delivery.</p>
     *         <p>
     *         <b>Note</b> Providing an SNS topic on a <a
     *         href="http://docs.aws.amazon.com/config/latest/APIReference/API_DeliveryChannel.html">DeliveryChannel</a>
     *         for AWS Config is optional. If the SNS delivery is turned off, the last status will be
     *         <b>Not_Applicable</b>.
     * @see DeliveryStatus
     */
    public String lastStatus() {
        return lastStatus;
    }

    /**
     * <p>
     * The error code from the last attempted delivery.
     * </p>
     * 
     * @return The error code from the last attempted delivery.
     */
    public String lastErrorCode() {
        return lastErrorCode;
    }

    /**
     * <p>
     * The error message from the last attempted delivery.
     * </p>
     * 
     * @return The error message from the last attempted delivery.
     */
    public String lastErrorMessage() {
        return lastErrorMessage;
    }

    /**
     * <p>
     * The time from the last status change.
     * </p>
     * 
     * @return The time from the last status change.
     */
    public Date lastStatusChangeTime() {
        return lastStatusChangeTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((lastStatus() == null) ? 0 : lastStatus().hashCode());
        hashCode = 31 * hashCode + ((lastErrorCode() == null) ? 0 : lastErrorCode().hashCode());
        hashCode = 31 * hashCode + ((lastErrorMessage() == null) ? 0 : lastErrorMessage().hashCode());
        hashCode = 31 * hashCode + ((lastStatusChangeTime() == null) ? 0 : lastStatusChangeTime().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigStreamDeliveryInfo)) {
            return false;
        }
        ConfigStreamDeliveryInfo other = (ConfigStreamDeliveryInfo) obj;
        if (other.lastStatus() == null ^ this.lastStatus() == null) {
            return false;
        }
        if (other.lastStatus() != null && !other.lastStatus().equals(this.lastStatus())) {
            return false;
        }
        if (other.lastErrorCode() == null ^ this.lastErrorCode() == null) {
            return false;
        }
        if (other.lastErrorCode() != null && !other.lastErrorCode().equals(this.lastErrorCode())) {
            return false;
        }
        if (other.lastErrorMessage() == null ^ this.lastErrorMessage() == null) {
            return false;
        }
        if (other.lastErrorMessage() != null && !other.lastErrorMessage().equals(this.lastErrorMessage())) {
            return false;
        }
        if (other.lastStatusChangeTime() == null ^ this.lastStatusChangeTime() == null) {
            return false;
        }
        if (other.lastStatusChangeTime() != null && !other.lastStatusChangeTime().equals(this.lastStatusChangeTime())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (lastStatus() != null) {
            sb.append("LastStatus: ").append(lastStatus()).append(",");
        }
        if (lastErrorCode() != null) {
            sb.append("LastErrorCode: ").append(lastErrorCode()).append(",");
        }
        if (lastErrorMessage() != null) {
            sb.append("LastErrorMessage: ").append(lastErrorMessage()).append(",");
        }
        if (lastStatusChangeTime() != null) {
            sb.append("LastStatusChangeTime: ").append(lastStatusChangeTime()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConfigStreamDeliveryInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ConfigStreamDeliveryInfo> {
        /**
         * <p>
         * Status of the last attempted delivery.
         * </p>
         * <p>
         * <b>Note</b> Providing an SNS topic on a <a
         * href="http://docs.aws.amazon.com/config/latest/APIReference/API_DeliveryChannel.html">DeliveryChannel</a> for
         * AWS Config is optional. If the SNS delivery is turned off, the last status will be <b>Not_Applicable</b>.
         * </p>
         * 
         * @param lastStatus
         *        Status of the last attempted delivery.</p>
         *        <p>
         *        <b>Note</b> Providing an SNS topic on a <a
         *        href="http://docs.aws.amazon.com/config/latest/APIReference/API_DeliveryChannel.html"
         *        >DeliveryChannel</a> for AWS Config is optional. If the SNS delivery is turned off, the last status
         *        will be <b>Not_Applicable</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeliveryStatus
         */
        Builder lastStatus(String lastStatus);

        /**
         * <p>
         * Status of the last attempted delivery.
         * </p>
         * <p>
         * <b>Note</b> Providing an SNS topic on a <a
         * href="http://docs.aws.amazon.com/config/latest/APIReference/API_DeliveryChannel.html">DeliveryChannel</a> for
         * AWS Config is optional. If the SNS delivery is turned off, the last status will be <b>Not_Applicable</b>.
         * </p>
         * 
         * @param lastStatus
         *        Status of the last attempted delivery.</p>
         *        <p>
         *        <b>Note</b> Providing an SNS topic on a <a
         *        href="http://docs.aws.amazon.com/config/latest/APIReference/API_DeliveryChannel.html"
         *        >DeliveryChannel</a> for AWS Config is optional. If the SNS delivery is turned off, the last status
         *        will be <b>Not_Applicable</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeliveryStatus
         */
        Builder lastStatus(DeliveryStatus lastStatus);

        /**
         * <p>
         * The error code from the last attempted delivery.
         * </p>
         * 
         * @param lastErrorCode
         *        The error code from the last attempted delivery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastErrorCode(String lastErrorCode);

        /**
         * <p>
         * The error message from the last attempted delivery.
         * </p>
         * 
         * @param lastErrorMessage
         *        The error message from the last attempted delivery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastErrorMessage(String lastErrorMessage);

        /**
         * <p>
         * The time from the last status change.
         * </p>
         * 
         * @param lastStatusChangeTime
         *        The time from the last status change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastStatusChangeTime(Date lastStatusChangeTime);
    }

    private static final class BuilderImpl implements Builder {
        private String lastStatus;

        private String lastErrorCode;

        private String lastErrorMessage;

        private Date lastStatusChangeTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigStreamDeliveryInfo model) {
            setLastStatus(model.lastStatus);
            setLastErrorCode(model.lastErrorCode);
            setLastErrorMessage(model.lastErrorMessage);
            setLastStatusChangeTime(model.lastStatusChangeTime);
        }

        public final String getLastStatus() {
            return lastStatus;
        }

        @Override
        public final Builder lastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
            return this;
        }

        @Override
        public final Builder lastStatus(DeliveryStatus lastStatus) {
            this.lastStatus(lastStatus.toString());
            return this;
        }

        public final void setLastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
        }

        public final void setLastStatus(DeliveryStatus lastStatus) {
            this.lastStatus(lastStatus.toString());
        }

        public final String getLastErrorCode() {
            return lastErrorCode;
        }

        @Override
        public final Builder lastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
            return this;
        }

        public final void setLastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
        }

        public final String getLastErrorMessage() {
            return lastErrorMessage;
        }

        @Override
        public final Builder lastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
            return this;
        }

        public final void setLastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
        }

        public final Date getLastStatusChangeTime() {
            return lastStatusChangeTime;
        }

        @Override
        public final Builder lastStatusChangeTime(Date lastStatusChangeTime) {
            this.lastStatusChangeTime = StandardMemberCopier.copy(lastStatusChangeTime);
            return this;
        }

        public final void setLastStatusChangeTime(Date lastStatusChangeTime) {
            this.lastStatusChangeTime = StandardMemberCopier.copy(lastStatusChangeTime);
        }

        @Override
        public ConfigStreamDeliveryInfo build() {
            return new ConfigStreamDeliveryInfo(this);
        }
    }
}
