/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteConfigRuleRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteConfigRuleRequest.Builder, DeleteConfigRuleRequest> {
    private final String configRuleName;

    private DeleteConfigRuleRequest(BuilderImpl builder) {
        this.configRuleName = builder.configRuleName;
    }

    /**
     * <p>
     * The name of the AWS Config rule that you want to delete.
     * </p>
     * 
     * @return The name of the AWS Config rule that you want to delete.
     */
    public String configRuleName() {
        return configRuleName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((configRuleName() == null) ? 0 : configRuleName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteConfigRuleRequest)) {
            return false;
        }
        DeleteConfigRuleRequest other = (DeleteConfigRuleRequest) obj;
        if (other.configRuleName() == null ^ this.configRuleName() == null) {
            return false;
        }
        if (other.configRuleName() != null && !other.configRuleName().equals(this.configRuleName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (configRuleName() != null) {
            sb.append("ConfigRuleName: ").append(configRuleName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteConfigRuleRequest> {
        /**
         * <p>
         * The name of the AWS Config rule that you want to delete.
         * </p>
         * 
         * @param configRuleName
         *        The name of the AWS Config rule that you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleName(String configRuleName);
    }

    private static final class BuilderImpl implements Builder {
        private String configRuleName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteConfigRuleRequest model) {
            setConfigRuleName(model.configRuleName);
        }

        public final String getConfigRuleName() {
            return configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        @Override
        public DeleteConfigRuleRequest build() {
            return new DeleteConfigRuleRequest(this);
        }
    }
}
