/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.config.transform.DeliveryChannelMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The channel through which AWS Config delivers notifications and updated configuration states.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeliveryChannel implements StructuredPojo, ToCopyableBuilder<DeliveryChannel.Builder, DeliveryChannel> {
    private final String name;

    private final String s3BucketName;

    private final String s3KeyPrefix;

    private final String snsTopicARN;

    private final ConfigSnapshotDeliveryProperties configSnapshotDeliveryProperties;

    private DeliveryChannel(BuilderImpl builder) {
        this.name = builder.name;
        this.s3BucketName = builder.s3BucketName;
        this.s3KeyPrefix = builder.s3KeyPrefix;
        this.snsTopicARN = builder.snsTopicARN;
        this.configSnapshotDeliveryProperties = builder.configSnapshotDeliveryProperties;
    }

    /**
     * <p>
     * The name of the delivery channel. By default, AWS Config assigns the name "default" when creating the delivery
     * channel. To change the delivery channel name, you must use the DeleteDeliveryChannel action to delete your
     * current delivery channel, and then you must use the PutDeliveryChannel command to create a delivery channel that
     * has the desired name.
     * </p>
     * 
     * @return The name of the delivery channel. By default, AWS Config assigns the name "default" when creating the
     *         delivery channel. To change the delivery channel name, you must use the DeleteDeliveryChannel action to
     *         delete your current delivery channel, and then you must use the PutDeliveryChannel command to create a
     *         delivery channel that has the desired name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The name of the Amazon S3 bucket to which AWS Config delivers configuration snapshots and configuration history
     * files.
     * </p>
     * <p>
     * If you specify a bucket that belongs to another AWS account, that bucket must have policies that grant access
     * permissions to AWS Config. For more information, see <a
     * href="http://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-policy.html">Permissions for the Amazon
     * S3 Bucket</a> in the AWS Config Developer Guide.
     * </p>
     * 
     * @return The name of the Amazon S3 bucket to which AWS Config delivers configuration snapshots and configuration
     *         history files.</p>
     *         <p>
     *         If you specify a bucket that belongs to another AWS account, that bucket must have policies that grant
     *         access permissions to AWS Config. For more information, see <a
     *         href="http://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-policy.html">Permissions for the
     *         Amazon S3 Bucket</a> in the AWS Config Developer Guide.
     */
    public String s3BucketName() {
        return s3BucketName;
    }

    /**
     * <p>
     * The prefix for the specified Amazon S3 bucket.
     * </p>
     * 
     * @return The prefix for the specified Amazon S3 bucket.
     */
    public String s3KeyPrefix() {
        return s3KeyPrefix;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon SNS topic to which AWS Config sends notifications about
     * configuration changes.
     * </p>
     * <p>
     * If you choose a topic from another account, the topic must have policies that grant access permissions to AWS
     * Config. For more information, see <a
     * href="http://docs.aws.amazon.com/config/latest/developerguide/sns-topic-policy.html">Permissions for the Amazon
     * SNS Topic</a> in the AWS Config Developer Guide.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon SNS topic to which AWS Config sends notifications about
     *         configuration changes.</p>
     *         <p>
     *         If you choose a topic from another account, the topic must have policies that grant access permissions to
     *         AWS Config. For more information, see <a
     *         href="http://docs.aws.amazon.com/config/latest/developerguide/sns-topic-policy.html">Permissions for the
     *         Amazon SNS Topic</a> in the AWS Config Developer Guide.
     */
    public String snsTopicARN() {
        return snsTopicARN;
    }

    /**
     * <p>
     * The options for how often AWS Config delivers configuration snapshots to the Amazon S3 bucket.
     * </p>
     * 
     * @return The options for how often AWS Config delivers configuration snapshots to the Amazon S3 bucket.
     */
    public ConfigSnapshotDeliveryProperties configSnapshotDeliveryProperties() {
        return configSnapshotDeliveryProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((s3BucketName() == null) ? 0 : s3BucketName().hashCode());
        hashCode = 31 * hashCode + ((s3KeyPrefix() == null) ? 0 : s3KeyPrefix().hashCode());
        hashCode = 31 * hashCode + ((snsTopicARN() == null) ? 0 : snsTopicARN().hashCode());
        hashCode = 31 * hashCode
                + ((configSnapshotDeliveryProperties() == null) ? 0 : configSnapshotDeliveryProperties().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeliveryChannel)) {
            return false;
        }
        DeliveryChannel other = (DeliveryChannel) obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.s3BucketName() == null ^ this.s3BucketName() == null) {
            return false;
        }
        if (other.s3BucketName() != null && !other.s3BucketName().equals(this.s3BucketName())) {
            return false;
        }
        if (other.s3KeyPrefix() == null ^ this.s3KeyPrefix() == null) {
            return false;
        }
        if (other.s3KeyPrefix() != null && !other.s3KeyPrefix().equals(this.s3KeyPrefix())) {
            return false;
        }
        if (other.snsTopicARN() == null ^ this.snsTopicARN() == null) {
            return false;
        }
        if (other.snsTopicARN() != null && !other.snsTopicARN().equals(this.snsTopicARN())) {
            return false;
        }
        if (other.configSnapshotDeliveryProperties() == null ^ this.configSnapshotDeliveryProperties() == null) {
            return false;
        }
        if (other.configSnapshotDeliveryProperties() != null
                && !other.configSnapshotDeliveryProperties().equals(this.configSnapshotDeliveryProperties())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (s3BucketName() != null) {
            sb.append("S3BucketName: ").append(s3BucketName()).append(",");
        }
        if (s3KeyPrefix() != null) {
            sb.append("S3KeyPrefix: ").append(s3KeyPrefix()).append(",");
        }
        if (snsTopicARN() != null) {
            sb.append("SnsTopicARN: ").append(snsTopicARN()).append(",");
        }
        if (configSnapshotDeliveryProperties() != null) {
            sb.append("ConfigSnapshotDeliveryProperties: ").append(configSnapshotDeliveryProperties()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeliveryChannelMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DeliveryChannel> {
        /**
         * <p>
         * The name of the delivery channel. By default, AWS Config assigns the name "default" when creating the
         * delivery channel. To change the delivery channel name, you must use the DeleteDeliveryChannel action to
         * delete your current delivery channel, and then you must use the PutDeliveryChannel command to create a
         * delivery channel that has the desired name.
         * </p>
         * 
         * @param name
         *        The name of the delivery channel. By default, AWS Config assigns the name "default" when creating the
         *        delivery channel. To change the delivery channel name, you must use the DeleteDeliveryChannel action
         *        to delete your current delivery channel, and then you must use the PutDeliveryChannel command to
         *        create a delivery channel that has the desired name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the Amazon S3 bucket to which AWS Config delivers configuration snapshots and configuration
         * history files.
         * </p>
         * <p>
         * If you specify a bucket that belongs to another AWS account, that bucket must have policies that grant access
         * permissions to AWS Config. For more information, see <a
         * href="http://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-policy.html">Permissions for the
         * Amazon S3 Bucket</a> in the AWS Config Developer Guide.
         * </p>
         * 
         * @param s3BucketName
         *        The name of the Amazon S3 bucket to which AWS Config delivers configuration snapshots and
         *        configuration history files.</p>
         *        <p>
         *        If you specify a bucket that belongs to another AWS account, that bucket must have policies that grant
         *        access permissions to AWS Config. For more information, see <a
         *        href="http://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-policy.html">Permissions for
         *        the Amazon S3 Bucket</a> in the AWS Config Developer Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketName(String s3BucketName);

        /**
         * <p>
         * The prefix for the specified Amazon S3 bucket.
         * </p>
         * 
         * @param s3KeyPrefix
         *        The prefix for the specified Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3KeyPrefix(String s3KeyPrefix);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon SNS topic to which AWS Config sends notifications about
         * configuration changes.
         * </p>
         * <p>
         * If you choose a topic from another account, the topic must have policies that grant access permissions to AWS
         * Config. For more information, see <a
         * href="http://docs.aws.amazon.com/config/latest/developerguide/sns-topic-policy.html">Permissions for the
         * Amazon SNS Topic</a> in the AWS Config Developer Guide.
         * </p>
         * 
         * @param snsTopicARN
         *        The Amazon Resource Name (ARN) of the Amazon SNS topic to which AWS Config sends notifications about
         *        configuration changes.</p>
         *        <p>
         *        If you choose a topic from another account, the topic must have policies that grant access permissions
         *        to AWS Config. For more information, see <a
         *        href="http://docs.aws.amazon.com/config/latest/developerguide/sns-topic-policy.html">Permissions for
         *        the Amazon SNS Topic</a> in the AWS Config Developer Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicARN(String snsTopicARN);

        /**
         * <p>
         * The options for how often AWS Config delivers configuration snapshots to the Amazon S3 bucket.
         * </p>
         * 
         * @param configSnapshotDeliveryProperties
         *        The options for how often AWS Config delivers configuration snapshots to the Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configSnapshotDeliveryProperties(ConfigSnapshotDeliveryProperties configSnapshotDeliveryProperties);
    }

    private static final class BuilderImpl implements Builder {
        private String name;

        private String s3BucketName;

        private String s3KeyPrefix;

        private String snsTopicARN;

        private ConfigSnapshotDeliveryProperties configSnapshotDeliveryProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(DeliveryChannel model) {
            setName(model.name);
            setS3BucketName(model.s3BucketName);
            setS3KeyPrefix(model.s3KeyPrefix);
            setSnsTopicARN(model.snsTopicARN);
            setConfigSnapshotDeliveryProperties(model.configSnapshotDeliveryProperties);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getS3BucketName() {
            return s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        public final String getS3KeyPrefix() {
            return s3KeyPrefix;
        }

        @Override
        public final Builder s3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        public final void setS3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
        }

        public final String getSnsTopicARN() {
            return snsTopicARN;
        }

        @Override
        public final Builder snsTopicARN(String snsTopicARN) {
            this.snsTopicARN = snsTopicARN;
            return this;
        }

        public final void setSnsTopicARN(String snsTopicARN) {
            this.snsTopicARN = snsTopicARN;
        }

        public final ConfigSnapshotDeliveryProperties getConfigSnapshotDeliveryProperties() {
            return configSnapshotDeliveryProperties;
        }

        @Override
        public final Builder configSnapshotDeliveryProperties(ConfigSnapshotDeliveryProperties configSnapshotDeliveryProperties) {
            this.configSnapshotDeliveryProperties = configSnapshotDeliveryProperties;
            return this;
        }

        public final void setConfigSnapshotDeliveryProperties(ConfigSnapshotDeliveryProperties configSnapshotDeliveryProperties) {
            this.configSnapshotDeliveryProperties = configSnapshotDeliveryProperties;
        }

        @Override
        public DeliveryChannel build() {
            return new DeliveryChannel(this);
        }
    }
}
