/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for the <a>GetResourceConfigHistory</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetResourceConfigHistoryResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetResourceConfigHistoryResponse.Builder, GetResourceConfigHistoryResponse> {
    private final List<ConfigurationItem> configurationItems;

    private final String nextToken;

    private GetResourceConfigHistoryResponse(BuilderImpl builder) {
        this.configurationItems = builder.configurationItems;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list that contains the configuration history of one or more resources.
     * </p>
     * 
     * @return A list that contains the configuration history of one or more resources.
     */
    public List<ConfigurationItem> configurationItems() {
        return configurationItems;
    }

    /**
     * <p>
     * The string that you use in a subsequent request to get the next page of results in a paginated response.
     * </p>
     * 
     * @return The string that you use in a subsequent request to get the next page of results in a paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((configurationItems() == null) ? 0 : configurationItems().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceConfigHistoryResponse)) {
            return false;
        }
        GetResourceConfigHistoryResponse other = (GetResourceConfigHistoryResponse) obj;
        if (other.configurationItems() == null ^ this.configurationItems() == null) {
            return false;
        }
        if (other.configurationItems() != null && !other.configurationItems().equals(this.configurationItems())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (configurationItems() != null) {
            sb.append("ConfigurationItems: ").append(configurationItems()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetResourceConfigHistoryResponse> {
        /**
         * <p>
         * A list that contains the configuration history of one or more resources.
         * </p>
         * 
         * @param configurationItems
         *        A list that contains the configuration history of one or more resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationItems(Collection<ConfigurationItem> configurationItems);

        /**
         * <p>
         * A list that contains the configuration history of one or more resources.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setConfigurationItems(java.util.Collection)} or {@link #withConfigurationItems(java.util.Collection)}
         * if you want to override the existing values.
         * </p>
         * 
         * @param configurationItems
         *        A list that contains the configuration history of one or more resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationItems(ConfigurationItem... configurationItems);

        /**
         * <p>
         * The string that you use in a subsequent request to get the next page of results in a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The string that you use in a subsequent request to get the next page of results in a paginated
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<ConfigurationItem> configurationItems = new SdkInternalList<>();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceConfigHistoryResponse model) {
            setConfigurationItems(model.configurationItems);
            setNextToken(model.nextToken);
        }

        public final Collection<ConfigurationItem> getConfigurationItems() {
            return configurationItems;
        }

        @Override
        public final Builder configurationItems(Collection<ConfigurationItem> configurationItems) {
            this.configurationItems = ConfigurationItemListCopier.copy(configurationItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationItems(ConfigurationItem... configurationItems) {
            if (this.configurationItems == null) {
                this.configurationItems = new SdkInternalList<>(configurationItems.length);
            }
            for (ConfigurationItem e : configurationItems) {
                this.configurationItems.add(e);
            }
            return this;
        }

        public final void setConfigurationItems(Collection<ConfigurationItem> configurationItems) {
            this.configurationItems = ConfigurationItemListCopier.copy(configurationItems);
        }

        @SafeVarargs
        public final void setConfigurationItems(ConfigurationItem... configurationItems) {
            if (this.configurationItems == null) {
                this.configurationItems = new SdkInternalList<>(configurationItems.length);
            }
            for (ConfigurationItem e : configurationItems) {
                this.configurationItems.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetResourceConfigHistoryResponse build() {
            return new GetResourceConfigHistoryResponse(this);
        }
    }
}
